/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.util.BitField;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.ideimpl.editor.DesktopDropZone;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.TabGroup;
import oracle.ideimpl.editor.TabGroupState;
import oracle.ideimpl.editor.TabGroupXMLLayoutPersistence;
import oracle.ideimpl.editor.TransferableEditorTab;
import oracle.ideimpl.layout.LayoutsImpl;
import oracle.ideimpl.util.DropFileUtil;
import oracle.ideimpl.window.MaximizedWindowInfo;

final class Desktop
extends JLayeredPane
implements DropTargetListener,
MaximizedWindowInfo {
    private int _currentTabGroupPos;
    private final DockLayoutPanel _dockLayoutPanel;
    private final JPanel _background;
    private DesktopDropZone _desktopDropZone;
    private static final Integer LAYER_BACKGROUND = JLayeredPane.DEFAULT_LAYER;
    private static final Integer LAYER_DOCKPANEL = new Integer(JLayeredPane.DEFAULT_LAYER + 1);
    private final DesktopFocusTraversalPolicy _focusTraversalPolicy;
    private static final String LAYOUT_ROOT_KEY = "editorPositions";
    private TabGroup _maximizedTabGroup;

    void $init$() {
        this._currentTabGroupPos = -1;
    }

    public Desktop() {
        this.$init$();
        this._background = new JPanel();
        this.add((Component)this._background, LAYER_BACKGROUND);
        this._dockLayoutPanel = new 1();
        this._dockLayoutPanel.setPaintingDividers(false);
        this._dockLayoutPanel.setVisible(false);
        this.add((Component)this._dockLayoutPanel, LAYER_DOCKPANEL);
        new DropTarget(this._background, 2, this);
        KeyUtil.removeCtrlTabFromTraversalKeys(this);
        this.setFocusCycleRoot(true);
        FocusTraversalPolicy focusTraversalPolicy = this.getFocusTraversalPolicy();
        this._focusTraversalPolicy = new DesktopFocusTraversalPolicy(focusTraversalPolicy);
        this.setFocusTraversalPolicy(this._focusTraversalPolicy);
    }

    void freezeFocusChanges(boolean bl) {
        this._focusTraversalPolicy.setFocusChangeFrozen(bl);
        if (!this._focusTraversalPolicy.isFocusChangeFrozen() && this.getTabGroupCount() == 0 && !Ide.isStarting()) {
            IdeUtil.tryToRestoreFocus(null);
        }
    }

    void dump(String string) {
        System.out.println(string + "Desktop");
        int n = this.getTabGroupCount();
        int n2 = 0;
        while (n2 < n) {
            TabGroup tabGroup = this.getTabGroup(n2);
            boolean bl = n2 == this._currentTabGroupPos;
            tabGroup.dump("  ", bl);
            ++n2;
        }
    }

    void setDropPanesVisible(boolean bl) {
        if (bl) {
            if (this._desktopDropZone == null) {
                this._desktopDropZone = new DesktopDropZone(this._dockLayoutPanel);
                this.add((Component)this._desktopDropZone, JLayeredPane.DRAG_LAYER);
            }
        } else if (this._desktopDropZone != null) {
            this.remove(this._desktopDropZone);
            this._desktopDropZone = null;
            this.repaint();
        }
    }

    public void addNotify() {
        Color color = UIManager.getColor("Desktop.background");
        this._background.setBackground(color);
        super.addNotify();
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.maximizeComponents(LAYER_BACKGROUND, dimension);
        this.maximizeComponents(LAYER_DOCKPANEL, dimension);
    }

    private void maximizeComponents(Integer n, Dimension dimension) {
        Component[] componentArray = this.getComponentsInLayer(n);
        int n2 = 0;
        while (n2 < componentArray.length) {
            Component component = componentArray[n2];
            component.setBounds(0, 0, dimension.width, dimension.height);
            ++n2;
        }
    }

    JComponent getDesktopBackground() {
        return this._background;
    }

    public int getVisibleTabGroupCount() {
        int n = 0;
        int n2 = this.getTabGroupCount();
        while (--n2 >= 0) {
            TabGroup tabGroup = this.getTabGroup(n2);
            if (!tabGroup.isVisible()) continue;
            ++n;
        }
        return n;
    }

    public int getTabGroupCount() {
        return this._dockLayoutPanel.getComponentCount();
    }

    public TabGroup getTabGroup(int n) {
        return (TabGroup)this._dockLayoutPanel.getComponent(n);
    }

    private int indexOf(TabGroup tabGroup) {
        int n = this.getTabGroupCount();
        int n2 = 0;
        while (n2 < n) {
            if (tabGroup == this.getTabGroup(n2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    boolean getCurrentEditorPath(EditorPathImpl editorPathImpl) {
        boolean bl = false;
        editorPathImpl._tabGroupPos = this.getCurrentTabGroupPos();
        if (editorPathImpl._tabGroupPos != -1) {
            TabGroup tabGroup = this.getTabGroup(editorPathImpl._tabGroupPos);
            bl = tabGroup.getCurrentEditorPath(editorPathImpl);
        }
        return bl;
    }

    public int getCurrentTabGroupPos() {
        return this._currentTabGroupPos;
    }

    private void setCurrentTabGroupPos(int n) {
        if (this._currentTabGroupPos != n) {
            this._currentTabGroupPos = n;
            TabGroup tabGroup = this._currentTabGroupPos != -1 ? this.getTabGroup(n) : null;
            this.whenCurrentEditorChanges(tabGroup);
        }
    }

    void maximizeTabGroup(TabGroup tabGroup) {
        this._maximizedTabGroup = tabGroup;
        MainWindowImpl mainWindowImpl = (MainWindowImpl)Ide.getMainWindow();
        mainWindowImpl.maximize(this);
    }

    void restoreTabGroups() {
        MainWindowImpl mainWindowImpl = (MainWindowImpl)Ide.getMainWindow();
        mainWindowImpl.restore();
    }

    boolean isTabGroupMaximized(TabGroup tabGroup) {
        return tabGroup == this._maximizedTabGroup && tabGroup.isVisible();
    }

    public int addTabGroup(TabGroup tabGroup, DockLayoutConstraint dockLayoutConstraint) {
        int n = this._dockLayoutPanel.getComponentCount();
        this._dockLayoutPanel.add((Component)tabGroup, dockLayoutConstraint);
        if (this.getTabGroupCount() == 1) {
            this.setCurrentTabGroupPos(0);
        }
        this.whenTabGroupAdded();
        return n;
    }

    private void whenTabGroupAdded() {
        this._background.setOpaque(false);
        this._dockLayoutPanel.setVisible(true);
        this._dockLayoutPanel.revalidate();
    }

    public void removeTabGroup(TabGroup tabGroup) {
        int n = this.indexOf(tabGroup);
        this._removeTabGroup(tabGroup);
        MainWindowImpl mainWindowImpl = (MainWindowImpl)Ide.getMainWindow();
        if (mainWindowImpl.getMaximizedWindowType() == 2 && this.getVisibleTabGroupCount() <= 0) {
            this.restoreTabGroups();
        }
        if (this._currentTabGroupPos >= n) {
            --this._currentTabGroupPos;
        }
        if (this.getTabGroupCount() == 0) {
            DockStation dockStation = DockStation.getDockStation();
            dockStation.activateAnyDockable();
        } else if (this._currentTabGroupPos < 0) {
            this._currentTabGroupPos = 0;
        }
    }

    private void _removeTabGroup(TabGroup tabGroup) {
        this._dockLayoutPanel.remove(tabGroup);
        if (this.getTabGroupCount() == 0) {
            this._background.setOpaque(true);
            this._dockLayoutPanel.setVisible(false);
        }
    }

    public void saveLayout() {
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess(LAYOUT_ROOT_KEY);
        TabGroupXMLLayoutPersistence tabGroupXMLLayoutPersistence = new TabGroupXMLLayoutPersistence();
        this._dockLayoutPanel.saveLayout(tabGroupXMLLayoutPersistence, defaultStructuredPropertyAccess);
        LayoutsImpl.getInstance().setLayoutInfo(defaultStructuredPropertyAccess);
    }

    public void loadLayout() {
        StructuredPropertyAccess structuredPropertyAccess = LayoutsImpl.getInstance().getLayoutInfo(LAYOUT_ROOT_KEY);
        if (structuredPropertyAccess != null) {
            TabGroupXMLLayoutPersistence tabGroupXMLLayoutPersistence = new TabGroupXMLLayoutPersistence();
            this._dockLayoutPanel.loadLayout(tabGroupXMLLayoutPersistence, structuredPropertyAccess);
            if (this.getTabGroupCount() > 0) {
                this.setCurrentTabGroupPos(0);
                this.whenTabGroupAdded();
            }
        }
    }

    public JComponent getMaximizeComponent() {
        return this;
    }

    public void maximize() {
        int n = 0;
        while (n < this.getTabGroupCount()) {
            TabGroup tabGroup = this.getTabGroup(n);
            if (tabGroup != this._maximizedTabGroup) {
                tabGroup.setVisible(false);
            }
            ++n;
        }
        this._maximizedTabGroup.focusCurrentEditor();
    }

    public void restore() {
        int n = 0;
        while (n < this.getTabGroupCount()) {
            TabGroup tabGroup = this.getTabGroup(n);
            tabGroup.setVisible(true);
            ++n;
        }
        MainWindowImpl mainWindowImpl = (MainWindowImpl)Ide.getMainWindow();
        mainWindowImpl.setDesktop(this);
        this._maximizedTabGroup.focusCurrentEditor();
        this._maximizedTabGroup = null;
    }

    public int getWindowType() {
        return 2;
    }

    private static void handleDropTargetDragEvent(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl;
        boolean bl2 = false;
        int n = dropTargetDragEvent.getDropAction();
        boolean bl3 = bl = BitField.isSet(n, 1) || BitField.isSet(n, 2);
        if (bl) {
            boolean bl4;
            boolean bl5 = bl4 = dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dropTargetDragEvent.isDataFlavorSupported(TransferableContext.contextFlavor);
            if (bl4) {
                bl2 = true;
            }
        }
        if (bl2) {
            dropTargetDragEvent.acceptDrag(2);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        Desktop.handleDropTargetDragEvent(dropTargetDragEvent);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Desktop.handleDropTargetDragEvent(dropTargetDragEvent);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        Desktop.handleDropTargetDragEvent(dropTargetDragEvent);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (dropTargetDropEvent.isDataFlavorSupported(TransferableContext.contextFlavor)) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                TransferableContext transferableContext = (TransferableContext)transferable.getTransferData(TransferableContext.contextFlavor);
                EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
                Context context = transferableContext.getContext();
                Element[] elementArray = context.getSelection();
                if (elementArray != null) {
                    int n = 0;
                    while (n < elementArray.length) {
                        Element element = elementArray[n];
                        if (element instanceof Node) {
                            Node node = (Node)element;
                            Context context2 = new Context(context.getView(), context.getWorkspace(), context.getProject(), node);
                            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context2);
                            editorManagerImpl.openEditor(openEditorOptions);
                        }
                        ++n;
                    }
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            DropFileUtil.drop(dropTargetDropEvent);
        }
    }

    void dropTab(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DockLayout dockLayout = (DockLayout)this._dockLayoutPanel.getLayout();
        dockLayout.lockOptimize();
        Component component = dropTargetDropEvent.getDropTargetContext().getComponent();
        Point point = SwingUtilities.convertPoint(component, dropTargetDropEvent.getLocation(), this._dockLayoutPanel);
        DockInsertionPoint dockInsertionPoint = this._dockLayoutPanel.getDockInsertionAt(point);
        if (dockInsertionPoint != null) {
            try {
                TransferableEditorTab transferableEditorTab = (TransferableEditorTab)transferable.getTransferData(TransferableEditorTab.contextFlavor);
                Context context = transferableEditorTab.getContext();
                EditorCriteriaImpl editorCriteriaImpl = new EditorCriteriaImpl(context);
                EditorPathImpl editorPathImpl = new EditorPathImpl();
                EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
                if (editorManagerImpl.searchEditor(editorPathImpl, editorCriteriaImpl)) {
                    TabGroup tabGroup = editorPathImpl.getTabGroup();
                    JComponent jComponent = dockInsertionPoint.getCenterReferenceComponent();
                    if (jComponent == null) {
                        boolean bl;
                        boolean bl2;
                        DockLayoutConstraint dockLayoutConstraint = dockInsertionPoint.createConstraint();
                        Object object = dockLayoutConstraint.getReference();
                        if (object instanceof DockLayoutInfo) {
                            DockLayoutInfo dockLayoutInfo = (DockLayoutInfo)object;
                            bl2 = dockLayoutInfo.isReferring(tabGroup);
                        } else {
                            bl2 = object == tabGroup;
                        }
                        boolean bl3 = bl = !bl2 || tabGroup.getTabGroupStateCount() > 1;
                        if (bl) {
                            TabGroupState tabGroupState = editorPathImpl.getTabGroupState();
                            TabGroup tabGroup2 = new TabGroup();
                            tabGroup.detachTabGroupState(editorPathImpl._tabGroupStatePos);
                            editorPathImpl._tabGroupStatePos = tabGroup2.addTabGroupState(tabGroupState, -1);
                            this.addTabGroup(tabGroup2, dockLayoutConstraint);
                            editorPathImpl._tabGroupPos = this.indexOf(tabGroup2);
                            editorManagerImpl.focusEditor(editorPathImpl);
                        }
                    } else {
                        TabGroup tabGroup3 = (TabGroup)jComponent;
                        int n = tabGroup.getTabGroupStateCount();
                        if (tabGroup != tabGroup3 || n > 1 && n - 1 > editorPathImpl._tabGroupStatePos) {
                            TabGroupState tabGroupState = editorPathImpl.getTabGroupState();
                            tabGroup.detachTabGroupState(editorPathImpl._tabGroupStatePos);
                            editorPathImpl._tabGroupPos = this.indexOf(tabGroup3);
                            editorPathImpl._tabGroupStatePos = tabGroup3.addTabGroupState(tabGroupState, -1);
                            editorManagerImpl.focusEditor(editorPathImpl);
                        }
                    }
                    int n = tabGroup.getTabGroupStateCount();
                    if (n == 0) {
                        this.removeTabGroup(tabGroup);
                    }
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        dockLayout.unlockOptimize();
    }

    void detachEditor(EditorPathImpl editorPathImpl) {
        TabGroup tabGroup = editorPathImpl.getTabGroup();
        DockLayoutInfoLeaf dockLayoutInfoLeaf = this._dockLayoutPanel.getLayoutInfo(tabGroup);
        Dimension dimension = dockLayoutInfoLeaf.getSize(2);
        DockLayoutConstraint dockLayoutConstraint = new DockLayoutConstraint(tabGroup, 1, 1, dimension);
        TabGroupState tabGroupState = editorPathImpl.getTabGroupState();
        TabGroup tabGroup2 = new TabGroup();
        tabGroup.detachTabGroupState(editorPathImpl._tabGroupStatePos);
        editorPathImpl._tabGroupStatePos = tabGroup2.addTabGroupState(tabGroupState, -1);
        this.addTabGroup(tabGroup2, dockLayoutConstraint);
        editorPathImpl._tabGroupPos = this.indexOf(tabGroup2);
        tabGroup2.activateEditor(editorPathImpl);
        tabGroup2.focusCurrentEditor();
        int n = tabGroup.getTabGroupStateCount();
        if (n == 0) {
            this.removeTabGroup(tabGroup);
        }
    }

    void reattachEditors() {
        this.setCurrentTabGroupPos(0);
        TabGroup tabGroup = this.getTabGroup(0);
        int n = this.getTabGroupCount();
        int n2 = 1;
        while (n2 < n) {
            TabGroup tabGroup2 = this.getTabGroup(1);
            int n3 = tabGroup2.getTabGroupStateCount();
            int n4 = 0;
            while (n4 < n3) {
                TabGroupState tabGroupState = tabGroup2.getTabGroupState(0);
                tabGroup2.detachTabGroupState(0);
                tabGroup.addTabGroupState(tabGroupState, -1);
                ++n4;
            }
            this.removeTabGroup(tabGroup2);
            ++n2;
        }
    }

    void whenCurrentEditorChanges(TabGroup tabGroup) {
        TabGroup tabGroup2;
        int n = this.getCurrentTabGroupPos();
        TabGroup tabGroup3 = tabGroup2 = n == -1 ? null : this.getTabGroup(n);
        if (tabGroup2 == tabGroup) {
            EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
            editorManagerImpl.whenCurrentEditorChanges();
        }
    }

    public void whenEditorActivated(TabGroup tabGroup) {
        TabGroup tabGroup2;
        int n = this.getCurrentTabGroupPos();
        TabGroup tabGroup3 = tabGroup2 = n == -1 ? null : this.getTabGroup(n);
        if (tabGroup != tabGroup2) {
            int n2 = this.indexOf(tabGroup);
            this.setCurrentTabGroupPos(n2);
        }
    }

    public boolean activateEditor(EditorPathImpl editorPathImpl) {
        boolean bl = false;
        this.setCurrentTabGroupPos(editorPathImpl._tabGroupPos);
        TabGroup tabGroup = editorPathImpl.getTabGroup();
        if (tabGroup != null) {
            bl = tabGroup.activateEditor(editorPathImpl);
        }
        return bl;
    }

    static JPanel ra$_background(Desktop desktop) {
        return desktop._background;
    }

    final class 1
    extends DockLayoutPanel {
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.paintDivider(graphics, this._layout.getVertDividers(this), true);
        }
    }

    private final class DesktopFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private int _focusChangeFrozen;
        private FocusTraversalPolicy _defaultPolicy;

        public DesktopFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
            this._defaultPolicy = focusTraversalPolicy;
        }

        public Component getComponentAfter(Container container, Component component) {
            if (this.isFocusChangeFrozen()) {
                return Desktop.ra$_background(Desktop.this);
            }
            return this._defaultPolicy.getComponentAfter(container, component);
        }

        public Component getComponentBefore(Container container, Component component) {
            if (this.isFocusChangeFrozen()) {
                return Desktop.ra$_background(Desktop.this);
            }
            return this._defaultPolicy.getComponentBefore(container, component);
        }

        public Component getFirstComponent(Container container) {
            if (this.isFocusChangeFrozen()) {
                return Desktop.ra$_background(Desktop.this);
            }
            return this._defaultPolicy.getFirstComponent(container);
        }

        public Component getLastComponent(Container container) {
            if (this.isFocusChangeFrozen()) {
                return Desktop.ra$_background(Desktop.this);
            }
            return this._defaultPolicy.getLastComponent(container);
        }

        public Component getDefaultComponent(Container container) {
            if (this.isFocusChangeFrozen()) {
                return Desktop.ra$_background(Desktop.this);
            }
            return this._defaultPolicy.getDefaultComponent(container);
        }

        public boolean isFocusChangeFrozen() {
            return this._focusChangeFrozen > 0;
        }

        public void setFocusChangeFrozen(boolean bl) {
            this._focusChangeFrozen = bl ? ++this._focusChangeFrozen : --this._focusChangeFrozen;
        }
    }
}

