/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.ideimpl.editor.Desktop;
import oracle.ideimpl.window.WindowingConstants;

final class DesktopDropZone
extends JPanel
implements DropTargetListener {
    private static final boolean DEBUG_DROP_POINTS = false;
    private static final int DEBUG_DROP_POINT_SIZE = 25;
    private final DockLayoutPanel _dockLayoutPanel;
    private DockInsertionPoint _insertionPoint;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = DesktopDropZone.class.desiredAssertionStatus() ^ true;
    }

    public DesktopDropZone(DockLayoutPanel dockLayoutPanel) {
        this._dockLayoutPanel = dockLayoutPanel;
        this.setBounds(this._dockLayoutPanel.getBounds());
        this.setOpaque(false);
        new DropTarget(this, this);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this._insertionPoint != null) {
            this.paintDragUnderFeedback(graphics);
        }
    }

    protected void paintDragUnderFeedback(Graphics graphics) {
        if (!$assertionsDisabled && this._insertionPoint == null) {
            throw new AssertionError();
        }
        Color color = graphics.getColor();
        Rectangle rectangle = SwingUtilities.convertRectangle(this._dockLayoutPanel, this._insertionPoint.getFeedback(), this);
        graphics.setColor(WindowingConstants.DRAG_FEEDBACK_BACKGROUND);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(WindowingConstants.DRAG_FEEDBACK_OUTLINE);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(color);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.setFeedbackPoint(dropTargetDragEvent.getLocation());
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.setFeedbackPoint(null);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Desktop desktop = (Desktop)this.getParent();
        desktop.dropTab(dropTargetDropEvent);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private void setFeedbackPoint(Point point) {
        DockInsertionPoint dockInsertionPoint = this.getInsertionPoint(point);
        if (dockInsertionPoint != this._insertionPoint) {
            this._insertionPoint = dockInsertionPoint;
            this.repaint();
        }
    }

    private DockInsertionPoint getInsertionPoint(Point point) {
        if (point != null) {
            Point point2 = SwingUtilities.convertPoint(this, point, this._dockLayoutPanel);
            return this._dockLayoutPanel.getDockInsertionAt(point2);
        }
        return null;
    }
}

