/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Ide;
import oracle.ide.controls.DoubleClickTrigger;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.editor.Desktop;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.TabGroup;

final class DocTabListener
implements MouseListener,
ListDataListener,
ListSelectionListener {
    private TabGroup _tabGroup;
    private CustomTab _docTabs;
    private DoubleClickTrigger _trigger;

    void $init$() {
        this._trigger = new DoubleClickTrigger();
    }

    public DocTabListener(TabGroup tabGroup, CustomTab customTab) {
        this.$init$();
        this._tabGroup = tabGroup;
        this._docTabs = customTab;
    }

    private boolean handleSystemMenu(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return false;
        }
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this._docTabs);
        int n = mouseEvent.getComponent() == this._docTabs ? this._docTabs.getPageAt(point) : -1;
        this._tabGroup.showSystemMenu(n, point);
        return true;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this._tabGroup.whenTabSelectionChanges();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.handleSystemMenu(mouseEvent)) {
            return;
        }
        if (this._trigger.isDoubleClick(mouseEvent)) {
            MainWindowImpl mainWindowImpl = (MainWindowImpl)Ide.getMainWindow();
            Desktop desktop = EditorManagerImpl.getInstance().getDesktop();
            if (!mainWindowImpl.isMaximized()) {
                desktop.maximizeTabGroup(this._tabGroup);
            } else {
                desktop.restoreTabGroups();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.handleSystemMenu(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.handleSystemMenu(mouseEvent)) {
            this._tabGroup.focusCurrentEditor();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

