/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.editor.EditorAddin;
import oracle.ide.model.Element;

final class EditorAddinRegistry {
    private final Map _registry;
    private final ArrayList _dynamicRegistry;
    private final HashMap _registeredAddins;
    private final HashSet _registeredEditors;
    private final Set _registeredClasses;

    void $init$() {
        this._registry = new HashMap();
        this._dynamicRegistry = new ArrayList();
        this._registeredAddins = new HashMap();
        this._registeredEditors = new HashSet();
        this._registeredClasses = new HashSet();
    }

    void unregister(EditorAddin editorAddin) {
        Set set = this._registry.keySet();
        ArrayList arrayList = new ArrayList(set);
        int n = 0;
        while (n < arrayList.size()) {
            Object k = arrayList.get(n);
            List list = (List)this._registry.get(k);
            int n2 = list.size() - 1;
            while (n2 >= 0) {
                EditorAddin editorAddin2 = (EditorAddin)list.get(n2);
                if (editorAddin.equals(editorAddin2)) {
                    list.remove(n2);
                }
                --n2;
            }
            if (list.isEmpty()) {
                this._registry.remove(k);
            }
            ++n;
        }
        this.removeFromRegistry(editorAddin);
    }

    void extend(EditorAddin editorAddin, Class[] classArray) {
        boolean bl = editorAddin.isDefault();
        int n = 0;
        while (n < classArray.length) {
            ArrayList<EditorAddin> arrayList = (ArrayList<EditorAddin>)this._registry.get(classArray[n]);
            if (arrayList == null) {
                arrayList = new ArrayList<EditorAddin>(5);
                arrayList.add(editorAddin);
                this._registry.put(classArray[n], arrayList);
                this._registeredClasses.add(classArray[n]);
            } else if (!arrayList.contains(editorAddin)) {
                if (bl) {
                    arrayList.add(0, editorAddin);
                } else {
                    arrayList.add(editorAddin);
                }
            }
            ++n;
        }
        this.addToRegistry(editorAddin);
    }

    void registerDynamic(EditorAddin editorAddin) {
        this._dynamicRegistry.add(editorAddin);
        this.addToRegistry(editorAddin);
    }

    void unregisterDynamic(EditorAddin editorAddin) {
        this._dynamicRegistry.remove(editorAddin);
        this.removeFromRegistry(editorAddin);
    }

    List getStaticAddins(Class clazz) {
        return this.getAddinsImpl(clazz, null);
    }

    Set getStaticElementTypes() {
        return Collections.unmodifiableSet(this._registeredClasses);
    }

    List getAddins(Element element) {
        List list = this.getAddinsImpl(element.getClass(), element);
        return list;
    }

    private List getAddinsImpl(Class clazz, Element element) {
        HashMap<EditorAddin, Float> hashMap = new HashMap<EditorAddin, Float>();
        List list = this.getStaticAddinsImpl(clazz);
        int n = 0;
        while (n < list.size()) {
            EditorAddin editorAddin = (EditorAddin)list.get(n);
            hashMap.put(editorAddin, new Float(0.5 - (double)n * 0.01));
            ++n;
        }
        int n2 = 0;
        while (element != null && n2 < this._dynamicRegistry.size()) {
            float f;
            EditorAddin editorAddin = (EditorAddin)this._dynamicRegistry.get(n2);
            if (!hashMap.containsKey(editorAddin) && !Float.isNaN(f = editorAddin.getEditorWeight(element))) {
                hashMap.put(editorAddin, new Float(f));
            }
            ++n2;
        }
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList, new 1(this, hashMap));
        return arrayList;
    }

    boolean hasAddins(Element element) {
        boolean bl = false;
        if (this.hasStaticAddins(element)) {
            bl = true;
        } else {
            int n = 0;
            while (n < this._dynamicRegistry.size()) {
                EditorAddin editorAddin = (EditorAddin)this._dynamicRegistry.get(n);
                float f = editorAddin.getEditorWeight(element);
                if (!Float.isNaN(f)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    private boolean hasStaticAddins(Element element) {
        boolean bl = false;
        Class<?> clazz = element.getClass();
        List list = (List)this._registry.get(clazz);
        if (list != null) {
            bl = true;
        } else {
            Class<?> clazz2 = clazz.getSuperclass();
            while (clazz2 != null) {
                list = (List)this._registry.get(clazz2);
                if (list != null && list.size() != 0) {
                    bl = true;
                    break;
                }
                clazz2 = clazz2.getSuperclass();
            }
        }
        return bl;
    }

    private List getStaticAddinsImpl(Class clazz) {
        List list = (List)this._registry.get(clazz);
        if (list == null) {
            Class clazz2 = clazz.getSuperclass();
            while (clazz2 != null) {
                list = (List)this._registry.get(clazz2);
                if (list != null && list.size() != 0) {
                    this._registry.put(clazz, list);
                    break;
                }
                clazz2 = clazz2.getSuperclass();
            }
        }
        return list != null ? list : Collections.EMPTY_LIST;
    }

    Class getRegisteredElementType(Class clazz) {
        if (this._registry.containsKey(clazz)) {
            return clazz;
        }
        Class clazz2 = clazz.getSuperclass();
        while (clazz2 != null) {
            if (this._registry.containsKey(clazz2)) {
                return clazz2;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return null;
    }

    void dumpRegisteredEditors() {
        HashMap hashMap = new HashMap();
        System.out.println("-------------------- Registered editors");
        for (Class clazz : this._registry.keySet()) {
            System.out.println(clazz.getName());
            List list = (List)this._registry.get(clazz);
            int n = 0;
            while (n < list.size()) {
                EditorAddin editorAddin = (EditorAddin)list.get(n);
                Class clazz2 = editorAddin.getEditorClass();
                System.out.println("    " + editorAddin.getMenuSpecification().label + " = " + clazz2.getName());
                ++n;
            }
            this.buildNodeTree(clazz, hashMap);
        }
        System.out.println("-------------------- Node hierarchy");
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)hashMap.get(Object.class);
        this.recDumpTree(defaultMutableTreeNode, "");
    }

    private DefaultMutableTreeNode buildNodeTree(Class clazz, HashMap hashMap) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)hashMap.get(clazz);
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(clazz);
            if (clazz != Object.class) {
                Class clazz2 = clazz.getSuperclass();
                DefaultMutableTreeNode defaultMutableTreeNode2 = this.buildNodeTree(clazz2, hashMap);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
            }
            hashMap.put(clazz, defaultMutableTreeNode);
        }
        return defaultMutableTreeNode;
    }

    private void recDumpTree(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        Class clazz = (Class)defaultMutableTreeNode.getUserObject();
        System.out.println(string + clazz.getName());
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            this.recDumpTree(defaultMutableTreeNode2, string + "  ");
            ++n2;
        }
    }

    private void addToRegistry(EditorAddin editorAddin) {
        Class<?> clazz = editorAddin.getClass();
        String string = clazz.getName();
        this._registeredAddins.put(string, editorAddin);
        Class clazz2 = editorAddin.getEditorClass();
        this._registeredEditors.add(clazz2);
    }

    private void removeFromRegistry(EditorAddin editorAddin) {
        Class<?> clazz = editorAddin.getClass();
        String string = clazz.getName();
        this._registeredAddins.remove(string);
        Class clazz2 = editorAddin.getEditorClass();
        this._registeredEditors.remove(clazz2);
    }

    EditorAddin getRegisteredEditorAddin(String string) {
        return (EditorAddin)this._registeredAddins.get(string);
    }

    boolean isEditorRegistered(Class clazz) {
        boolean bl = this._registeredEditors.contains(clazz);
        return bl;
    }

    EditorAddin getEditorAddin(Class clazz) {
        if (this.isEditorRegistered(clazz)) {
            Iterator iterator;
            Set set = this._registeredAddins.keySet();
            Iterator iterator2 = iterator = set != null ? set.iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    EditorAddin editorAddin = (EditorAddin)this._registeredAddins.get(k);
                    if (editorAddin == null || editorAddin.getEditorClass() != clazz) continue;
                    return editorAddin;
                }
            }
        }
        return null;
    }

    EditorAddinRegistry() {
        this.$init$();
    }

    final class 1
    implements Comparator {
        private final /* synthetic */ HashMap v$addins;
        final /* synthetic */ EditorAddinRegistry this$0;

        public int compare(Object object, Object object2) {
            Float f = (Float)this.v$addins.get(object);
            Float f2 = (Float)this.v$addins.get(object2);
            return Float.compare(f2.floatValue(), f.floatValue());
        }

        public 1(EditorAddinRegistry editorAddinRegistry, HashMap hashMap) {
            this.v$addins = hashMap;
            this.this$0 = editorAddinRegistry;
        }
    }
}

