/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.Enumeration;
import java.util.Iterator;
import oracle.ide.util.BitField;
import oracle.ideimpl.editor.Desktop;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.TabGroup;
import oracle.ideimpl.editor.TabGroupState;

public final class EditorIterator
implements Enumeration,
Iterator {
    private static final int ITERATE_TABGROUP = 1;
    public static final int ITERATE_DOCUMENT = 3;
    private static final int ITERATE_PANE_STATE = 7;
    public static final int ITERATE_EDITOR = 15;
    private final int _type;
    private final EditorPathImpl _path;

    public EditorIterator(int n) {
        this._type = n;
        this._path = new EditorPathImpl(0, 0, 0, 0);
    }

    public EditorPathImpl getPath() {
        return this._path;
    }

    public boolean hasNext() {
        return this.hasNextEditor() || this.hasNextPane() || this.hasNextDocument();
    }

    private boolean hasNextDocument() {
        TabGroup tabGroup;
        boolean bl = false;
        if (BitField.isSet(this._type, 3) && (tabGroup = this._path.getTabGroup()) != null) {
            int n = tabGroup.getTabGroupStateCount();
            bl = this._path._tabGroupStatePos < n;
        }
        return bl;
    }

    private boolean hasNextPane() {
        TabGroupState tabGroupState;
        boolean bl = false;
        if (BitField.isSet(this._type, 7) && (tabGroupState = this._path.getTabGroupState()) != null) {
            int n = tabGroupState.getSplitPaneStateCount();
            bl = this._path._panePos < n;
        }
        return bl;
    }

    private boolean hasNextEditor() {
        SplitPaneState splitPaneState;
        boolean bl = false;
        if (BitField.isSet(this._type, 15) && (splitPaneState = this._path.getSplitPaneState()) != null) {
            int n = splitPaneState.getEditorStateCount();
            bl = this._path._editorPos < n;
        }
        return bl;
    }

    public Object next() {
        Object object = null;
        switch (this._type) {
            case 1: {
                object = this._path.getTabGroup();
                this.incrementTabGroup();
                break;
            }
            case 3: {
                object = this._path.getTabGroupState();
                this.incrementDocumentPos();
                break;
            }
            case 7: {
                object = this._path.getSplitPaneState();
                this.incrementSplitPaneState();
                break;
            }
            case 15: {
                object = this._path.getEditorState();
                this.incrementEditorPos();
            }
        }
        return object;
    }

    private boolean incrementTabGroup() {
        ++this._path._tabGroupPos;
        Desktop desktop = EditorManagerImpl.getInstance().getDesktop();
        boolean bl = this._path._tabGroupPos < desktop.getTabGroupCount();
        return bl;
    }

    private boolean incrementDocumentPos() {
        boolean bl = false;
        ++this._path._tabGroupStatePos;
        TabGroup tabGroup = this._path.getTabGroup();
        if (tabGroup != null) {
            if (this._path._tabGroupStatePos >= tabGroup.getTabGroupStateCount()) {
                if (this.incrementTabGroup()) {
                    this._path._tabGroupStatePos = 0;
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private boolean incrementSplitPaneState() {
        boolean bl = false;
        ++this._path._panePos;
        TabGroupState tabGroupState = this._path.getTabGroupState();
        if (tabGroupState != null) {
            if (this._path._panePos >= tabGroupState.getSplitPaneStateCount()) {
                if (this.incrementDocumentPos()) {
                    this._path._panePos = 0;
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private boolean incrementEditorPos() {
        boolean bl = false;
        ++this._path._editorPos;
        SplitPaneState splitPaneState = this._path.getSplitPaneState();
        if (splitPaneState != null) {
            if (this._path._editorPos >= splitPaneState.getEditorStateCount()) {
                if (this.incrementSplitPaneState()) {
                    this._path._editorPos = 0;
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMoreElements() {
        return this.hasNext();
    }

    public Object nextElement() {
        return this.next();
    }
}

