/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorConstants;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorPath;
import oracle.ide.editor.EditorsOptions;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.layout.BaseLayoutListener;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutListener;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeUtil;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.BitField;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.MultiMap;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideimpl.ActiveViewHandlerImpl;
import oracle.ideimpl.IdeMenus;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.ProfileIDs;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.editor.Desktop;
import oracle.ideimpl.editor.EditorAddinRegistry;
import oracle.ideimpl.editor.EditorCreation;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorIterator;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.EditorSelector;
import oracle.ideimpl.editor.EditorState;
import oracle.ideimpl.editor.LastUsedFiles;
import oracle.ideimpl.editor.RecentFilesLRU;
import oracle.ideimpl.editor.SplitPane;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.TabGroup;
import oracle.ideimpl.editor.TabGroupState;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.ideri.util.Product;
import oracle.javatools.dialogs.ExceptionDialog;

public class EditorManagerImpl
extends EditorManager
implements IdeListener,
ControllerProvider,
ActiveViewListener,
LayoutListener,
ContextMenuListener {
    public static final int MAX_SHORTCUTS = 9;
    public static final int EDITOR_EVENT_OPENED = 1;
    public static final int EDITOR_EVENT_ACTIVATED = 2;
    public static final int EDITOR_EVENT_DEACTIVATED = 3;
    public static final int EDITOR_EVENT_CLOSED = 4;
    private static final EditorSelector EDITOR_SELECTOR = EditorSelector.getInstance();
    private static final int MAX_MENUS = 9;
    private static final int MAX_ACCELERATOR = 9;
    private static EditorManagerImpl INSTANCE;
    private final ArrayList _editorListeners;
    private final HashMap _layoutListener;
    protected final Desktop _desktop;
    private ContextMenu CONTEXT_MENU;
    public static final int CLOSE_OTHERS_CMD_ID;
    private static final int OPEN_EDITOR_CMD_ID;
    public static final int SYSTEM_MENU_CMD_ID;
    public static final int SHOW_DROPDOWN_CMD_ID;
    public static final int NEXT_PANE_CMD_ID;
    public static final int PREV_PANE_CMD_ID;
    public static final int SPLIT_DOCUMENT_CMD_ID;
    public static final int UNSPLIT_DOCUMENT_CMD_ID;
    public static final int DETACH_DOCUMENT_CMD_ID;
    public static final int REGROUP_DOCUMENTS_CMD_ID;
    public static final int NAVIGATE_LRU_FILES_CMD_ID;
    public static final int MAXIMIZE_TAB_GROUP_CMD_ID;
    public static final int RESTORE_TAB_GROUPS_CMD_ID;
    private static IdeAction nextPaneAction;
    private static IdeAction prevPaneAction;
    private static IdeAction nextEditorAction;
    private static IdeAction prevEditorAction;
    private static IdeAction splitDocument;
    private static IdeAction unsplitDocument;
    private static IdeAction detachDocument;
    private static IdeAction regroupDocuments;
    private static IdeAction navigateLruFiles;
    private static IdeAction maximizeTabGroup;
    private static IdeAction restoreTabGroup;
    private final LinkedList _orderedDocumentList;
    private final int[] _windowListCmdID;
    private int[] _activateCmdId;
    private int[] _assignCmdId;
    private final MultiMap _preferredLayouts;
    private final LinkedList _splitpanePool;
    private ActiveViewHandlerImpl _activeViewHandler;
    private static final String EDITOR_FRAME_ID = "EditorFrame";
    protected final HashMap _idsToViews;
    protected final HashMap _viewsToIds;
    private static final boolean DEBUG_TRACE_VIEW_CHANGES;
    private EditorsOptions _editorsOptions;
    private TabGroup _lastActiveTabGroup;
    private SplitPane _lastActiveSplitPane;
    protected RecentFilesLRU _recentFilesLRU;
    protected EditorAddinRegistry _editorAddinRegistry;
    protected static final int EMO_TOP_EDITOR_TABS = 1;
    protected static final int EMO_HIDE_SINGLE_EDITOR_TABS = 2;
    protected static final int EMO_GRADIENT_EDITOR_TABS = 4;
    private static Integer _editorManagerOptions;

    static {
        CLOSE_OTHERS_CMD_ID = Ide.findOrCreateCmdID("CLOSE_OTHERS_CMD_ID");
        OPEN_EDITOR_CMD_ID = Ide.findOrCreateCmdID("OPEN_EDITOR_CMD_ID");
        SYSTEM_MENU_CMD_ID = Ide.findOrCreateCmdID("SYSTEM_MENU_CMD_ID");
        SHOW_DROPDOWN_CMD_ID = Ide.findOrCreateCmdID("SHOW_DROPDOWN_CMD_ID");
        NEXT_PANE_CMD_ID = Ide.findOrCreateCmdID("NEXT_PANE_CMD_ID");
        PREV_PANE_CMD_ID = Ide.findOrCreateCmdID("PREV_PANE_CMD_ID");
        SPLIT_DOCUMENT_CMD_ID = Ide.findOrCreateCmdID("SPLIT_DOCUMENT_CMD_ID");
        UNSPLIT_DOCUMENT_CMD_ID = Ide.findOrCreateCmdID("UNSPLIT_DOCUMENT_CMD_ID");
        DETACH_DOCUMENT_CMD_ID = Ide.findOrCreateCmdID("DETACH_DOCUMENT_CMD_ID");
        REGROUP_DOCUMENTS_CMD_ID = Ide.findOrCreateCmdID("REGROUP_DOCUMENTS_CMD_ID");
        NAVIGATE_LRU_FILES_CMD_ID = Ide.findOrCreateCmdID("NAVIGATE_LRU_FILES_CMD_ID");
        MAXIMIZE_TAB_GROUP_CMD_ID = Ide.findOrCreateCmdID("MAXIMIZE_TAB_GROUP_CMD_ID");
        RESTORE_TAB_GROUPS_CMD_ID = Ide.findOrCreateCmdID("RESTORE_TAB_GROUPS_CMD_ID");
        DEBUG_TRACE_VIEW_CHANGES = Boolean.valueOf(Ide.getProperty("DEBUG_TRACE_VIEW_CHANGES", "false"));
    }

    void $init$() {
        this._editorListeners = new ArrayList(3);
        this._layoutListener = new HashMap();
        this._orderedDocumentList = new LinkedList();
        this._windowListCmdID = new int[9];
        this._preferredLayouts = new MultiMap();
        this._splitpanePool = new LinkedList();
    }

    public EditorManagerImpl() {
        this.$init$();
        this._idsToViews = new HashMap();
        this._viewsToIds = new HashMap();
        this._editorAddinRegistry = new EditorAddinRegistry();
        this._recentFilesLRU = new RecentFilesLRU();
        this._desktop = new Desktop();
        NavigatorManager.getWorkspaceNavigatorManager().addContextMenuListener(this, null);
    }

    protected static boolean getEditorManagerOption(int n) {
        if (_editorManagerOptions == null) {
            int n2 = 0;
            if (Product.isRaptor()) {
                n2 |= 7;
            }
            _editorManagerOptions = new Integer(n2);
        }
        return BitField.isSet(_editorManagerOptions, n);
    }

    public void setActiveViewHandler(ActiveViewHandlerImpl activeViewHandlerImpl) {
        this._activeViewHandler = activeViewHandlerImpl;
        if (this._activeViewHandler != null) {
            this._activeViewHandler.addActiveViewListener(this);
            this._activeViewHandler.addControllerProvider(this._desktop, this);
        }
    }

    public List getWindowList() {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        Iterator iterator = this._orderedDocumentList.iterator();
        int n = 1;
        while (n <= 9 && iterator.hasNext()) {
            TabGroupState tabGroupState = (TabGroupState)iterator.next();
            Context context = tabGroupState.getContext();
            Node node = context.getNode();
            Icon icon = node.getIcon();
            String string = Integer.toString(n) + " " + node.getShortLabel();
            4 var9_9 = new 4(this, string, icon, tabGroupState);
            JMenuItem jMenuItem = new JMenuItem(var9_9);
            jMenuItem.setMnemonic(48 + n);
            arrayList.add(jMenuItem);
            ++n;
        }
        return arrayList;
    }

    public static final EditorManagerImpl createInstance() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = new EditorManagerImpl();
        return INSTANCE;
    }

    public static final EditorManagerImpl getInstance() {
        return INSTANCE;
    }

    public void initialize() {
        Layouts.getLayouts().addStartupLayoutListener(EDITOR_FRAME_ID, this);
        this.createActions();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/ideimpl/editor/accelerators.xml");
        Ide.addIdeListener(this);
    }

    private void createActions() {
        Menubar menubar = Ide.getMenubar();
        String string = IdeArb.getString(194) + " ";
        int n = 0;
        while (n < 9) {
            this._windowListCmdID[n] = Ide.findOrCreateCmdID("WINDOW_" + n + "_CMD_ID");
            IdeAction ideAction = IdeAction.get(this._windowListCmdID[n], null, string + n, IdeArb.getString(191), new Integer(49 + n), null, new Integer(n), true);
            ideAction.addController(this);
            ++n;
        }
        this._activateCmdId = new int[9];
        this._assignCmdId = new int[9];
        String string2 = IdeImplArb.getString(39);
        String string3 = IdeImplArb.getString(40);
        int n2 = 0;
        while (n2 < 9) {
            this._activateCmdId[n2] = Ide.findOrCreateCmdID("DOCUMENT_" + (n2 + 1) + "_CMD_ID");
            Object[] objectArray = new Object[]{new Integer(n2 + 1)};
            IdeAction ideAction = IdeAction.get(this._activateCmdId[n2], null, MessageFormat.format(string2, objectArray), IdeMainWindow.ACTION_CATEGORY_WINDOWS, new Integer(49 + n2), null, new Integer(n2), true);
            ideAction.addController(this);
            this._assignCmdId[n2] = Ide.findOrCreateCmdID("DOCUMENT_ASSIGN_" + (n2 + 1) + "_CMD_ID");
            ideAction = IdeAction.get(this._assignCmdId[n2], null, MessageFormat.format(string3, objectArray), IdeMainWindow.ACTION_CATEGORY_WINDOWS, new Integer(49 + n2), null, new Integer(n2), true);
            ideAction.addController(this);
            ++n2;
        }
        String string4 = IdeImplArb.getString(27);
        IdeAction ideAction = IdeAction.get(CLOSE_OTHERS_CMD_ID, null, StringUtils.stripMnemonic((String)string4), IdeMainWindow.ACTION_CATEGORY_FILE, new Integer(StringUtils.getMnemonicKeyCode((String)string4)), IdeImplArb.getInstance(), 28, null, true);
        ideAction.addController(this);
        IdeAction ideAction2 = IdeAction.get(OPEN_EDITOR_CMD_ID, null, IdeImplArb.getString(31), IdeMainWindow.ACTION_CATEGORY_WINDOWS, IdeImplArb.getInteger(32), IdeImplArb.getInstance(), 33, null, true);
        ideAction2.addController(this);
        String string5 = IdeImplArb.getString(34);
        IdeAction ideAction3 = IdeAction.get(SHOW_DROPDOWN_CMD_ID, null, StringUtils.stripMnemonic((String)string5), IdeMainWindow.ACTION_CATEGORY_WINDOWS, new Integer(StringUtils.getMnemonicKeyCode((String)string5)), IdeImplArb.getInstance(), 35, null, true);
        ideAction3.addController(this);
        String string6 = IdeImplArb.getString(37);
        IdeAction ideAction4 = IdeAction.get(SYSTEM_MENU_CMD_ID, null, StringUtils.stripMnemonic((String)string6), IdeMainWindow.ACTION_CATEGORY_WINDOWS, new Integer(StringUtils.getMnemonicKeyCode((String)string6)), IdeImplArb.getInstance(), 38, null, true);
        ideAction4.addController(this);
        String string7 = IdeImplArb.getString(4);
        IdeAction.get(70, null, StringUtils.stripMnemonic((String)string7), IdeMainWindow.ACTION_CATEGORY_WINDOWS, new Integer(StringUtils.getMnemonicKeyCode((String)string7)), IdeImplArb.getInstance(), 5, null, true);
        String string8 = IdeImplArb.getString(7);
        IdeAction.get(71, null, StringUtils.stripMnemonic((String)string8), IdeMainWindow.ACTION_CATEGORY_WINDOWS, new Integer(StringUtils.getMnemonicKeyCode((String)string8)), IdeImplArb.getInstance(), 8, null, true);
        String string9 = IdeImplArb.getString(10);
        String string10 = StringUtils.stripMnemonic((String)string9);
        int n3 = StringUtils.getMnemonicKeyCode((String)string9);
        nextPaneAction = IdeAction.get(NEXT_PANE_CMD_ID, null, string10, IdeMainWindow.ACTION_CATEGORY_WINDOWS, new Integer(n3), IdeImplArb.getInstance(), 11, null, true);
        nextPaneAction.addController(this);
        String string11 = IdeImplArb.getString(12);
        String string12 = StringUtils.stripMnemonic((String)string11);
        int n4 = StringUtils.getMnemonicKeyCode((String)string11);
        prevPaneAction = IdeAction.get(PREV_PANE_CMD_ID, null, string12, IdeMainWindow.ACTION_CATEGORY_WINDOWS, new Integer(n4), IdeImplArb.getInstance(), 13, null, true);
        prevPaneAction.addController(this);
        String string13 = IdeImplArb.getString(14);
        String string14 = StringUtils.stripMnemonic((String)string13);
        int n5 = StringUtils.getMnemonicKeyCode((String)string13);
        nextEditorAction = IdeAction.get(40, null, string14, IdeMainWindow.ACTION_CATEGORY_WINDOWS, new Integer(n5), IdeImplArb.getInstance(), 15, null, true);
        nextEditorAction.addController(this);
        String string15 = IdeImplArb.getString(16);
        String string16 = StringUtils.stripMnemonic((String)string15);
        int n6 = StringUtils.getMnemonicKeyCode((String)string15);
        prevEditorAction = IdeAction.get(41, null, string16, IdeMainWindow.ACTION_CATEGORY_WINDOWS, new Integer(n6), IdeImplArb.getInstance(), 17, null, true);
        prevEditorAction.addController(this);
        String string17 = IdeImplArb.getString(22);
        String string18 = StringUtils.stripMnemonic((String)string17);
        int n7 = StringUtils.getMnemonicKeyCode((String)string17);
        splitDocument = IdeAction.get(SPLIT_DOCUMENT_CMD_ID, null, string18, IdeMainWindow.ACTION_CATEGORY_WINDOWS, new Integer(n7), (ResourceBundle)IdeImplArb.getInstance(), null, null, false);
        splitDocument.addController(this);
        String string19 = IdeImplArb.getString(23);
        String string20 = StringUtils.stripMnemonic((String)string19);
        int n8 = StringUtils.getMnemonicKeyCode((String)string19);
        unsplitDocument = IdeAction.get(UNSPLIT_DOCUMENT_CMD_ID, null, string20, IdeMainWindow.ACTION_CATEGORY_WINDOWS, new Integer(n8), (ResourceBundle)IdeImplArb.getInstance(), null, null, false);
        unsplitDocument.addController(this);
        String string21 = IdeImplArb.getString(24);
        String string22 = StringUtils.stripMnemonic((String)string21);
        int n9 = StringUtils.getMnemonicKeyCode((String)string21);
        detachDocument = IdeAction.get(DETACH_DOCUMENT_CMD_ID, null, string22, IdeMainWindow.ACTION_CATEGORY_WINDOWS, new Integer(n9), (ResourceBundle)IdeImplArb.getInstance(), null, null, false);
        detachDocument.addController(this);
        String string23 = IdeImplArb.getString(25);
        String string24 = StringUtils.stripMnemonic((String)string23);
        int n10 = StringUtils.getMnemonicKeyCode((String)string23);
        regroupDocuments = IdeAction.get(REGROUP_DOCUMENTS_CMD_ID, null, string24, IdeMainWindow.ACTION_CATEGORY_WINDOWS, new Integer(n10), (ResourceBundle)IdeImplArb.getInstance(), null, null, false);
        regroupDocuments.addController(this);
        String string25 = IdeImplArb.getString(26);
        String string26 = StringUtils.stripMnemonic((String)string25);
        int n11 = StringUtils.getMnemonicKeyCode((String)string25);
        navigateLruFiles = IdeAction.get(NAVIGATE_LRU_FILES_CMD_ID, null, string26, IdeMainWindow.ACTION_CATEGORY_NAVIGATE, new Integer(n11), (ResourceBundle)IdeImplArb.getInstance(), null, null, true);
        navigateLruFiles.addController(this);
        JMenuItem jMenuItem = menubar.createMenuItem(navigateLruFiles, MenuConstants.WEIGHT_NAVIGATE_GO_TO_RECENTFILE);
        JMenu jMenu = IdeMenus.findOrCreateJMenu("Navigate");
        menubar.add(jMenuItem, jMenu, MenuConstants.SECTION_NAVIGATE_GOTO_ELEMENT);
        String string27 = IdeImplArb.getString(20);
        String string28 = StringUtils.stripMnemonic((String)string27);
        int n12 = StringUtils.getMnemonicKeyCode((String)string27);
        maximizeTabGroup = IdeAction.get(MAXIMIZE_TAB_GROUP_CMD_ID, null, string28, IdeMainWindow.ACTION_CATEGORY_NAVIGATE, new Integer(n12), (ResourceBundle)IdeImplArb.getInstance(), null, null, true);
        maximizeTabGroup.addController(this);
        String string29 = IdeImplArb.getString(21);
        String string30 = StringUtils.stripMnemonic((String)string29);
        int n13 = StringUtils.getMnemonicKeyCode((String)string29);
        restoreTabGroup = IdeAction.get(RESTORE_TAB_GROUPS_CMD_ID, null, string30, IdeMainWindow.ACTION_CATEGORY_NAVIGATE, new Integer(n13), (ResourceBundle)IdeImplArb.getInstance(), null, null, true);
        restoreTabGroup.addController(this);
    }

    public void addinsLoaded(IdeEvent ideEvent) {
    }

    public void mainWindowOpened(IdeEvent ideEvent) {
    }

    public void mainWindowClosing(IdeEvent ideEvent) {
        Desktop desktop = this.getDesktop();
        int n = desktop.getTabGroupCount();
        int n2 = 0;
        while (n2 < n) {
            TabGroup tabGroup = desktop.getTabGroup(n2);
            int n3 = tabGroup.getTabGroupStateCount();
            int n4 = 0;
            while (n4 < n3) {
                TabGroupState tabGroupState = tabGroup.getTabGroupState(n4);
                boolean bl = tabGroupState.isRestorableAtStartup();
                if (!bl) {
                    Context context = tabGroupState.getContext();
                    this.removeFromLRUList(context);
                }
                ++n4;
            }
            ++n2;
        }
    }

    Desktop getDesktop() {
        return this._desktop;
    }

    public void register(EditorAddin editorAddin, Class[] classArray) {
        this.extend(editorAddin, classArray);
    }

    public void unregister(EditorAddin editorAddin) {
        this._editorAddinRegistry.unregister(editorAddin);
    }

    public void extend(EditorAddin editorAddin, Class[] classArray) {
        this._editorAddinRegistry.extend(editorAddin, classArray);
    }

    public void registerDynamic(EditorAddin editorAddin) {
        this._editorAddinRegistry.registerDynamic(editorAddin);
    }

    public void unregisterDynamic(EditorAddin editorAddin) {
        this._editorAddinRegistry.unregisterDynamic(editorAddin);
    }

    public boolean isEditorRegistered(Class clazz) {
        return this._editorAddinRegistry.isEditorRegistered(clazz);
    }

    public EditorAddin getEditorAddin(Class clazz) {
        return this._editorAddinRegistry.getEditorAddin(clazz);
    }

    List getAddins(Element element) {
        return this._editorAddinRegistry.getAddins(element);
    }

    private boolean hasAddins(Element element) {
        return this._editorAddinRegistry.hasAddins(element);
    }

    private void dumpRegisteredEditors() {
        this._editorAddinRegistry.dumpRegisteredEditors();
    }

    private EditorAddin getBestEditorAddin(Context context) {
        Node node;
        EditorAddin editorAddin = this.getMostRecentEditorAddin(context);
        if (editorAddin == null && (node = context.getNode()) != null) {
            editorAddin = this.getBestEditorAddin(node);
        }
        return editorAddin;
    }

    private EditorAddin getMostRecentEditorAddin(Context context) {
        String string;
        EditorAddin editorAddin = null;
        RecentFile recentFile = this._recentFilesLRU.getRecentFile(context);
        if (recentFile != null && (string = recentFile.getEditor()) != null) {
            editorAddin = this._editorAddinRegistry.getRegisteredEditorAddin(string);
        }
        return editorAddin;
    }

    public EditorAddin getBestEditorAddin(Node node) {
        EditorAddin editorAddin = this.getDefaultAddinPreference(node);
        if (editorAddin == null) {
            editorAddin = this.getDefaultAddin(node);
        }
        return editorAddin;
    }

    private EditorAddin getDefaultAddinPreference(Node node) {
        IdeSettings ideSettings = Ide.getSettings();
        DocumentExtensions documentExtensions = (DocumentExtensions)ideSettings.getData("document-extensions-options");
        if (documentExtensions == null) {
            return null;
        }
        Map map = documentExtensions.getDefaultEditorMap();
        if (map == null) {
            return null;
        }
        Class clazz = this._editorAddinRegistry.getRegisteredElementType(node.getClass());
        for (Map.Entry entry : map.entrySet()) {
            try {
                EditorAddin editorAddin;
                Class<?> clazz2 = Class.forName((String)entry.getKey());
                if (!clazz2.equals(clazz) || (editorAddin = this._editorAddinRegistry.getRegisteredEditorAddin((String)entry.getValue())) == null || !this.getAddins(node).contains(editorAddin)) continue;
                EditorAddin editorAddin2 = editorAddin;
                return editorAddin2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public EditorAddin getDefaultAddin(Element element) {
        EditorAddin editorAddin = null;
        List list = this.getAddins(element);
        if (!list.isEmpty()) {
            editorAddin = (EditorAddin)list.get(0);
        }
        return editorAddin;
    }

    public EditorAddin[] getStaticAddins(Class clazz) {
        return this._editorAddinRegistry.getStaticAddins(clazz).toArray(new EditorAddin[0]);
    }

    public Class[] getStaticElementTypes() {
        return this._editorAddinRegistry.getStaticElementTypes().toArray(new Class[0]);
    }

    public void addEditorListener(EditorListener editorListener) {
        this._editorListeners.add(editorListener);
    }

    public void removeEditorListener(EditorListener editorListener) {
        this._editorListeners.remove(editorListener);
    }

    private void fireEditorEvent(int n, Editor editor) {
        EditorManagerImpl.traceEditorEvent(n, editor);
        List list = (List)this._editorListeners.clone();
        int n2 = 0;
        while (n2 < list.size()) {
            EditorListener editorListener = (EditorListener)list.get(n2);
            try {
                switch (n) {
                    case 1: {
                        editorListener.editorOpened(editor);
                        break;
                    }
                    case 2: {
                        editorListener.editorActivated(editor);
                        break;
                    }
                    case 3: {
                        editorListener.editorDeactivated(editor);
                        break;
                    }
                    case 4: {
                        editorListener.editorClosed(editor);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
    }

    public void addLayoutListener(String string, BaseLayoutListener baseLayoutListener) {
        this._layoutListener.put(string, baseLayoutListener);
    }

    public void removeLayoutListener(String string) {
        this._layoutListener.remove(string);
    }

    public void registerPreferredLayoutListener(Class clazz, Class clazz2, String string, PreferredLayoutListener preferredLayoutListener) {
        this._preferredLayouts.add(clazz2, new Object[]{clazz, string, preferredLayoutListener});
    }

    void initPreferredLayoutInfo(Editor editor, Context context) {
        Class<?> clazz = editor.getClass();
        Object[] objectArray = null;
        List list = this._preferredLayouts.get(clazz);
        if (list != null) {
            Class<?> clazz2;
            Node node = context.getNode();
            Class<?> clazz3 = clazz2 = node.getClass();
            while (clazz3 != null) {
                int n = 0;
                while (n < list.size()) {
                    Object[] objectArray2 = (Object[])list.get(n);
                    Class clazz4 = (Class)objectArray2[0];
                    if (clazz3 == clazz4) {
                        objectArray = objectArray2;
                        break;
                    }
                    if (clazz4.isAssignableFrom(clazz3)) {
                        objectArray = objectArray2;
                    }
                    ++n;
                }
                clazz3 = clazz3.getSuperclass();
            }
            if (objectArray != null) {
                PreferredLayoutListener preferredLayoutListener = (PreferredLayoutListener)objectArray[2];
                editor.addPreferredLayoutListener(preferredLayoutListener);
                String string = (String)objectArray[1];
                editor.setPreferredLayoutBaseName(string);
                String string2 = clazz2.getName() + "-" + clazz.getName();
                editor.setType(string2);
            }
        }
    }

    public boolean searchEditor(EditorPathImpl editorPathImpl, EditorCriteriaImpl editorCriteriaImpl) {
        boolean bl = false;
        int n = this._desktop.getTabGroupCount();
        int n2 = 0;
        while (!bl && n2 < n) {
            TabGroup tabGroup = this._desktop.getTabGroup(n2);
            if (tabGroup.match(editorCriteriaImpl) || tabGroup.searchEditor(editorPathImpl, editorCriteriaImpl)) {
                editorPathImpl._tabGroupPos = n2;
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public JComponent getDesktopComponent() {
        return this.getDesktop();
    }

    SplitPane createSplitPane() {
        SplitPane splitPane = this._splitpanePool.isEmpty() ? new SplitPane() : (SplitPane)this._splitpanePool.removeFirst();
        return splitPane;
    }

    void releaseSplitPane(SplitPane splitPane) {
        this._splitpanePool.addFirst(splitPane);
    }

    public Editor openDefaultEditorInFrame(Context context) {
        Editor editor = null;
        EditorPathImpl editorPathImpl = new EditorPathImpl();
        if (this.searchEditor(editorPathImpl, new EditorCriteriaImpl(context))) {
            this.focusEditor(editorPathImpl);
            TabGroupState tabGroupState = editorPathImpl.getTabGroupState();
            editor = tabGroupState.getCurrentEditor();
            EditorManagerImpl.updateContext(editor, context);
        } else {
            EditorAddin editorAddin = this.getBestEditorAddin(context);
            if (editorAddin != null) {
                Class clazz = editorAddin.getEditorClass();
                editor = this.openEditorInFrame(clazz, context);
            }
        }
        return editor;
    }

    private static void updateContext(Editor editor, Context context) {
        Context context2 = editor.getContext();
        if (ModelUtil.areDifferent((Object)context2.getProject(), (Object)context.getProject()) || ModelUtil.areDifferent((Object)context2.getWorkspace(), (Object)context.getWorkspace())) {
            editor.setContext(context);
        }
    }

    public Editor openEditorInFrame(Class clazz, Context context) {
        Editor editor = null;
        WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.show();
        try {
            EditorPathImpl editorPathImpl = new EditorPathImpl();
            if (this.focusEditor(clazz, context, editorPathImpl)) {
                EditorState editorState = editorPathImpl.getEditorState();
                editor = editorState.getEditor();
                EditorManagerImpl.updateContext(editor, context);
            } else {
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, clazz);
                if (this.createEditor(openEditorOptions, editorPathImpl)) {
                    EditorState editorState = editorPathImpl.getEditorState();
                    editor = editorState.getEditor();
                }
            }
        }
        finally {
            waitCursor.hide();
        }
        return editor;
    }

    public Editor openEditor(OpenEditorOptions openEditorOptions) {
        EditorState editorState;
        EditorCriteriaImpl editorCriteriaImpl;
        Editor editor = null;
        EditorPathImpl editorPathImpl = new EditorPathImpl();
        Context context = openEditorOptions.getContext();
        Class clazz = openEditorOptions.getEditorClass();
        if (clazz == null) {
            editorCriteriaImpl = new EditorCriteriaImpl(context);
            EditorAddin editorAddin = this.getBestEditorAddin(context);
            if (editorAddin != null) {
                openEditorOptions.setEditorClass(editorAddin.getEditorClass());
            }
        } else {
            editorCriteriaImpl = new EditorCriteriaImpl(context, clazz);
        }
        if (this.searchEditor(editorPathImpl, editorCriteriaImpl)) {
            int n = openEditorOptions.getFlags();
            if (BitField.isSet(n, 1)) {
                if (BitField.isSet(n, 5)) {
                    this.focusEditor(editorPathImpl);
                } else {
                    this.activateEditor(editorPathImpl);
                }
            }
            TabGroupState tabGroupState = editorPathImpl.getTabGroupState();
            editor = tabGroupState.getCurrentEditor();
            EditorManagerImpl.updateContext(editor, context);
        } else if (this.createEditor(openEditorOptions, editorPathImpl) && (editorState = editorPathImpl.getEditorState()) != null) {
            editor = editorState.getEditor();
        }
        return editor;
    }

    boolean focusEditor(EditorPathImpl editorPathImpl) {
        boolean bl = false;
        if (this.activateEditor(editorPathImpl)) {
            TabGroup tabGroup = editorPathImpl.getTabGroup();
            tabGroup.focusCurrentEditor();
            bl = true;
        }
        return bl;
    }

    private void focusActiveEditor() {
        EditorPathImpl editorPathImpl = new EditorPathImpl();
        if (this.getCurrentEditorPath(editorPathImpl)) {
            this.focusEditor(editorPathImpl);
        }
    }

    private boolean focusEditor(Class clazz, Context context, EditorPathImpl editorPathImpl) {
        boolean bl = false;
        EditorCriteriaImpl editorCriteriaImpl = new EditorCriteriaImpl(context, clazz);
        if (this.searchEditor(editorPathImpl, editorCriteriaImpl) && this.focusEditor(editorPathImpl)) {
            bl = true;
        }
        return bl;
    }

    boolean createEditor(OpenEditorOptions openEditorOptions, EditorPathImpl editorPathImpl) {
        List list;
        boolean bl = false;
        Context context = openEditorOptions.getContext();
        Node node = context.getNode();
        if (node != null && !(list = this.getAddins(node)).isEmpty()) {
            EditorCreation editorCreation = new EditorCreation();
            editorCreation.setOpenEditorOptions(openEditorOptions);
            editorCreation.setEditorAddins(list);
            editorCreation.setEditorPath(editorPathImpl);
            if (this.createEditor(editorCreation)) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean createEditor(EditorCreation editorCreation) {
        boolean bl;
        TabGroup tabGroup;
        boolean bl2 = false;
        Desktop desktop = this.getDesktop();
        EditorPathImpl editorPathImpl = editorCreation.getEditorPath();
        int n = 0;
        TabGroup tabGroup2 = null;
        OpenEditorOptions openEditorOptions = editorCreation.getOpenEditorOptions();
        EditorPath editorPath = openEditorOptions.getPositionReference();
        if (editorPath instanceof EditorPathImpl) {
            EditorPathImpl editorPathImpl2 = (EditorPathImpl)editorPath;
            tabGroup2 = editorPathImpl2.getTabGroup();
            n = openEditorOptions.getPosition();
        }
        if (editorPathImpl._tabGroupPos == -1) {
            int n2 = desktop.getCurrentTabGroupPos();
            if (n2 == -1) {
                tabGroup = new TabGroup();
                bl = true;
            } else if (tabGroup2 != null) {
                if (n == 4) {
                    tabGroup = tabGroup2;
                    bl = false;
                    this.searchEditor(editorPathImpl, new EditorCriteriaImpl(tabGroup));
                } else {
                    tabGroup = new TabGroup();
                    bl = true;
                }
            } else {
                editorPathImpl._tabGroupPos = n2;
                tabGroup = desktop.getTabGroup(n2);
                bl = false;
            }
        } else {
            tabGroup = desktop.getTabGroup(editorPathImpl._tabGroupPos);
            bl = false;
        }
        if (tabGroup.addTabGroupState(editorCreation)) {
            int n3;
            if (bl) {
                DockLayoutConstraint dockLayoutConstraint = new DockLayoutConstraint(tabGroup2, n, 1, null);
                editorPathImpl._tabGroupPos = desktop.addTabGroup(tabGroup, dockLayoutConstraint);
            }
            if (BitField.isSet(n3 = openEditorOptions.getFlags(), 1)) {
                bl2 = tabGroup.activateEditor(editorPathImpl);
                if (bl2) {
                    EditorState editorState = editorPathImpl.getEditorState();
                    EditorAddin editorAddin = editorState.getEditorAddin();
                    Context context = openEditorOptions.getContext();
                    this.raiseContextInLRUList(context, editorAddin);
                } else if (editorPathImpl._tabGroupStatePos != -1) {
                    tabGroup.closeTabGroupState(editorPathImpl._tabGroupStatePos);
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                if (BitField.isSet(n3, 8)) {
                    Context context = openEditorOptions.getContext();
                    this._recentFilesLRU.setExplicit(context, true);
                }
                if (BitField.isSet(n3, 2)) {
                    tabGroup.validate();
                }
                if (BitField.isSet(n3, 5)) {
                    tabGroup.focusCurrentEditor();
                }
            }
        }
        return bl2;
    }

    public boolean activateEditor(EditorPathImpl editorPathImpl) {
        return this.getDesktop().activateEditor(editorPathImpl);
    }

    public void activateCurrentEditorFrame() {
        int n = this._desktop.getCurrentTabGroupPos();
        if (n != -1) {
            TabGroup tabGroup = this._desktop.getTabGroup(n);
            tabGroup.focusCurrentEditor();
        }
    }

    public List findEditors(Context context) {
        ArrayList arrayList = new ArrayList();
        int n = this._desktop.getTabGroupCount();
        int n2 = 0;
        while (n2 < n) {
            TabGroup tabGroup = this._desktop.getTabGroup(n2);
            List list = tabGroup.findEditors(context);
            arrayList.addAll(list);
            ++n2;
        }
        return arrayList;
    }

    public List getAllEditors() {
        ArrayList arrayList = new ArrayList();
        int n = this._desktop.getTabGroupCount();
        int n2 = 0;
        while (n2 < n) {
            TabGroup tabGroup = this._desktop.getTabGroup(n2);
            List list = tabGroup.getAllEditors();
            arrayList.addAll(list);
            ++n2;
        }
        return arrayList;
    }

    public Editor getCurrentEditor() {
        Editor editor = null;
        int n = this._desktop.getCurrentTabGroupPos();
        if (n != -1) {
            TabGroup tabGroup = this._desktop.getTabGroup(n);
            editor = tabGroup.getCurrentEditor();
        }
        return editor;
    }

    public JComponent getDesktopBackground() {
        return this.getDesktop().getDesktopBackground();
    }

    private boolean getCurrentEditorPath(EditorPathImpl editorPathImpl) {
        return this._desktop.getCurrentEditorPath(editorPathImpl);
    }

    public final synchronized ContextMenu getContextMenu() {
        if (this.CONTEXT_MENU == null) {
            this.CONTEXT_MENU = new ContextMenu(new MnemonicSolver());
            this.CONTEXT_MENU.addContextMenuListener(new 3());
            IdeAction ideAction = IdeAction.find(57);
            EditorConstants.NAVIGATE_ITEM = this.CONTEXT_MENU.createMenuItem(ideAction, MenuConstants.WEIGHT_NAVIGATE_SELECT_IN_NAVIGATOR);
            ideAction = IdeAction.find(5);
            EditorConstants.UNDO_ITEM = this.CONTEXT_MENU.createMenuItem(ideAction, 1.0f);
            ideAction = IdeAction.find(6);
            EditorConstants.REDO_ITEM = this.CONTEXT_MENU.createMenuItem(ideAction, MenuConstants.WEIGHT_EDIT_REDO);
            ideAction = IdeAction.find(17);
            EditorConstants.CUT_ITEM = this.CONTEXT_MENU.createMenuItem(ideAction, MenuConstants.WEIGHT_EDIT_CUT);
            ideAction = IdeAction.find(18);
            EditorConstants.COPY_ITEM = this.CONTEXT_MENU.createMenuItem(ideAction, MenuConstants.WEIGHT_EDIT_COPY);
            ideAction = IdeAction.find(19);
            EditorConstants.PASTE_ITEM = this.CONTEXT_MENU.createMenuItem(ideAction, MenuConstants.WEIGHT_EDIT_PASTE);
            ideAction = IdeAction.find(78);
            EditorConstants.EXTENDED_PASTE_ITEM = this.CONTEXT_MENU.createMenuItem(ideAction, MenuConstants.WEIGHT_EDIT_EXTENDED_PASTE);
            ideAction = IdeAction.find(22);
            EditorConstants.ALL_ITEM = this.CONTEXT_MENU.createMenuItem(ideAction, MenuConstants.WEIGHT_EDIT_SELECT_ALL);
        }
        return this.CONTEXT_MENU;
    }

    public void replaceEditors(Context context, Context context2) {
        EditorPathImpl editorPathImpl = new EditorPathImpl();
        EditorCriteriaImpl editorCriteriaImpl = new EditorCriteriaImpl(context);
        if (this.searchEditor(editorPathImpl, editorCriteriaImpl)) {
            TabGroupState tabGroupState = editorPathImpl.getTabGroupState();
            tabGroupState.setContext(context2);
        }
    }

    public List getEditorsInfo() {
        ArrayList arrayList = new ArrayList();
        EditorIterator editorIterator = new EditorIterator(15);
        IdeUtil.addAll(arrayList, editorIterator);
        return arrayList;
    }

    public void closeEditors(List list) {
        EditorState[] editorStateArray = new EditorState[list.size()];
        int n = 0;
        while (n < list.size()) {
            Editor editor;
            EditorPathImpl editorPathImpl;
            Object e = list.get(n);
            if (e instanceof EditorState) {
                editorStateArray[n] = (EditorState)e;
            } else if (e instanceof Editor && this.searchEditor(editorPathImpl = new EditorPathImpl(), new EditorCriteriaImpl(editor = (Editor)e))) {
                editorStateArray[n] = editorPathImpl.getEditorState();
            }
            ++n;
        }
        this.closeEditors(editorStateArray);
    }

    private void closeEditors(EditorState[] editorStateArray) {
        HashSet<TabGroupState> hashSet = new HashSet<TabGroupState>();
        int n = 0;
        while (n < editorStateArray.length) {
            EditorState editorState = editorStateArray[n];
            SplitPaneState splitPaneState = editorState.getParentSplitPaneState();
            TabGroupState tabGroupState = splitPaneState.getParentTabGroupState();
            hashSet.add(tabGroupState);
            ++n;
        }
        TabGroupState[] tabGroupStateArray = hashSet.toArray(new TabGroupState[hashSet.size()]);
        this.closeEditors(tabGroupStateArray);
    }

    public void closeEditors(TabGroupState[] tabGroupStateArray) {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean bl = component == null ? false : SwingUtilities.isDescendingFrom(component, this.getDesktop());
        this.getDesktop().freezeFocusChanges(true);
        HashSet<TabGroupState> hashSet = new HashSet<TabGroupState>(Arrays.asList(tabGroupStateArray));
        HashSet<Node> hashSet2 = new HashSet<Node>();
        HashSet<Node> hashSet3 = new HashSet<Node>();
        MultiMap multiMap = new MultiMap();
        int n = this.getDesktop().getTabGroupCount();
        int n2 = 0;
        while (n2 < n) {
            TabGroup tabGroup = this.getDesktop().getTabGroup(n2);
            int n3 = tabGroup.getTabGroupStateCount();
            int n4 = 0;
            while (n4 < n3) {
                TabGroupState tabGroupState = tabGroup.getTabGroupState(n4);
                boolean bl2 = hashSet.contains(tabGroupState);
                Context context = tabGroupState.getContext();
                Node node = context.getNode();
                if (bl2) {
                    hashSet2.add(node);
                    multiMap.add(context, node);
                } else {
                    hashSet3.add(node);
                }
                int n5 = tabGroupState.getSplitPaneStateCount();
                int n6 = 0;
                while (n6 < n5) {
                    SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(n6);
                    int n7 = splitPaneState.getEditorStateCount();
                    int n8 = 0;
                    while (n8 < n7) {
                        Node[] nodeArray;
                        EditorState editorState = splitPaneState.getEditorState(n8);
                        Editor editor = editorState.getEditor();
                        if (editor != null && (nodeArray = editor.getDependentNodes()) != null) {
                            int n9 = 0;
                            while (n9 < nodeArray.length) {
                                Node node2 = nodeArray[n9];
                                if (bl2) {
                                    hashSet2.add(node2);
                                    multiMap.add(context, node2);
                                } else {
                                    hashSet3.add(node2);
                                }
                                ++n9;
                            }
                        }
                        ++n8;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        Set set = multiMap.keySet();
        for (Context context : set) {
            List list = multiMap.get(context);
            list.removeAll(hashSet3);
        }
        hashSet2.removeAll(hashSet3);
        IdeAction ideAction = IdeActions.getFileCloseAction();
        String string = ideAction.getCommand();
        Command command = CommandProcessor.createCommand(string, new Context());
        CloseNodeCommand closeNodeCommand = command instanceof CloseNodeCommand ? (CloseNodeCommand)command : new CloseNodeCommand();
        int n10 = closeNodeCommand.checkSave(hashSet2.iterator());
        if (n10 != 1) {
            int n11 = this._desktop.getTabGroupCount();
            int n12 = n11 - 1;
            while (n12 >= 0) {
                TabGroup tabGroup = this._desktop.getTabGroup(n12);
                tabGroup.close(tabGroupStateArray);
                --n12;
            }
            for (Context context : set) {
                List list = multiMap.get(context);
                closeNodeCommand.setContext(context);
                closeNodeCommand.clearAffectedNodes();
                n10 = closeNodeCommand.close(list.iterator(), context, false, true);
                if (n10 == 1) break;
            }
        }
        this.getDesktop().freezeFocusChanges(false);
        if (bl) {
            this.focusActiveEditor();
        }
    }

    public void activateEditor(EditorInfo editorInfo) {
        EditorPathImpl editorPathImpl = new EditorPathImpl();
        EditorCriteriaImpl editorCriteriaImpl = new EditorCriteriaImpl(editorInfo);
        EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
        if (editorManagerImpl.searchEditor(editorPathImpl, editorCriteriaImpl)) {
            this.activateEditor(editorPathImpl);
        }
    }

    public void setExplicit(Editor editor, boolean bl) {
        Context context = editor.getContext();
        this._recentFilesLRU.setExplicit(context, bl);
    }

    void raiseContextInLRUList(Context context, EditorAddin editorAddin) {
        String string = null;
        boolean bl = true;
        if (editorAddin != null) {
            Object object = editorAddin.getAttribute("no-recent-file");
            if (Boolean.FALSE.equals(object)) {
                bl = false;
            }
            Class<?> clazz = editorAddin.getClass();
            string = clazz.getName();
        }
        if (bl) {
            this._recentFilesLRU.raiseContextInLRUList(context, string);
        }
    }

    void removeFromLRUList(Context context) {
        this._recentFilesLRU.remove(context);
    }

    private static int getExplicitNumber() {
        EditorIterator editorIterator = new EditorIterator(3);
        ArrayList arrayList = Collections.list(editorIterator);
        Collections.sort(arrayList, new 2());
        int n = 0;
        while (n < arrayList.size()) {
            TabGroupState tabGroupState = (TabGroupState)arrayList.get(n);
            if (tabGroupState.isExplicit()) break;
            ++n;
        }
        int n2 = 0;
        while (n < arrayList.size()) {
            TabGroupState tabGroupState = (TabGroupState)arrayList.get(n);
            int n3 = tabGroupState.getNodeNumber();
            if (n2 < n3) break;
            ++n;
            ++n2;
        }
        if (n2 >= 9) {
            n2 = -1;
        }
        return n2;
    }

    EditorsOptions getEditorsOptions() {
        if (this._editorsOptions == null) {
            ClientSetting clientSetting = ClientSetting.findOrCreate("oracle.ide");
            this._editorsOptions = (EditorsOptions)clientSetting.getData("editors-options");
            if (this._editorsOptions == null) {
                this._editorsOptions = new EditorsOptions();
                clientSetting.putData("editors-options", this._editorsOptions);
            }
        }
        return this._editorsOptions;
    }

    public EditorPath searchEditor(Node node) {
        EditorPathImpl editorPathImpl = null;
        EditorPathImpl editorPathImpl2 = new EditorPathImpl();
        if (this.searchEditor(editorPathImpl2, new EditorCriteriaImpl(node))) {
            editorPathImpl = editorPathImpl2;
        }
        return editorPathImpl;
    }

    public void addView(ViewId viewId, View view) {
        this._idsToViews.put(viewId, view);
        this._viewsToIds.put(view, viewId);
    }

    public View getView(ViewId viewId) {
        return (View)this._idsToViews.get(viewId);
    }

    public void removeView(View view) {
        Object v = this._viewsToIds.get(view);
        if (v != null) {
            this._idsToViews.remove(v);
            this._viewsToIds.remove(view);
        }
    }

    public void addOpenedViews(Layout layout, List list) {
        Iterator iterator = this._viewsToIds.keySet().iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
    }

    public void save(Layout layout) {
        this.getDesktop().saveLayout();
        for (BaseLayoutListener baseLayoutListener : this._layoutListener.values()) {
            baseLayoutListener.save(layout);
        }
    }

    public void init(Layout layout) {
        int n = 0;
        if (ProfileIDs.PROFILE_CREATEEDITORS) {
            n = IdeProfile.startEvent(3312);
        }
        this.getDesktop().loadLayout();
        for (BaseLayoutListener baseLayoutListener : this._layoutListener.values()) {
            baseLayoutListener.init(layout);
        }
        if (ProfileIDs.PROFILE_CREATEEDITORS) {
            IdeProfile.endEvent(n);
        }
    }

    public void close(Layout layout) {
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        View view;
        View view2 = activeViewEvent.getOldView();
        if (view2 instanceof Editor) {
            Editor editor = (Editor)view2;
            this.fireEditorEvent(3, editor);
        }
        if ((view = activeViewEvent.getNewView()) instanceof Editor) {
            Editor editor = (Editor)view;
            this.fireEditorEvent(2, editor);
        }
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Node node;
        Context context = contextMenu.getContext();
        if (context != null && (node = context.getNode()) != null && this.hasAddins(node)) {
            JMenuItem jMenuItem = contextMenu.createMenuItem(IdeAction.find(OPEN_EDITOR_CMD_ID), MenuConstants.WEIGHT_FILE_OPEN);
            contextMenu.add((Component)jMenuItem, 1.0f);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return this.whenOpenEditor(context);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 48 || n == 70 || n == 71 || n == NEXT_PANE_CMD_ID || n == PREV_PANE_CMD_ID || n == 40 || n == 41 || n == 42 || n == 43 || this.isGoto_n(ideAction) || this.isWindow_n(ideAction)) {
            this.handleWithoutFocus(ideAction, context, false);
        } else if (n == SYSTEM_MENU_CMD_ID) {
            this.whenShowSystemMenu();
        } else if (n == NAVIGATE_LRU_FILES_CMD_ID) {
            this.whenNavigateLRUFiles();
        } else if (n == SHOW_DROPDOWN_CMD_ID) {
            Desktop desktop = this.getDesktop();
            int n2 = desktop.getCurrentTabGroupPos();
            if (n2 != -1) {
                TabGroup tabGroup = desktop.getTabGroup(n2);
                tabGroup.showDropDownMenu();
            }
        } else if (n == CLOSE_OTHERS_CMD_ID) {
            this.whenCloseOthers(context);
        } else if (n == 39) {
            List list = this.getEditorsInfo();
            this.closeEditors(list);
        } else if (n == OPEN_EDITOR_CMD_ID) {
            this.whenOpenEditor(context);
        } else if (n == MAXIMIZE_TAB_GROUP_CMD_ID) {
            this.whenMaximizeTabGroup(context);
        } else if (n == RESTORE_TAB_GROUPS_CMD_ID) {
            this.whenRestoreTabGroups();
        } else if (n == SPLIT_DOCUMENT_CMD_ID) {
            EditorPathImpl editorPathImpl = new EditorPathImpl();
            if (this.searchEditor(editorPathImpl, new EditorCriteriaImpl(context))) {
                this.activateEditor(editorPathImpl);
                TabGroupState tabGroupState = editorPathImpl.getTabGroupState();
                int n3 = tabGroupState.getSplitPaneStateCount();
                boolean bl = false;
                int n4 = 0;
                while (!bl && n4 < n3) {
                    SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(n4);
                    if (splitPaneState.isSplitable()) {
                        editorPathImpl._panePos = n4;
                        TabGroup tabGroup = editorPathImpl.getTabGroup();
                        tabGroup.splitPane(editorPathImpl);
                        bl = true;
                    }
                    ++n4;
                }
            }
        } else if (n == UNSPLIT_DOCUMENT_CMD_ID) {
            EditorPathImpl editorPathImpl = new EditorPathImpl();
            if (this.searchEditor(editorPathImpl, new EditorCriteriaImpl(context))) {
                this.activateEditor(editorPathImpl);
                TabGroup tabGroup = editorPathImpl.getTabGroup();
                tabGroup.getCurrentEditorPath(editorPathImpl);
                tabGroup.unsplitPane(editorPathImpl);
                editorPathImpl._panePos = 0;
                tabGroup.activateEditor(editorPathImpl);
                this._desktop.revalidate();
            }
        } else if (n == DETACH_DOCUMENT_CMD_ID) {
            EditorPathImpl editorPathImpl = new EditorPathImpl();
            if (this.searchEditor(editorPathImpl, new EditorCriteriaImpl(context))) {
                this._desktop.detachEditor(editorPathImpl);
            }
        } else if (n == REGROUP_DOCUMENTS_CMD_ID) {
            this._desktop.reattachEditors();
        } else if (n == 51) {
            this.whenRefresh();
        } else if (!this.handleAssign_n(ideAction)) {
            return false;
        }
        return true;
    }

    private void updateRefresh(IdeAction ideAction) {
        boolean bl = false;
        Editor editor = this.getCurrentEditor();
        if (editor != null) {
            Context context = editor.getContext();
            Node node = context.getNode();
            if (node != null) {
                bl = true;
            }
            ideAction.setEnabled(bl);
        }
    }

    private void whenRefresh() {
        Editor editor = this.getCurrentEditor();
        Context context = editor.getContext();
        Node node = context.getNode();
        if (node != null) {
            NodeUtil.reloadBuffers(Collections.singletonList(node), true);
        }
    }

    private void whenNavigateLRUFiles() {
        RecentFile[] recentFileArray = this._recentFilesLRU.getRecentFiles();
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        LastUsedFiles.runDialog((Frame)((Object)ideMainWindow), recentFileArray);
    }

    private void handleWithoutFocus(IdeAction ideAction, Context context, boolean bl) {
        int n = ideAction.getCommandId();
        if (n == 48) {
            this.whenCloseEditor(context);
        } else if (n == 70) {
            this.whenActivateLeftNode();
        } else if (n == 71) {
            this.whenActivateRightNode();
        } else if (n == NEXT_PANE_CMD_ID || n == PREV_PANE_CMD_ID) {
            Desktop desktop = this.getDesktop();
            int n2 = desktop.getCurrentTabGroupPos();
            TabGroup tabGroup = desktop.getTabGroup(n2);
            TabGroupState tabGroupState = tabGroup.getCurrentTabGroupState();
            tabGroupState.handleEvent(n);
        } else if (n == 40 || n == 41) {
            Desktop desktop = this.getDesktop();
            int n3 = desktop.getCurrentTabGroupPos();
            TabGroup tabGroup = desktop.getTabGroup(n3);
            TabGroupState tabGroupState = tabGroup.getCurrentTabGroupState();
            SplitPane splitPane = tabGroupState.getCurrentSplitPane();
            splitPane.handleEvent(n);
        } else if (n == 42) {
            this.whenNextEditorFrame(context);
        } else if (n == 43) {
            this.whenPrevEditorFrame(context);
        } else if (this.handleGoto_n(ideAction) || this.handleWindow_n(ideAction)) {
            // empty if block
        }
        if (bl) {
            this.focusActiveEditor();
        }
    }

    private boolean isGoto_n(IdeAction ideAction) {
        int n = ideAction.getCommandId();
        int n2 = 0;
        while (n2 < this._activateCmdId.length) {
            int n3 = this._activateCmdId[n2];
            if (n3 == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean handleGoto_n(IdeAction ideAction) {
        int n = ideAction.getCommandId();
        int n2 = 0;
        while (n2 < this._activateCmdId.length) {
            int n3 = this._activateCmdId[n2];
            if (n3 == n) {
                EditorPathImpl editorPathImpl = new EditorPathImpl();
                if (this.searchEditor(editorPathImpl, new EditorCriteriaImpl(n2))) {
                    this.activateEditor(editorPathImpl);
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean handleAssign_n(IdeAction ideAction) {
        int n = ideAction.getCommandId();
        int n2 = 0;
        while (n2 < this._assignCmdId.length) {
            int n3 = this._assignCmdId[n2];
            if (n3 == n) {
                EditorPathImpl editorPathImpl = new EditorPathImpl();
                if (this.getCurrentEditorPath(editorPathImpl)) {
                    TabGroupState tabGroupState = editorPathImpl.getTabGroupState();
                    TabGroupState tabGroupState2 = null;
                    EditorPathImpl editorPathImpl2 = new EditorPathImpl();
                    if (this.searchEditor(editorPathImpl2, new EditorCriteriaImpl(n2))) {
                        tabGroupState2 = editorPathImpl2.getTabGroupState();
                    }
                    if (tabGroupState2 == null) {
                        tabGroupState.setNodeNumber(n2);
                    } else if (tabGroupState2 != tabGroupState) {
                        tabGroupState2.setNodeNumber(-1);
                        tabGroupState.setNodeNumber(n2);
                        int n4 = EditorManagerImpl.getExplicitNumber();
                        tabGroupState2.setNodeNumber(n4);
                    }
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isWindow_n(IdeAction ideAction) {
        int n = ideAction.getCommandId();
        TabGroupState tabGroupState = this.getTabGroupStateFromWindowMenu(n);
        return tabGroupState != null;
    }

    private boolean handleWindow_n(IdeAction ideAction) {
        int n = ideAction.getCommandId();
        TabGroupState tabGroupState = this.getTabGroupStateFromWindowMenu(n);
        if (tabGroupState != null) {
            EditorPathImpl editorPathImpl = new EditorPathImpl();
            if (this.searchEditor(editorPathImpl, new EditorCriteriaImpl(tabGroupState))) {
                this.activateEditor(editorPathImpl);
            }
            return true;
        }
        return false;
    }

    private void whenMaximizeTabGroup(Context context) {
        TabGroup tabGroup = this.getTabGroupFromContext(context);
        Desktop desktop = this.getDesktop();
        desktop.maximizeTabGroup(tabGroup);
    }

    private void whenRestoreTabGroups() {
        Desktop desktop = this.getDesktop();
        desktop.restoreTabGroups();
    }

    private boolean isTabGroupMaximized(Context context) {
        if (context == null) {
            return false;
        }
        MainWindowImpl mainWindowImpl = (MainWindowImpl)Ide.getMainWindow();
        if (mainWindowImpl.getMaximizedWindowType() != 2) {
            return false;
        }
        Desktop desktop = this.getDesktop();
        TabGroup tabGroup = this.getTabGroupFromContext(context);
        return desktop.isTabGroupMaximized(tabGroup);
    }

    private TabGroup getTabGroupFromContext(Context context) {
        EditorPathImpl editorPathImpl = new EditorPathImpl();
        if (this.searchEditor(editorPathImpl, new EditorCriteriaImpl(context))) {
            return editorPathImpl.getTabGroup();
        }
        Desktop desktop = this.getDesktop();
        int n = desktop.getCurrentTabGroupPos();
        if (n != -1) {
            return desktop.getTabGroup(n);
        }
        return null;
    }

    private void whenCloseOthers(Context context) {
        TabGroupState tabGroupState = null;
        Desktop desktop = this.getDesktop();
        EditorPathImpl editorPathImpl = new EditorPathImpl();
        if (this.searchEditor(editorPathImpl, new EditorCriteriaImpl(context))) {
            tabGroupState = editorPathImpl.getTabGroupState();
        } else {
            int n = desktop.getCurrentTabGroupPos();
            if (n != -1) {
                TabGroup tabGroup = desktop.getTabGroup(n);
                tabGroupState = tabGroup.getCurrentTabGroupState();
            }
        }
        int n = desktop.getTabGroupCount();
        ArrayList<TabGroupState> arrayList = new ArrayList<TabGroupState>();
        int n2 = 0;
        while (n2 < n) {
            TabGroup tabGroup = desktop.getTabGroup(n2);
            int n3 = tabGroup.getTabGroupStateCount();
            int n4 = 0;
            while (n4 < n3) {
                TabGroupState tabGroupState2 = tabGroup.getTabGroupState(n4);
                if (tabGroupState2 != tabGroupState) {
                    arrayList.add(tabGroupState2);
                }
                ++n4;
            }
            ++n2;
        }
        TabGroupState[] tabGroupStateArray = new TabGroupState[arrayList.size()];
        arrayList.toArray(tabGroupStateArray);
        this.closeEditors(tabGroupStateArray);
    }

    private void whenShowSystemMenu() {
        int n = this.getDesktop().getCurrentTabGroupPos();
        if (n != -1) {
            TabGroup tabGroup = this.getDesktop().getTabGroup(n);
            tabGroup.whenShowSystemMenu();
        }
    }

    private boolean whenOpenEditor(Context context) {
        boolean bl = false;
        try {
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            openEditorOptions.setFlags(8, true);
            Editor editor = this.openEditor(openEditorOptions);
            if (editor != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)exception);
        }
        return bl;
    }

    private TabGroupState getTabGroupStateFromWindowMenu(int n) {
        int n2 = 0;
        while (n2 < this._windowListCmdID.length) {
            IdeAction ideAction;
            WeakReference weakReference;
            if (this._windowListCmdID[n2] == n && (weakReference = (WeakReference)(ideAction = IdeAction.find(this._windowListCmdID[n2])).getValue("UserData")) != null) {
                TabGroupState tabGroupState = (TabGroupState)weakReference.get();
                return tabGroupState;
            }
            ++n2;
        }
        return null;
    }

    private void whenNextEditorFrame(Context context) {
        if (EditorManagerImpl.isMenuAction(context)) {
            TabGroupState tabGroupState = (TabGroupState)this._orderedDocumentList.get(1);
            this.activateEditor(tabGroupState);
        } else {
            EDITOR_SELECTOR.selectNext(this._orderedDocumentList);
        }
    }

    private void whenPrevEditorFrame(Context context) {
        if (EditorManagerImpl.isMenuAction(context)) {
            TabGroupState tabGroupState = (TabGroupState)this._orderedDocumentList.getLast();
            this.activateEditor(tabGroupState);
        } else {
            EDITOR_SELECTOR.selectPrevious(this._orderedDocumentList);
        }
    }

    void activateEditor(TabGroupState tabGroupState) {
        EditorPathImpl editorPathImpl = new EditorPathImpl();
        this.searchEditor(editorPathImpl, new EditorCriteriaImpl(tabGroupState));
        this.activateEditor(editorPathImpl);
    }

    private static boolean isMenuAction(Context context) {
        EventObject eventObject = context.getEvent();
        if (eventObject instanceof ActionEvent) {
            ActionEvent actionEvent = (ActionEvent)eventObject;
            Object object = actionEvent.getSource();
            return object instanceof MenuElement;
        }
        return false;
    }

    public void addToNodeList(TabGroupState tabGroupState) {
        this._orderedDocumentList.remove(tabGroupState);
        this._orderedDocumentList.addLast(tabGroupState);
    }

    public void removeFromNodeList(TabGroupState tabGroupState) {
        this._orderedDocumentList.remove(tabGroupState);
    }

    void moveTabGroupStateSwitchToTop(TabGroupState tabGroupState) {
        this._orderedDocumentList.remove(tabGroupState);
        this._orderedDocumentList.addFirst(tabGroupState);
    }

    private void whenWindowMenuActivates(TabGroupState tabGroupState) {
        EditorPathImpl editorPathImpl = new EditorPathImpl();
        if (this.searchEditor(editorPathImpl, new EditorCriteriaImpl(tabGroupState))) {
            this.activateEditor(editorPathImpl);
        }
    }

    private void whenActivateRightNode() {
        int n = this._desktop.getCurrentTabGroupPos();
        TabGroup tabGroup = this._desktop.getTabGroup(n);
        tabGroup.whenActivateRightNode();
    }

    private void whenActivateLeftNode() {
        int n = this._desktop.getCurrentTabGroupPos();
        TabGroup tabGroup = this._desktop.getTabGroup(n);
        tabGroup.whenActivateLeftNode();
    }

    private void whenCloseEditor(Context context) {
        EditorPathImpl editorPathImpl = new EditorPathImpl();
        EditorCriteriaImpl editorCriteriaImpl = new EditorCriteriaImpl(context);
        if (this.searchEditor(editorPathImpl, editorCriteriaImpl)) {
            this.whenCloseEditor(editorPathImpl);
        }
    }

    private void whenCloseEditor(EditorPathImpl editorPathImpl) {
        TabGroupState tabGroupState = editorPathImpl.getTabGroupState();
        this.closeEditors(new TabGroupState[]{tabGroupState});
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 39 || n == SHOW_DROPDOWN_CMD_ID || n == SYSTEM_MENU_CMD_ID) {
            ideAction.setEnabled(this._desktop.getTabGroupCount() != 0);
        } else if (n == 42 || n == 43 || n == CLOSE_OTHERS_CMD_ID) {
            int n2 = this._desktop.getTabGroupCount();
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                TabGroup tabGroup = this._desktop.getTabGroup(n4);
                if (tabGroup.isVisible()) {
                    n3 += tabGroup.getTabGroupStateCount();
                }
                ++n4;
            }
            ideAction.setEnabled(n3 > 1);
        } else if (n == MAXIMIZE_TAB_GROUP_CMD_ID) {
            boolean bl = this.isTabGroupMaximized(context);
            ideAction.setEnabled(bl ^ true);
        } else if (n == RESTORE_TAB_GROUPS_CMD_ID) {
            boolean bl = this.isTabGroupMaximized(context);
            ideAction.setEnabled(bl);
        } else if (n == REGROUP_DOCUMENTS_CMD_ID) {
            int n5 = this._desktop.getTabGroupCount();
            boolean bl = n5 > 1;
            ideAction.setEnabled(bl);
        } else if (n == DETACH_DOCUMENT_CMD_ID) {
            boolean bl = false;
            EditorPathImpl editorPathImpl = new EditorPathImpl();
            if (this.searchEditor(editorPathImpl, new EditorCriteriaImpl(context))) {
                TabGroup tabGroup = editorPathImpl.getTabGroup();
                int n6 = tabGroup.getTabGroupStateCount();
                bl = n6 > 1;
            }
            ideAction.setEnabled(bl);
        } else if (n == SPLIT_DOCUMENT_CMD_ID) {
            boolean bl = false;
            EditorPathImpl editorPathImpl = new EditorPathImpl();
            if (this.searchEditor(editorPathImpl, new EditorCriteriaImpl(context))) {
                TabGroupState tabGroupState = editorPathImpl.getTabGroupState();
                int n7 = tabGroupState.getSplitPaneStateCount();
                int n8 = 0;
                while (!bl && n8 < n7) {
                    SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(n8);
                    if (splitPaneState.isSplitable()) {
                        bl = true;
                    }
                    ++n8;
                }
            }
            ideAction.setEnabled(bl);
        } else if (n == UNSPLIT_DOCUMENT_CMD_ID) {
            boolean bl = false;
            EditorPathImpl editorPathImpl = new EditorPathImpl();
            if (this.searchEditor(editorPathImpl, new EditorCriteriaImpl(context))) {
                int n9 = editorPathImpl.getTabGroupState().getSplitPaneStateCount();
                bl = n9 > 1;
            }
            ideAction.setEnabled(bl);
        } else if (n != NAVIGATE_LRU_FILES_CMD_ID) {
            if (n == 70) {
                boolean bl = false;
                int n10 = this._desktop.getCurrentTabGroupPos();
                if (n10 != -1) {
                    TabGroup tabGroup = this._desktop.getTabGroup(n10);
                    bl = tabGroup.canActivateLeftNode();
                }
                ideAction.setEnabled(bl);
            } else if (n == 71) {
                boolean bl = false;
                int n11 = this._desktop.getCurrentTabGroupPos();
                if (n11 != -1) {
                    TabGroup tabGroup = this._desktop.getTabGroup(n11);
                    bl = tabGroup.canActivateRightNode();
                }
                ideAction.setEnabled(bl);
            } else if (n == NEXT_PANE_CMD_ID || n == PREV_PANE_CMD_ID) {
                TabGroup tabGroup;
                TabGroupState tabGroupState;
                boolean bl = false;
                Desktop desktop = this.getDesktop();
                int n12 = desktop.getCurrentTabGroupPos();
                if (n12 != -1 && (tabGroupState = (tabGroup = desktop.getTabGroup(n12)).getCurrentTabGroupState()) != null) {
                    bl = tabGroupState.canDo(ideAction);
                }
                ideAction.setEnabled(bl);
            } else if (n == 40 || n == 41) {
                SplitPane splitPane;
                TabGroup tabGroup;
                TabGroupState tabGroupState;
                boolean bl = false;
                Desktop desktop = this.getDesktop();
                int n13 = desktop.getCurrentTabGroupPos();
                if (n13 != -1 && (tabGroupState = (tabGroup = desktop.getTabGroup(n13)).getCurrentTabGroupState()) != null && (splitPane = tabGroupState.getCurrentSplitPane()) != null) {
                    bl = splitPane.canDo(ideAction);
                }
                ideAction.setEnabled(bl);
            } else if (n == 51) {
                this.updateRefresh(ideAction);
            } else if (!this.updateAssign(ideAction, n) && !this.updateActivate(ideAction, n)) {
                return false;
            }
        }
        return true;
    }

    private boolean updateAssign(IdeAction ideAction, int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this._assignCmdId.length) {
            int n3 = this._assignCmdId[n2];
            if (n3 == n) {
                boolean bl2 = this._desktop.getTabGroupCount() != 0;
                ideAction.setEnabled(bl2);
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    private boolean updateActivate(IdeAction ideAction, int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this._activateCmdId.length) {
            int n3 = this._activateCmdId[n2];
            if (n3 == n) {
                boolean bl2 = this.searchEditor(new EditorPathImpl(), new EditorCriteriaImpl(n2));
                ideAction.setEnabled(bl2);
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    int getActivateCmdId(int n) {
        return this._activateCmdId[n];
    }

    public int getAssignCmdId(int n) {
        return this._assignCmdId[n];
    }

    public String getActivateCmdTooltip(int n) {
        int n2 = this.getActivateCmdId(n);
        String string = KeyUtil.getAcceleratorTooltip(n2);
        return string;
    }

    public void whenCurrentEditorChanges() {
        Layouts layouts = Layouts.getLayouts();
        if (layouts != null) {
            SwingUtilities.invokeLater(new 1(this, layouts));
        }
    }

    void whenEditorOpened(Editor editor) {
        this.fireEditorEvent(1, editor);
    }

    void whenEditorClosed(Editor editor) {
        this.fireEditorEvent(4, editor);
        String string = editor.getId();
        BaseLayoutListener baseLayoutListener = (BaseLayoutListener)this._layoutListener.get(string);
        if (baseLayoutListener != null) {
            IdeProperties ideProperties = Ide.getIdeProperties();
            baseLayoutListener.close(ideProperties);
        }
    }

    private static void traceEditorEvent(int n, Editor editor) {
        if (DEBUG_TRACE_VIEW_CHANGES) {
            String string = n == 1 ? "EDITOR_EVENT_OPENED" : (n == 2 ? "EDITOR_EVENT_ACTIVATED" : (n == 3 ? "EDITOR_EVENT_DEACTIVATED" : (n == 4 ? "EDITOR_EVENT_CLOSED" : "???")));
            String string2 = editor == null ? "null" : editor.getId();
            System.out.println("fireEditorEvent( " + string + ", " + string2 + ")");
        }
    }

    public Controller getController() {
        return this;
    }

    static void mav$whenWindowMenuActivates(EditorManagerImpl editorManagerImpl, TabGroupState tabGroupState) {
        editorManagerImpl.whenWindowMenuActivates(tabGroupState);
    }

    static boolean mav$getCurrentEditorPath(EditorManagerImpl editorManagerImpl, EditorPathImpl editorPathImpl) {
        return editorManagerImpl.getCurrentEditorPath(editorPathImpl);
    }

    static TabGroup ra$_lastActiveTabGroup(EditorManagerImpl editorManagerImpl) {
        return editorManagerImpl._lastActiveTabGroup;
    }

    static void wa$_lastActiveTabGroup(EditorManagerImpl editorManagerImpl, TabGroup tabGroup) {
        editorManagerImpl._lastActiveTabGroup = tabGroup;
    }

    static SplitPane ra$_lastActiveSplitPane(EditorManagerImpl editorManagerImpl) {
        return editorManagerImpl._lastActiveSplitPane;
    }

    static void wa$_lastActiveSplitPane(EditorManagerImpl editorManagerImpl, SplitPane splitPane) {
        editorManagerImpl._lastActiveSplitPane = splitPane;
    }

    public final class 4
    extends AbstractAction {
        private final /* synthetic */ TabGroupState v$tabGroupState;
        final /* synthetic */ EditorManagerImpl this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            SwingUtilities.invokeLater(new 1());
        }

        public 4(EditorManagerImpl editorManagerImpl, String string, Icon icon, TabGroupState tabGroupState) {
            this.v$tabGroupState = tabGroupState;
            this.this$0 = editorManagerImpl;
            super(string, icon);
        }

        static TabGroupState ra$v$tabGroupState(4 var0) {
            return var0.v$tabGroupState;
        }

        public final class 1
        implements Runnable {
            public void run() {
                EditorManagerImpl.mav$whenWindowMenuActivates(4.this.this$0, 4.ra$v$tabGroupState(4.this));
            }
        }
    }

    public final class 3
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu contextMenu) {
            contextMenu.add((Component)EditorConstants.CUT_ITEM, MenuConstants.SECTION_EDIT_CTXT_MENU, true);
            contextMenu.add((Component)EditorConstants.COPY_ITEM, MenuConstants.SECTION_EDIT_CTXT_MENU, true);
            contextMenu.add((Component)EditorConstants.PASTE_ITEM, MenuConstants.SECTION_EDIT_CTXT_MENU, true);
            contextMenu.add((Component)EditorConstants.ALL_ITEM, MenuConstants.SECTION_EDIT_CTXT_MENU, true);
            JMenuItem jMenuItem = EditorConstants.NAVIGATE_ITEM;
            if (jMenuItem != null) {
                IdeAction ideAction = (IdeAction)jMenuItem.getAction();
                ideAction.updateAction(contextMenu.getContext());
                contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_NAVIGATE_CTXT_MENU, true);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    public static final class 2
    implements Comparator {
        public int compare(Object object, Object object2) {
            TabGroupState tabGroupState = (TabGroupState)object;
            TabGroupState tabGroupState2 = (TabGroupState)object2;
            return tabGroupState.getNodeNumber() - tabGroupState2.getNodeNumber();
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Layouts v$layouts;
        final /* synthetic */ EditorManagerImpl this$0;

        public void run() {
            EditorPathImpl editorPathImpl = new EditorPathImpl();
            if (EditorManagerImpl.mav$getCurrentEditorPath(this.this$0, editorPathImpl)) {
                SplitPaneState splitPaneState;
                SplitPane splitPane;
                TabGroup tabGroup = editorPathImpl.getTabGroup();
                if (tabGroup != EditorManagerImpl.ra$_lastActiveTabGroup(this.this$0)) {
                    if (EditorManagerImpl.ra$_lastActiveTabGroup(this.this$0) != null) {
                        EditorManagerImpl.ra$_lastActiveTabGroup(this.this$0).highlight(false);
                    }
                    EditorManagerImpl.wa$_lastActiveTabGroup(this.this$0, tabGroup);
                    if (EditorManagerImpl.ra$_lastActiveTabGroup(this.this$0) != null) {
                        EditorManagerImpl.ra$_lastActiveTabGroup(this.this$0).highlight(true);
                    }
                }
                if ((splitPane = (splitPaneState = editorPathImpl.getSplitPaneState()).getSplitPane()) != EditorManagerImpl.ra$_lastActiveSplitPane(this.this$0)) {
                    if (EditorManagerImpl.ra$_lastActiveSplitPane(this.this$0) != null) {
                        EditorManagerImpl.ra$_lastActiveSplitPane(this.this$0).highlight(false);
                    }
                    EditorManagerImpl.wa$_lastActiveSplitPane(this.this$0, splitPane);
                    if (EditorManagerImpl.ra$_lastActiveSplitPane(this.this$0) != null) {
                        EditorManagerImpl.ra$_lastActiveSplitPane(this.this$0).highlight(true);
                    }
                }
                EditorState editorState = editorPathImpl.getEditorState();
                Editor editor = editorState.getEditor();
                IdeLayout ideLayout = this.v$layouts.getActiveLayout();
                Layout layout = this.v$layouts.getActiveSubLayout();
                this.v$layouts.activatePreferredLayout(editor);
                Context context = editor.getContext();
                EditorAddin editorAddin = editorState.getEditorAddin();
                this.this$0.raiseContextInLRUList(context, editorAddin);
            } else {
                int n = this.this$0.getDesktop().getTabGroupCount();
                if (n == 0) {
                    this.v$layouts.activateDefaultDesignLayout();
                }
            }
        }

        public 1(EditorManagerImpl editorManagerImpl, Layouts layouts) {
            this.v$layouts = layouts;
            this.this$0 = editorManagerImpl;
        }
    }
}

