/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import oracle.ide.editor.EditorPath;
import oracle.ideimpl.editor.Desktop;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorState;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.TabGroup;
import oracle.ideimpl.editor.TabGroupState;

public final class EditorPathImpl
extends EditorPath {
    public static final int EDITOR_STATUS_UNKNOWN = 0;
    public static final int EDITOR_STATUS_ACTIVE = 1;
    public static final int EDITOR_STATUS_EXISTS = 2;
    public static final int EDITOR_STATUS_NEW = 3;
    int _tabGroupPos;
    int _tabGroupStatePos;
    int _panePos;
    int _editorPos;
    int _editorStatus;

    void $init$() {
        this._tabGroupPos = -1;
        this._tabGroupStatePos = -1;
        this._panePos = -1;
        this._editorPos = -1;
        this._editorStatus = 0;
    }

    public EditorPathImpl() {
        this.$init$();
    }

    public EditorPathImpl(int n, int n2, int n3, int n4) {
        this.$init$();
        this._tabGroupPos = n;
        this._tabGroupStatePos = n2;
        this._panePos = n3;
        this._editorPos = n4;
    }

    public String toString() {
        return "[_tabGroupPos=" + this._tabGroupPos + ";_tabGroupStatePos=" + this._tabGroupStatePos + ";_panePos=" + this._panePos + ";_editorPos=" + this._editorPos + "]";
    }

    public TabGroup getTabGroup() {
        EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
        return this.getTabGroup(editorManagerImpl);
    }

    private TabGroup getTabGroup(EditorManagerImpl editorManagerImpl) {
        TabGroup tabGroup = null;
        Desktop desktop = editorManagerImpl.getDesktop();
        if (0 <= this._tabGroupPos && this._tabGroupPos < desktop.getTabGroupCount()) {
            tabGroup = desktop.getTabGroup(this._tabGroupPos);
        }
        return tabGroup;
    }

    public TabGroupState getTabGroupState() {
        TabGroup tabGroup = this.getTabGroup();
        return this.getTabGroupState(tabGroup);
    }

    private TabGroupState getTabGroupState(TabGroup tabGroup) {
        TabGroupState tabGroupState = null;
        if (tabGroup != null && 0 <= this._tabGroupStatePos && this._tabGroupStatePos < tabGroup.getTabGroupStateCount()) {
            tabGroupState = tabGroup.getTabGroupState(this._tabGroupStatePos);
        }
        return tabGroupState;
    }

    public SplitPaneState getSplitPaneState() {
        TabGroupState tabGroupState = this.getTabGroupState();
        return this.getSplitPaneState(tabGroupState);
    }

    private SplitPaneState getSplitPaneState(TabGroupState tabGroupState) {
        SplitPaneState splitPaneState = null;
        if (tabGroupState != null && 0 <= this._panePos && this._panePos < tabGroupState.getSplitPaneStateCount()) {
            splitPaneState = tabGroupState.getSplitPaneState(this._panePos);
        }
        return splitPaneState;
    }

    public EditorState getEditorState() {
        SplitPaneState splitPaneState = this.getSplitPaneState();
        return this.getEditorState(splitPaneState);
    }

    private EditorState getEditorState(SplitPaneState splitPaneState) {
        EditorState editorState = null;
        if (splitPaneState != null && 0 <= this._editorPos && this._editorPos < splitPaneState.getEditorStateCount()) {
            editorState = splitPaneState.getEditorState(this._editorPos);
        }
        return editorState;
    }

    public int getEditorStatus() {
        return this._editorStatus;
    }
}

