/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.Displayable;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.TabGroupState;
import oracle.ideimpl.window.WindowSelector;

final class EditorSelector
extends WindowSelector {
    private static final EditorSelector INSTANCE;
    private List _nodeList;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = EditorSelector.class.desiredAssertionStatus() ^ true;
        INSTANCE = new EditorSelector();
    }

    private EditorSelector() {
    }

    public static EditorSelector getInstance() {
        return INSTANCE;
    }

    void selectNext(List list) {
        this.initialize(list);
        this.selectNextItem();
    }

    void selectPrevious(List list) {
        this.initialize(list);
        this.selectPreviousItem();
    }

    protected Displayable[] getDisplayables() {
        if (!$assertionsDisabled && this._nodeList == null) {
            throw new AssertionError();
        }
        Displayable[] displayableArray = new Displayable[this._nodeList.size()];
        int n = 0;
        for (TabGroupState tabGroupState : this._nodeList) {
            displayableArray[n++] = tabGroupState.getContext().getNode();
        }
        return displayableArray;
    }

    protected void activateSelectedWindow() {
        if (this._nodeList != null) {
            int n = this.getSelectedIndex();
            TabGroupState tabGroupState = (TabGroupState)this._nodeList.get(n);
            this.dispose();
            EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
            EditorPathImpl editorPathImpl = new EditorPathImpl();
            if (editorManagerImpl.searchEditor(editorPathImpl, new EditorCriteriaImpl(tabGroupState))) {
                editorManagerImpl.focusEditor(editorPathImpl);
                editorManagerImpl.moveTabGroupStateSwitchToTop(tabGroupState);
            }
        }
    }

    protected void dispose() {
        super.dispose();
        this._nodeList = null;
    }

    private void initialize(List list) {
        if (this._nodeList == null) {
            if (!($assertionsDisabled || list != null && list.size() > 1)) {
                throw new AssertionError();
            }
            this._nodeList = new ArrayList();
            for (TabGroupState tabGroupState : list) {
                if (!tabGroupState.getParentTabGroup().isVisible()) continue;
                this._nodeList.add(tabGroupState);
            }
            if (!$assertionsDisabled && this._nodeList.size() <= 1) {
                throw new AssertionError();
            }
        }
    }
}

