/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Component;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorCreator;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.model.Node;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.TabGroupState;

final class EditorState
implements EditorInfo {
    private static final String KEY_XSCROLL_MIN = "xScrollMin";
    private static final String KEY_XSCROLL_MAX = "xScrollMax";
    private static final String KEY_XSCROLL_EXT = "xScrollExtent";
    private static final String KEY_XSCROLL_POS = "xScrollPos";
    private static final String KEY_YSCROLL_MIN = "yScrollMin";
    private static final String KEY_YSCROLL_MAX = "yScrollMax";
    private static final String KEY_YSCROLL_EXT = "yScrollExtent";
    private static final String KEY_YSCROLL_POS = "yScrollPos";
    private SplitPaneState _parentSplitPaneState;
    private final EditorAddin _editorAddin;
    private Editor _editor;
    private boolean _enabled;
    private Component _focusedComponent;
    private int _xScrollMin;
    private int _xScrollMax;
    private int _xScrollExtent;
    private int _xScrollPos;
    private int _yScrollMin;
    private int _yScrollMax;
    private int _yScrollExtent;
    private int _yScrollPos;
    private StructuredPropertyAccess _layoutInfo;

    void $init$() {
        this._enabled = true;
    }

    public EditorState(SplitPaneState splitPaneState, EditorAddin editorAddin) {
        this.$init$();
        this._parentSplitPaneState = splitPaneState;
        this._editorAddin = editorAddin;
    }

    SplitPaneState getParentSplitPaneState() {
        return this._parentSplitPaneState;
    }

    public EditorAddin getEditorAddin() {
        return this._editorAddin;
    }

    public Editor getEditor() {
        return this._editor;
    }

    private Editor giveUpEditor() {
        Editor editor = this.getEditor();
        this.setEditor(null);
        return editor;
    }

    public Editor getOrCreateEditor(Context context) {
        Editor editor = this.getEditor();
        if (editor != null || (editor = this.createEditor(context)) != null) {
            // empty if block
        }
        return editor;
    }

    Editor createEditor(Context context) {
        Editor editor = null;
        Editor editor2 = this.stealEditor();
        if (editor2 != null) {
            editor = editor2;
            this.setEditor(editor2);
        } else {
            EditorAddin editorAddin = this.getEditorAddin();
            if (editorAddin instanceof EditorCreator) {
                editor = ((EditorCreator)((Object)editorAddin)).createEditor(context);
            } else {
                Class clazz = editorAddin.getEditorClass();
                try {
                    editor = (Editor)clazz.newInstance();
                }
                catch (Exception exception) {
                    System.err.println("Failed to create an instance of editor " + clazz.getName());
                    exception.printStackTrace();
                }
            }
            if (editor != null) {
                editor.setContext(context);
                EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
                editorManagerImpl.initPreferredLayoutInfo(editor, context);
                if (!this.openEditor(editor)) {
                    return null;
                }
            }
        }
        return editor;
    }

    private Editor stealEditor() {
        Editor editor = null;
        if (!this.isSplittable()) {
            TabGroupState tabGroupState;
            EditorAddin editorAddin = this.getEditorAddin();
            SplitPaneState splitPaneState = this.getParentSplitPaneState();
            if (splitPaneState != null && (tabGroupState = splitPaneState.getParentTabGroupState()) != null) {
                int n = tabGroupState.getSplitPaneStateCount();
                int n2 = 0;
                while (editor == null && n2 < n) {
                    SplitPaneState splitPaneState2 = tabGroupState.getSplitPaneState(n2);
                    int n3 = splitPaneState2.getEditorStateCount();
                    int n4 = 0;
                    while (editor == null && n4 < n3) {
                        EditorState editorState = splitPaneState2.getEditorState(n4);
                        if (editorState != this && editorState.getEditorAddin() == editorAddin) {
                            editor = editorState.giveUpEditor();
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        return editor;
    }

    public boolean match(EditorCriteriaImpl editorCriteriaImpl) {
        boolean bl = false;
        switch (editorCriteriaImpl.getType()) {
            case 11: {
                bl = this.equals(editorCriteriaImpl.getEditorInfo());
                break;
            }
            case 3: {
                bl = editorCriteriaImpl.getEditor().equals(this._editor);
                break;
            }
            case 10: {
                if (this._editor == null) break;
                Class clazz = editorCriteriaImpl.getEditorClass();
                bl = clazz == null || clazz.equals(this._editor.getClass());
            }
        }
        return bl;
    }

    boolean openEditor(Editor editor) {
        boolean bl = true;
        try {
            if (editor != null) {
                editor.open();
                if (this._layoutInfo != null) {
                    this.applyLayoutInfo(editor, this._layoutInfo);
                    this._layoutInfo = null;
                }
            }
            EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
            if (this._editor != null) {
                editorManagerImpl.whenEditorClosed(this._editor);
                this._editor.close();
            }
            this.setEditor(editor);
            if (this._editor != null) {
                editorManagerImpl.whenEditorOpened(this._editor);
            }
        }
        catch (OpenAbortedException openAbortedException) {
            bl = false;
        }
        return bl;
    }

    private void setEditor(Editor editor) {
        this._editor = editor;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean bl) {
        if (bl != this._enabled) {
            this._enabled = bl;
            SplitPaneState splitPaneState = this.getParentSplitPaneState();
            splitPaneState.whenEditorStateChanges(this);
        }
    }

    public Component getFocusedComponent() {
        return this._focusedComponent;
    }

    public void setFocusedComponent(Component component) {
        this._focusedComponent = component;
    }

    public int getXScrollPos() {
        return this._xScrollPos;
    }

    public int getXScrollExtent() {
        return this._xScrollExtent;
    }

    public int getXScrollMax() {
        return this._xScrollMax;
    }

    public int getXScrollMin() {
        return this._xScrollMin;
    }

    public void setXScrollExtent(int n) {
        this._xScrollExtent = n;
    }

    public void setXScrollMax(int n) {
        this._xScrollMax = n;
    }

    public void setXScrollMin(int n) {
        this._xScrollMin = n;
    }

    public void setXScrollPos(int n) {
        this._xScrollPos = n;
    }

    public int getYScrollPos() {
        return this._yScrollPos;
    }

    public void setYScrollPos(int n) {
        this._yScrollPos = n;
    }

    public int getYScrollExtent() {
        return this._yScrollExtent;
    }

    public int getYScrollMax() {
        return this._yScrollMax;
    }

    public int getYScrollMin() {
        return this._yScrollMin;
    }

    public void setYScrollExtent(int n) {
        this._yScrollExtent = n;
    }

    public void setYScrollMax(int n) {
        this._yScrollMax = n;
    }

    public void setYScrollMin(int n) {
        this._yScrollMin = n;
    }

    private static EditorManagerImpl getEditorManager() {
        return EditorManagerImpl.getInstance();
    }

    private EditorPathImpl getPath() {
        EditorPathImpl editorPathImpl = new EditorPathImpl();
        EditorState.getEditorManager().searchEditor(editorPathImpl, new EditorCriteriaImpl(this));
        return editorPathImpl;
    }

    private TabGroupState getTabGroupState() {
        return this.getPath().getTabGroupState();
    }

    private Node getNode() {
        return this.getTabGroupState().getContext().getNode();
    }

    public Editor _getEditor() {
        return this._editor;
    }

    public String _getShortLabel() {
        String string = null;
        Node node = this.getNode();
        if (node != null) {
            string = node.getShortLabel();
        }
        return string;
    }

    public String _getLongLabel() {
        String string = null;
        Node node = this.getNode();
        if (node != null) {
            string = node.getLongLabel();
        }
        return string;
    }

    public Icon _getIcon() {
        Icon icon = null;
        Node node = this.getNode();
        if (node != null) {
            icon = node.getIcon();
        }
        return icon;
    }

    void dump(String string, boolean bl) {
        String string2 = bl ? "*" : "";
        String string3 = this._editorAddin.getClass().getName();
        String string4 = this._editor != null ? " - " + this._editor.getClass().getName() : "";
        System.out.println(string + "EditorState - " + string2 + string3 + string4);
    }

    public boolean isSplittable() {
        return this.getEditorAddin().isDuplicable();
    }

    void saveStateInfo(StructuredPropertyAccess structuredPropertyAccess) {
        int n = this.getXScrollMin();
        int n2 = this.getXScrollMax();
        int n3 = this.getXScrollExtent();
        int n4 = this.getXScrollPos();
        structuredPropertyAccess.setProperty(KEY_XSCROLL_MIN, Integer.toString(n));
        structuredPropertyAccess.setProperty(KEY_XSCROLL_MAX, Integer.toString(n2));
        structuredPropertyAccess.setProperty(KEY_XSCROLL_EXT, Integer.toString(n3));
        structuredPropertyAccess.setProperty(KEY_XSCROLL_POS, Integer.toString(n4));
        int n5 = this.getYScrollMin();
        int n6 = this.getYScrollMax();
        int n7 = this.getYScrollExtent();
        int n8 = this.getYScrollPos();
        structuredPropertyAccess.setProperty(KEY_YSCROLL_MIN, Integer.toString(n5));
        structuredPropertyAccess.setProperty(KEY_YSCROLL_MAX, Integer.toString(n6));
        structuredPropertyAccess.setProperty(KEY_YSCROLL_EXT, Integer.toString(n7));
        structuredPropertyAccess.setProperty(KEY_YSCROLL_POS, Integer.toString(n8));
        Editor editor = this.getEditor();
        if (editor != null) {
            editor.saveSettings(structuredPropertyAccess);
        }
    }

    void loadStateInfo(StructuredPropertyAccess structuredPropertyAccess) {
        if (this._editor == null) {
            this._layoutInfo = structuredPropertyAccess;
        } else {
            this.applyLayoutInfo(this._editor, structuredPropertyAccess);
        }
    }

    StructuredPropertyAccess getStateInfo() {
        return this._layoutInfo;
    }

    private void applyLayoutInfo(Editor editor, StructuredPropertyAccess structuredPropertyAccess) {
        int n = Integer.parseInt(structuredPropertyAccess.getProperty(KEY_XSCROLL_MIN, "0"));
        int n2 = Integer.parseInt(structuredPropertyAccess.getProperty(KEY_XSCROLL_MAX, "1000"));
        int n3 = Integer.parseInt(structuredPropertyAccess.getProperty(KEY_XSCROLL_EXT, "1000"));
        int n4 = Integer.parseInt(structuredPropertyAccess.getProperty(KEY_XSCROLL_POS, "0"));
        this.setXScrollMin(n);
        this.setXScrollMax(n2);
        this.setXScrollExtent(n3);
        this.setXScrollPos(n4);
        int n5 = Integer.parseInt(structuredPropertyAccess.getProperty(KEY_YSCROLL_MIN, "0"));
        int n6 = Integer.parseInt(structuredPropertyAccess.getProperty(KEY_YSCROLL_MAX, "1000"));
        int n7 = Integer.parseInt(structuredPropertyAccess.getProperty(KEY_YSCROLL_EXT, "1000"));
        int n8 = Integer.parseInt(structuredPropertyAccess.getProperty(KEY_YSCROLL_POS, "0"));
        this.setYScrollMin(n5);
        this.setYScrollMax(n6);
        this.setYScrollExtent(n7);
        this.setYScrollPos(n8);
        editor.loadSettings(structuredPropertyAccess);
    }
}

