/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.layout.URL2String;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.ProfileIDs;

abstract class EditorUtil {
    static boolean isSameNode(Context context, Context context2) {
        Node node = context.getNode();
        Node node2 = context2.getNode();
        return EditorUtil.isSameNode(node, node2);
    }

    static boolean isSameNode(Node node, Node node2) {
        URL uRL;
        URL uRL2;
        boolean bl = false;
        if (node == node2) {
            bl = true;
        } else if (node != null && node2 != null && URLFileSystem.equals(uRL2 = node.getURL(), uRL = node2.getURL())) {
            bl = true;
        }
        return bl;
    }

    static Context loadContext(StructuredPropertyAccess structuredPropertyAccess) {
        int n = 0;
        if (ProfileIDs.PROFILE_GETCONTEXT) {
            n = IdeProfile.startEvent(3313);
        }
        Context context = null;
        Node node = EditorUtil.getNode("document", structuredPropertyAccess);
        if (node != null) {
            Node node2;
            Context context2 = Context.newIdeContext(node);
            Node node3 = EditorUtil.getNode("project", structuredPropertyAccess);
            if (node3 instanceof Project) {
                context2.setProject((Project)node3);
            }
            if ((node2 = EditorUtil.getNode("workspace", structuredPropertyAccess)) instanceof Workspace) {
                context2.setWorkspace((Workspace)node2);
            }
            context = context2;
        }
        if (ProfileIDs.PROFILE_GETCONTEXT) {
            IdeProfile.endEvent(n);
        }
        return context;
    }

    private static Node getNode(String string, StructuredPropertyAccess structuredPropertyAccess) {
        URL uRL = EditorUtil.getURL(string, structuredPropertyAccess);
        Node node = null;
        if (uRL != null && (URLFileSystem.exists(uRL) || URLFileSystem.hasSuffix(uRL, ".helpT") || URLFileSystem.hasSuffix(uRL, ".help"))) {
            try {
                node = NodeFactory.findOrCreate(uRL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return node;
    }

    private static URL getURL(String string, StructuredPropertyAccess structuredPropertyAccess) {
        String string2 = structuredPropertyAccess.getProperty(string, null);
        URL uRL = null;
        if (string2 != null && string2.length() > 0) {
            uRL = URL2String.toURL(string2);
        }
        return uRL;
    }

    static void saveContext(Context context, StructuredPropertyAccess structuredPropertyAccess) {
        Node node;
        Workspace workspace;
        Project project = context.getProject();
        if (project != null) {
            URL uRL = project.getURL();
            String string = URL2String.toString(uRL);
            structuredPropertyAccess.setProperty("project", string);
        }
        if ((workspace = context.getWorkspace()) != null) {
            URL uRL = workspace.getURL();
            String string = URL2String.toString(uRL);
            structuredPropertyAccess.setProperty("workspace", string);
        }
        if ((node = context.getNode()) != null) {
            URL uRL = node.getURL();
            String string = URL2String.toString(uRL);
            structuredPropertyAccess.setProperty("document", string);
        }
    }

    static boolean isOldEditor(Editor editor) {
        Boolean bl = (Boolean)editor.getEditorAttribute("old_editor");
        return Boolean.TRUE.equals(bl);
    }

    EditorUtil() {
    }
}

