/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.EditorsOptions;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.DialogsArb;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.editor.EditorManagerImpl;

final class LastUsedFiles
extends JPanel
implements ListSelectionListener,
ActionListener,
KeyListener {
    private Set _duplicates;
    private RecentFile[] _recentFiles;
    private KeyNavigationManager _keyNavigationManager;
    private JCheckBox _showAll;
    private JList _lFiles;
    private DismissableJEWTDialog _container;

    public static boolean runDialog(Frame frame, RecentFile[] recentFileArray) {
        LastUsedFiles lastUsedFiles = new LastUsedFiles(recentFileArray);
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        DismissableJEWTDialog dismissableJEWTDialog = new DismissableJEWTDialog(frame);
        if (helpSystem != null) {
            helpSystem.registerTopic(lastUsedFiles, "f1_idedrecentfiles_html");
        }
        lastUsedFiles.setContainer(dismissableJEWTDialog);
        dismissableJEWTDialog.setInitialFocus(lastUsedFiles._lFiles);
        dismissableJEWTDialog.setContent(lastUsedFiles);
        dismissableJEWTDialog.setResizable(true);
        boolean bl = WizardLauncher.runDialog((JDialog)((Object)dismissableJEWTDialog));
        if (bl) {
            JList jList = lastUsedFiles._lFiles;
            Object[] objectArray = jList.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                Object[] objectArray2 = jList.getSelectedValues();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    MyModelElement myModelElement = (MyModelElement)objectArray2[n2];
                    Context context = myModelElement.getContext();
                    EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                    openEditorOptions.setFlags(8, true);
                    editorManagerImpl.openEditor(openEditorOptions);
                    ++n2;
                }
                ++n;
            }
        }
        return bl;
    }

    private LastUsedFiles(RecentFile[] recentFileArray) {
        this._recentFiles = recentFileArray;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        Dimension dimension = new Dimension(400, 400);
        this.setSize(dimension);
        JLabel jLabel = new JLabel();
        DefaultListModel defaultListModel = new DefaultListModel();
        this._lFiles = new 1MyList(defaultListModel);
        this._lFiles.addListSelectionListener(this);
        this._lFiles.setCellRenderer(new 2());
        this._lFiles.addKeyListener(this);
        this._keyNavigationManager = new KeyNavigationManager(new KeyNavigationManager.ListKeyAdapter(this._lFiles));
        EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
        EditorsOptions editorsOptions = editorManagerImpl.getEditorsOptions();
        boolean bl = editorsOptions.isRecentFilesShowAll();
        this._showAll = new JCheckBox();
        this._showAll.getModel().setSelected(bl);
        this._showAll.addActionListener(this);
        ResourceUtils.resButton(this._showAll, DialogsArb.getString(16));
        this.fillEditors();
        ResourceUtils.resLabel(jLabel, this._lFiles, DialogsArb.getString(15));
        this._lFiles.addMouseListener(new 1());
        this._lFiles.setSelectionMode(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)new JScrollPane(this._lFiles), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this._showAll, gridBagConstraints);
        this.whenSelectionChanges();
    }

    private void fillEditors() {
        ButtonModel buttonModel = this._showAll.getModel();
        boolean bl = buttonModel.isSelected();
        RecentFile[] recentFileArray = LastUsedFiles.getValidRecentFiles(this._recentFiles);
        RecentFile[] recentFileArray2 = bl ? recentFileArray : LastUsedFiles.filterExplicits(recentFileArray);
        this._duplicates = LastUsedFiles.getDuplicates(recentFileArray2);
        DefaultListModel defaultListModel = (DefaultListModel)this._lFiles.getModel();
        ListSelectionModel listSelectionModel = this._lFiles.getSelectionModel();
        List<Object> list = Arrays.asList(this._lFiles.getSelectedValues());
        defaultListModel.clear();
        int n = recentFileArray2.length;
        defaultListModel.ensureCapacity(n);
        int n2 = 0;
        while (n2 < n) {
            RecentFile recentFile = recentFileArray2[n2];
            MyModelElement myModelElement = new MyModelElement(recentFile);
            defaultListModel.addElement(myModelElement);
            if (list.contains(myModelElement)) {
                listSelectionModel.addSelectionInterval(n2, n2);
            }
            ++n2;
        }
    }

    private static RecentFile[] getValidRecentFiles(RecentFile[] recentFileArray) {
        ArrayList<RecentFile> arrayList = new ArrayList<RecentFile>(recentFileArray.length);
        int n = 0;
        while (n < recentFileArray.length) {
            RecentFile recentFile = recentFileArray[n];
            if (recentFile != null) {
                Context context = recentFile.getContext();
                if (context != null) {
                    Node node = context.getNode();
                    if (node != null) {
                        URL uRL = node.getURL();
                        if (URLFileSystem.exists(uRL)) {
                            String string = node.getShortLabel();
                            if (string != null) {
                                String string2 = node.getLongLabel();
                                if (string2 != null) {
                                    arrayList.add(recentFile);
                                } else {
                                    System.err.println("null loglabel for " + recentFile.getNodeURL());
                                }
                            } else {
                                System.err.println("null shortlabel for " + recentFile.getNodeURL());
                            }
                        }
                    } else {
                        System.err.println("null node for " + recentFile.getNodeURL());
                    }
                } else {
                    System.err.println("null context for " + recentFile.getNodeURL());
                }
            } else {
                System.err.println("recentFile[" + n + "] is null");
            }
            ++n;
        }
        return arrayList.toArray(new RecentFile[arrayList.size()]);
    }

    private static RecentFile[] filterExplicits(RecentFile[] recentFileArray) {
        ArrayList<RecentFile> arrayList = new ArrayList<RecentFile>(recentFileArray.length);
        int n = 0;
        while (n < recentFileArray.length) {
            RecentFile recentFile = recentFileArray[n];
            if (recentFile.isExplicit()) {
                arrayList.add(recentFile);
            }
            ++n;
        }
        return arrayList.toArray(new RecentFile[arrayList.size()]);
    }

    private static Set getDuplicates(RecentFile[] recentFileArray) {
        int n = recentFileArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            Context context = recentFileArray[n2].getContext();
            Node node = context.getNode();
            stringArray[n2] = node.getShortLabel();
            ++n2;
        }
        ArrayList<RecentFile> arrayList = new ArrayList<RecentFile>();
        int n3 = 0;
        while (n3 < n) {
            boolean bl = false;
            int n4 = n3 + 1;
            while (n4 < n) {
                if (stringArray[n3].equals(stringArray[n4])) {
                    arrayList.add(recentFileArray[n4]);
                    bl = true;
                }
                ++n4;
            }
            if (bl) {
                arrayList.add(recentFileArray[n3]);
            }
            ++n3;
        }
        return new HashSet(arrayList);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        EditorsOptions editorsOptions = EditorManagerImpl.getInstance().getEditorsOptions();
        ButtonModel buttonModel = this._showAll.getModel();
        boolean bl = buttonModel.isSelected();
        editorsOptions.setRecentFilesShowAll(bl);
        this.fillEditors();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.whenSelectionChanges();
    }

    private void whenSelectionChanges() {
        DismissableJEWTDialog dismissableJEWTDialog = this.getContainer();
        if (dismissableJEWTDialog != null) {
            ListSelectionModel listSelectionModel = this._lFiles.getSelectionModel();
            boolean bl = listSelectionModel.isSelectionEmpty();
            dismissableJEWTDialog.setOKButtonEnabled(!bl);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 10) {
            DismissableJEWTDialog.mav$dismiss(this.getContainer());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private DismissableJEWTDialog getContainer() {
        return this._container;
    }

    private void setContainer(DismissableJEWTDialog dismissableJEWTDialog) {
        this._container = dismissableJEWTDialog;
        this.whenSelectionChanges();
    }

    static KeyNavigationManager ra$_keyNavigationManager(LastUsedFiles lastUsedFiles) {
        return lastUsedFiles._keyNavigationManager;
    }

    static DismissableJEWTDialog mav$getContainer(LastUsedFiles lastUsedFiles) {
        return lastUsedFiles.getContainer();
    }

    static Set ra$_duplicates(LastUsedFiles lastUsedFiles) {
        return lastUsedFiles._duplicates;
    }

    private static final class DismissableJEWTDialog
    extends JEWTDialog {
        public DismissableJEWTDialog(Frame frame) {
            super(frame, DialogsArb.getString(14), 7);
        }

        private void dismiss() {
            this.dismissDialog(false);
        }

        static void mav$dismiss(DismissableJEWTDialog dismissableJEWTDialog) {
            dismissableJEWTDialog.dismiss();
        }
    }

    final class 1MyList
    extends JList {
        public 1MyList(ListModel listModel) {
            super(listModel);
            this.enableEvents(8);
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            if (LastUsedFiles.ra$_keyNavigationManager(LastUsedFiles.this) != null) {
                LastUsedFiles.ra$_keyNavigationManager(LastUsedFiles.this).preProcessKeyEvent(keyEvent);
            }
            super.processKeyEvent(keyEvent);
            if (LastUsedFiles.ra$_keyNavigationManager(LastUsedFiles.this) != null) {
                LastUsedFiles.ra$_keyNavigationManager(LastUsedFiles.this).postProcessKeyEvent(keyEvent);
            }
            if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 10) {
                DismissableJEWTDialog.mav$dismiss(LastUsedFiles.mav$getContainer(LastUsedFiles.this));
            }
        }
    }

    final class 2
    extends DefaultListCellRenderer {
        private MyModelElement _currentModelElement;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this._currentModelElement = (MyModelElement)object;
            String string = this._currentModelElement.getText();
            this.setText(string);
            Context context = this._currentModelElement.getContext();
            Node node = context.getNode();
            this.setIcon(node.getIcon());
            return this;
        }

        public String getToolTipText() {
            String string;
            if (this._currentModelElement != null) {
                Context context = this._currentModelElement.getContext();
                Node node = context.getNode();
                string = node.getLongLabel();
            } else {
                string = super.getToolTipText();
            }
            return string;
        }
    }

    final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                DismissableJEWTDialog.mav$dismiss(LastUsedFiles.mav$getContainer(LastUsedFiles.this));
            }
        }
    }

    private final class MyModelElement {
        private RecentFile _recentFile;

        public MyModelElement(RecentFile recentFile) {
            this._recentFile = recentFile;
        }

        public boolean equals(Object object) {
            MyModelElement myModelElement = (MyModelElement)object;
            return this._recentFile.equals(myModelElement);
        }

        public int hashCode() {
            return this._recentFile.hashCode();
        }

        public String toString() {
            return this.getText();
        }

        public Context getContext() {
            return this._recentFile.getContext();
        }

        String getText() {
            Context context = this.getContext();
            Node node = context.getNode();
            String string = node.getShortLabel();
            if (LastUsedFiles.ra$_duplicates(LastUsedFiles.this).contains(this._recentFile)) {
                string = string + " (" + node.getLongLabel() + ")";
            }
            return string;
        }
    }
}

