/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorsOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.model.Node;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;

final class RecentFilesLRU {
    private int LRU_FILES_SIZE;
    private ArrayList _lruFiles;
    private int _explicitCount;

    RecentFilesLRU() {
        String string = Ide.getProperty("Editors.RecentFilesSize", "20");
        this.LRU_FILES_SIZE = Integer.parseInt(string);
    }

    public void setExplicit(Context context, boolean bl) {
        RecentFile recentFile = this.getRecentFile(context);
        if (recentFile != null) {
            boolean bl2 = recentFile.isExplicit();
            if (bl2) {
                --this._explicitCount;
            }
            recentFile.setExplicit(bl);
            if (bl) {
                ++this._explicitCount;
            }
            this.adjustSize();
        }
    }

    private void adjustSize() {
        if (this._explicitCount > this.LRU_FILES_SIZE) {
            this.removeOldest(true);
        } else {
            int n = this.getLRUList().size();
            int n2 = n - this._explicitCount;
            if (n2 > this.LRU_FILES_SIZE) {
                this.removeOldest(false);
            }
        }
    }

    private void removeOldest(boolean bl) {
        EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
        EditorPathImpl editorPathImpl = new EditorPathImpl();
        ArrayList arrayList = this.getLRUList();
        int n = 0;
        while (n < arrayList.size()) {
            EditorCriteriaImpl editorCriteriaImpl;
            Context context;
            boolean bl2;
            RecentFile recentFile = (RecentFile)arrayList.get(n);
            boolean bl3 = recentFile.isExplicit();
            if (bl3 == bl && (bl2 = (context = recentFile.getContext()) != null ? false == editorManagerImpl.searchEditor(editorPathImpl, editorCriteriaImpl = new EditorCriteriaImpl(context)) : true)) {
                arrayList.remove(n);
                if (!bl3) break;
                --this._explicitCount;
                break;
            }
            ++n;
        }
    }

    RecentFile[] getRecentFiles() {
        ArrayList arrayList = this.getLRUList();
        int n = arrayList.size();
        RecentFile[] recentFileArray = new RecentFile[n];
        int n2 = 0;
        while (n2 < n) {
            RecentFile recentFile;
            recentFileArray[n - n2 - 1] = recentFile = (RecentFile)arrayList.get(n2);
            ++n2;
        }
        return recentFileArray;
    }

    void raiseContextInLRUList(Context context, String string) {
        Node node;
        if (context != null && (node = context.getNode()) != null) {
            RecentFile recentFile = this.remove(context);
            if (recentFile == null) {
                recentFile = new RecentFile(context);
            }
            if (string != null) {
                recentFile.setEditor(string);
            }
            ArrayList arrayList = this.getLRUList();
            arrayList.add(recentFile);
            if (recentFile.isExplicit()) {
                ++this._explicitCount;
            }
            this.adjustSize();
        }
    }

    private ArrayList getLRUList() {
        if (this._lruFiles == null) {
            EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
            EditorsOptions editorsOptions = editorManagerImpl.getEditorsOptions();
            this._lruFiles = editorsOptions.getLruFiles();
            int n = 0;
            while (n < this._lruFiles.size()) {
                RecentFile recentFile = (RecentFile)this._lruFiles.get(n);
                if (recentFile.isExplicit()) {
                    ++this._explicitCount;
                }
                ++n;
            }
        }
        return this._lruFiles;
    }

    private int getPositionInLRUList(Context context) {
        if (context != null) {
            ArrayList arrayList = this.getLRUList();
            int n = 0;
            while (n < arrayList.size()) {
                RecentFile recentFile = (RecentFile)arrayList.get(n);
                if (recentFile.isSameNode(context)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    RecentFile getRecentFile(Context context) {
        RecentFile recentFile = null;
        int n = this.getPositionInLRUList(context);
        if (n != -1) {
            recentFile = this.getRecentFile(n);
        }
        return recentFile;
    }

    private RecentFile getRecentFile(int n) {
        return (RecentFile)this.getLRUList().get(n);
    }

    RecentFile remove(Context context) {
        RecentFile recentFile = null;
        int n = this.getPositionInLRUList(context);
        if (n >= 0 && (recentFile = (RecentFile)this.getLRUList().remove(n)).isExplicit()) {
            --this._explicitCount;
        }
        return recentFile;
    }
}

