/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.DoubleClickTrigger;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.JDK;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.TitledContainer;
import oracle.ideimpl.controls.ScrollableCustomTab;
import oracle.ideimpl.editor.Desktop;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.EditorState;
import oracle.ideimpl.editor.EditorUtil;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.Splitter;
import oracle.ideimpl.editor.TabGroup;
import oracle.ideimpl.editor.TabGroupState;

final class SplitPane
extends JPanel
implements ComponentListener,
PropertyChangeListener,
MouseMotionListener,
MouseListener,
TitledContainer {
    private static final int SPLIT_DRAG_BOUNDS_THRESHHOLD = 25;
    private static int _splitPaneID = 0;
    private final int _id;
    private SplitPaneState _splitPaneState;
    private final JScrollPane _scrollPane;
    private final JScrollBar _nativeVertScrollBar;
    private Component _installedVertScrollBar;
    private boolean _vertSplitterVisible;
    private final Splitter _vertSplitter;
    private final JScrollBar _nativeHorzScrollBar;
    private Component _installedHorzScrollBar;
    private boolean _horzSplitterVisible;
    private final Splitter _horzSplitter;
    private final CustomTab _editorTabs;
    private final ScrollableCustomTab _scrollableCustomTab;
    private final JPanel _bottomPanel;
    private int _currentEditorStatePos;
    private Component _leftMargin;
    private Component _rightMargin;
    private Component _topMargin;
    private Component _bottomMargin;
    private Component _editorComponent;
    private Component _editorButtons;
    private Point _ptDragSplitter;
    private DoubleClickTrigger _splitTrigger;
    private boolean _pendingEditorShown;
    private Component _bottomComponent;

    void $init$() {
        this._id = _splitPaneID++;
        this._currentEditorStatePos = -1;
        this._splitTrigger = new DoubleClickTrigger();
    }

    public SplitPane() {
        this.$init$();
        this.setOpaque(false);
        this._scrollableCustomTab = EditorManagerImpl.getEditorManagerOption(1) ? new ScrollableCustomTab(1) : new ScrollableCustomTab(3);
        this._editorTabs = this._scrollableCustomTab.getCustomTab();
        this._editorTabs.setGapBetweenTabs(-1);
        this._editorTabs.setGapLeft(2);
        this._editorTabs.setGapRight(2);
        this._editorTabs.setOffsetSelected(0);
        this._editorTabs.setMinTabWidth(30);
        this._editorTabs.setOpaque(false);
        this._editorTabs.setShowIcons(false);
        boolean bl = EditorManagerImpl.getEditorManagerOption(4);
        this._editorTabs.setGradientHighlight(bl);
        this._editorTabs.addSelectionListener(new 2());
        this._editorTabs.addMouseListener(this);
        this.add(this._scrollableCustomTab);
        this._vertSplitter = new Splitter(0);
        this.add(this._vertSplitter);
        this._vertSplitter.addMouseListener(this);
        this._vertSplitter.addMouseMotionListener(this);
        this._horzSplitter = new Splitter(1);
        this.add(this._horzSplitter);
        this._horzSplitter.addMouseListener(this);
        this._horzSplitter.addMouseMotionListener(this);
        this._scrollPane = new JScrollPane();
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add(this._scrollPane);
        this._nativeVertScrollBar = this._scrollPane.getVerticalScrollBar();
        this.add(this._nativeVertScrollBar);
        this._nativeHorzScrollBar = this._scrollPane.getHorizontalScrollBar();
        this.add(this._nativeHorzScrollBar);
        this._scrollPane.addComponentListener(this);
        this._bottomPanel = new JPanel();
        this._bottomPanel.setBorder(BorderFactory.createLineBorder(IdeConstants.COLOR_IDE_LINES));
        this.add(this._bottomPanel);
        if (JDK.HAS_BUG_4699831) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            JViewport jViewport = this._scrollPane.getViewport();
            jViewport.addComponentListener(new 1(this, jViewport, dimension));
        }
    }

    public String toString() {
        return "SplitPane[" + this._id + ";" + String.valueOf(this._splitPaneState) + "]";
    }

    SplitPaneState getSplitPaneState() {
        return this._splitPaneState;
    }

    void setSplitPaneState(SplitPaneState splitPaneState) {
        if (this._splitPaneState != null) {
            this.detachCurrentEditor();
            this._editorTabs.setModel(null);
            this._currentEditorStatePos = -1;
        }
        this._splitPaneState = splitPaneState;
        if (this._splitPaneState != null) {
            DefaultListModel defaultListModel = this._splitPaneState.getEditorsModel();
            this._editorTabs.setModel(defaultListModel);
            int n = this._splitPaneState.getCurrentEditorStatePos();
            this.setCurrentEditorStatePos(n);
            int n2 = this._splitPaneState.getEditorStateCount();
            int n3 = 0;
            while (n3 < n2) {
                EditorState editorState = this._splitPaneState.getEditorState(n3);
                DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._editorTabs.getPage(n3);
                defaultCustomTabPage.setEnabled(editorState.isEnabled());
                ++n3;
            }
            boolean bl = true;
            if (n2 == 1 && EditorManagerImpl.getEditorManagerOption(2)) {
                bl = false;
            }
            this._scrollableCustomTab.setVisible(bl);
        }
    }

    private void setScrollableLeftMargin(Component component) {
        if (component == null) {
            this._scrollPane.setRowHeader(null);
        } else {
            this._scrollPane.setRowHeaderView(component);
        }
    }

    private void setScrollableTopMargin(Component component) {
        if (component == null) {
            this._scrollPane.setColumnHeader(null);
        } else {
            this._scrollPane.setColumnHeaderView(component);
        }
    }

    private void setFixedLeftMargin(Component component) {
        if (this._leftMargin != null) {
            this.remove(this._leftMargin);
        }
        this._leftMargin = component;
        if (this._leftMargin != null) {
            this.add(this._leftMargin);
        }
    }

    private void setFixedRightMargin(Component component) {
        if (this._rightMargin != null) {
            this.remove(this._rightMargin);
        }
        this._rightMargin = component;
        if (this._rightMargin != null) {
            this.add(this._rightMargin);
        }
    }

    private void setFixedTopMargin(Component component) {
        if (this._topMargin != null) {
            this.remove(this._topMargin);
        }
        this._topMargin = component;
        if (this._topMargin != null) {
            this.add(this._topMargin);
        }
    }

    private void setFixedBottomMargin(Component component) {
        if (this._bottomMargin != null) {
            this.remove(this._bottomMargin);
        }
        this._bottomMargin = component;
        if (this._bottomMargin != null) {
            this.add(this._bottomMargin);
        }
    }

    private void setEditorButtons(Component component) {
        if (this._editorButtons != null) {
            this.remove(this._editorButtons);
        }
        this._editorButtons = component;
        if (this._editorButtons != null) {
            this.add(this._editorButtons);
        }
    }

    private void setBottomComponent(Component component) {
        if (this._bottomComponent != null) {
            this.remove(this._bottomComponent);
        }
        this._bottomComponent = component;
        if (this._bottomComponent != null) {
            this.remove(this._bottomPanel);
            this.add(this._bottomComponent);
            this.add(this._bottomPanel);
        }
    }

    private void setEditorComponent(Component component, boolean bl, Component component2, Component component3) {
        if (bl) {
            JViewport jViewport = this._scrollPane.getViewport();
            Dimension dimension = component.getSize();
            component.setSize(dimension.width - 1, dimension.height);
            jViewport.setView(component);
            this._scrollPane.setVisible(true);
            this._editorComponent = this._scrollPane;
            if (component2 == null) {
                this._installedHorzScrollBar = this.getNativeHorzScrollBar();
                this._installedHorzScrollBar.setVisible(true);
            } else {
                this._installedHorzScrollBar = component2;
                this.remove(this._bottomPanel);
                this.add(component2);
                this.add(this._bottomPanel);
            }
            if (component3 == null) {
                this._installedVertScrollBar = this.getNativeVertScrollBar();
                this._installedVertScrollBar.setVisible(true);
            } else {
                this._installedVertScrollBar = component3;
                this.add(component3);
            }
        } else {
            this._scrollPane.setVisible(false);
            this.getNativeHorzScrollBar().setVisible(false);
            if (component2 != null) {
                this.remove(this._bottomPanel);
                this._installedHorzScrollBar = component2;
                this.add(component2);
                this.add(this._bottomPanel);
            }
            this.getNativeVertScrollBar().setVisible(false);
            if (component3 != null) {
                this._installedVertScrollBar = component3;
                this.add(this._installedVertScrollBar);
            }
            this._editorComponent = component;
            this.add(this._editorComponent);
        }
        this._horzSplitter.setVisible(this._installedHorzScrollBar != null && this._installedHorzScrollBar.isVisible());
        this._vertSplitter.setVisible(this._installedVertScrollBar != null && this._installedVertScrollBar.isVisible());
    }

    public void setVertSplitterVisible(boolean bl) {
        this._vertSplitterVisible = bl;
    }

    public void setHorzSplitterVisible(boolean bl) {
        this._horzSplitterVisible = bl;
    }

    public Editor getCurrentEditor() {
        Editor editor = null;
        SplitPaneState splitPaneState = this.getSplitPaneState();
        EditorState editorState = splitPaneState.getCurrentEditorState();
        if (editorState != null) {
            editor = editorState.getEditor();
        }
        return editor;
    }

    private void setHorizontalScrollBarPolicy(int n) {
        switch (n) {
            case 31: {
                this._nativeHorzScrollBar.setVisible(false);
                break;
            }
            case 32: {
                this._nativeHorzScrollBar.setVisible(true);
                break;
            }
            case 30: {
                throw new UnsupportedOperationException("Not supported");
            }
        }
    }

    private void setVerticalScrollBarPolicy(int n) {
        switch (n) {
            case 21: {
                this._nativeVertScrollBar.setVisible(false);
                break;
            }
            case 22: {
                this._nativeVertScrollBar.setVisible(true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported");
            }
        }
    }

    public Dimension getMinimumSize() {
        if (!this.isMinimumSizeSet()) {
            Insets insets = this.getInsets();
            int n = this._horzSplitter.getPreferredSize().height;
            int n2 = this._scrollableCustomTab.isVisible() ? this._scrollableCustomTab.getPreferredSize().height : 0;
            n = Math.min(n, n2);
            Dimension dimension = new Dimension(insets.left + insets.right, insets.top + n + insets.bottom);
            super.setMinimumSize(dimension);
        }
        return super.getMinimumSize();
    }

    public void doLayout() {
        if (EditorManagerImpl.getEditorManagerOption(1)) {
            this.doLayoutTopTabs();
        } else {
            this.doLayoutBottomTabs();
        }
    }

    private void doLayoutBottomTabs() {
        Dimension dimension = this.getSize();
        int n = dimension.height;
        int n2 = dimension.width;
        Insets insets = this.getInsets();
        int n3 = this._leftMargin != null && this._leftMargin.isVisible() ? this._leftMargin.getPreferredSize().width : 0;
        int n4 = this._rightMargin != null && this._rightMargin.isVisible() ? this._rightMargin.getPreferredSize().width : 0;
        int n5 = this._topMargin != null && this._topMargin.isVisible() ? this._topMargin.getPreferredSize().height : 0;
        int n6 = this._bottomMargin != null && this._bottomMargin.isVisible() ? this._bottomMargin.getPreferredSize().height : 0;
        int n7 = this._bottomComponent != null && this._bottomComponent.isVisible() ? this._bottomComponent.getPreferredSize().height : 0;
        int n8 = this._installedVertScrollBar != null && this._installedVertScrollBar.isVisible() ? this._installedVertScrollBar.getPreferredSize().width : 0;
        int n9 = this._vertSplitterVisible ? this._vertSplitter.getPreferredSize().height : 0;
        boolean bl = this._installedHorzScrollBar != null && this._installedHorzScrollBar.isVisible();
        int n10 = bl ? this._installedHorzScrollBar.getPreferredSize().height : 0;
        Dimension dimension2 = this._scrollableCustomTab.getPreferredSize();
        int n11 = Math.max(n7 + 1, Math.max(n10 + 1, dimension2.height));
        int n12 = insets.left + 1;
        int n13 = n2 - insets.right - 1;
        int n14 = insets.top + 1;
        int n15 = n - insets.bottom;
        int n16 = n14 + n5;
        int n17 = n12 + n3;
        int n18 = n13 - n4 - n8 - n17;
        int n19 = n15 - (n16 + n11 + n6);
        int n20 = n16 + n19;
        int n21 = insets.left;
        int n22 = dimension2.width;
        int n23 = n17 + n18;
        int n24 = n15 - n14 - n11;
        int n25 = n8 + n4;
        int n26 = this._editorButtons == null || !this._editorButtons.isVisible() ? n25 : Math.max(this._editorButtons.getPreferredSize().width, n25);
        int n27 = n13 - n26;
        int n28 = this._horzSplitterVisible && this._horzSplitter != null && this._horzSplitter.isVisible() ? this._horzSplitter.getPreferredSize().width : 0;
        int n29 = n27 - n28;
        int n30 = n21 + n22;
        int n31 = n29 - n30;
        if (this._leftMargin != null && this._leftMargin.isVisible()) {
            this._leftMargin.setBounds(n12, n14, n3, n24);
        }
        if (this._rightMargin != null && this._rightMargin.isVisible()) {
            this._rightMargin.setBounds(n23 + n8, n14, n4, n24);
        }
        if (this._topMargin != null && this._topMargin.isVisible()) {
            this._topMargin.setBounds(n17, n14, n18, n5);
        }
        if (this._bottomMargin != null && this._bottomMargin.isVisible()) {
            this._bottomMargin.setBounds(n17, n20, n18, n6);
        }
        if (this._editorComponent != null) {
            this._editorComponent.setBounds(n17, n16, n18, n19);
        }
        this._vertSplitter.setBounds(n23, n14, n8, n9);
        if (this._installedVertScrollBar != null) {
            this._installedVertScrollBar.setBounds(n23, n14 + n9, n8, n24 - n9);
        }
        this._scrollableCustomTab.setBounds(n21, n20 + n6, n22, n11);
        this._bottomPanel.setBounds(n21 + n22 - 1, n20 + n6, n31 + n28 + n8 + n4 + 2, n11);
        if (bl) {
            this._installedHorzScrollBar.setBounds(n30, n20 + n6, n31, n10);
        } else if (this._bottomComponent != null) {
            this._bottomComponent.setBounds(n30, n20 + n6, n31, n7);
        }
        this._horzSplitter.setBounds(n29, n20 + n6, n28, n10);
        if (this._editorButtons != null) {
            this._editorButtons.setBounds(n27, n20 + n6, n26, n11 - 1);
        }
        if (this._pendingEditorShown) {
            this._pendingEditorShown = false;
            Editor editor = this.getCurrentEditor();
            editor.editorShown();
        }
    }

    private void doLayoutTopTabs() {
        int n;
        Dimension dimension = this.getSize();
        int n2 = dimension.height;
        int n3 = dimension.width;
        Insets insets = (Insets)this.getInsets().clone();
        ++insets.left;
        ++insets.right;
        Component component = this._installedVertScrollBar;
        Component component2 = this._installedHorzScrollBar;
        Component component3 = component2 != null ? component2 : this._bottomComponent;
        if (this._scrollableCustomTab.isVisible()) {
            Dimension dimension2 = this._scrollableCustomTab.getPreferredSize();
            n = dimension2.height;
        } else {
            n = 0;
        }
        boolean bl = this._leftMargin != null && this._leftMargin.isVisible();
        boolean bl2 = this._rightMargin != null && this._rightMargin.isVisible();
        boolean bl3 = this._topMargin != null && this._topMargin.isVisible();
        boolean bl4 = this._bottomMargin != null && this._bottomMargin.isVisible();
        boolean bl5 = this._editorButtons != null && this._editorButtons.isVisible();
        boolean bl6 = component != null && component.isVisible();
        boolean bl7 = component3 != null && component3.isVisible();
        int n4 = bl ? this._leftMargin.getPreferredSize().width : 0;
        int n5 = bl2 ? this._rightMargin.getPreferredSize().width : 0;
        int n6 = bl3 ? this._topMargin.getPreferredSize().height : 0;
        int n7 = bl4 ? this._bottomMargin.getPreferredSize().height : 0;
        int n8 = bl5 ? this._editorButtons.getPreferredSize().height : 0;
        int n9 = bl6 ? component.getPreferredSize().width : 0;
        int n10 = this._vertSplitterVisible ? this._vertSplitter.getPreferredSize().height : 0;
        int n11 = bl7 ? component3.getPreferredSize().height : 0;
        int n12 = this._horzSplitterVisible ? this._horzSplitter.getPreferredSize().width : 0;
        int n13 = n9 + n5;
        int n14 = bl5 ? Math.max(this._editorButtons.getPreferredSize().width, n13) : n13;
        int n15 = Math.max(n8 + 1, n11 + 1);
        int n16 = insets.left - 1;
        int n17 = insets.top;
        int n18 = n3 - insets.left - insets.right + 1;
        int n19 = n;
        this._scrollableCustomTab.setBounds(new Rectangle(n16, n17, n18, n19));
        if (bl3) {
            int n20 = insets.left;
            int n21 = insets.top + n;
            int n22 = n3 - insets.right - n5 - n9;
            int n23 = n6;
            this._topMargin.setBounds(n20, n21, n22, n23);
        }
        if (n10 > 0) {
            int n24 = n3 - insets.right - n5 - n9;
            int n25 = insets.top + n;
            int n26 = n9;
            int n27 = n10;
            this._vertSplitter.setBounds(n24, n25, n26, n27);
        }
        if (n9 > 0) {
            int n28 = n3 - insets.right - n5 - n9;
            int n29 = insets.top + n + n10;
            int n30 = n9;
            int n31 = n2 - n29 - n15;
            component.setBounds(n28, n29, n30, n31);
        }
        if (bl2) {
            int n32 = n3 - insets.right - n5;
            int n33 = insets.top + n;
            int n34 = n5;
            int n35 = n2 - n33 - n15;
            this._rightMargin.setBounds(n32, n33, n34, n35);
        }
        if (bl) {
            int n36 = insets.left;
            int n37 = insets.top + n + n6;
            int n38 = n4;
            int n39 = n2 - insets.top - n - n6 - n7 - n15 - insets.bottom;
            this._leftMargin.setBounds(n36, n37, n38, n39);
        }
        int n40 = insets.left + n4;
        int n41 = insets.top + n + n6;
        int n42 = n3 - insets.left - n4 - n9 - n5 - insets.right;
        int n43 = n2 - insets.top - n - n6 - n7 - n15 - insets.bottom;
        this._editorComponent.setBounds(n40, n41, n42, n43);
        if (bl4) {
            int n44 = insets.left;
            int n45 = n2 - insets.bottom - n15 - n7;
            int n46 = n3 - insets.right - n5 - n9;
            int n47 = n7;
            this._bottomMargin.setBounds(n44, n45, n46, n47);
        }
        if (bl7) {
            int n48 = insets.left - 1;
            int n49 = n2 - insets.bottom - n15;
            int n50 = n3 - insets.left + 1 - n12 - n14 - insets.right;
            int n51 = n15;
            component3.setBounds(n48, n49, n50, n51);
        }
        if (n12 > 0) {
            int n52 = n3 - insets.right - n14 - n12;
            int n53 = n2 - insets.bottom - n15;
            int n54 = n12;
            int n55 = n15;
            this._horzSplitter.setBounds(n52, n53, n54, n55);
        }
        if (bl5) {
            int n56 = n3 - insets.right - n14;
            int n57 = n2 - insets.bottom - n8;
            int n58 = n14;
            int n59 = n7;
            this._editorButtons.setBounds(n56, n57, n58, n59);
        }
        if (this._pendingEditorShown) {
            this._pendingEditorShown = false;
            Editor editor = this.getCurrentEditor();
            editor.editorShown();
        }
    }

    protected void paintBorder(Graphics graphics) {
        int n = this._scrollableCustomTab.isVisible() ? this._scrollableCustomTab.getHeight() : 0;
        Dimension dimension = this.getSize();
        graphics.setColor(IdeConstants.COLOR_IDE_LINES);
        if (EditorManagerImpl.getEditorManagerOption(1)) {
            int[] nArray = new int[]{0, 0, dimension.width - 1, dimension.width - 1};
            int[] nArray2 = new int[]{n, dimension.height - 1, dimension.height - 1, 0};
            graphics.drawPolyline(nArray, nArray2, nArray.length);
        } else {
            graphics.drawLine(0, 0, dimension.width - 1, 0);
            graphics.drawLine(0, 0, 0, dimension.height - n - 1);
            graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - n - 1);
        }
    }

    private void detachCurrentEditor() {
        if (this._editorComponent != null) {
            this.savePaneState();
            SplitPaneState splitPaneState = this.getSplitPaneState();
            Editor editor = splitPaneState.getCurrentEditor();
            if (editor != null) {
                if (!EditorUtil.isOldEditor(editor)) {
                    editor.removePropertyChangeListener(this);
                }
                editor.editorHidden();
                Component component = editor.getGUI();
                Component component2 = GraphicsUtils.getFocusedChildComponent(component);
                if (component2 != null) {
                    EditorState editorState = splitPaneState.getCurrentEditorState();
                    editorState.setFocusedComponent((JComponent)component2);
                }
            }
            if (this._editorComponent == this._scrollPane) {
                JViewport jViewport = this._scrollPane.getViewport();
                jViewport.setView(null);
            } else {
                this.remove(this._editorComponent);
            }
            this._editorComponent = null;
            if (this._installedHorzScrollBar != null) {
                if (this._installedHorzScrollBar != this.getNativeHorzScrollBar()) {
                    this.remove(this._installedHorzScrollBar);
                }
                this._installedHorzScrollBar = null;
            }
            if (this._installedVertScrollBar != null) {
                if (this._installedVertScrollBar != this.getNativeVertScrollBar()) {
                    this.remove(this._installedVertScrollBar);
                }
                this._installedVertScrollBar = null;
            }
            this.setScrollableLeftMargin(null);
            this.setScrollableTopMargin(null);
            this.setFixedLeftMargin(null);
            this.setFixedTopMargin(null);
            this.setFixedRightMargin(null);
            this.setFixedBottomMargin(null);
            this.setEditorButtons(null);
            MainWindowImpl mainWindowImpl = (MainWindowImpl)Ide.getMainWindow();
            mainWindowImpl.unregisterView(editor);
            this.revalidate();
            this.repaint();
        }
    }

    private void attachCurrentEditor() {
        int n;
        SplitPaneState splitPaneState = this.getSplitPaneState();
        EditorState editorState = splitPaneState.getEditorState(n = splitPaneState.getCurrentEditorStatePos());
        Editor editor = editorState.getEditor();
        if (editor == null) {
            TabGroupState tabGroupState = splitPaneState.getParentTabGroupState();
            Context context = tabGroupState.getContext();
            editor = editorState.createEditor(context);
        }
        if (editor == null) {
            this.attachNullEditor();
        } else {
            MainWindowImpl mainWindowImpl = (MainWindowImpl)Ide.getMainWindow();
            mainWindowImpl.registerView(editor, this);
            if (EditorUtil.isOldEditor(editor)) {
                this.attachOldEditor(editor);
            } else {
                this.attachEditor(editor);
            }
        }
        this._pendingEditorShown = true;
        this.revalidate();
        this.repaint();
    }

    private void attachEditor(Editor editor) {
        Component component = editor.getGUI();
        Component component2 = editor.getFixedLeftMargin();
        Component component3 = editor.getFixedRightMargin();
        Component component4 = editor.getFixedTopMargin();
        Component component5 = editor.getFixedBottomMargin();
        Component component6 = editor.getScrollableLeftMargin();
        Component component7 = editor.getScrollableTopMargin();
        Component component8 = editor.getMiniToolbar();
        Component component9 = editor.getBottomComponent();
        Object object = editor.getEditorAttribute("scrollable");
        boolean bl = Boolean.FALSE.equals(object) ^ true;
        Component component10 = (Component)editor.getEditorAttribute("custom_horizontal_scrollbar");
        Component component11 = (Component)editor.getEditorAttribute("custom_vertical_scrollbar");
        this.setEditorComponent(component, bl, component10, component11);
        this.loadPaneState();
        this.whenHorizontalScrollbarPolicyChanges(null);
        this.whenHorizontalUnitChanges(null);
        this.whenHorizontalBlockIncrementChanges(null);
        this.whenVerticalScrollbarPolicyChanges(null);
        this.whenVerticalUnitChanges(null);
        this.whenVerticalBlockIncrementChanges(null);
        this.whenBackgroundColorChanges(null);
        editor.addPropertyChangeListener(this);
        this.setScrollableLeftMargin(component6);
        this.setScrollableTopMargin(component7);
        this.setFixedLeftMargin(component2);
        this.setFixedRightMargin(component3);
        this.setFixedTopMargin(component4);
        this.setFixedBottomMargin(component5);
        this.setEditorButtons(component8);
        this.setBottomComponent(component9);
    }

    void savePaneState() {
        JScrollBar jScrollBar;
        SplitPaneState splitPaneState = this.getSplitPaneState();
        EditorState editorState = splitPaneState.getCurrentEditorState();
        JScrollBar jScrollBar2 = this.getNativeHorzScrollBar();
        if (this._installedHorzScrollBar == jScrollBar2) {
            BoundedRangeModel boundedRangeModel = jScrollBar2.getModel();
            int n = boundedRangeModel.getMinimum();
            int n2 = boundedRangeModel.getMaximum();
            int n3 = boundedRangeModel.getExtent();
            int n4 = boundedRangeModel.getValue();
            editorState.setXScrollMin(n);
            editorState.setXScrollMax(n2);
            editorState.setXScrollExtent(n3);
            editorState.setXScrollPos(n4);
        }
        if (this._installedVertScrollBar == (jScrollBar = this.getNativeVertScrollBar())) {
            BoundedRangeModel boundedRangeModel = jScrollBar.getModel();
            int n = boundedRangeModel.getMinimum();
            int n5 = boundedRangeModel.getMaximum();
            int n6 = boundedRangeModel.getExtent();
            int n7 = boundedRangeModel.getValue();
            editorState.setYScrollMin(n);
            editorState.setYScrollMax(n5);
            editorState.setYScrollExtent(n6);
            editorState.setYScrollPos(n7);
        }
    }

    void loadPaneState() {
        JScrollBar jScrollBar;
        SplitPaneState splitPaneState = this.getSplitPaneState();
        EditorState editorState = splitPaneState.getCurrentEditorState();
        JScrollBar jScrollBar2 = this.getNativeHorzScrollBar();
        if (this._installedHorzScrollBar == jScrollBar2) {
            BoundedRangeModel boundedRangeModel = jScrollBar2.getModel();
            int n = editorState.getXScrollMin();
            int n2 = editorState.getXScrollMax();
            int n3 = editorState.getXScrollExtent();
            int n4 = editorState.getXScrollPos();
            boundedRangeModel.setMinimum(n);
            boundedRangeModel.setMaximum(n2);
            boundedRangeModel.setExtent(n3);
            boundedRangeModel.setValue(n4);
        }
        if (this._installedVertScrollBar == (jScrollBar = this.getNativeVertScrollBar())) {
            BoundedRangeModel boundedRangeModel = jScrollBar.getModel();
            int n = editorState.getYScrollMin();
            int n5 = editorState.getYScrollMax();
            int n6 = editorState.getYScrollExtent();
            int n7 = editorState.getYScrollPos();
            boundedRangeModel.setMinimum(n);
            boundedRangeModel.setMaximum(n5);
            boundedRangeModel.setExtent(n6);
            boundedRangeModel.setValue(n7);
        }
    }

    private void attachOldEditor(Editor editor) {
        JComponent jComponent = (JComponent)editor.getGUI();
        this.setEditorComponent(jComponent, false, null, null);
    }

    private void attachNullEditor() {
        JPanel jPanel = new JPanel();
        this.setEditorComponent(jPanel, false, null, null);
    }

    void focusCurrentEditor() {
        SplitPaneState splitPaneState = this.getSplitPaneState();
        EditorState editorState = splitPaneState.getCurrentEditorState();
        if (editorState != null) {
            Editor editor;
            Component component = editorState.getFocusedComponent();
            if (component == null && (editor = editorState.getEditor()) != null) {
                component = (JComponent)editor.getDefaultFocusComponent();
            }
            if (component != null && SwingUtilities.isDescendingFrom(component, this._editorComponent)) {
                component.requestFocus();
            } else {
                GraphicsUtils.focusComponentOrChild(this._editorComponent);
            }
        }
    }

    private int searchEditorClassPos(Class clazz) {
        int n = this._editorTabs.getPageCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._editorTabs.getPage(n2);
            EditorState editorState = (EditorState)defaultCustomTabPage.getUserObject();
            EditorAddin editorAddin = editorState.getEditorAddin();
            if (clazz.equals(editorAddin.getEditorClass())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private int getCurrentEditorStatePos() {
        return this._currentEditorStatePos;
    }

    boolean setCurrentEditorStatePos(int n) {
        boolean bl = false;
        if (n != this._currentEditorStatePos) {
            SplitPaneState splitPaneState = this.getSplitPaneState();
            boolean bl2 = splitPaneState.canSetEditorStatePos(n);
            if (bl2) {
                boolean bl3 = GraphicsUtils.getFocusedChildComponent(this) != null;
                Desktop desktop = EditorManagerImpl.getInstance().getDesktop();
                desktop.freezeFocusChanges(true);
                this.detachCurrentEditor();
                this._currentEditorStatePos = n;
                splitPaneState.setCurrentEditorStatePos(this._currentEditorStatePos);
                this.attachCurrentEditor();
                if (bl3) {
                    this.focusCurrentEditor();
                }
                desktop.freezeFocusChanges(false);
                this._editorTabs.setSelectedPage(n);
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private void setEditorEnabled(int n, boolean bl) {
        DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._editorTabs.getPage(n);
        if (defaultCustomTabPage.isEnabled() != bl) {
            defaultCustomTabPage.setEnabled(bl);
        }
        this._editorTabs.whenTabChanged();
    }

    public boolean activateEditor(Editor editor) {
        boolean bl = false;
        int n = this.searchEditorClassPos(editor.getClass());
        if (this.getEditor(n) == editor) {
            this.setCurrentEditorStatePos(n);
            bl = true;
        }
        return bl;
    }

    private Editor getEditor(int n) {
        SplitPaneState splitPaneState = this.getSplitPaneState();
        Editor editor = splitPaneState.getOrCreateEditor(n);
        return editor;
    }

    public void whenEditorStateChanges(EditorState editorState) {
        boolean bl = editorState.isEnabled();
        int n = this.searchEditorStatePos(editorState);
        this.setEditorEnabled(n, bl);
    }

    private int searchEditorStatePos(EditorState editorState) {
        SplitPaneState splitPaneState = this.getSplitPaneState();
        int n = splitPaneState.getEditorStateCount();
        int n2 = 0;
        while (n2 < n) {
            EditorState editorState2 = splitPaneState.getEditorState(n2);
            if (editorState == editorState2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void closeAll() {
        SplitPaneState splitPaneState = this.getSplitPaneState();
        TabGroupState tabGroupState = splitPaneState.getParentTabGroupState();
        EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
        editorManagerImpl.closeEditors(new TabGroupState[]{tabGroupState});
    }

    public void containerActivated(boolean bl) {
        SplitPaneState splitPaneState = this.getSplitPaneState();
        if (splitPaneState != null) {
            if (bl) {
                splitPaneState.whenEditorActivated();
            }
            this.getTabGroup().setFocused(bl);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == this._vertSplitter) {
            Graphics graphics = this.getGraphics();
            graphics.setXORMode(this.getBackground());
            this._ptDragSplitter = SwingUtilities.convertPoint(this._vertSplitter, mouseEvent.getPoint(), this);
            graphics.drawLine(0, this._ptDragSplitter.y, this.getWidth(), this._ptDragSplitter.y);
        } else if (component == this._horzSplitter) {
            Graphics graphics = this.getGraphics();
            graphics.setXORMode(this.getBackground());
            this._ptDragSplitter = SwingUtilities.convertPoint(this._horzSplitter, mouseEvent.getPoint(), this);
            graphics.drawLine(this._ptDragSplitter.x, 0, this._ptDragSplitter.x, this.getHeight());
        } else if (component == this._editorTabs) {
            this.whenEditorTabMousePressed();
        }
    }

    private void whenEditorTabMousePressed() {
        SplitPaneState splitPaneState;
        Editor editor;
        EditorPathImpl editorPathImpl;
        EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
        if (editorManagerImpl.searchEditor(editorPathImpl = new EditorPathImpl(), new EditorCriteriaImpl(editor = (splitPaneState = this.getSplitPaneState()).getCurrentEditor()))) {
            editorManagerImpl.focusEditor(editorPathImpl);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this._vertSplitter) {
            Graphics graphics = this.getGraphics();
            graphics.setXORMode(this.getBackground());
            graphics.drawLine(0, this._ptDragSplitter.y, this.getWidth(), this._ptDragSplitter.y);
            this._ptDragSplitter = SwingUtilities.convertPoint(this._vertSplitter, mouseEvent.getPoint(), this);
            graphics.drawLine(0, this._ptDragSplitter.y, this.getWidth(), this._ptDragSplitter.y);
        } else if (mouseEvent.getComponent() == this._horzSplitter) {
            Graphics graphics = this.getGraphics();
            graphics.setXORMode(this.getBackground());
            graphics.drawLine(this._ptDragSplitter.x, 0, this._ptDragSplitter.x, this.getHeight());
            this._ptDragSplitter = SwingUtilities.convertPoint(this._horzSplitter, mouseEvent.getPoint(), this);
            graphics.drawLine(this._ptDragSplitter.x, 0, this._ptDragSplitter.x, this.getHeight());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this._vertSplitter) {
            Graphics graphics = this.getGraphics();
            int n = this._ptDragSplitter.y;
            graphics.setXORMode(this.getBackground());
            graphics.drawLine(0, n, this.getWidth(), n);
            Rectangle rectangle = this._editorComponent.getBounds();
            if (n >= rectangle.y + 25 && n <= rectangle.y + rectangle.height - 25) {
                this.getTabGroup().split(this, n, 1);
            }
        } else if (mouseEvent.getComponent() == this._horzSplitter) {
            Graphics graphics = this.getGraphics();
            int n = this._ptDragSplitter.x;
            graphics.setXORMode(this.getBackground());
            graphics.drawLine(n, 0, n, this.getHeight());
            Rectangle rectangle = this._editorComponent.getBounds();
            if (n >= rectangle.x + 25 && n <= rectangle.x + rectangle.width - 25) {
                this.getTabGroup().split(this, n, 0);
            }
        }
    }

    private TabGroup getTabGroup() {
        return (TabGroup)this.getParent().getParent();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._splitTrigger.isDoubleClick(mouseEvent)) {
            Component component = mouseEvent.getComponent();
            TabGroup tabGroup = this.getTabGroup();
            Rectangle rectangle = this._editorComponent.getBounds();
            if (component == this._vertSplitter) {
                if (rectangle.height >= 50) {
                    tabGroup.split(this, rectangle.y + rectangle.height / 2, 1);
                }
            } else if (component == this._horzSplitter && rectangle.width >= 50) {
                tabGroup.split(this, rectangle.x + rectangle.width / 2, 0);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block1: {
            String string;
            block6: {
                block5: {
                    block4: {
                        block3: {
                            block2: {
                                block0: {
                                    string = propertyChangeEvent.getPropertyName();
                                    if (!string.equals("horizontal_scrollbar_policy")) break block0;
                                    this.whenHorizontalScrollbarPolicyChanges((Integer)propertyChangeEvent.getNewValue());
                                    break block1;
                                }
                                if (!string.equals("horizontal_unit_increment")) break block2;
                                this.whenHorizontalUnitChanges((Integer)propertyChangeEvent.getNewValue());
                                break block1;
                            }
                            if (!string.equals("horizontal_block_increment")) break block3;
                            this.whenHorizontalBlockIncrementChanges((Integer)propertyChangeEvent.getNewValue());
                            break block1;
                        }
                        if (!string.equals("vertical_scrollbar_policy")) break block4;
                        this.whenVerticalScrollbarPolicyChanges((Integer)propertyChangeEvent.getNewValue());
                        break block1;
                    }
                    if (!string.equals("vertical_unit_increment")) break block5;
                    this.whenVerticalUnitChanges((Integer)propertyChangeEvent.getNewValue());
                    break block1;
                }
                if (!string.equals("vertical_block_increment")) break block6;
                this.whenVerticalBlockIncrementChanges((Integer)propertyChangeEvent.getNewValue());
                break block1;
            }
            if (!string.equals("background_color")) break block1;
            this.whenBackgroundColorChanges((Color)propertyChangeEvent.getNewValue());
        }
    }

    private void whenHorizontalScrollbarPolicyChanges(Integer n) {
        this.setHorizontalScrollBarPolicy((n = this.getWhenPropertyChangeValue(n, "horizontal_scrollbar_policy")) != null ? n : 31);
    }

    private void whenHorizontalUnitChanges(Integer n) {
        JScrollBar jScrollBar = this.getNativeHorzScrollBar();
        if (this._installedHorzScrollBar == jScrollBar) {
            jScrollBar.setUnitIncrement((n = this.getWhenPropertyChangeValue(n, "horizontal_unit_increment")) != null ? n : 1);
        }
    }

    private void whenHorizontalBlockIncrementChanges(Integer n) {
        JScrollBar jScrollBar = this.getNativeHorzScrollBar();
        if (this._installedHorzScrollBar == jScrollBar) {
            jScrollBar.setBlockIncrement((n = this.getWhenPropertyChangeValue(n, "horizontal_block_increment")) != null ? n : 1);
        }
    }

    private void whenVerticalScrollbarPolicyChanges(Integer n) {
        this.setVerticalScrollBarPolicy((n = this.getWhenPropertyChangeValue(n, "vertical_scrollbar_policy")) != null ? n : 21);
    }

    private void whenVerticalUnitChanges(Integer n) {
        JScrollBar jScrollBar = this.getNativeVertScrollBar();
        if (jScrollBar == this._installedVertScrollBar) {
            jScrollBar.setUnitIncrement((n = this.getWhenPropertyChangeValue(n, "vertical_unit_increment")) != null ? n : 1);
        }
    }

    private void whenVerticalBlockIncrementChanges(Integer n) {
        JScrollBar jScrollBar = this.getNativeVertScrollBar();
        if (this._installedVertScrollBar == jScrollBar) {
            jScrollBar.setBlockIncrement((n = this.getWhenPropertyChangeValue(n, "vertical_block_increment")) != null ? n : 1);
        }
    }

    private void whenBackgroundColorChanges(Color color) {
        color = this.getWhenPropertyChangeValue(color, "background_color");
        JViewport jViewport = this._scrollPane.getViewport();
        jViewport.setBackground(color);
    }

    private Integer getWhenPropertyChangeValue(Integer n, String string) {
        if (n == null) {
            SplitPaneState splitPaneState = this.getSplitPaneState();
            Editor editor = splitPaneState.getCurrentEditor();
            n = (Integer)editor.getEditorAttribute(string);
        }
        return n;
    }

    private Color getWhenPropertyChangeValue(Color color, String string) {
        if (color == null) {
            Editor editor = this.getSplitPaneState().getCurrentEditor();
            color = (Color)editor.getEditorAttribute(string);
        }
        return color;
    }

    public void handleEvent(int n) {
        block4: {
            block5: {
                if (n != 40) break block5;
                int n2 = this.getCurrentEditorStatePos();
                int n3 = this._editorTabs.getPageCount();
                int n4 = n2 + 1;
                while (n4 < n3) {
                    DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._editorTabs.getPage(n4);
                    boolean bl = defaultCustomTabPage.isEnabled();
                    if (bl) {
                        this.setCurrentEditorStatePos(n4);
                        break block4;
                    }
                    ++n4;
                }
                break block4;
            }
            if (n != 41) break block4;
            int n5 = this.getCurrentEditorStatePos();
            int n6 = n5 - 1;
            while (n6 >= 0) {
                DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._editorTabs.getPage(n6);
                boolean bl = defaultCustomTabPage.isEnabled();
                if (bl) {
                    this.setCurrentEditorStatePos(n6);
                    break;
                }
                --n6;
            }
        }
    }

    boolean canDo(IdeAction ideAction) {
        boolean bl;
        block4: {
            int n;
            block5: {
                bl = false;
                n = ideAction.getCommandId();
                if (n != 40) break block5;
                int n2 = this.getCurrentEditorStatePos();
                int n3 = this._editorTabs.getPageCount();
                int n4 = n2 + 1;
                while (n4 < n3) {
                    DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._editorTabs.getPage(n4);
                    boolean bl2 = defaultCustomTabPage.isEnabled();
                    if (bl2) {
                        bl = true;
                        break block4;
                    }
                    ++n4;
                }
                break block4;
            }
            if (n != 41) break block4;
            int n5 = this.getCurrentEditorStatePos();
            int n6 = n5 - 1;
            while (n6 >= 0) {
                DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._editorTabs.getPage(n6);
                boolean bl3 = defaultCustomTabPage.isEnabled();
                if (bl3) {
                    bl = true;
                    break;
                }
                --n6;
            }
        }
        return bl;
    }

    void highlight(boolean bl) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.whenHorizontalBlockIncrementChanges(null);
        this.whenVerticalBlockIncrementChanges(null);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    private JScrollBar getNativeVertScrollBar() {
        return this._nativeVertScrollBar;
    }

    private JScrollBar getNativeHorzScrollBar() {
        return this._nativeHorzScrollBar;
    }

    static CustomTab ra$_editorTabs(SplitPane splitPane) {
        return splitPane._editorTabs;
    }

    final class 2
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = SplitPane.ra$_editorTabs(SplitPane.this).getSelectedPage();
            SplitPane.this.setCurrentEditorStatePos(n);
        }
    }

    final class 1
    extends ComponentAdapter {
        private final /* synthetic */ JViewport v$viewport;
        private final /* synthetic */ Dimension v$primaryScreenSize;
        final /* synthetic */ SplitPane this$0;

        public void componentResized(ComponentEvent componentEvent) {
            Dimension dimension = this.v$viewport.getSize();
            if (dimension.getWidth() > this.v$primaryScreenSize.getWidth() || dimension.getHeight() > this.v$primaryScreenSize.getHeight()) {
                this.v$viewport.removeComponentListener(this);
                this.v$viewport.setScrollMode(0);
            }
        }

        public 1(SplitPane splitPane, JViewport jViewport, Dimension dimension) {
            this.v$primaryScreenSize = dimension;
            this.v$viewport = jViewport;
            this.this$0 = splitPane;
        }
    }
}

