/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import oracle.ide.Context;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorCriteria;
import oracle.ide.model.Node;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.MenuSpec;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.editor.EditorCreation;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.EditorState;
import oracle.ideimpl.editor.SplitPane;
import oracle.ideimpl.editor.TabGroupState;

final class SplitPaneState {
    private TabGroupState _parentTabGroupState;
    private SplitPane _splitPane;
    private int _currentEditorStatePos;
    private DefaultListModel _editorsModel;

    void $init$() {
        this._currentEditorStatePos = -1;
    }

    public SplitPaneState(EditorCreation editorCreation, TabGroupState tabGroupState) {
        this.$init$();
        this._parentTabGroupState = tabGroupState;
        this._editorsModel = this.createEditorsModel(editorCreation.getEditorAddins());
    }

    public SplitPaneState(TabGroupState tabGroupState) {
        this.$init$();
        this._parentTabGroupState = tabGroupState;
        this._editorsModel = this.createEditorsModel();
    }

    TabGroupState getParentTabGroupState() {
        return this._parentTabGroupState;
    }

    public String toString() {
        TabGroupState tabGroupState = this.getParentTabGroupState();
        Context context = tabGroupState.getContext();
        Node node = context.getNode();
        String string = node.getShortLabel();
        return string;
    }

    private DefaultListModel createEditorsModel() {
        List list = this.getParentTabGroupState().getEditorAddins();
        return this.createEditorsModel(list);
    }

    private DefaultListModel createEditorsModel(List list) {
        DefaultListModel<DefaultCustomTabPage> defaultListModel = new DefaultListModel<DefaultCustomTabPage>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            EditorAddin editorAddin = (EditorAddin)list.get(n2);
            MenuSpec menuSpec = editorAddin.getMenuSpecification();
            EditorState editorState = new EditorState(this, editorAddin);
            DefaultCustomTabPage defaultCustomTabPage = new DefaultCustomTabPage(menuSpec.getIcon(), menuSpec.label, editorState);
            defaultListModel.addElement(defaultCustomTabPage);
            ++n2;
        }
        return defaultListModel;
    }

    public SplitPane getSplitPane() {
        return this._splitPane;
    }

    public void setSplitPane(SplitPane splitPane) {
        this._splitPane = splitPane;
    }

    public int getEditorStateCount() {
        return this._editorsModel.getSize();
    }

    public EditorState getEditorState(int n) {
        DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._editorsModel.get(n);
        EditorState editorState = (EditorState)defaultCustomTabPage.getUserObject();
        return editorState;
    }

    public int searchEditorPos(Class clazz) {
        int n = this.getEditorStateCount();
        int n2 = 0;
        while (n2 < n) {
            EditorState editorState = this.getEditorState(n2);
            EditorAddin editorAddin = editorState.getEditorAddin();
            if (clazz.equals(editorAddin.getEditorClass())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int searchEditorPos(EditorAddin editorAddin) {
        int n = this.getEditorStateCount();
        int n2 = 0;
        while (n2 < n) {
            EditorState editorState = this.getEditorState(n2);
            EditorAddin editorAddin2 = editorState.getEditorAddin();
            if (editorAddin2 == editorAddin) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private int searchEditorPos(String string) {
        int n = this.getEditorStateCount();
        int n2 = 0;
        while (n2 < n) {
            EditorState editorState = this.getEditorState(n2);
            EditorAddin editorAddin = editorState.getEditorAddin();
            if (string.equals(editorAddin.getClass().getName())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    boolean getCurrentEditorPath(EditorPathImpl editorPathImpl) {
        boolean bl = false;
        editorPathImpl._editorPos = this.getCurrentEditorStatePos();
        if (editorPathImpl._editorPos != -1) {
            bl = true;
        }
        return bl;
    }

    public Editor getCurrentEditor() {
        Editor editor = null;
        EditorState editorState = this.getCurrentEditorState();
        if (editorState != null) {
            editor = editorState.getEditor();
        }
        return editor;
    }

    public int getCurrentEditorStatePos() {
        return this._currentEditorStatePos;
    }

    public EditorState getCurrentEditorState() {
        return this._currentEditorStatePos == -1 ? null : this.getEditorState(this._currentEditorStatePos);
    }

    public boolean setCurrentEditorStatePos(int n) {
        boolean bl = true;
        if (this._currentEditorStatePos != n && (bl = this.canSetEditorStatePos(n))) {
            TabGroupState tabGroupState = this.getParentTabGroupState();
            if (this._currentEditorStatePos != -1 && tabGroupState != null) {
                tabGroupState.reserveEditorStates(this, this._currentEditorStatePos, false);
            }
            this._currentEditorStatePos = n;
            if (this._currentEditorStatePos != -1 && tabGroupState != null) {
                tabGroupState.reserveEditorStates(this, n, true);
                tabGroupState.whenCurrentEditorChanges(this);
            }
        }
        return bl;
    }

    boolean canSetEditorStatePos(int n) {
        boolean bl;
        if (n == -1) {
            bl = true;
        } else {
            EditorState editorState = this.getEditorState(n);
            Editor editor = editorState.getEditor();
            if (editor == null) {
                TabGroupState tabGroupState = this.getParentTabGroupState();
                Context context = tabGroupState.getContext();
                editor = editorState.getOrCreateEditor(context);
            }
            bl = editor != null;
        }
        return bl;
    }

    public Editor getOrCreateEditor(int n) {
        EditorState editorState = this.getEditorState(n);
        Context context = this.getParentTabGroupState().getContext();
        return editorState.getOrCreateEditor(context);
    }

    public DefaultListModel getEditorsModel() {
        return this._editorsModel;
    }

    public static boolean match(EditorCriteria editorCriteria) {
        return false;
    }

    public boolean searchEditor(EditorPathImpl editorPathImpl, EditorCriteriaImpl editorCriteriaImpl) {
        boolean bl = false;
        int n = this.getEditorStateCount();
        int n2 = 0;
        while (!bl && n2 < n) {
            EditorState editorState = this.getEditorState(n2);
            if (editorState.match(editorCriteriaImpl)) {
                editorPathImpl._editorPos = n2;
                editorPathImpl._editorStatus = 0;
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public void whenEditorActivated() {
        this.getParentTabGroupState().whenEditorActivated(this);
    }

    public void whenEditorStateChanges(EditorState editorState) {
        SplitPane splitPane = this.getSplitPane();
        if (splitPane != null) {
            splitPane.whenEditorStateChanges(editorState);
        }
    }

    void dump(String string, boolean bl) {
        System.out.println(string + "SplitPaneState" + (bl ? "*" : ""));
        int n = this.getEditorStateCount();
        int n2 = 0;
        while (n2 < n) {
            EditorState editorState = this.getEditorState(n2);
            boolean bl2 = n2 == this._currentEditorStatePos;
            editorState.dump(string + "  ", bl2);
            ++n2;
        }
    }

    public boolean activateEditor(EditorPathImpl editorPathImpl) {
        boolean bl;
        if (editorPathImpl._editorPos == -1) {
            editorPathImpl._editorPos = this.getCurrentEditorStatePos();
            bl = true;
        } else {
            SplitPane splitPane = this.getSplitPane();
            bl = splitPane.setCurrentEditorStatePos(editorPathImpl._editorPos);
        }
        return bl;
    }

    boolean saveStateInfo(StructuredPropertyAccess structuredPropertyAccess) {
        boolean bl = this.isRestorableAtStartup();
        if (bl) {
            EditorState editorState = this.getCurrentEditorState();
            EditorAddin editorAddin = editorState.getEditorAddin();
            String string = editorAddin.getClass().getName();
            structuredPropertyAccess.setProperty("currentEditor", string);
            int n = this.getEditorStateCount();
            int n2 = 0;
            while (n2 < n) {
                EditorState editorState2 = this.getEditorState(n2);
                EditorAddin editorAddin2 = editorState2.getEditorAddin();
                if (editorState2.getEditor() != null) {
                    DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess("editorState");
                    String string2 = editorAddin2.getClass().getName();
                    defaultStructuredPropertyAccess.setProperty("addin", string2);
                    editorState2.saveStateInfo(defaultStructuredPropertyAccess);
                    structuredPropertyAccess.appendChild(defaultStructuredPropertyAccess);
                } else {
                    StructuredPropertyAccess structuredPropertyAccess2 = editorState2.getStateInfo();
                    if (structuredPropertyAccess2 != null) {
                        structuredPropertyAccess.addAll(structuredPropertyAccess2);
                    }
                }
                ++n2;
            }
        }
        return bl;
    }

    boolean isRestorableAtStartup() {
        int n = this.getEditorStateCount();
        int n2 = 0;
        while (n2 < n) {
            EditorState editorState = this.getEditorState(n2);
            EditorAddin editorAddin = editorState.getEditorAddin();
            if (!editorAddin.restoreAtStartup()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    boolean loadStateInfo(StructuredPropertyAccess structuredPropertyAccess) {
        Iterator iterator = structuredPropertyAccess.getChildNodes("editorState");
        while (iterator.hasNext()) {
            int n;
            StructuredPropertyAccess structuredPropertyAccess2 = (StructuredPropertyAccess)iterator.next();
            String string = structuredPropertyAccess2.getProperty("addin", null);
            if (string == null || (n = this.searchEditorPos(string)) == -1) continue;
            EditorState editorState = this.getEditorState(n);
            editorState.loadStateInfo(structuredPropertyAccess2);
        }
        String string = structuredPropertyAccess.getProperty("currentEditor", null);
        int n = -1;
        if (string != null) {
            n = this.searchEditorPos(string);
        }
        if (n == -1) {
            n = 0;
        }
        boolean bl = this.setCurrentEditorStatePos(n);
        return bl;
    }

    boolean isSplitable() {
        int n = this.getCurrentEditorStatePos();
        EditorState editorState = this.getEditorState(n);
        EditorAddin editorAddin = editorState.getEditorAddin();
        boolean bl = true;
        if (!editorAddin.isDuplicable()) {
            bl = false;
            TabGroupState tabGroupState = this.getParentTabGroupState();
            int n2 = this.getEditorStateCount();
            int n3 = 0;
            while (n3 < n2) {
                SplitPaneState splitPaneState = tabGroupState.getReservedEditorState(n3);
                if (splitPaneState == null) {
                    bl = true;
                }
                ++n3;
            }
        }
        return bl;
    }
}

