/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;

final class Splitter
extends JComponent {
    static final int HORIZONTAL = 0;
    static final int VERTICAL = 1;
    private final int _orientation;
    private static final Color C0 = UIManager.getColor("ScrollBar.thumb");
    private static final Color C1 = UIManager.getColor("ScrollBar.thumbHighlight");
    private static final Color C2 = UIManager.getColor("ScrollBar.thumbShadow");

    public Splitter(int n) {
        this._orientation = n;
        this.setCursor(Cursor.getPredefinedCursor(n == 0 ? 9 : 10));
    }

    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            Dimension dimension = this.getSize();
            if (this._orientation == 0) {
                dimension.height = 5;
            } else {
                dimension.width = 5;
            }
            this.setPreferredSize(dimension);
        }
        return super.getPreferredSize();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        int n = dimension.height;
        int n2 = dimension.width;
        graphics.setColor(C0);
        graphics.fillRect(0, 0, n2 - 1, n - 1);
        graphics.setColor(C2);
        graphics.drawRect(0, 0, n2 - 1, n - 1);
        graphics.setColor(C1);
        graphics.drawLine(1, 1, n2 - 2, 1);
        graphics.drawLine(1, 1, 1, n - 2);
    }
}

