/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.MenuSelectionManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeUIManager;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.customtab.AutoRepeatButtonModel;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.ContentSetSupport;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.controls.ArrowIcon;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.editor.Desktop;
import oracle.ideimpl.editor.DocTabListener;
import oracle.ideimpl.editor.DropDownMenuButton;
import oracle.ideimpl.editor.EditorCreation;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.EditorState;
import oracle.ideimpl.editor.SplitPane;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.SplitPaneStructPersistence;
import oracle.ideimpl.editor.TabGroupPanel;
import oracle.ideimpl.editor.TabGroupState;
import oracle.ideimpl.editor.TransferableEditorTab;
import oracle.ideimpl.util.DropFileUtil;
import oracle.javatools.border.JavatoolsBorderFactory;

final class TabGroup
extends JPanel
implements ItemListener,
ChangeListener,
DropTargetListener,
DragSourceListener,
DragGestureListener,
ActionListener,
ComponentListener {
    private static final int SCROLL_ARROW_SIZE = 4;
    private static final int HEADER_PANEL_HEIGHT = 2;
    private final CustomTab _docTabs;
    private final JPanel _headerPanel;
    private final TabGroupPanel _centerPanel;
    private TabGroupState _currentTabGroupState;
    private final JViewport _viewport;
    private final Box _buttonBox;
    private final JButton _scrollLeftButton;
    private final JButton _scrollRightButton;
    private final DropDownMenuButton _dropDownButton;
    private final DragSource _dragSource;
    private boolean _ensureTabVisibleAfterValidate;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = TabGroup.class.desiredAssertionStatus() ^ true;
    }

    void $init$() {
        this._dragSource = new DragSource();
    }

    public TabGroup() {
        this.$init$();
        this.setOpaque(false);
        this._docTabs = new CustomTab(new DefaultListModel(), 1);
        this._docTabs.setGradientHighlight(true);
        this._docTabs.setOpaque(false);
        this._docTabs.setOffsetSelected(0);
        this._docTabs.setGapBetweenTabs(-1);
        DocTabListener docTabListener = new DocTabListener(this, this._docTabs);
        this._docTabs.addSelectionListener(docTabListener);
        this._docTabs.addListDataListener(docTabListener);
        this._docTabs.addMouseListener(docTabListener);
        this._docTabs.setCtrlClickCloseEnabled(true);
        this._docTabs.setCloseAction(new TabCloseAction());
        this._viewport = new JViewport();
        this._viewport.setView(this._docTabs);
        this._viewport.addChangeListener(this);
        this._viewport.setOpaque(false);
        this._viewport.addComponentListener(this);
        String string = KeyUtil.buildTooltip(70);
        this._scrollLeftButton = new JButton();
        this._scrollLeftButton.setModel(new AutoRepeatButtonModel(400, 100));
        this._scrollLeftButton.addActionListener(this);
        this.initScrollButton(this._scrollLeftButton, string, 7);
        String string2 = KeyUtil.buildTooltip(71);
        this._scrollRightButton = new JButton();
        this._scrollRightButton.setModel(new AutoRepeatButtonModel(400, 100));
        this._scrollRightButton.addActionListener(this);
        this.initScrollButton(this._scrollRightButton, string2, 3);
        String string3 = KeyUtil.buildTooltip(EditorManagerImpl.SHOW_DROPDOWN_CMD_ID);
        this._dropDownButton = new DropDownMenuButton();
        this._dropDownButton.addItemListener(this);
        this.initScrollButton(this._dropDownButton, string3, 5);
        Component component = Box.createHorizontalStrut(5);
        component.addMouseListener(docTabListener);
        this._buttonBox = new Box(0);
        this._buttonBox.setBorder(JavatoolsBorderFactory.createBottomBorder((Color)IdeConstants.COLOR_IDE_LINES));
        this._buttonBox.setOpaque(false);
        this._buttonBox.addMouseListener(docTabListener);
        this._buttonBox.add(component);
        this._buttonBox.add(this._scrollLeftButton);
        this._buttonBox.add(this._scrollRightButton);
        this._buttonBox.add(this._dropDownButton);
        Border border = JavatoolsBorderFactory.createLeftRightBorder((Color)IdeConstants.COLOR_IDE_LINES);
        this._headerPanel = new JPanel();
        this._headerPanel.setBackground(IdeUIManager.getInactiveTitleGradientDarkColor());
        this._headerPanel.setBorder(border);
        this._centerPanel = new TabGroupPanel();
        this._dragSource.createDefaultDragGestureRecognizer(this._docTabs, 2, this);
        new DropTarget(this._docTabs, this);
        new DropTarget(this._headerPanel, this);
        new DropTarget(this._buttonBox, this);
        this.add(this._buttonBox);
        this.add(this._viewport);
        this.add(this._headerPanel);
        this.add(this._centerPanel);
    }

    private void initScrollButton(AbstractButton abstractButton, String string, int n) {
        ArrowIcon arrowIcon = new ArrowIcon(4, n);
        int n2 = Math.max(arrowIcon.getIconWidth() + 8, arrowIcon.getIconHeight() + 8);
        if (n2 % 2 != 0) {
            ++n2;
        }
        Dimension dimension = new Dimension(n2, n2);
        abstractButton.setIcon(arrowIcon);
        abstractButton.setToolTipText(string);
        abstractButton.setMaximumSize(dimension);
        abstractButton.setPreferredSize(dimension);
        abstractButton.setFocusable(false);
        abstractButton.setRolloverEnabled(false);
        abstractButton.setAlignmentY(0.0f);
        abstractButton.setMargin(new Insets(0, 0, 0, 0));
        Insets insets = abstractButton.getInsets();
        if (insets.top > 3 || insets.left > 3 || insets.bottom > 3 || insets.right > 3) {
            abstractButton.setBorder(BorderFactory.createLineBorder(SystemColor.controlDkShadow));
        }
    }

    private static EditorManagerImpl getEditorManager() {
        return EditorManagerImpl.getInstance();
    }

    private static Desktop getDesktop() {
        return TabGroup.getEditorManager().getDesktop();
    }

    public boolean isFocused() {
        return this._docTabs.isFocused();
    }

    public void setFocused(boolean bl) {
        this._docTabs.setFocused(bl);
        this._headerPanel.setBackground(bl ? IdeUIManager.getActiveTitleGradientDarkColor() : IdeUIManager.getInactiveTitleGradientDarkColor());
        TabGroupState tabGroupState = this.getCurrentTabGroupState();
        if (tabGroupState != null) {
            EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
            editorManagerImpl.moveTabGroupStateSwitchToTop(tabGroupState);
        }
    }

    public int getTabGroupStateCount() {
        return this._docTabs.getPageCount();
    }

    public TabGroupState getTabGroupState(int n) {
        DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._docTabs.getPage(n);
        TabGroupState tabGroupState = (TabGroupState)defaultCustomTabPage.getUserObject();
        return tabGroupState;
    }

    boolean addTabGroupState(EditorCreation editorCreation) {
        boolean bl = false;
        TabGroupState tabGroupState = new TabGroupState(this, editorCreation);
        SplitPaneState splitPaneState = tabGroupState.createSplitPaneState(editorCreation);
        if (splitPaneState != null) {
            tabGroupState.addSplitPaneState(splitPaneState);
            TabGroupState tabGroupState2 = this.getCurrentTabGroupState();
            int n = this.indexOf(tabGroupState2);
            EditorPathImpl editorPathImpl = editorCreation.getEditorPath();
            editorPathImpl._tabGroupStatePos = this.addTabGroupState(tabGroupState, n + 1);
            editorPathImpl._panePos = 0;
            bl = true;
        }
        return bl;
    }

    int addTabGroupState(TabGroupState tabGroupState, int n) {
        DefaultListModel defaultListModel = (DefaultListModel)this._docTabs.getModel();
        if (n < 0) {
            n = defaultListModel.getSize();
        }
        DefaultCustomTabPage defaultCustomTabPage = new DefaultCustomTabPage(tabGroupState);
        defaultListModel.add(n, defaultCustomTabPage);
        tabGroupState.setParentTabGroup(this);
        this.whenTabGroupStateChanged(n);
        TabGroup.getEditorManager().addToNodeList(tabGroupState);
        this._ensureTabVisibleAfterValidate = true;
        return n;
    }

    void whenTabGroupStateChanged(TabGroupState tabGroupState) {
        block0: {
            int n = this.indexOf(tabGroupState);
            if (n == -1) break block0;
            this.whenTabGroupStateChanged(n);
        }
    }

    private void whenTabGroupStateChanged(int n) {
        DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._docTabs.getPage(n);
        TabGroupState tabGroupState = (TabGroupState)defaultCustomTabPage.getUserObject();
        Context context = tabGroupState.getContext();
        Node node = context.getNode();
        Icon icon = tabGroupState.getNodeIcon();
        String string = node.getShortLabel();
        String string2 = tabGroupState.getLongLabel();
        Attributes attributes = node.getAttributes();
        boolean bl = attributes.isSet(ElementAttributes.COMPOSITE) ? attributes.isSet(ElementAttributes.DIRTY_COMPOSITE) : node.isDirty();
        defaultCustomTabPage.setIcon(icon);
        defaultCustomTabPage.setLabel(string);
        defaultCustomTabPage.setTooltip(string2);
        defaultCustomTabPage.setDirty(bl);
        this._docTabs.revalidate();
    }

    void closeTabGroupState(int n) {
        DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._docTabs.getPage(n);
        this.detachTabGroupState(n);
        try {
            TabGroupState tabGroupState = (TabGroupState)defaultCustomTabPage.getUserObject();
            EditorManagerImpl editorManagerImpl = TabGroup.getEditorManager();
            editorManagerImpl.removeFromNodeList(tabGroupState);
            boolean bl = tabGroupState.isRestorableAtStartup();
            if (!bl) {
                Context context = tabGroupState.getContext();
                editorManagerImpl.removeFromLRUList(context);
            }
            int n2 = tabGroupState.getSplitPaneStateCount();
            int n3 = n2 - 1;
            while (n3 >= 0) {
                tabGroupState.closeSplitPaneState(n3);
                --n3;
            }
            tabGroupState.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this._docTabs.getPageCount() == 0) {
            Desktop desktop = TabGroup.getDesktop();
            desktop.removeTabGroup(this);
        }
    }

    void detachTabGroupState(int n) {
        this._docTabs.removePage(n);
    }

    private int indexOf(TabGroupState tabGroupState) {
        int n = this._docTabs.getPageCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._docTabs.getPage(n2);
            if (defaultCustomTabPage.getUserObject() == tabGroupState) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    void whenTabSelectionChanges() {
        int n = this._docTabs.getSelectedPage();
        if (n == -1) {
            this.setCurrentTabGroupState(null);
        } else {
            this.safeSetCurrentTabGroupState(n);
        }
    }

    private static boolean canChangeSelection(TabGroupState tabGroupState) {
        SplitPaneState splitPaneState;
        EditorState editorState;
        Editor editor;
        boolean bl = tabGroupState != null ? (editor = (editorState = (splitPaneState = tabGroupState.getCurrentSplitPaneState()).getCurrentEditorState()).getOrCreateEditor(tabGroupState.getContext())) != null : true;
        return bl;
    }

    private void ensureTabVisible() {
        int n = this._docTabs.getSelectedPage();
        if (n != -1) {
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._docTabs.getPage(n);
            Dimension dimension = this._docTabs.getPreferredSize();
            if (dimension != null) {
                Rectangle rectangle = defaultCustomTabPage.getBounds();
                Rectangle rectangle2 = this._viewport.getViewRect();
                if (rectangle.x < rectangle2.x) {
                    this._viewport.setViewPosition(new Point(rectangle.x, 0));
                } else if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                    this._viewport.setViewPosition(new Point(rectangle.x + rectangle.width - rectangle2.width, 0));
                }
            }
        }
    }

    private void detachCurrentNode() {
        TabGroupState tabGroupState = this.getCurrentTabGroupState();
        if (tabGroupState != null) {
            this.updateCurrentLayoutState();
            int n = tabGroupState.getSplitPaneStateCount();
            int n2 = 0;
            while (n2 < n) {
                SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(n2);
                SplitPane splitPane = splitPaneState.getSplitPane();
                if (splitPane != null) {
                    this._centerPanel.remove(splitPane);
                    splitPane.setSplitPaneState(null);
                    splitPaneState.setSplitPane(null);
                    TabGroup.getEditorManager().releaseSplitPane(splitPane);
                }
                ++n2;
            }
        }
    }

    private void updateCurrentLayoutState() {
        TabGroupState tabGroupState = this.getCurrentTabGroupState();
        DockLayout dockLayout = (DockLayout)this._centerPanel.getLayout();
        SplitPaneStructPersistence splitPaneStructPersistence = new SplitPaneStructPersistence(tabGroupState);
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess("pane");
        dockLayout.saveLayout(splitPaneStructPersistence, defaultStructuredPropertyAccess);
        tabGroupState.setStructPersistence(defaultStructuredPropertyAccess);
    }

    private void attachCurrentNode() {
        DockLayout dockLayout = (DockLayout)this._centerPanel.getLayout();
        TabGroupState tabGroupState = this.getCurrentTabGroupState();
        StructuredPropertyAccess structuredPropertyAccess = tabGroupState.getStructPersistence();
        if (structuredPropertyAccess != null) {
            SplitPaneStructPersistence splitPaneStructPersistence = new SplitPaneStructPersistence(tabGroupState);
            dockLayout.loadLayout((Container)this._centerPanel, splitPaneStructPersistence, structuredPropertyAccess);
        } else {
            SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(0);
            SplitPane splitPane = TabGroup.getEditorManager().createSplitPane();
            splitPaneState.setSplitPane(splitPane);
            splitPane.setSplitPaneState(splitPaneState);
            this._centerPanel.add((Component)splitPane, new DockLayoutConstraint((Component)null, 2, 1, new Dimension(1000, 1000)));
        }
    }

    public void focusCurrentEditor() {
        TabGroupState tabGroupState = this.getCurrentTabGroupState();
        if (tabGroupState != null) {
            tabGroupState.focusCurrentEditor();
        }
    }

    void getDropArea(Rectangle rectangle) {
        this._centerPanel.getBounds(rectangle);
    }

    private static void printTree(Component component, String string) {
        System.out.println((component.isValid() ? " " : "I") + "  " + string + component.getClass().getName());
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                Component component2 = container.getComponent(n);
                TabGroup.printTree(component2, string + "  ");
                ++n;
            }
        }
    }

    public void doLayout() {
        boolean bl;
        boolean bl2 = bl = this._docTabs.getPageCount() != 0;
        if (!$assertionsDisabled && !bl) {
            throw new AssertionError();
        }
        if (bl) {
            Dimension dimension = this.getSize();
            Insets insets = this.getInsets();
            Dimension dimension2 = this._docTabs.getPreferredSize();
            Dimension dimension3 = this._buttonBox.getPreferredSize();
            int n = Math.max(dimension2.height, this._buttonBox.getHeight());
            Rectangle rectangle = new Rectangle(insets.left, insets.top + n - dimension2.height, dimension.width - (insets.left + dimension3.width + insets.right), dimension2.height);
            Rectangle rectangle2 = new Rectangle(rectangle.x + rectangle.width, insets.top + n - dimension2.height, dimension3.width, dimension2.height);
            this._viewport.setBounds(rectangle);
            this._buttonBox.setBounds(rectangle2);
            this._headerPanel.setBounds(insets.left, insets.top + n, dimension.width - insets.left - insets.right, 2);
            this._centerPanel.setBounds(insets.left, insets.top + (n += 2), dimension.width - (insets.left + insets.right), dimension.height - (n + insets.top + insets.bottom));
        }
    }

    public void validate() {
        super.validate();
        if (this._ensureTabVisibleAfterValidate) {
            this._ensureTabVisibleAfterValidate = false;
            this.ensureTabVisible();
        }
    }

    public boolean searchEditor(EditorPathImpl editorPathImpl, EditorCriteriaImpl editorCriteriaImpl) {
        boolean bl = false;
        int n = this.getTabGroupStateCount();
        int n2 = 0;
        while (!bl && n2 < n) {
            TabGroupState tabGroupState = this.getTabGroupState(n2);
            if (tabGroupState.match(editorCriteriaImpl) || tabGroupState.searchEditor(editorPathImpl, editorCriteriaImpl)) {
                editorPathImpl._tabGroupStatePos = n2;
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public boolean match(EditorCriteriaImpl editorCriteriaImpl) {
        return editorCriteriaImpl.getCriteria1() == this && editorCriteriaImpl.getType() == 13;
    }

    public boolean activateEditor(EditorPathImpl editorPathImpl) {
        TabGroupState tabGroupState;
        boolean bl = true;
        int n = editorPathImpl._tabGroupStatePos;
        if (n != -1 && this.setCurrentTabGroupState(tabGroupState = this.getTabGroupState(n)) && (bl = tabGroupState.activateEditor(editorPathImpl))) {
            this.restoreIfMaximized();
            if (!this._ensureTabVisibleAfterValidate) {
                this.ensureTabVisible();
            }
        }
        return bl;
    }

    private void restoreIfMaximized() {
        MainWindowImpl mainWindowImpl = (MainWindowImpl)Ide.getMainWindow();
        int n = mainWindowImpl.getMaximizedWindowType();
        if (n == 1) {
            mainWindowImpl.restore();
        } else if (n == 2 && !this.isShowing()) {
            mainWindowImpl.restore();
        }
    }

    public List findEditors(Context context) {
        ArrayList<Editor> arrayList = null;
        Node node = context.getNode();
        Project project = context.getProject();
        Workspace workspace = context.getWorkspace();
        int n = this.getTabGroupStateCount();
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            TabGroupState tabGroupState = this.getTabGroupState(n2);
            Context context2 = tabGroupState.getContext();
            boolean bl2 = bl = ModelUtil.areEqual((Object)node, (Object)context2.getNode()) && ModelUtil.areEqual((Object)project, (Object)context2.getProject()) && ModelUtil.areEqual((Object)workspace, (Object)context2.getWorkspace());
            if (bl) {
                int n3 = tabGroupState.getSplitPaneStateCount();
                int n4 = 0;
                while (n4 < n3) {
                    SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(n4);
                    int n5 = splitPaneState.getEditorStateCount();
                    int n6 = 0;
                    while (n6 < n5) {
                        EditorState editorState = splitPaneState.getEditorState(n6);
                        Editor editor = editorState.getEditor();
                        if (editor != null) {
                            if (arrayList == null) {
                                arrayList = new ArrayList<Editor>(1);
                            }
                            arrayList.add(editor);
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return arrayList != null ? arrayList : Collections.EMPTY_LIST;
    }

    public List getAllEditors() {
        ArrayList<Editor> arrayList = new ArrayList<Editor>();
        int n = this.getTabGroupStateCount();
        int n2 = 0;
        while (n2 < n) {
            TabGroupState tabGroupState = this.getTabGroupState(n2);
            int n3 = tabGroupState.getSplitPaneStateCount();
            int n4 = 0;
            while (n4 < n3) {
                SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(n4);
                int n5 = splitPaneState.getEditorStateCount();
                int n6 = 0;
                while (n6 < n5) {
                    EditorState editorState = splitPaneState.getEditorState(n6);
                    Editor editor = editorState.getEditor();
                    if (editor != null) {
                        arrayList.add(editor);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return arrayList;
    }

    boolean getCurrentEditorPath(EditorPathImpl editorPathImpl) {
        boolean bl = false;
        TabGroupState tabGroupState = this.getCurrentTabGroupState();
        if (tabGroupState != null) {
            editorPathImpl._tabGroupStatePos = this.indexOf(tabGroupState);
            bl = tabGroupState.getCurrentEditorPath(editorPathImpl);
        }
        return bl;
    }

    TabGroupState getCurrentTabGroupState() {
        return this._currentTabGroupState;
    }

    public SplitPane getCurrentSplitPane() {
        TabGroupState tabGroupState = this.getCurrentTabGroupState();
        return tabGroupState == null ? null : tabGroupState.getCurrentSplitPane();
    }

    public Editor getCurrentEditor() {
        Editor editor = null;
        TabGroupState tabGroupState = this.getCurrentTabGroupState();
        if (tabGroupState != null) {
            editor = tabGroupState.getCurrentEditor();
        }
        return editor;
    }

    public SplitPane getSplitPane(Editor editor) {
        SplitPane splitPane = null;
        int n = this.getTabGroupStateCount();
        int n2 = 0;
        while (n2 < n) {
            TabGroupState tabGroupState = this.getTabGroupState(n2);
            int n3 = tabGroupState.getSplitPaneStateCount();
            int n4 = 0;
            while (n4 < n3) {
                SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(n4);
                int n5 = splitPaneState.getEditorStateCount();
                int n6 = 0;
                while (n6 < n5) {
                    EditorState editorState = splitPaneState.getEditorState(n6);
                    if (editor == editorState.getEditor()) {
                        splitPane = splitPaneState.getSplitPane();
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return splitPane;
    }

    void close(TabGroupState[] tabGroupStateArray) {
        int n;
        HashSet hashSet = new HashSet();
        IdeUtil.addAll(hashSet, tabGroupStateArray);
        TabGroupState tabGroupState = this.getCurrentTabGroupState();
        int n2 = n = this.indexOf(tabGroupState);
        while (n2 >= 0) {
            TabGroupState tabGroupState2 = this.getTabGroupState(n2);
            if (!hashSet.contains(tabGroupState2)) break;
            --n2;
        }
        if (n2 == -1) {
            int n3;
            int n4 = this.getTabGroupStateCount();
            int n5 = n3 = n >= 0 ? n : 0;
            while (n5 < n4) {
                TabGroupState tabGroupState3 = this.getTabGroupState(n5);
                if (!hashSet.contains(tabGroupState3)) {
                    n2 = n5;
                    break;
                }
                ++n5;
            }
        }
        this._docTabs.setSelectedPage(n2);
        int n6 = 0;
        while (n6 < tabGroupStateArray.length) {
            TabGroupState tabGroupState4 = tabGroupStateArray[n6];
            int n7 = this.indexOf(tabGroupState4);
            if (n7 != -1) {
                this.closeTabGroupState(n7);
            }
            ++n6;
        }
    }

    private void updateButtonsEnabledStateActivate() {
        Point point = this._viewport.getViewPosition();
        Dimension dimension = this._viewport.getViewSize();
        Dimension dimension2 = this._viewport.getExtentSize();
        this._scrollLeftButton.setEnabled(point.x != 0);
        this._scrollRightButton.setEnabled(point.x < dimension.width - dimension2.width);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateButtonsEnabledStateActivate();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.ensureTabVisible();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._scrollLeftButton) {
            this.whenScrollTabsLeft();
        } else if (object == this._scrollRightButton) {
            this.whenScrollTabsRight();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this._dropDownButton) {
            if (itemEvent.getStateChange() == 1) {
                this.whenDropDownButtonPressed(true);
            } else if (itemEvent.getStateChange() == 2) {
                this.whenDropDownButtonPressed(false);
            }
        }
    }

    private void whenScrollTabsRight() {
        Point point = this._viewport.getViewPosition();
        Dimension dimension = this._viewport.getViewSize();
        int n = this._docTabs.getPageAfter(point.x);
        if (n >= 0) {
            CustomTabPage customTabPage = this._docTabs.getPage(n);
            Rectangle rectangle = customTabPage.getBounds();
            Dimension dimension2 = this._viewport.getExtentSize();
            int n2 = Math.min(rectangle.x, dimension.width - dimension2.width);
            this._viewport.setViewPosition(new Point(n2, 0));
        }
    }

    private void whenScrollTabsLeft() {
        Point point = this._viewport.getViewPosition();
        int n = this._docTabs.getPageBefore(point.x);
        if (n >= 0) {
            CustomTabPage customTabPage = this._docTabs.getPage(n);
            Rectangle rectangle = customTabPage.getBounds();
            int n2 = rectangle.x;
            this._viewport.setViewPosition(new Point(n2, 0));
        }
    }

    private void whenDropDownButtonPressed(boolean bl) {
        this._dropDownButton.removeAllPopupItems();
        if (!bl) {
            return;
        }
        Dimension dimension = this._dropDownButton.getToolkit().getScreenSize();
        List list = TabGroup.getMiscPopupItems();
        List list2 = this.getEditorPopupItems();
        int n = list.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            JMenuItem jMenuItem = (JMenuItem)list.get(n3);
            int n4 = jMenuItem.getPreferredSize().height;
            n2 += n4;
            ++n3;
        }
        n = list2.size();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            JMenuItem jMenuItem = (JMenuItem)list2.get(n6);
            int n7 = jMenuItem.getPreferredSize().height;
            n5 += n7;
            ++n6;
        }
        if (n5 + n2 < dimension.height * 9 / 10) {
            n = list2.size();
            int n8 = 0;
            while (n8 < n) {
                JMenuItem jMenuItem = (JMenuItem)list2.get(n8);
                this._dropDownButton.addPopupItem(jMenuItem);
                ++n8;
            }
        } else {
            n = list2.size();
            int n9 = dimension.height * 9 / 10 - n2;
            int n10 = n5 / n9 + 1;
            int n11 = list2.size() / n10 + 1;
            int n12 = n11 + 1;
            JMenu jMenu = null;
            int n13 = 0;
            while (n13 < n) {
                JMenuItem jMenuItem = (JMenuItem)list2.get(n13);
                if (n12 >= n11) {
                    String string = jMenuItem.getText();
                    int n14 = Math.min(n13 + n11, n) - 1;
                    JMenuItem jMenuItem2 = (JMenuItem)list2.get(n14);
                    String string2 = jMenuItem2.getText();
                    jMenu = new JMenu(string + " - " + string2);
                    this._dropDownButton.addPopupItem(jMenu);
                    n12 = 0;
                }
                jMenu.add(jMenuItem);
                ++n12;
                ++n13;
            }
        }
        this._dropDownButton.addPopupSeparator();
        n = list.size();
        int n15 = 0;
        while (n15 < n) {
            JMenuItem jMenuItem = (JMenuItem)list.get(n15);
            this._dropDownButton.addPopupItem(jMenuItem);
            ++n15;
        }
    }

    private List getEditorPopupItems() {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        int n = this.getTabGroupStateCount();
        int n2 = 0;
        while (n2 < n) {
            TabGroupState tabGroupState = this.getTabGroupState(n2);
            Context context = tabGroupState.getContext();
            Node node = context.getNode();
            2 var7_7 = new 2(this, node.getShortLabel(), node.getIcon(), tabGroupState);
            JMenuItem jMenuItem = new JMenuItem(var7_7);
            arrayList.add(jMenuItem);
            ++n2;
        }
        Collections.sort(arrayList, new 1());
        return arrayList;
    }

    private static List getMiscPopupItems() {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>(2);
        Menubar menubar = Ide.getMenubar();
        IdeAction ideAction = IdeAction.find(61);
        JMenuItem jMenuItem = menubar.createMenuItem(ideAction);
        arrayList.add(jMenuItem);
        return arrayList;
    }

    public boolean canActivateLeftNode() {
        int n = this._docTabs.getSelectedPage();
        return n >= 1;
    }

    public void whenActivateLeftNode() {
        int n = this._docTabs.getSelectedPage();
        int n2 = n - 1;
        if (n2 >= 0) {
            this._docTabs.setSelectedPage(n2);
            this.ensureTabVisible();
        }
    }

    public boolean canActivateRightNode() {
        int n;
        int n2 = this._docTabs.getSelectedPage();
        return n2 + 1 < (n = this._docTabs.getPageCount());
    }

    public void whenActivateRightNode() {
        int n;
        int n2 = this._docTabs.getSelectedPage();
        int n3 = n2 + 1;
        if (n3 < (n = this._docTabs.getPageCount())) {
            this._docTabs.setSelectedPage(n3);
            this.ensureTabVisible();
        }
    }

    void splitPane(EditorPathImpl editorPathImpl) {
        SplitPaneState splitPaneState = editorPathImpl.getSplitPaneState();
        SplitPane splitPane = splitPaneState.getSplitPane();
        int n = splitPane.getHeight() / 2;
        this.split(splitPane, n, 1);
    }

    void unsplitPane(EditorPathImpl editorPathImpl) {
        int n = editorPathImpl._panePos;
        TabGroupState tabGroupState = editorPathImpl.getTabGroupState();
        editorPathImpl._panePos = 0;
        int n2 = 0;
        while (n2 < n) {
            this._centerPanel.closePanel(editorPathImpl);
            ++n2;
        }
        int n3 = tabGroupState.getSplitPaneStateCount();
        editorPathImpl._panePos = 1;
        int n4 = 1;
        while (n4 < n3) {
            this._centerPanel.closePanel(editorPathImpl);
            ++n4;
        }
    }

    void split(SplitPane splitPane, int n, int n2) {
        int n3;
        SplitPaneState splitPaneState;
        EditorState editorState;
        EditorAddin editorAddin;
        EditorAddin editorAddin2;
        int n4;
        TabGroupState tabGroupState = this.getCurrentTabGroupState();
        SplitPaneState splitPaneState2 = new SplitPaneState(tabGroupState);
        boolean bl = splitPaneState2.setCurrentEditorStatePos(n4 = splitPaneState2.searchEditorPos(editorAddin2 = tabGroupState.findBestDuplicatedEditor(editorAddin = (editorState = (splitPaneState = splitPane.getSplitPaneState()).getEditorState(n3 = splitPaneState.getCurrentEditorStatePos())).getEditorAddin())));
        if (bl) {
            int n5;
            tabGroupState.addSplitPaneState(splitPaneState2);
            SplitPane splitPane2 = EditorManagerImpl.getInstance().createSplitPane();
            splitPaneState2.setSplitPane(splitPane2);
            splitPane2.setSplitPaneState(splitPaneState2);
            DockLayoutInfoLeaf dockLayoutInfoLeaf = this._centerPanel.getLayoutInfo(splitPane);
            Dimension dimension = dockLayoutInfoLeaf.getSize(2);
            Dimension dimension2 = splitPane.getSize();
            Dimension dimension3 = new Dimension(dimension);
            if (n2 == 1) {
                int n6 = dimension.height;
                dimension.height = n6 * n / dimension2.height;
                dimension3.height = n6 - dimension.height;
                n5 = 3;
            } else {
                int n7 = dimension.width;
                dimension.width = n7 * n / dimension2.width;
                dimension3.width = n7 - dimension.width;
                n5 = 1;
            }
            if (editorAddin == editorAddin2) {
                DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess("DUPLICATON");
                splitPane.savePaneState();
                editorState.saveStateInfo(defaultStructuredPropertyAccess);
                EditorState editorState2 = splitPaneState2.getCurrentEditorState();
                editorState2.loadStateInfo(defaultStructuredPropertyAccess);
                splitPane2.loadPaneState();
            }
            this._centerPanel.add((Component)splitPane2, new DockLayoutConstraint(splitPane, n5, 1, dimension3));
            this.revalidate();
        }
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        int n = this._docTabs.getPageAt(dragGestureEvent.getDragOrigin());
        if (n != -1) {
            TabGroupState tabGroupState = this.getTabGroupState(n);
            Context context = tabGroupState.getContext();
            TransferableEditorTab transferableEditorTab = new TransferableEditorTab(context);
            TabGroup.getDesktop().setDropPanesVisible(true);
            this._dragSource.startDrag(dragGestureEvent, null, transferableEditorTab, this);
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        TabGroup.getDesktop().setDropPanesVisible(false);
    }

    private boolean setCurrentTabGroupState(TabGroupState tabGroupState) {
        boolean bl = false;
        if (this._currentTabGroupState != tabGroupState) {
            if (TabGroup.canChangeSelection(tabGroupState)) {
                boolean bl2 = GraphicsUtils.getFocusedChildComponent(this) != null;
                TabGroup.getDesktop().freezeFocusChanges(true);
                if (this._currentTabGroupState != null) {
                    this.detachCurrentNode();
                }
                this._currentTabGroupState = tabGroupState;
                int n = this._currentTabGroupState == null ? -1 : this.indexOf(this._currentTabGroupState);
                this._docTabs.setSelectedPage(n);
                if (this._currentTabGroupState != null) {
                    this.attachCurrentNode();
                    if (bl2) {
                        this.focusCurrentEditor();
                    }
                }
                TabGroup.getDesktop().freezeFocusChanges(false);
                this.whenCurrentEditorChanges();
                if (tabGroupState != null) {
                    Context context = tabGroupState.getContext();
                    SplitPaneState splitPaneState = tabGroupState.getCurrentSplitPaneState();
                    EditorState editorState = splitPaneState.getCurrentEditorState();
                    EditorAddin editorAddin = editorState.getEditorAddin();
                    EditorManagerImpl editorManagerImpl = TabGroup.getEditorManager();
                    editorManagerImpl.raiseContextInLRUList(context, editorAddin);
                    editorManagerImpl.moveTabGroupStateSwitchToTop(tabGroupState);
                }
                this.revalidate();
                this.repaint();
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        TabGroup.handleDragEvent(dropTargetDragEvent);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        TabGroup.handleDragEvent(dropTargetDragEvent);
    }

    private static void handleDragEvent(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(TransferableEditorTab.contextFlavor) || dropTargetDragEvent.isDataFlavorSupported(TransferableContext.contextFlavor) || dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dropTargetDragEvent.acceptDrag(2);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        int n = 0;
        while (n < dataFlavorArray.length) {
            DataFlavor dataFlavor = dataFlavorArray[n];
            try {
                if (TransferableEditorTab.contextFlavor.equals(dataFlavor)) {
                    this.dropTransferableEditorTab(dropTargetDropEvent);
                } else if (TransferableContext.contextFlavor.equals(dataFlavor)) {
                    this.dropTransferableContext(dropTargetDropEvent);
                } else if (DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                    this.dropJavaFileList(dropTargetDropEvent);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ++n;
        }
    }

    private void dropTransferableContext(DropTargetDropEvent dropTargetDropEvent) throws IOException, UnsupportedFlavorException {
        dropTargetDropEvent.acceptDrop(3);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        TransferableContext transferableContext = (TransferableContext)transferable.getTransferData(TransferableContext.contextFlavor);
        Context context = transferableContext.getContext();
        this.dropContext(context);
    }

    private void dropTransferableEditorTab(DropTargetDropEvent dropTargetDropEvent) throws UnsupportedFlavorException, IOException {
        dropTargetDropEvent.acceptDrop(3);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        TransferableEditorTab transferableEditorTab = (TransferableEditorTab)transferable.getTransferData(TransferableEditorTab.contextFlavor);
        Context context = transferableEditorTab.getContext();
        this.dropContext(context);
    }

    private void dropContext(Context context) {
        EditorCriteriaImpl editorCriteriaImpl = new EditorCriteriaImpl(context);
        EditorPathImpl editorPathImpl = new EditorPathImpl();
        EditorManagerImpl editorManagerImpl = TabGroup.getEditorManager();
        if (editorManagerImpl.searchEditor(editorPathImpl, editorCriteriaImpl)) {
            TabGroup tabGroup = editorPathImpl.getTabGroup();
            if (tabGroup != this) {
                TabGroupState tabGroupState = editorPathImpl.getTabGroupState();
                tabGroup.detachTabGroupState(editorPathImpl._tabGroupStatePos);
                editorPathImpl._tabGroupStatePos = this.addTabGroupState(tabGroupState, -1);
                this.activateEditor(editorPathImpl);
                int n = tabGroup.getTabGroupStateCount();
                if (n == 0) {
                    TabGroup.getDesktop().removeTabGroup(tabGroup);
                }
            }
        } else if (editorManagerImpl.searchEditor(editorPathImpl, new EditorCriteriaImpl(this))) {
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            editorManagerImpl.createEditor(openEditorOptions, editorPathImpl);
        }
    }

    private void dropJavaFileList(DropTargetDropEvent dropTargetDropEvent) {
        EditorPathImpl editorPathImpl;
        EditorManagerImpl editorManagerImpl = TabGroup.getEditorManager();
        if (editorManagerImpl.searchEditor(editorPathImpl = new EditorPathImpl(), new EditorCriteriaImpl(this))) {
            editorManagerImpl.activateEditor(editorPathImpl);
        }
        DropFileUtil.drop(dropTargetDropEvent);
    }

    void showDropDownMenu() {
        this._dropDownButton.setSelected(true);
    }

    void whenCurrentEditorChanges(TabGroupState tabGroupState) {
        TabGroupState tabGroupState2 = this.getCurrentTabGroupState();
        if (tabGroupState2 == tabGroupState) {
            this.whenCurrentEditorChanges();
        }
    }

    private void whenCurrentEditorChanges() {
        Desktop desktop = TabGroup.getDesktop();
        desktop.whenCurrentEditorChanges(this);
    }

    public void whenEditorActivated(TabGroupState tabGroupState) {
        TabGroupState tabGroupState2 = this.getCurrentTabGroupState();
        if (tabGroupState2 != tabGroupState) {
            this.setCurrentTabGroupState(tabGroupState);
        }
        TabGroup.getDesktop().whenEditorActivated(this);
    }

    void dump(String string, boolean bl) {
        System.out.println(string + "TabGroupState" + (bl ? "*" : ""));
        int n = this.getTabGroupStateCount();
        int n2 = 0;
        while (n2 < n) {
            TabGroupState tabGroupState = this.getTabGroupState(n2);
            boolean bl2 = tabGroupState == this._currentTabGroupState;
            tabGroupState.dump(string + "  ", bl2);
            ++n2;
        }
    }

    public void whenShowSystemMenu() {
        int n = this._docTabs.getSelectedPage();
        this.showSystemMenu(n, null);
    }

    void showSystemMenu(int n, Point point) {
        int n2;
        int n3;
        if (!this.isShowing()) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        Menubar menubar = Ide.getMenubar();
        EditorManagerImpl editorManagerImpl = TabGroup.getEditorManager();
        if (n != -1) {
            IdeAction ideAction;
            IdeAction ideAction2;
            IdeAction ideAction3;
            TabGroupState tabGroupState = this.getTabGroupState(n);
            EditorPathImpl editorPathImpl = new EditorPathImpl();
            editorManagerImpl.searchEditor(editorPathImpl, new EditorCriteriaImpl(tabGroupState));
            tabGroupState.getCurrentEditorPath(editorPathImpl);
            Editor editor = editorPathImpl.getSplitPaneState().getCurrentEditor();
            Context context = editor.getContext();
            int[] nArray = new int[]{EditorManagerImpl.MAXIMIZE_TAB_GROUP_CMD_ID, EditorManagerImpl.RESTORE_TAB_GROUPS_CMD_ID, EditorManagerImpl.SPLIT_DOCUMENT_CMD_ID, EditorManagerImpl.UNSPLIT_DOCUMENT_CMD_ID, EditorManagerImpl.DETACH_DOCUMENT_CMD_ID, EditorManagerImpl.REGROUP_DOCUMENTS_CMD_ID};
            int n4 = 0;
            while (n4 < nArray.length) {
                int n5 = nArray[n4];
                IdeAction ideAction4 = TabGroup.createLocalAction(n5, editor, context);
                if (ideAction4 != null && ideAction4.isEnabled()) {
                    JMenuItem jMenuItem = menubar.createMenuItem(ideAction4);
                    jPopupMenu.add(jMenuItem);
                }
                ++n4;
            }
            IdeAction ideAction5 = TabGroup.createLocalAction(WorkingSets.ADD_TO_WORKING_SET_CMD_ID, editor, context);
            if (ideAction5 != null && ideAction5.isEnabled()) {
                JMenuItem jMenuItem = menubar.createMenuItem(ideAction5);
                jPopupMenu.addSeparator();
                jPopupMenu.add(jMenuItem);
            }
            if ((ideAction3 = TabGroup.createLocalAction(ContentSetSupport.ADD_URL_TO_PROJECT_CMD_ID, editor, context)) != null && ideAction3.isEnabled()) {
                JMenuItem jMenuItem = menubar.createMenuItem(ideAction3);
                String string = context.getProject().getShortLabel();
                String string2 = ModelArb.format(67, string);
                jMenuItem.setText(string2);
                jPopupMenu.addSeparator();
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.addSeparator();
            IdeAction ideAction6 = TabGroup.createLocalAction(61, editor, context);
            if (ideAction6 != null) {
                JMenuItem jMenuItem = menubar.createMenuItem(ideAction6);
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.addSeparator();
            IdeAction ideAction7 = TabGroup.createLocalAction(48, editor, context);
            if (ideAction7 != null) {
                JMenuItem jMenuItem = menubar.createMenuItem(ideAction7);
                jPopupMenu.add(jMenuItem);
            }
            if ((ideAction2 = TabGroup.createLocalAction(39, editor, context)) != null) {
                JMenuItem jMenuItem = menubar.createMenuItem(ideAction2);
                jPopupMenu.add(jMenuItem);
            }
            if ((ideAction = TabGroup.createLocalAction(EditorManagerImpl.CLOSE_OTHERS_CMD_ID, editor, context)) != null) {
                JMenuItem jMenuItem = menubar.createMenuItem(ideAction);
                jPopupMenu.add(jMenuItem);
            }
        } else {
            Editor editor = this.getCurrentEditor();
            Context context = editor != null ? editor.getContext() : null;
            int[] nArray = new int[]{EditorManagerImpl.MAXIMIZE_TAB_GROUP_CMD_ID, EditorManagerImpl.RESTORE_TAB_GROUPS_CMD_ID, EditorManagerImpl.REGROUP_DOCUMENTS_CMD_ID};
            int n6 = 0;
            while (n6 < nArray.length) {
                int n7 = nArray[n6];
                IdeAction ideAction = TabGroup.createLocalAction(n7, editor, context);
                editorManagerImpl.update(ideAction, context);
                if (ideAction.isEnabled()) {
                    JMenuItem jMenuItem = menubar.createMenuItem(ideAction);
                    jPopupMenu.add(jMenuItem);
                }
                ++n6;
            }
            jPopupMenu.addSeparator();
            IdeAction ideAction = IdeAction.find(61);
            editorManagerImpl.update(ideAction, null);
            JMenuItem jMenuItem = menubar.createMenuItem(ideAction);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
            IdeAction ideAction8 = IdeAction.find(39);
            editorManagerImpl.update(ideAction8, null);
            JMenuItem jMenuItem2 = menubar.createMenuItem(ideAction8);
            jPopupMenu.add(jMenuItem2);
        }
        if (point == null) {
            CustomTabPage customTabPage = this._docTabs.getPage(n);
            Rectangle rectangle = customTabPage.getBounds();
            n3 = rectangle.x;
            n2 = rectangle.y + rectangle.height;
        } else {
            n3 = point.x;
            n2 = point.y;
        }
        jPopupMenu.show(this._docTabs, n3, n2);
    }

    private static IdeAction createLocalAction(int n, Editor editor, Context context) {
        IdeAction ideAction = IdeAction.newLocalAction(n, editor);
        if (ideAction != null) {
            ideAction.updateAction(context);
        }
        return ideAction;
    }

    boolean saveLayout(StructuredPropertyAccess structuredPropertyAccess) {
        this.updateCurrentLayoutState();
        boolean bl = false;
        int n = this.getTabGroupStateCount();
        int n2 = 0;
        while (n2 < n) {
            TabGroupState tabGroupState = this.getTabGroupState(n2);
            boolean bl2 = tabGroupState.isRestorableAtStartup();
            if (bl2) {
                DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess("state");
                tabGroupState.saveStateInfo(defaultStructuredPropertyAccess);
                structuredPropertyAccess.appendChild(defaultStructuredPropertyAccess);
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            int n3 = this._docTabs.getSelectedPage();
            structuredPropertyAccess.setProperty("selectedPage", Integer.toString(n3));
        }
        return bl;
    }

    static TabGroup loadLayout(StructuredPropertyAccess structuredPropertyAccess) {
        TabGroup tabGroup = new TabGroup();
        String string = structuredPropertyAccess.getProperty("selectedPage", "0");
        int n = Integer.parseInt(string);
        Iterator iterator = structuredPropertyAccess.getChildNodes("state");
        while (iterator.hasNext()) {
            TabGroupState tabGroupState = new TabGroupState(tabGroup);
            StructuredPropertyAccess structuredPropertyAccess2 = (StructuredPropertyAccess)iterator.next();
            if (!tabGroupState.loadStateInfo(structuredPropertyAccess2)) continue;
            tabGroup.addTabGroupState(tabGroupState, -1);
        }
        boolean bl = tabGroup.safeSetCurrentTabGroupState(n);
        tabGroup.validate();
        return bl ? tabGroup : null;
    }

    private boolean safeSetCurrentTabGroupState(int n) {
        boolean bl = false;
        while (!bl && n >= 0) {
            int n2 = this.getTabGroupStateCount();
            if (n >= n2) {
                --n;
                continue;
            }
            TabGroupState tabGroupState = this.getTabGroupState(n);
            if (this.setCurrentTabGroupState(tabGroupState)) {
                bl = true;
                continue;
            }
            this.closeTabGroupState(n);
        }
        return bl;
    }

    void highlight(boolean bl) {
    }

    static EditorManagerImpl maS$getEditorManager() {
        return TabGroup.getEditorManager();
    }

    final class 2
    extends AbstractAction {
        private final /* synthetic */ TabGroupState v$tabGroupState;
        final /* synthetic */ TabGroup this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPathImpl editorPathImpl;
            EditorManagerImpl editorManagerImpl = TabGroup.maS$getEditorManager();
            if (editorManagerImpl.searchEditor(editorPathImpl = new EditorPathImpl(), new EditorCriteriaImpl(this.v$tabGroupState))) {
                editorManagerImpl.focusEditor(editorPathImpl);
            }
        }

        public 2(TabGroup tabGroup, String string, Icon icon, TabGroupState tabGroupState) {
            this.v$tabGroupState = tabGroupState;
            this.this$0 = tabGroup;
            super(string, icon);
        }
    }

    final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            JMenuItem jMenuItem = (JMenuItem)object;
            JMenuItem jMenuItem2 = (JMenuItem)object2;
            return String.CASE_INSENSITIVE_ORDER.compare(jMenuItem.getText(), jMenuItem2.getText());
        }
    }

    private static final class TabCloseAction
    extends AbstractAction {
        public TabCloseAction() {
            this.putValue("ShortDescription", KeyUtil.buildTooltip(48));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)object;
            TabGroupState tabGroupState = (TabGroupState)defaultCustomTabPage.getUserObject();
            TabGroupState[] tabGroupStateArray = new TabGroupState[]{tabGroupState};
            EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
            editorManagerImpl.closeEditors(tabGroupStateArray);
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
    }
}

