/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Graphics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import oracle.ide.editor.Editor;
import oracle.ideimpl.controls.dockLayout.AbstractDockLayoutInfoNode;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.EditorState;
import oracle.ideimpl.editor.SplitPane;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.TabGroup;
import oracle.ideimpl.editor.TabGroupState;

final class TabGroupPanel
extends DockLayoutPanel
implements ContainerListener {
    private static final int CLOSE_SENSIBILITY = 50;

    public TabGroupPanel() {
        this.addContainerListener(this);
        this.setPaintingDividers(false);
    }

    private TabGroup getTabGroup() {
        return (TabGroup)this.getParent();
    }

    protected void whenDividerMoved() {
        if (this._draggedIsHorz && this._draggedPtLast.x < 50) {
            this.whenDividerCloses(this._draggedDivider.getBefore());
        } else if (this._draggedIsHorz && this._draggedPtLast.x > this.getWidth() - 50) {
            this.whenDividerCloses(this._draggedDivider.getAfter());
        } else if (!this._draggedIsHorz && this._draggedPtLast.y < 50) {
            this.whenDividerCloses(this._draggedDivider.getBefore());
        } else if (!this._draggedIsHorz && this._draggedPtLast.y > this.getHeight() - 50) {
            this.whenDividerCloses(this._draggedDivider.getAfter());
        } else {
            super.whenDividerMoved();
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintDivider(graphics, this._layout.getVertDividers(this), true);
    }

    private void whenDividerCloses(DockLayoutInfo dockLayoutInfo) {
        this.closePanels(dockLayoutInfo);
        this._draggedDivider = null;
        this.setCursor(null);
    }

    protected void whenDividerDoubleClicked(DockDivider dockDivider, int n) {
        DockLayoutInfo dockLayoutInfo;
        SplitPane splitPane = this.getTabGroup().getCurrentSplitPane();
        DockLayoutInfo dockLayoutInfo2 = this.isSplitPaneInDockLayoutInfo(splitPane, dockLayoutInfo = dockDivider.getBefore()) ? dockDivider.getAfter() : dockLayoutInfo;
        this.closePanels(dockLayoutInfo2);
    }

    private boolean isSplitPaneInDockLayoutInfo(SplitPane splitPane, DockLayoutInfo dockLayoutInfo) {
        if (dockLayoutInfo.isLeaf()) {
            DockLayoutInfoLeaf dockLayoutInfoLeaf = (DockLayoutInfoLeaf)dockLayoutInfo;
            return dockLayoutInfoLeaf.getComponent() == splitPane;
        }
        int n = dockLayoutInfo.getNodeCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            DockLayoutInfo dockLayoutInfo2 = dockLayoutInfo.getNode(n2);
            if (this.isSplitPaneInDockLayoutInfo(splitPane, dockLayoutInfo2)) {
                return true;
            }
            --n2;
        }
        return false;
    }

    private void closePanels(DockLayoutInfo dockLayoutInfo) {
        EditorPathImpl editorPathImpl;
        ArrayList arrayList = new ArrayList(1);
        this.collectEditorsToClose(dockLayoutInfo, arrayList);
        TabGroup tabGroup = this.getTabGroup();
        SplitPane splitPane = tabGroup.getCurrentSplitPane();
        Editor editor = splitPane.getCurrentEditor();
        EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
        Editor editor2 = null;
        if (arrayList.contains(editor)) {
            TabGroupState tabGroupState = tabGroup.getCurrentTabGroupState();
            int n = 0;
            while (editor2 == null && n < tabGroupState.getSplitPaneStateCount()) {
                SplitPane splitPane2 = tabGroupState.getSplitPane(n);
                Editor editor3 = splitPane2.getCurrentEditor();
                if (!arrayList.contains(editor3)) {
                    editor2 = editor3;
                }
                ++n;
            }
        }
        if (editor2 != null && editorManagerImpl.searchEditor(editorPathImpl = new EditorPathImpl(), new EditorCriteriaImpl(editor2))) {
            editorManagerImpl.focusEditor(editorPathImpl);
        }
        this.closePanels(arrayList);
    }

    private void collectEditorsToClose(DockLayoutInfo dockLayoutInfo, ArrayList arrayList) {
        if (dockLayoutInfo.isLeaf()) {
            DockLayoutInfoLeaf dockLayoutInfoLeaf = (DockLayoutInfoLeaf)dockLayoutInfo;
            SplitPane splitPane = (SplitPane)dockLayoutInfoLeaf.getComponent();
            SplitPaneState splitPaneState = splitPane.getSplitPaneState();
            EditorState editorState = splitPaneState.getCurrentEditorState();
            Editor editor = editorState.getEditor();
            arrayList.add(editor);
        } else {
            int n = dockLayoutInfo.getNodeCount();
            int n2 = n - 1;
            while (n2 >= 0) {
                DockLayoutInfo dockLayoutInfo2 = dockLayoutInfo.getNode(n2);
                this.collectEditorsToClose(dockLayoutInfo2, arrayList);
                --n2;
            }
        }
    }

    private void closePanels(ArrayList arrayList) {
        EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
        EditorPathImpl editorPathImpl = new EditorPathImpl();
        int n = 0;
        while (n < arrayList.size()) {
            Editor editor = (Editor)arrayList.get(n);
            EditorCriteriaImpl editorCriteriaImpl = new EditorCriteriaImpl(editor);
            if (editorManagerImpl.searchEditor(editorPathImpl, editorCriteriaImpl)) {
                this.closePanel(editorPathImpl);
            }
            this.revalidate();
            ++n;
        }
    }

    void closePanel(EditorPathImpl editorPathImpl) {
        TabGroupState tabGroupState = editorPathImpl.getTabGroupState();
        SplitPaneState splitPaneState = editorPathImpl.getSplitPaneState();
        SplitPane splitPane = splitPaneState.getSplitPane();
        tabGroupState.closeSplitPaneState(editorPathImpl._panePos);
        this.remove(splitPane);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        this.whenSplitPaneAddedOrRemoved();
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        this.whenSplitPaneAddedOrRemoved();
    }

    private void whenSplitPaneAddedOrRemoved() {
        DockLayout dockLayout = (DockLayout)this.getLayout();
        DockLayoutInfo dockLayoutInfo = dockLayout.getConstraints();
        this.recWalkSplitPanes(dockLayoutInfo);
    }

    private void recWalkSplitPanes(DockLayoutInfo dockLayoutInfo) {
        AbstractDockLayoutInfoNode abstractDockLayoutInfoNode = (AbstractDockLayoutInfoNode)dockLayoutInfo;
        int n = dockLayoutInfo.getNodeCount();
        boolean bl = abstractDockLayoutInfoNode.isSameOrientation(2);
        int n2 = 0;
        while (n2 < n) {
            DockLayoutInfo dockLayoutInfo2 = dockLayoutInfo.getNode(n2);
            if (dockLayoutInfo2.isLeaf()) {
                DockLayoutInfoLeaf dockLayoutInfoLeaf = (DockLayoutInfoLeaf)dockLayoutInfo2;
                SplitPane splitPane = (SplitPane)dockLayoutInfoLeaf.getComponent();
                SplitPaneState splitPaneState = splitPane.getSplitPaneState();
                boolean bl2 = splitPaneState.isSplitable();
                if (bl) {
                    splitPane.setVertSplitterVisible(bl2 && n2 == 0);
                    splitPane.setHorzSplitterVisible(bl2);
                } else {
                    splitPane.setVertSplitterVisible(bl2);
                    splitPane.setHorzSplitterVisible(bl2 && n2 == n - 1);
                }
            } else {
                this.recWalkSplitPanes(dockLayoutInfo2);
            }
            ++n2;
        }
    }
}

