/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.editor.AcceleratorIcon;
import oracle.ideimpl.editor.EditorCreation;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.EditorState;
import oracle.ideimpl.editor.EditorUtil;
import oracle.ideimpl.editor.SplitPane;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.TabGroup;

public final class TabGroupState
implements Observer {
    private TabGroup _parentTabGroup;
    private Context _context;
    private int _currentSplitPanePos;
    private final ArrayList _splitPaneStates;
    private StructuredPropertyAccess _structuredPropertyAccess;
    private int _acceleratorNo;
    private Icon _icon;
    private SplitPaneState[] _reservedEditors;
    private List _editorAddins;

    void $init$() {
        this._currentSplitPanePos = -1;
        this._splitPaneStates = new ArrayList();
        this._acceleratorNo = -1;
    }

    public TabGroupState(TabGroup tabGroup, EditorCreation editorCreation) {
        this.$init$();
        this._parentTabGroup = tabGroup;
        OpenEditorOptions openEditorOptions = editorCreation.getOpenEditorOptions();
        Context context = openEditorOptions.getContext();
        this.setContext(context);
        List list = editorCreation.getEditorAddins();
        this.setEditorAddins(list);
    }

    TabGroupState(TabGroup tabGroup) {
        this.$init$();
        this._parentTabGroup = tabGroup;
    }

    public void setParentTabGroup(TabGroup tabGroup) {
        this._parentTabGroup = tabGroup;
    }

    TabGroup getParentTabGroup() {
        return this._parentTabGroup;
    }

    public SplitPaneState createSplitPaneState(EditorCreation editorCreation) {
        int n;
        SplitPaneState splitPaneState = null;
        SplitPaneState splitPaneState2 = new SplitPaneState(editorCreation, this);
        int n2 = 0;
        Class clazz = editorCreation.getOpenEditorOptions().getEditorClass();
        if (clazz != null && (n = splitPaneState2.searchEditorPos(clazz)) != -1) {
            n2 = n;
        }
        if (splitPaneState2.setCurrentEditorStatePos(n2)) {
            splitPaneState = splitPaneState2;
        }
        return splitPaneState;
    }

    public void addSplitPaneState(SplitPaneState splitPaneState) {
        this._splitPaneStates.add(splitPaneState);
        if (this._currentSplitPanePos == -1) {
            this.setCurrentSplitPanePos(0);
        }
        int n = splitPaneState.getEditorStateCount();
        int n2 = 0;
        while (n2 < n) {
            EditorState editorState = splitPaneState.getEditorState(n2);
            SplitPaneState splitPaneState2 = this.getReservedEditorState(n2);
            boolean bl = splitPaneState2 == null || splitPaneState2 == splitPaneState;
            editorState.setEnabled(bl);
            ++n2;
        }
    }

    public int getSplitPaneStateCount() {
        return this._splitPaneStates.size();
    }

    public SplitPane getSplitPane(int n) {
        SplitPaneState splitPaneState = this.getSplitPaneState(n);
        return splitPaneState.getSplitPane();
    }

    public SplitPaneState getSplitPaneState(int n) {
        return (SplitPaneState)this._splitPaneStates.get(n);
    }

    int indexOf(SplitPaneState splitPaneState) {
        int n = this.getSplitPaneStateCount();
        int n2 = 0;
        while (n2 < n) {
            if (splitPaneState == this.getSplitPaneState(n2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void setCurrentSplitPanePos(int n) {
        if (this._currentSplitPanePos != n) {
            this._currentSplitPanePos = n;
            SplitPaneState splitPaneState = this._currentSplitPanePos != -1 ? this.getSplitPaneState(n) : null;
            this.whenCurrentEditorChanges(splitPaneState);
        }
    }

    boolean getCurrentEditorPath(EditorPathImpl editorPathImpl) {
        boolean bl = false;
        editorPathImpl._panePos = this.getCurrentSplitPanePos();
        if (editorPathImpl._panePos != -1) {
            SplitPaneState splitPaneState = this.getSplitPaneState(editorPathImpl._panePos);
            bl = splitPaneState.getCurrentEditorPath(editorPathImpl);
        }
        return bl;
    }

    private int getCurrentSplitPanePos() {
        return this._currentSplitPanePos;
    }

    public SplitPane getCurrentSplitPane() {
        SplitPane splitPane = null;
        if (this._currentSplitPanePos != -1) {
            splitPane = this.getSplitPane(this._currentSplitPanePos);
        }
        return splitPane;
    }

    public SplitPaneState getCurrentSplitPaneState() {
        SplitPaneState splitPaneState = null;
        if (this._currentSplitPanePos != -1) {
            splitPaneState = this.getSplitPaneState(this._currentSplitPanePos);
        }
        return splitPaneState;
    }

    public Editor getCurrentEditor() {
        Editor editor = null;
        SplitPaneState splitPaneState = this.getCurrentSplitPaneState();
        if (splitPaneState != null) {
            editor = splitPaneState.getCurrentEditor();
        }
        return editor;
    }

    public Context getContext() {
        return this._context;
    }

    void setContext(Context context) {
        if (this._context != null) {
            Node node = this._context.getNode();
            node.detach(this);
        }
        this._context = context;
        if (this._context != null) {
            Node node = this._context.getNode();
            node.attach(this);
        }
    }

    private void setEditorAddins(List list) {
        this._editorAddins = list;
        if (list != null) {
            int n = list.size();
            this._reservedEditors = new SplitPaneState[n];
        } else {
            this._reservedEditors = null;
        }
    }

    List getEditorAddins() {
        return this._editorAddins;
    }

    public boolean match(EditorCriteriaImpl editorCriteriaImpl) {
        boolean bl = false;
        switch (editorCriteriaImpl.getType()) {
            case 2: {
                bl = EditorUtil.isSameNode(editorCriteriaImpl.getContext(), this.getContext());
                break;
            }
            case 1: {
                bl = EditorUtil.isSameNode(editorCriteriaImpl.getNode(), this.getContext().getNode());
                break;
            }
            case 12: {
                bl = this.equals(editorCriteriaImpl.getCriteria1());
                break;
            }
            case 14: {
                bl = this.getNodeNumber() == editorCriteriaImpl.getAssignedKey();
            }
        }
        return bl;
    }

    public boolean searchEditor(EditorPathImpl editorPathImpl, EditorCriteriaImpl editorCriteriaImpl) {
        boolean bl = false;
        if (editorCriteriaImpl.getType() == 10) {
            Context context = editorCriteriaImpl.getContext();
            if (EditorUtil.isSameNode(context, this.getContext())) {
                bl = this.searchBestEditor(editorPathImpl, editorCriteriaImpl.getEditorClass());
            }
        } else {
            int n = this.getSplitPaneStateCount();
            int n2 = 0;
            while (!bl && n2 < n) {
                SplitPaneState splitPaneState = this.getSplitPaneState(n2);
                if (SplitPaneState.match(editorCriteriaImpl) || splitPaneState.searchEditor(editorPathImpl, editorCriteriaImpl)) {
                    editorPathImpl._panePos = n2;
                    bl = true;
                }
                ++n2;
            }
        }
        return bl;
    }

    private boolean searchBestEditor(EditorPathImpl editorPathImpl, Class clazz) {
        int n;
        boolean bl = false;
        int n2 = this.getCurrentSplitPanePos();
        SplitPaneState splitPaneState = this.getSplitPaneState(n2);
        EditorState editorState = splitPaneState.getEditorState(n = splitPaneState.getCurrentEditorStatePos());
        EditorAddin editorAddin = editorState.getEditorAddin();
        Class clazz2 = editorAddin.getEditorClass();
        if (clazz.equals(clazz2)) {
            editorPathImpl._panePos = n2;
            editorPathImpl._editorPos = n;
            bl = true;
        }
        if (!bl) {
            int n3 = this.getSplitPaneStateCount();
            int n4 = 0;
            while (!bl && n4 < n3) {
                EditorState editorState2;
                EditorAddin editorAddin2;
                Class clazz3;
                SplitPaneState splitPaneState2 = this.getSplitPaneState(n4);
                int n5 = splitPaneState2.getCurrentEditorStatePos();
                if (n5 != -1 && clazz.equals(clazz3 = (editorAddin2 = (editorState2 = splitPaneState2.getEditorState(n5)).getEditorAddin()).getEditorClass())) {
                    editorPathImpl._panePos = n4;
                    editorPathImpl._editorPos = n5;
                    bl = true;
                }
                ++n4;
            }
            if (!bl) {
                int n6 = 0;
                while (!bl && n6 < n3) {
                    SplitPaneState splitPaneState3 = this.getSplitPaneState(n6);
                    int n7 = splitPaneState3.getEditorStateCount();
                    int n8 = 0;
                    while (n8 < n7) {
                        Class<?> clazz4;
                        EditorState editorState3 = splitPaneState3.getEditorState(n8);
                        Editor editor = editorState3.getEditor();
                        if (editor != null && clazz.equals(clazz4 = editor.getClass())) {
                            editorPathImpl._panePos = n6;
                            editorPathImpl._editorPos = n8;
                            bl = true;
                        }
                        ++n8;
                    }
                    ++n6;
                }
                if (!bl) {
                    SplitPaneState splitPaneState4 = this.getSplitPaneState(n2);
                    int n9 = splitPaneState4.getEditorStateCount();
                    int n10 = 0;
                    while (n10 < n9) {
                        EditorState editorState4 = splitPaneState4.getEditorState(n10);
                        EditorAddin editorAddin3 = editorState4.getEditorAddin();
                        Class clazz5 = editorAddin3.getEditorClass();
                        if (clazz.equals(clazz5)) {
                            editorPathImpl._panePos = n2;
                            editorPathImpl._editorPos = n10;
                            bl = true;
                        }
                        ++n10;
                    }
                }
            }
        }
        return bl;
    }

    public boolean activateEditor(EditorPathImpl editorPathImpl) {
        boolean bl = false;
        int n = editorPathImpl._panePos != -1 ? editorPathImpl._panePos : this.getCurrentSplitPanePos();
        SplitPaneState splitPaneState = this.getSplitPaneState(n);
        if (splitPaneState.activateEditor(editorPathImpl)) {
            this.setCurrentSplitPanePos(n);
            bl = true;
        }
        return bl;
    }

    int getNodeNumber() {
        return this._acceleratorNo;
    }

    void setNodeNumber(int n) {
        this._acceleratorNo = n;
        Icon icon = this.getBaseIcon();
        this._icon = n >= 0 ? new AcceleratorIcon(icon, n + 1) : icon;
        this.getParentTabGroup().whenTabGroupStateChanged(this);
    }

    Icon getNodeIcon() {
        if (this._icon == null) {
            this._icon = this.getBaseIcon();
        }
        return this._icon;
    }

    private Icon getBaseIcon() {
        Context context = this.getContext();
        Node node = context.getNode();
        Icon icon = node.getIcon();
        return icon;
    }

    boolean isExplicit() {
        return this.getNodeNumber() >= 0;
    }

    private boolean hasAccelerator() {
        int n = this.getNodeNumber();
        return n >= 0 && n <= 8;
    }

    String getLongLabel() {
        String string;
        Context context = this.getContext();
        Node node = context.getNode();
        String string2 = node.getLongLabel();
        if (this.hasAccelerator()) {
            int n = this.getNodeNumber();
            EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
            String string3 = editorManagerImpl.getActivateCmdTooltip(n);
            string = string2 + " (" + string3 + ")";
        } else {
            string = string2;
        }
        return string;
    }

    public StructuredPropertyAccess getStructPersistence() {
        return this._structuredPropertyAccess;
    }

    public void setStructPersistence(StructuredPropertyAccess structuredPropertyAccess) {
        this._structuredPropertyAccess = structuredPropertyAccess;
    }

    public void closeSplitPaneState(int n) {
        SplitPaneState splitPaneState = this.getSplitPaneState(n);
        SplitPane splitPane = splitPaneState.getSplitPane();
        if (splitPane != null) {
            splitPane.setSplitPaneState(null);
        }
        splitPaneState.setCurrentEditorStatePos(-1);
        DefaultListModel defaultListModel = splitPaneState.getEditorsModel();
        int n2 = defaultListModel.getSize();
        int n3 = 0;
        while (n3 < n2) {
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)defaultListModel.get(n3);
            EditorState editorState = (EditorState)defaultCustomTabPage.getUserObject();
            if (editorState != null) {
                editorState.openEditor(null);
            }
            ++n3;
        }
        if (n <= this._currentSplitPanePos) {
            --this._currentSplitPanePos;
            if (this._currentSplitPanePos < 0 && this.getSplitPaneStateCount() > 1) {
                ++this._currentSplitPanePos;
            }
        }
        this._splitPaneStates.remove(n);
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (n == UpdateMessage.OBJECT_CLOSED) {
            this.whenObjectClosed();
        } else if (n == UpdateMessage.OBJECT_RENAMED) {
            this.whenObjectChanged();
        } else if (n == UpdateMessage.ATTRIBUTE_CHANGED) {
            this.whenAttributeChanged();
        }
    }

    private void whenObjectClosed() {
        this.getParentTabGroup().close(new TabGroupState[]{this});
    }

    private void whenAttributeChanged() {
        Editor editor;
        boolean bl;
        Context context = this.getContext();
        Node node = context.getNode();
        if (node != null && (bl = node.isDirty()) && (editor = this.getCurrentEditor()) != null) {
            EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
            editorManagerImpl.setExplicit(editor, true);
        }
        this.whenObjectChanged();
    }

    private void whenObjectChanged() {
        this.getParentTabGroup().whenTabGroupStateChanged(this);
    }

    void dispose() {
        this.setContext(null);
        this.setEditorAddins(null);
    }

    void reserveEditorStates(SplitPaneState splitPaneState, int n, boolean bl) {
        EditorState editorState = splitPaneState.getEditorState(n);
        boolean bl2 = editorState.isSplittable();
        SplitPaneState splitPaneState2 = bl && !bl2 ? splitPaneState : null;
        this.setReservedEditorState(n, splitPaneState2);
    }

    private void setReservedEditorState(int n, SplitPaneState splitPaneState) {
        SplitPaneState splitPaneState2 = this._reservedEditors[n];
        if (splitPaneState2 != splitPaneState) {
            this._reservedEditors[n] = splitPaneState;
            int n2 = this.getSplitPaneStateCount();
            int n3 = 0;
            while (n3 < n2) {
                SplitPaneState splitPaneState3 = this.getSplitPaneState(n3);
                EditorState editorState = splitPaneState3.getEditorState(n);
                boolean bl = splitPaneState == null || splitPaneState == splitPaneState3;
                editorState.setEnabled(bl);
                ++n3;
            }
        }
    }

    SplitPaneState getReservedEditorState(int n) {
        return this._reservedEditors[n];
    }

    public void whenCurrentEditorChanges(SplitPaneState splitPaneState) {
        TabGroup tabGroup = this.getParentTabGroup();
        if (tabGroup != null) {
            tabGroup.whenCurrentEditorChanges(this);
        }
    }

    public void whenEditorActivated(SplitPaneState splitPaneState) {
        SplitPaneState splitPaneState2;
        int n = this.getCurrentSplitPanePos();
        SplitPaneState splitPaneState3 = splitPaneState2 = n == -1 ? null : this.getSplitPaneState(n);
        if (splitPaneState2 != splitPaneState) {
            int n2 = this.indexOf(splitPaneState);
            this.setCurrentSplitPanePos(n2);
        }
        this.getParentTabGroup().whenEditorActivated(this);
    }

    void dump(String string, boolean bl) {
        Node node;
        Context context = this.getContext();
        String string2 = context != null ? ((node = context.getNode()) != null ? node.getShortLabel() : "node = null") : "context = null";
        System.out.println(string + "TabGroupState" + (bl ? "*" : "") + " - " + string2);
        int n = this.getSplitPaneStateCount();
        int n2 = 0;
        while (n2 < n) {
            SplitPaneState splitPaneState = this.getSplitPaneState(n2);
            boolean bl2 = n2 == this._currentSplitPanePos;
            splitPaneState.dump(string + "  ", bl2);
            ++n2;
        }
    }

    EditorAddin findBestDuplicatedEditor(EditorAddin editorAddin) {
        EditorAddin editorAddin2 = null;
        if (editorAddin.isDuplicable()) {
            editorAddin2 = editorAddin;
        } else {
            Node node;
            EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
            EditorAddin editorAddin3 = editorManagerImpl.getDefaultAddin(node = this.getContext().getNode());
            if (this.isGoodDuplicatedEditor(editorAddin3)) {
                editorAddin2 = editorAddin3;
            } else {
                List list = editorManagerImpl.getAddins(node);
                int n = 0;
                while (editorAddin2 == null && n < list.size()) {
                    EditorAddin editorAddin4 = (EditorAddin)list.get(n);
                    if (this.isGoodDuplicatedEditor(editorAddin4)) {
                        editorAddin2 = editorAddin4;
                    }
                    ++n;
                }
            }
        }
        return editorAddin2;
    }

    private boolean isGoodDuplicatedEditor(EditorAddin editorAddin) {
        int n = 0;
        while (n < this._reservedEditors.length) {
            EditorState editorState;
            EditorAddin editorAddin2;
            SplitPaneState splitPaneState = this._reservedEditors[n];
            if (splitPaneState != null && editorAddin.equals(editorAddin2 = (editorState = splitPaneState.getCurrentEditorState()).getEditorAddin())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void focusCurrentEditor() {
        SplitPane splitPane = this.getCurrentSplitPane();
        if (splitPane != null) {
            splitPane.focusCurrentEditor();
        }
    }

    public void handleEvent(int n) {
        if (n == EditorManagerImpl.NEXT_PANE_CMD_ID || n == EditorManagerImpl.PREV_PANE_CMD_ID) {
            int n2 = this.getCurrentSplitPanePos();
            int n3 = n == EditorManagerImpl.NEXT_PANE_CMD_ID ? n2 + 1 : n2 - 1;
            this.setCurrentSplitPanePos(n3);
            SplitPane splitPane = this.getSplitPane(n3);
            splitPane.focusCurrentEditor();
        }
    }

    boolean canDo(IdeAction ideAction) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (n == EditorManagerImpl.NEXT_PANE_CMD_ID) {
            int n2;
            int n3 = this.getCurrentSplitPanePos();
            bl = n3 + 1 < (n2 = this.getSplitPaneStateCount());
        } else if (n == EditorManagerImpl.PREV_PANE_CMD_ID) {
            int n4 = this.getCurrentSplitPanePos();
            bl = n4 > 0;
        }
        return bl;
    }

    boolean isRestorableAtStartup() {
        int n = 0;
        while (n < this.getSplitPaneStateCount()) {
            SplitPaneState splitPaneState = this.getSplitPaneState(n);
            boolean bl = splitPaneState.isRestorableAtStartup();
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean saveStateInfo(StructuredPropertyAccess structuredPropertyAccess) {
        boolean bl = false;
        Context context = this.getContext();
        EditorUtil.saveContext(context, structuredPropertyAccess);
        int n = this.getNodeNumber();
        structuredPropertyAccess.setProperty("accelerator", Integer.toString(n));
        int n2 = this.getSplitPaneStateCount();
        int n3 = 0;
        while (n3 < n2) {
            DefaultStructuredPropertyAccess defaultStructuredPropertyAccess;
            SplitPaneState splitPaneState = this.getSplitPaneState(n3);
            if (splitPaneState.saveStateInfo(defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess("paneState"))) {
                structuredPropertyAccess.appendChild(defaultStructuredPropertyAccess);
                bl = true;
            }
            ++n3;
        }
        StructuredPropertyAccess structuredPropertyAccess2 = this.getStructPersistence();
        if (structuredPropertyAccess2 != null) {
            structuredPropertyAccess.appendChild(structuredPropertyAccess2);
        }
        return bl;
    }

    boolean loadStateInfo(StructuredPropertyAccess structuredPropertyAccess) {
        StructuredPropertyAccess structuredPropertyAccess2;
        boolean bl = false;
        Context context = EditorUtil.loadContext(structuredPropertyAccess);
        if (context != null) {
            this.setContext(context);
            EditorManagerImpl editorManagerImpl = EditorManagerImpl.getInstance();
            Node node = context.getNode();
            List list = editorManagerImpl.getAddins(node);
            this.setEditorAddins(list);
            if (!list.isEmpty()) {
                int n;
                Iterator iterator = structuredPropertyAccess.getChildNodes("paneState");
                while (iterator.hasNext()) {
                    SplitPaneState splitPaneState = new SplitPaneState(this);
                    StructuredPropertyAccess structuredPropertyAccess3 = (StructuredPropertyAccess)iterator.next();
                    if (!splitPaneState.loadStateInfo(structuredPropertyAccess3)) continue;
                    this.addSplitPaneState(splitPaneState);
                    bl = true;
                }
                String string = structuredPropertyAccess.getProperty("accelerator", null);
                if (string != null && (n = Integer.parseInt(string)) >= 0 && n < 9) {
                    this.setNodeNumber(n);
                }
            }
        }
        if ((structuredPropertyAccess2 = structuredPropertyAccess.getChildNode("pane")) != null) {
            this.setStructPersistence(structuredPropertyAccess2);
        }
        return bl;
    }
}

