/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.explorer.CellRendererAttributes;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayTreeCellRenderer;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.resource.ExplorerArb;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ideimpl.ProfileIDs;
import oracle.ideimpl.explorer.CustomTree;
import oracle.ideimpl.explorer.CustomTreeKeyNavigation;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.ideimpl.explorer.NodeUpdateListener;
import oracle.ideimpl.explorer.dnd.DragDropListener;
import oracle.ideimpl.explorer.dnd.JTreeDragHandler;
import oracle.ideimpl.explorer.dnd.JTreeDropHandler;
import oracle.javatools.dnd.DndUtils;

public class BaseTreeExplorer
extends TreeExplorer
implements DragDropListener,
IdeListener,
FocusListener,
ActionListener,
MouseListener,
KeyListener,
TreeExpansionListener,
TreeSelectionListener,
NodeUpdateListener {
    protected CustomTree tree;
    private final JScrollPane _gui;
    private Comparator _comparator;
    private IconOverlayCache _overlayCache;
    private Map _filterCache;
    private KeyNavigationManager _keyMgr;
    private WeakReference _lastActiveNodeWeakRef;
    private CellRendererAttributes _attributes;
    private final Timer _timer;
    private static final String FILTER_PROP = "filter";
    private static final String KEY_PROP = ".key";
    private static final String FILTER_CLS_PROP = ".filterCls";
    private static final String FILTER_OPTS_PROP = ".options";
    private static final String DISABLE_EXPLORER_DRAG_AND_DROP_PROP = "TreeExplorer.DisableDragAndDrop";
    private final ArrayList _updates;

    void $init$() {
        this._gui = new JScrollPane();
        this._filterCache = new HashMap();
        this._updates = new ArrayList();
    }

    public BaseTreeExplorer() {
        this.$init$();
        this._gui.setBorder(BorderFactory.createEmptyBorder());
        if (this.coalesceObserverUpdates()) {
            this._timer = new Timer(200, new 4());
            this._timer.setRepeats(false);
        } else {
            this._timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cacheFilter(TNode tNode, ChildFilter childFilter) {
        if (childFilter != null) {
            String string = this.buildPathKey(tNode);
            Map map = this._filterCache;
            synchronized (map) {
                this._filterCache.put(string, new FilterInfo(childFilter));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ChildFilter findCacheFilter(TNode tNode) {
        FilterInfo filterInfo;
        String string = this.buildPathKey(tNode);
        Map map = this._filterCache;
        synchronized (map) {
            filterInfo = (FilterInfo)this._filterCache.get(string);
        }
        return filterInfo != null ? filterInfo.getFilter() : null;
    }

    public final TNode createTNode(Element element) {
        ExplorerNode explorerNode = new ExplorerNode(element);
        this.checkLeafState(explorerNode);
        explorerNode.addNodeUpdateListener(this);
        return explorerNode;
    }

    public final TNode findTNode(Element element, TNode tNode) {
        return this.findNodeDepthFirst(element, tNode, true);
    }

    public final TNode findTNodeBreadthFirst(Element element, TNode tNode) {
        return this.findNodeBreadthFirst(element, tNode, true);
    }

    public final TNode searchTNode(Element element, TNode tNode) {
        return this.findNodeDepthFirst(element, tNode, false);
    }

    public final TNode searchTNodeBreadthFirst(Element element, TNode tNode) {
        return this.findNodeBreadthFirst(element, tNode, false);
    }

    public final void expand(TNode tNode, boolean bl) {
        ExplorerNode explorerNode = (ExplorerNode)tNode;
        if (explorerNode == null || explorerNode.isLeaf()) {
            return;
        }
        TreePath treePath = new TreePath(explorerNode.getPath());
        if (this.tree.isCollapsed(treePath)) {
            this.open(explorerNode);
            this.tree.expandPath(treePath);
            this.setSelected(explorerNode);
        }
        if (bl) {
            Enumeration enumeration = explorerNode.children();
            while (enumeration.hasMoreElements()) {
                this.expand((TNode)enumeration.nextElement(), bl);
            }
        }
    }

    public final void refresh(TNode tNode) {
        this.refreshImpl(tNode, tNode);
    }

    public final void refresh(TNode tNode, Class clazz) {
        TNode tNode2 = tNode.getAncestorTNode(clazz, true);
        this.refreshImpl(tNode2, tNode);
    }

    public final void collapse(TNode tNode, boolean bl) {
        if (!tNode.isLeaf()) {
            TreePath treePath = new TreePath(tNode.getPath());
            if (this.tree.isExpanded(treePath)) {
                this.tree.collapsePath(treePath);
            }
            if (bl) {
                this.dropNodeSubtree((ExplorerNode)tNode);
            }
        }
    }

    public void addChildren(TNode tNode) {
        ExplorerNode explorerNode;
        ExplorerNode explorerNode2;
        int n = 0;
        if (ProfileIDs.PROFILE_ADDCHILDREN) {
            n = IdeProfile.startEvent(3310);
        }
        if ((explorerNode2 = (ExplorerNode)tNode) == null || explorerNode2.isSet(TNodeConstants.IS_OPENED)) {
            if (ProfileIDs.PROFILE_ADDCHILDREN) {
                IdeProfile.endEvent(n);
            }
            return;
        }
        if (explorerNode2.getChildCount() > 0) {
            explorerNode2.removeAllChildren();
        }
        Iterator iterator = null;
        ChildFilter childFilter = explorerNode2.getChildFilter();
        iterator = childFilter != null ? childFilter.getChildren() : explorerNode2.getChildNodes();
        if (iterator == null) {
            if (ProfileIDs.PROFILE_ADDCHILDREN) {
                IdeProfile.endEvent(n);
            }
            return;
        }
        if (childFilter == null && (explorerNode = (ExplorerNode)explorerNode2.getParent()) != null) {
            childFilter = explorerNode.findChildFilter();
        }
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            ExplorerNode explorerNode3 = (ExplorerNode)this.createTNode(element);
            explorerNode2.add(explorerNode3);
            if (childFilter == null) continue;
            childFilter.cache(explorerNode3);
        }
        explorerNode2.setBit(TNodeConstants.IS_OPENED);
        if (ProfileIDs.PROFILE_ADDCHILDREN) {
            IdeProfile.endEvent(n);
        }
    }

    public final JTree getJTree() {
        return this.getTree(null);
    }

    public final DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.tree.getModel();
    }

    public final void nodeChanged(TNode tNode) {
        if (tNode == null) {
            return;
        }
        DefaultTreeModel defaultTreeModel = this.getTreeModel();
        if (defaultTreeModel != null) {
            defaultTreeModel.nodeChanged(tNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveFilters(PropertyAccess propertyAccess) {
        Map map = this._filterCache;
        synchronized (map) {
            int n = this._filterCache.size();
            if (n == 0) {
                return;
            }
            String string = FILTER_PROP;
            propertyAccess.setProperty(string, Integer.toString(n));
            int n2 = 0;
            for (Map.Entry entry : this._filterCache.entrySet()) {
                String string2 = (String)entry.getKey();
                if (string2 == null) continue;
                FilterInfo filterInfo = (FilterInfo)entry.getValue();
                String string3 = null;
                int n3 = 0;
                if (filterInfo != null) {
                    string3 = filterInfo.getClassName();
                    n3 = filterInfo.getOptions();
                }
                string = new StringBuffer().append(FILTER_PROP).append(n2).append(KEY_PROP).toString();
                propertyAccess.setProperty(string, string2);
                string = new StringBuffer().append(FILTER_PROP).append(n2).append(FILTER_CLS_PROP).toString();
                propertyAccess.setProperty(string, string3);
                if (n3 != -1) {
                    string = new StringBuffer().append(FILTER_PROP).append(n2).append(FILTER_OPTS_PROP).toString();
                    propertyAccess.setProperty(string, Integer.toString(n3));
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void openFilters(PropertyAccess propertyAccess) {
        Element element;
        String string = FILTER_PROP;
        int n = Integer.parseInt(propertyAccess.getProperty(string, "0"));
        if (n == 0) {
            return;
        }
        Map map = this._filterCache;
        synchronized (map) {
            int n2 = 0;
            while (n2 < n) {
                string = new StringBuffer().append(FILTER_PROP).append(n2).append(KEY_PROP).toString();
                String string2 = propertyAccess.getProperty(string, null);
                string = new StringBuffer().append(FILTER_PROP).append(n2).append(FILTER_CLS_PROP).toString();
                String string3 = propertyAccess.getProperty(string, null);
                if (string2 != null && string3 != null) {
                    string = new StringBuffer().append(FILTER_PROP).append(n2).append(FILTER_OPTS_PROP).toString();
                    String string4 = propertyAccess.getProperty(string, null);
                    int n3 = string4 != null ? Integer.parseInt(string4) : 0;
                    FilterInfo filterInfo = (FilterInfo)this._filterCache.get(string2);
                    if (filterInfo == null || !filterInfo.getClassName().equals(string3) || filterInfo.getOptions() != n3) {
                        this._filterCache.put(string2, new FilterInfo(string3, n3));
                    }
                }
                ++n2;
            }
        }
        ExplorerNode explorerNode = (ExplorerNode)this.getRoot();
        if (explorerNode != null && explorerNode.getFilter() != this.findCacheFilter(explorerNode) && (element = explorerNode.getData()) != null) {
            this.setRoot(element);
            this.collapse(this.getRoot(), false);
        }
    }

    private void renameFilters(TNode tNode, TNode tNode2, UpdateMessage updateMessage) {
        TreePath treePath;
        if (tNode2.getParent() == null) {
            TreePath treePath2 = new TreePath(tNode.getPath());
            treePath = treePath2.pathByAddingChild(tNode2);
        } else {
            treePath = new TreePath(tNode2.getPath());
        }
        String string = this.buildPathKey(treePath);
        if (RenameMessage.isPreRenameMessage(updateMessage)) {
            HashMap hashMap = new HashMap();
            this._filterCache.put(null, hashMap);
            int n = string.length();
            Iterator iterator = this._filterCache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getKey();
                if (string2 == null || !string2.startsWith(string)) continue;
                iterator.remove();
                string2 = string2.substring(n);
                hashMap.put(string2, entry.getValue());
            }
        } else {
            Map map = (Map)this._filterCache.remove(null);
            if (map == null) {
                return;
            }
            for (Map.Entry entry : map.entrySet()) {
                String string3 = (String)entry.getKey();
                FilterInfo filterInfo = (FilterInfo)entry.getValue();
                ChildFilter childFilter = filterInfo.getFilter();
                if (childFilter == null) continue;
                this._filterCache.put(string + string3, new FilterInfo(childFilter));
                if (string3.length() != 0) continue;
                tNode2.setChildFilter(childFilter);
                childFilter.setOwner(tNode2);
                childFilter.refresh(null);
            }
            map.clear();
        }
    }

    public final Comparator getComparator() {
        return this._comparator;
    }

    public final void setComparator(Comparator comparator) {
        if (!ModelUtil.areEqual((Object)comparator, (Object)this._comparator)) {
            this._comparator = comparator;
            TNode tNode = this.getRoot();
            if (tNode != null) {
                Element element = tNode.getData();
                this.setRoot(element);
            }
        }
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.getTree(context);
    }

    public final Context getContext(EventObject eventObject) {
        this.tryForceUpdateImpl();
        Context context = super.getContext(eventObject);
        TreePath[] treePathArray = this.getTree(null).getSelectionPaths();
        TNode[] tNodeArray = new TNode[treePathArray != null ? treePathArray.length : 0];
        int n = 0;
        while (n < tNodeArray.length) {
            tNodeArray[n] = (TNode)treePathArray[n].getLastPathComponent();
            ++n;
        }
        Workspace workspace = tNodeArray.length > 0 ? (Workspace)tNodeArray[tNodeArray.length - 1].getAncestor(Workspace.class, true) : null;
        Project project = tNodeArray.length > 0 ? (Project)tNodeArray[tNodeArray.length - 1].getAncestor(Project.class, true) : null;
        context.setWorkspace(workspace != null ? workspace : this.defaultWorkspace);
        context.setProject(project != null ? project : this.defaultProject);
        ExplorerContext.setTNodes(context, tNodeArray);
        this.initializeContextNode(context, tNodeArray);
        return context;
    }

    public final Component getGUI() {
        return this._gui;
    }

    public final void setSelected(TNode tNode) {
        if (tNode == null) {
            return;
        }
        TreePath treePath = new TreePath(tNode.getPath());
        this.tree.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
    }

    public final void setSelected(TNode[] tNodeArray) {
        if (tNodeArray == null) {
            return;
        }
        TreePath[] treePathArray = new TreePath[tNodeArray.length];
        int n = 0;
        while (n < tNodeArray.length) {
            treePathArray[n] = new TreePath(tNodeArray[n].getPath());
            ++n;
        }
        this.tree.setSelectionPaths(treePathArray);
    }

    public final void updateTitle(Object object) {
        if (this.owner() == null) {
            return;
        }
        this.owner().updateTitle(object);
    }

    public final TNode removeChild(TNode tNode, DefaultTreeModel defaultTreeModel) {
        ExplorerNode explorerNode = (ExplorerNode)tNode;
        explorerNode.removeNodeUpdateListener(this);
        ExplorerNode explorerNode2 = BaseTreeExplorer.getClosestTNode(explorerNode);
        defaultTreeModel.removeNodeFromParent(explorerNode);
        return explorerNode2;
    }

    private TNode removeChildren(TNode tNode, List list, DefaultTreeModel defaultTreeModel) {
        ArrayList<TNode> arrayList = new ArrayList<TNode>(list.size());
        Enumeration<? extends TreeNode> enumeration = tNode.children();
        while (enumeration.hasMoreElements()) {
            TNode tNode2 = (TNode)enumeration.nextElement();
            if (!list.contains(tNode2.getData())) continue;
            arrayList.add(tNode2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        int n = arrayList.size();
        MutableTreeNode[] mutableTreeNodeArray = arrayList.toArray(new ExplorerNode[n]);
        int n2 = 0;
        while (n2 < n) {
            ExplorerNode explorerNode = mutableTreeNodeArray[n2];
            explorerNode.removeNodeUpdateListener(this);
            ++n2;
        }
        ExplorerNode explorerNode = BaseTreeExplorer.getClosestTNode(mutableTreeNodeArray[n - 1]);
        TreeExplorerModel.mav$removeNodesFromParent((TreeExplorerModel)defaultTreeModel, (MutableTreeNode)((Object)tNode), mutableTreeNodeArray);
        return explorerNode;
    }

    public final TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, DefaultTreeModel defaultTreeModel, ChildFilter childFilter) {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        this.tree.clearSelection();
        TNode tNode2 = childFilter == null ? this.removeChildren(tNode, updateMessage.getRemoveObjects(), defaultTreeModel) : childFilter.childrenRemoved(updateMessage, tNode, this);
        if (treePathArray != null && treePathArray.length > 0) {
            int n = 0;
            while (n < treePathArray.length) {
                TreePath treePath = treePathArray[n];
                TNode tNode3 = (TNode)treePath.getLastPathComponent();
                if (tNode.getIndex(tNode3) != -1) {
                    this.tree.addSelectionPath(treePath);
                }
                ++n;
            }
        }
        if (tNode2 != null && this.tree.isSelectionEmpty()) {
            this.setSelected(tNode2);
        }
        return tNode2;
    }

    public final TNode addChild(Element element, TNode tNode, DefaultTreeModel defaultTreeModel) {
        return this.addChild(element, tNode.getChildCount(), tNode, defaultTreeModel);
    }

    private TNode addChild(Element element, int n, TNode tNode, DefaultTreeModel defaultTreeModel) {
        ExplorerNode explorerNode = (ExplorerNode)this.createTNode(element);
        defaultTreeModel.insertNodeInto(explorerNode, (ExplorerNode)tNode, n);
        return explorerNode;
    }

    public final TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, DefaultTreeModel defaultTreeModel, ChildFilter childFilter, boolean bl) {
        if (this.isHideChildren(tNode)) {
            return null;
        }
        TNode tNode2 = this.open(tNode) ? tNode : null;
        List list = updateMessage.getAddObjects();
        if (childFilter == null) {
            ArrayList arrayList = new ArrayList(list);
            Enumeration<? extends TreeNode> enumeration = tNode.children();
            while (enumeration.hasMoreElements()) {
                tNode2 = (TNode)enumeration.nextElement();
                Element element = tNode2.getData();
                if (!arrayList.contains(element)) continue;
                arrayList.remove(element);
            }
            for (Element element : arrayList) {
                tNode2 = this.addChild(element, tNode, defaultTreeModel);
            }
            arrayList.clear();
        } else {
            tNode2 = childFilter.childrenAdded(updateMessage, tNode, this);
        }
        if (bl && tNode2 != null && this.isViewActive()) {
            TreePath treePath = new TreePath(tNode2.getPath());
            this.tree.scrollPathToVisible(treePath);
            this.tree.setSelectionRow(this.tree.getRowForPath(treePath));
            if (tNode2 == tNode && !tNode2.isLeaf()) {
                this.tree.expandPath(treePath);
            }
        }
        return tNode2;
    }

    public final boolean open(TNode tNode) {
        if (tNode.isSet(TNodeConstants.IS_OPENED)) {
            return false;
        }
        this.addChildren(tNode);
        DefaultTreeModel defaultTreeModel = this.getTreeModel();
        if (defaultTreeModel != null) {
            defaultTreeModel.reload(tNode);
        }
        return true;
    }

    public final boolean updateActiveNode(TNode tNode) {
        ExplorerNode explorerNode;
        if (tNode == null) {
            return false;
        }
        if (this._lastActiveNodeWeakRef != null && (explorerNode = (ExplorerNode)this._lastActiveNodeWeakRef.get()) != null) {
            if (explorerNode == tNode) {
                return false;
            }
            explorerNode.unsetBit(ElementAttributes.ACTIVE);
            this.nodeChanged(explorerNode);
        }
        this._lastActiveNodeWeakRef = new WeakReference<TNode>(tNode);
        tNode.setBit(ElementAttributes.ACTIVE);
        this.nodeChanged(tNode);
        return true;
    }

    public final TNode getRoot() {
        TreeModel treeModel = this.tree.getModel();
        return treeModel != null ? (TNode)treeModel.getRoot() : null;
    }

    public final void setRootElement(Element element) {
        if (element != null) {
            this.setContext(Context.newIdeContext(element));
        }
    }

    public final Attributes getCellRendererAttributes() {
        if (this._attributes == null) {
            this._attributes = new CellRendererAttributes();
        }
        return this._attributes;
    }

    private static boolean refreshNodes(TNode[] tNodeArray, boolean bl) {
        boolean bl2 = false;
        if (tNodeArray != null && tNodeArray.length > 0) {
            boolean bl3 = false;
            int n = 0;
            while (n < tNodeArray.length) {
                ChildFilter childFilter;
                TNode tNode = tNodeArray[n];
                if ((bl || tNode.isSet(TNodeConstants.IS_OPENED)) && (childFilter = tNode.findChildFilter()) != null && tNode != childFilter.getOwner()) {
                    if (BaseTreeExplorer.refreshAncestor(tNode, bl)) {
                        bl2 = true;
                    }
                    bl3 = true;
                    if (!childFilter.canRefresh(tNodeArray)) break;
                    bl2 = true;
                    if (!bl) break;
                    childFilter.refresh(tNodeArray);
                    break;
                }
                ++n;
            }
            if (!bl3 && BaseTreeExplorer.refreshAncestor(tNodeArray[0], bl)) {
                bl2 = true;
            }
            int n2 = 0;
            while (n2 < tNodeArray.length) {
                ChildFilter childFilter;
                TNode tNode = tNodeArray[n2];
                if ((bl || tNode.isSet(TNodeConstants.IS_OPENED)) && (childFilter = tNode.findChildFilter()) != null && tNode == childFilter.getOwner() && childFilter.canRefresh(tNodeArray)) {
                    bl2 = true;
                    if (bl) {
                        childFilter.refresh(tNodeArray);
                    }
                }
                ++n2;
            }
        }
        return bl2;
    }

    public final boolean canRefresh(TNode tNode, Class clazz) {
        TNode tNode2 = tNode.getAncestorTNode(clazz, true);
        if (tNode2 == null || tNode2.isLeaf()) {
            TNode[] tNodeArray = new TNode[]{tNode};
            return BaseTreeExplorer.refreshNodes(tNodeArray, false);
        }
        if (!tNode2.isSet(TNodeConstants.IS_OPENED)) {
            return false;
        }
        ChildFilter childFilter = tNode2.findChildFilter();
        TNode[] tNodeArray = new TNode[]{tNode2};
        return childFilter != null && tNode2 == childFilter.getOwner() && childFilter.canRefresh(tNodeArray);
    }

    private static boolean refreshAncestor(TNode tNode, boolean bl) {
        ChildFilter childFilter;
        TNode tNode2;
        boolean bl2 = false;
        if (tNode != null && (tNode2 = (TNode)tNode.getParent()) != null && (childFilter = tNode2.findChildFilter()) != null) {
            TNode[] tNodeArray;
            if (BaseTreeExplorer.refreshAncestor(childFilter.getOwner(), bl)) {
                bl2 = true;
            }
            if (childFilter.canRefresh(tNodeArray = new TNode[]{tNode})) {
                if (bl) {
                    childFilter.refresh(tNodeArray);
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    public final IconOverlayCache getOverlayCache() {
        return this._overlayCache;
    }

    public final void setOverlayCache(IconOverlayCache iconOverlayCache) {
        this._overlayCache = iconOverlayCache;
    }

    public final Element getElement(Object object) {
        return ((TNode)object).getData();
    }

    protected void nodeExpanded(TNode tNode, boolean bl) {
    }

    protected boolean coalesceObserverUpdates() {
        return true;
    }

    protected void initializeContextNode(Context context, TNode[] tNodeArray) {
        switch (tNodeArray.length) {
            case 0: {
                context.setNode(this.defaultNode);
                break;
            }
            case 1: {
                Node node = (Node)tNodeArray[0].getAncestor(Node.class, true);
                context.setNode(node != null ? node : this.defaultNode);
                break;
            }
            default: {
                TNode tNode = tNodeArray[0];
                if (tNode.getData() instanceof Node) {
                    context.setNode(null);
                    break;
                }
                Node node = (Node)tNode.getAncestor(Node.class, true);
                context.setNode(node != null ? node : this.defaultNode);
            }
        }
    }

    protected Element[] getSelectionFromUI() {
        TreePath[] treePathArray = this.getTree(null).getSelectionPaths();
        Element[] elementArray = new Element[treePathArray != null ? treePathArray.length : 0];
        int n = elementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TNode tNode = (TNode)treePathArray[n2].getLastPathComponent();
            elementArray[n2] = tNode.getData();
            ++n2;
        }
        return elementArray;
    }

    protected synchronized CustomTree getTree(Context context) {
        if (this.tree == null) {
            this.tree = this.createCustomTree();
            this.tree.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.tree.setCellRendererAttributes(this.getCellRendererAttributes());
            this.installTreeKeyManager();
            if (context != null) {
                this.setRoot(this.annotate(context));
            }
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.setScrollsOnExpand(true);
            this.tree.addTreeSelectionListener(this);
            this.tree.addTreeExpansionListener(this);
            this.tree.setPreMouseListener(this);
            this.tree.addFocusListener(this);
            this.tree.getActionMap().put(new Integer(20), IdeAction.get(20, "oracle.ide.cmd.DeleteTNodeCommand", ExplorerArb.getString(3)));
            if (Ide.isStarting()) {
                Ide.addIdeListener(this);
            } else {
                this.createDragDropSupportIfEnabled();
            }
            this._gui.setViewportView(this.tree);
        } else if (context != null) {
            TNode tNode = this.getRoot();
            Element element = tNode != null ? tNode.getData() : null;
            Element element2 = this.annotate(context);
            if (element2 == null || element2 != element && !element2.equals(element)) {
                this.setRoot(element2);
            }
        }
        return this.tree;
    }

    protected void createDragSource() {
        new JTreeDragHandler(this.tree, 3, this);
    }

    protected void createDropTarget() {
        new JTreeDropHandler(this.tree, 3);
    }

    protected Element annotate(Context context) {
        return context != null ? context.getElement() : null;
    }

    protected final void setRoot(Element element) {
        ExplorerNode explorerNode = (ExplorerNode)this.getRoot();
        if (explorerNode != null) {
            this.dropNodeSubtree(explorerNode);
            explorerNode.setOwner(null);
            explorerNode.removeNodeUpdateListener(this);
        }
        explorerNode = new ExplorerNode(element);
        explorerNode.setOwner(this);
        explorerNode.addNodeUpdateListener(this);
        this.addChildren(explorerNode);
        this.tree.setModel(new TreeExplorerModel(explorerNode, null));
    }

    private void refreshImpl(TNode tNode, TNode tNode2) {
        if (tNode == null || tNode.isLeaf()) {
            if (tNode2 != null) {
                TNode[] tNodeArray = new TNode[]{tNode2};
                BaseTreeExplorer.refreshNodes(tNodeArray, true);
            }
        } else if (tNode.isSet(TNodeConstants.IS_OPENED)) {
            List list = ExplorerContext.storeExpansionState(tNode, this);
            this.releaseFilters(tNode, false);
            this.collapse(tNode, true);
            ExplorerContext.restoreExpansionState(tNode, this, list);
        }
    }

    private TNode findNodeBreadthFirst(Element element, TNode tNode, boolean bl) {
        if (EventQueue.isDispatchThread()) {
            this.updateImpl();
        }
        if (tNode == null) {
            tNode = this.getRoot();
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<TNode> arrayList2 = new ArrayList<TNode>();
        arrayList2.add(tNode);
        TNode tNode2 = null;
        while ((tNode2 = this.findNodeBreadthFirst(element, arrayList2, bl, arrayList)) == null) {
            if (arrayList.size() == 0) {
                return null;
            }
            arrayList2.clear();
            arrayList2.addAll(arrayList);
            arrayList.clear();
        }
        return tNode2;
    }

    private TNode findNodeDepthFirst(Element element, TNode tNode, boolean bl) {
        if (EventQueue.isDispatchThread()) {
            this.updateImpl();
        }
        if (tNode == null) {
            tNode = this.getRoot();
        }
        if (tNode.getData() == element) {
            return tNode;
        }
        if (tNode.isLeaf()) {
            return null;
        }
        if (!(tNode.isSet(TNodeConstants.IS_OPENED) || bl && this.open(tNode))) {
            return null;
        }
        Enumeration<? extends TreeNode> enumeration = tNode.children();
        TNode tNode2 = null;
        while (enumeration.hasMoreElements()) {
            TNode tNode3 = (TNode)enumeration.nextElement();
            tNode2 = this.findNodeDepthFirst(element, tNode3, bl);
            if (tNode2 != null) break;
        }
        return tNode2;
    }

    private String buildPathKey(TreePath treePath) {
        int n = treePath.getPathCount();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            Element element = ((TNode)treePath.getPathComponent(n2)).getData();
            String string = element.getLongLabel();
            stringBuffer.append(ModelUtil.hasLength((String)string) ? string : " ");
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void installTreeKeyManager() {
        CustomTreeKeyNavigation customTreeKeyNavigation = new CustomTreeKeyNavigation(this.tree);
        this._keyMgr = new KeyNavigationManager(customTreeKeyNavigation);
        this.tree.setPreKeyListener(new 3());
        this.tree.setPostKeyListener(this);
    }

    private CustomTree createCustomTree() {
        CustomTree customTree = new CustomTree();
        if (this._overlayCache != null) {
            customTree.setCellRenderer(new IconOverlayTreeCellRenderer(this, (DefaultTreeCellRenderer)customTree.getCellRenderer()));
        }
        return customTree;
    }

    public void addinsLoaded(IdeEvent ideEvent) {
    }

    public void mainWindowClosing(IdeEvent ideEvent) {
    }

    public void mainWindowOpened(IdeEvent ideEvent) {
        this.createDragDropSupportIfEnabled();
        Ide.removeIdeListener(this);
    }

    private void createDragDropSupportIfEnabled() {
        if (!Ide.getIdeProperties().isPropertySet(DISABLE_EXPLORER_DRAG_AND_DROP_PROP, Boolean.toString(true), Boolean.toString(false))) {
            this.createDragSource();
            this.createDropTarget();
        }
    }

    public void dispose() {
        ExplorerNode explorerNode = (ExplorerNode)this.getRoot();
        if (explorerNode != null) {
            explorerNode.removeNodeUpdateListener(this);
            if (explorerNode.getChildCount() > 0) {
                Enumeration<TreeNode> enumeration = explorerNode.breadthFirstEnumeration();
                enumeration.nextElement();
                while (enumeration.hasMoreElements()) {
                    ExplorerNode explorerNode2 = (ExplorerNode)enumeration.nextElement();
                    explorerNode2.removeNodeUpdateListener(this);
                }
            }
        }
    }

    private static final ExplorerNode getClosestTNode(ExplorerNode explorerNode) {
        TreeNode treeNode = explorerNode.getNextSibling();
        if (treeNode == null && (treeNode = explorerNode.getPreviousSibling()) == null && (treeNode = explorerNode.getParent()) == null) {
            treeNode = explorerNode.getNextNode();
        }
        return (ExplorerNode)treeNode;
    }

    private void fireDefaultAction(InputEvent inputEvent) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu == null) {
            return;
        }
        View view = this.owner();
        Context context = view != null ? view.getContext(inputEvent) : this.getContext();
        TNode[] tNodeArray = ExplorerContext.getTNodes(context);
        if (tNodeArray != null && tNodeArray.length > 0 && contextMenu.fireDefaultAction(context)) {
            inputEvent.consume();
        }
    }

    private String buildPathKey(TNode tNode) {
        TreePath treePath = new TreePath(tNode.getPath());
        return this.buildPathKey(treePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseFilters(TNode tNode, boolean bl) {
        if (tNode.isLeaf()) {
            return;
        }
        String string = this.buildPathKey(tNode);
        Map map = this._filterCache;
        synchronized (map) {
            FilterInfo filterInfo = (FilterInfo)this._filterCache.get(string);
            if (filterInfo != null) {
                tNode.setChildFilter(null);
                filterInfo.releaseFilter();
            }
        }
        if (bl && tNode.isSet(TNodeConstants.IS_OPENED)) {
            Enumeration<? extends TreeNode> enumeration = tNode.children();
            while (enumeration.hasMoreElements()) {
                this.releaseFilters((TNode)enumeration.nextElement(), true);
            }
        }
    }

    private boolean isViewActive() {
        return this.owner() != null && this.owner() == Ide.getMainWindow().getLastActiveView();
    }

    private TNode findNodeBreadthFirst(Element element, List list, boolean bl, List list2) {
        for (TNode tNode : list) {
            if (element == tNode.getData()) {
                return tNode;
            }
            if (tNode.isLeaf() || !tNode.isSet(TNodeConstants.IS_OPENED) && (!bl || !this.open(tNode))) continue;
            Enumeration<? extends TreeNode> enumeration = tNode.children();
            while (enumeration.hasMoreElements()) {
                list2.add(enumeration.nextElement());
            }
        }
        return null;
    }

    private void dropNodeSubtree(ExplorerNode explorerNode) {
        ChildFilter childFilter = explorerNode.getFilter();
        if (childFilter != null) {
            childFilter.uncache(explorerNode);
        }
        if (explorerNode.getChildCount() > 0) {
            Enumeration<TreeNode> enumeration = explorerNode.breadthFirstEnumeration();
            enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                ExplorerNode explorerNode2 = (ExplorerNode)enumeration.nextElement();
                explorerNode2.removeNodeUpdateListener(this);
                this.releaseFilters(explorerNode2, false);
                if (childFilter == null) continue;
                childFilter.uncache(explorerNode2);
            }
            explorerNode.removeAllChildren();
            this.collapse(explorerNode, false);
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(explorerNode);
        }
        explorerNode.unsetBit(TNodeConstants.IS_OPENED);
    }

    private void checkLeafState(TNode tNode) {
        if (this.isHideChildren(tNode)) {
            ((ExplorerNode)tNode).makeLeaf();
        }
    }

    private boolean isHideChildren(TNode tNode) {
        Element element = tNode.getData();
        return this.getCellRendererAttributes().isSet(CellRendererAttributes.HIDE_CHILDREN) && element.getAttributes().isSet(ElementAttributes.HIDE_CHILDREN) && element.mayHaveChildren();
    }

    public void focusGained(FocusEvent focusEvent) {
        ExplorerNode explorerNode;
        this.nodeChanged(this.getRoot());
        if (this._lastActiveNodeWeakRef != null && (explorerNode = (ExplorerNode)this._lastActiveNodeWeakRef.get()) != null) {
            this.nodeChanged(explorerNode);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.focusGained(focusEvent);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.scheduleUpdateSelection();
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        TNode tNode = (TNode)treePath.getLastPathComponent();
        if (!tNode.isLeaf()) {
            2 var4_4 = new 2(this, tNode);
            SwingUtilities.invokeLater(var4_4);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        this._keyMgr.postKeyPressed(keyEvent);
        if (!keyEvent.isConsumed() && (n = keyEvent.getKeyCode()) == 10) {
            this.fireDefaultAction(keyEvent);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        this._keyMgr.postKeyTyped(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this._keyMgr.postKeyReleased(keyEvent);
    }

    private void dblClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (mouseEvent.getClickCount() == 2) {
            if (this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) != null) {
                this.fireDefaultAction(mouseEvent);
            }
        } else if (mouseEvent.getClickCount() > 2) {
            mouseEvent.consume();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.tryPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.dblClicked(mouseEvent);
        } else {
            this.tryPopup(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void tryPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            View view;
            Context context;
            ContextMenu contextMenu = this.getContextMenu();
            if (contextMenu == null) {
                return;
            }
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            TreePath[] treePathArray = this.tree.getSelectionPaths();
            boolean bl = false;
            if (treePathArray != null) {
                int n = 0;
                while (n < treePathArray.length) {
                    if (treePathArray[n].getLastPathComponent() == treePath.getLastPathComponent()) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl) {
                this.tree.setSelectionPath(treePath);
            }
            Context context2 = context = (view = this.owner()) != null ? view.getContext(mouseEvent) : this.getContext(mouseEvent);
            if (context.getElement() == null) {
                return;
            }
            contextMenu.show(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(TNode tNode, UpdateMessage updateMessage) {
        ArrayList arrayList = this._updates;
        synchronized (arrayList) {
            this._updates.add(tNode);
            this._updates.add(updateMessage);
        }
        if (this._timer != null) {
            this._timer.restart();
        } else {
            this.updateImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImpl() {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this._updates;
        synchronized (arrayList2) {
            if (this._updates.isEmpty()) {
                return;
            }
            arrayList.addAll(this._updates);
            this._updates.clear();
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TNode tNode = (TNode)iterator.next();
            UpdateMessage updateMessage = (UpdateMessage)iterator.next();
            this.updateImpl(tNode, updateMessage);
        }
    }

    private void tryForceUpdateImpl() {
        if (EventQueue.isDispatchThread()) {
            this.updateImpl();
        }
    }

    private void updateImpl(TNode tNode, UpdateMessage updateMessage) {
        DefaultTreeModel defaultTreeModel = this.getTreeModel();
        int n = updateMessage.getMessageID();
        if (n == UpdateMessage.OBJECT_RENAMED) {
            this.nodeChanged(tNode);
            if (tNode != this.getRoot()) {
                return;
            }
            this.updateTitle(tNode);
            this.setSelected(tNode);
        }
        if (n == UpdateMessage.OBJECT_RENAMED || n == UpdateMessage.CHILD_RENAMED) {
            TNode tNode2;
            List list;
            ChildFilter childFilter = tNode.getChildFilter();
            List list2 = updateMessage.getRemoveObjects();
            if (list2.size() > 0) {
                this.childrenRemoved(updateMessage, tNode, defaultTreeModel, childFilter);
            }
            if ((list = updateMessage.getAddObjects()).size() > 0 && (tNode2 = this.childrenAdded(updateMessage, tNode, defaultTreeModel, childFilter, true)) != null) {
                this.renameFilters(tNode, tNode2, updateMessage);
                this.nodeChanged(tNode2);
                this.setSelected(tNode2);
            }
        } else if (n == UpdateMessage.CHILD_REMOVED) {
            this.childrenRemoved(updateMessage, tNode, defaultTreeModel, tNode.getChildFilter());
        } else if (n == UpdateMessage.CHILD_ADDED) {
            boolean bl = TreeExplorer.isSelectAddedChild(updateMessage, true);
            this.childrenAdded(updateMessage, tNode, defaultTreeModel, tNode.getChildFilter(), bl);
        } else if (n == UpdateMessage.STRUCTURE_CHANGED) {
            this.update(tNode, updateMessage, false);
        } else if (n == UpdateMessage.PROPERTY_SET) {
            this.update(tNode, updateMessage, true);
        } else if (n == UpdateMessage.OBJECT_CLOSED) {
            this.releaseFilters(tNode, true);
            this.collapse(tNode, true);
            tNode.unsetBit(TNodeConstants.IS_OPENED);
            if (tNode == this.getRoot() && this.owner() != null) {
                this.owner().close();
            }
        } else if (n == UpdateMessage.ATTRIBUTE_CHANGED) {
            this.nodeChanged(tNode);
        } else if (this.owner() instanceof NodeUpdateListener) {
            ((NodeUpdateListener)((Object)this.owner())).update(tNode, updateMessage);
        }
    }

    private void update(TNode tNode, UpdateMessage updateMessage, boolean bl) {
        ChildFilter childFilter = tNode.getChildFilter();
        if (childFilter != null) {
            if (!bl || childFilter.canUpdate(tNode, updateMessage)) {
                this.refresh(tNode, Project.class);
            }
        } else if (!tNode.isLeaf()) {
            this.refresh(tNode);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.updateSelection();
    }

    public Transferable[] dragStarted(DragGestureEvent dragGestureEvent) {
        Point point = dragGestureEvent.getDragOrigin();
        if (this.tree.getPathForLocation(point.x, point.y) == null) {
            return new Transferable[0];
        }
        Context context = this.getContext(dragGestureEvent);
        TransferableContext transferableContext = new TransferableContext(context);
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        1 var6_6 = new 1(this, inputEvent);
        return new Transferable[]{transferableContext, var6_6};
    }

    public void dropOccurred(DragSourceDropEvent dragSourceDropEvent, Object object) {
        if (dragSourceDropEvent.getDropSuccess()) {
            this.nodeChanged((TNode)object);
        }
    }

    static void mav$updateImpl(BaseTreeExplorer baseTreeExplorer) {
        baseTreeExplorer.updateImpl();
    }

    static KeyNavigationManager ra$_keyMgr(BaseTreeExplorer baseTreeExplorer) {
        return baseTreeExplorer._keyMgr;
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            BaseTreeExplorer.mav$updateImpl(BaseTreeExplorer.this);
        }
    }

    public final class 3
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
            BaseTreeExplorer.ra$_keyMgr(BaseTreeExplorer.this).preKeyPressed(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            BaseTreeExplorer.ra$_keyMgr(BaseTreeExplorer.this).preKeyReleased(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            BaseTreeExplorer.ra$_keyMgr(BaseTreeExplorer.this).preKeyTyped(keyEvent);
        }
    }

    public final class oracle.ideimpl.explorer.BaseTreeExplorer$2
    implements Runnable {
        private final /* synthetic */ TNode v$tnode;
        final /* synthetic */ BaseTreeExplorer this$0;

        public void run() {
            String string = this.getClass().getName() + ".treeExpanded.1." + this.v$tnode;
            String string2 = this.getClass().getName() + ".treeExpanded.2." + this.v$tnode;
            boolean bl = Ide.isStarting();
            if (!bl) {
                Ide.getWaitCursor().show();
            }
            boolean bl2 = this.v$tnode.isSet(TNodeConstants.IS_OPENED) ^ true;
            try {
                if (bl2) {
                    this.this$0.open(this.v$tnode);
                    IdeMainWindow.updateVisibleActions();
                }
                this.this$0.nodeExpanded(this.v$tnode, bl2);
            }
            finally {
                if (!bl) {
                    Ide.getWaitCursor().hide();
                }
            }
        }

        public oracle.ideimpl.explorer.BaseTreeExplorer$2(BaseTreeExplorer baseTreeExplorer, TNode tNode) {
            this.v$tnode = tNode;
            this.this$0 = baseTreeExplorer;
        }

        static TNode ra$v$tnode(oracle.ideimpl.explorer.BaseTreeExplorer$2 var0) {
            return var0.v$tnode;
        }

        public final class 2
        implements Runnable {
            private final /* synthetic */ String v$key1;
            final /* synthetic */ oracle.ideimpl.explorer.BaseTreeExplorer$2 this$0;

            public void run() {
                String string;
                Element element = oracle.ideimpl.explorer.BaseTreeExplorer$2.ra$v$tnode(this.this$0).getData();
                if (element instanceof Workspace && Boolean.valueOf(string = System.getProperty("jdev.autoexpand.workspace")).booleanValue()) {
                    this.this$0.this$0.expand(oracle.ideimpl.explorer.BaseTreeExplorer$2.ra$v$tnode(this.this$0), true);
                    SwingUtilities.invokeLater(new 1(this, element));
                }
            }

            public 2(oracle.ideimpl.explorer.BaseTreeExplorer$2 var1_1, String string) {
                this.v$key1 = string;
                this.this$0 = var1_1;
            }

            public final class 1
            implements Runnable {
                private final /* synthetic */ Element v$data;
                final /* synthetic */ 2 this$0;

                public void run() {
                }

                public 1(2 var1_1, Element element) {
                    this.v$data = element;
                    this.this$0 = var1_1;
                }
            }
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ boolean v$tnodeWasClosed;
            private final /* synthetic */ String v$key2;
            final /* synthetic */ oracle.ideimpl.explorer.BaseTreeExplorer$2 this$0;

            public void run() {
                if (this.v$tnodeWasClosed) {
                    // empty if block
                }
            }

            public 1(oracle.ideimpl.explorer.BaseTreeExplorer$2 var1_1, boolean bl, String string) {
                this.v$key2 = string;
                this.v$tnodeWasClosed = bl;
                this.this$0 = var1_1;
            }
        }
    }

    private final class TreeExplorerModel
    extends DefaultTreeModel {
        private TreeExplorerModel(TreeNode treeNode) {
            super(treeNode);
        }

        public void insertNodeInto(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2, int n) {
            block1: {
                if (mutableTreeNode2 instanceof ExplorerNode && !((ExplorerNode)mutableTreeNode2).isSet(TNodeConstants.IS_OPENED)) {
                    ((ExplorerNode)mutableTreeNode2).removeAllChildren();
                }
                mutableTreeNode2.insert(mutableTreeNode, n);
                int[] nArray = new int[1];
                int n2 = mutableTreeNode2.getIndex(mutableTreeNode);
                if (n2 < 0) break block1;
                nArray[0] = mutableTreeNode2.getIndex(mutableTreeNode);
                this.nodesWereInserted(mutableTreeNode2, nArray);
            }
        }

        private void removeNodesFromParent(MutableTreeNode mutableTreeNode, MutableTreeNode[] mutableTreeNodeArray) {
            int n = mutableTreeNodeArray.length;
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = mutableTreeNode.getIndex(mutableTreeNodeArray[n2]);
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                mutableTreeNode.remove(mutableTreeNodeArray[n3]);
                ++n3;
            }
            this.nodesWereRemoved(mutableTreeNode, nArray, mutableTreeNodeArray);
        }

        TreeExplorerModel(TreeNode treeNode, 1 var3_3) {
            this(treeNode);
        }

        static void mav$removeNodesFromParent(TreeExplorerModel treeExplorerModel, MutableTreeNode mutableTreeNode, MutableTreeNode[] mutableTreeNodeArray) {
            treeExplorerModel.removeNodesFromParent(mutableTreeNode, mutableTreeNodeArray);
        }

        public final class 1 {
        }
    }

    private static final class FilterInfo {
        private String _className;
        private int _options;
        private ChildFilter _filter;

        FilterInfo(String string, int n) {
            this._className = string;
            this._options = n;
        }

        FilterInfo(ChildFilter childFilter) {
            this._className = childFilter.getClass().getName();
            this._options = childFilter.getOptions();
            this._filter = childFilter;
        }

        ChildFilter getFilter() {
            if (this._filter == null) {
                try {
                    Class<?> clazz = Class.forName(this._className);
                    this._filter = (ChildFilter)clazz.newInstance();
                    this._filter.setOptions(this._options);
                    ChildFilter childFilter = this._filter;
                    return childFilter;
                }
                catch (Exception exception) {
                    ChildFilter childFilter = null;
                    return childFilter;
                }
            }
            return this._filter;
        }

        String getClassName() {
            return this._className;
        }

        int getOptions() {
            return this._options;
        }

        ChildFilter releaseFilter() {
            ChildFilter childFilter = this._filter;
            this._filter = null;
            if (childFilter != null) {
                childFilter.closeChildren();
            }
            return childFilter;
        }
    }

    public final class 1
    implements Transferable {
        private final /* synthetic */ Object v$inputEvent;
        final /* synthetic */ BaseTreeExplorer this$0;

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DndUtils.FLAVOR_TRIGGER_EVENT};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return DndUtils.FLAVOR_TRIGGER_EVENT.equals(dataFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (this.isDataFlavorSupported(dataFlavor)) {
                return this.v$inputEvent;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        public 1(BaseTreeExplorer baseTreeExplorer, Object object) {
            this.v$inputEvent = object;
            this.this$0 = baseTreeExplorer;
        }
    }
}

