/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.explorer.CellRendererAttributes;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.ideimpl.plaf.DefaultTreeCellRendererFocusFix;

public class CustomTreeCellRenderer
extends DefaultTreeCellRendererFocusFix {
    private Color inactiveBackgroundSelectionColor;
    private Color inactiveTextSelectionColor;
    private Attributes _attributes;
    private HashMap fonts;
    private boolean treeHasFocus;
    private static final Integer PLAIN_STYLE = new Integer(0);
    private static final Integer ITALIC_STYLE = new Integer(2);
    private static final Integer BOLD_STYLE = new Integer(1);
    private static final Integer BOLD_ITALIC_STYLE = new Integer(3);

    void $init$() {
        this.fonts = new HashMap(4);
    }

    public CustomTreeCellRenderer() {
        this.$init$();
        this.inactiveBackgroundSelectionColor = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground");
        if (this.inactiveBackgroundSelectionColor == null) {
            this.inactiveBackgroundSelectionColor = this.backgroundSelectionColor;
        }
        this.inactiveTextSelectionColor = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground");
        if (this.inactiveTextSelectionColor == null) {
            this.inactiveTextSelectionColor = this.textSelectionColor;
        }
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.treeHasFocus = jTree.hasFocus();
        ExplorerNode explorerNode = (ExplorerNode)object;
        Element element = explorerNode.getData();
        this.setEnabled(jTree.isEnabled() && CustomTreeCellRenderer.isInProject(explorerNode));
        this.setFont(this.getFont(jTree, explorerNode));
        Icon icon = explorerNode.getIcon();
        String string = this.getShortLabel(element);
        String string2 = CustomTreeCellRenderer.getToolTipText(explorerNode);
        if (icon != null) {
            this.setIcon(icon);
        }
        if (element != null) {
            this.setText(string);
        }
        if (string2 != null) {
            this.setToolTipText(string2);
        }
        return this;
    }

    public Icon getDisabledIcon() {
        Icon icon = super.getDisabledIcon();
        if (icon == null) {
            Icon icon2 = super.getIcon();
            if (icon2 instanceof ImageIcon) {
                Image image = GrayFilter.createDisabledImage(((ImageIcon)icon2).getImage());
                return new ImageIcon(image);
            }
            if (icon2 instanceof OverlayIcon) {
                return CustomTreeCellRenderer.createDisabledIcon((OverlayIcon)icon2);
            }
            return icon2;
        }
        return icon;
    }

    public Color getBackgroundSelectionColor() {
        return this.treeHasFocus ? super.getBackgroundSelectionColor() : this.inactiveBackgroundSelectionColor;
    }

    public Color getTextSelectionColor() {
        return this.treeHasFocus ? super.getTextSelectionColor() : this.inactiveTextSelectionColor;
    }

    public String getShortLabel(Element element) {
        String string = element.getShortLabel();
        if (this.getAttributes().isSet(CellRendererAttributes.HIDE_FILE_EXTENSIONS) && element.getAttributes().isSet(ElementAttributes.HIDE_FILE_EXTENSION)) {
            int n = string.lastIndexOf(46);
            string = n > 0 ? string.substring(0, n) : string;
        }
        return string;
    }

    protected void setAttributes(Attributes attributes) {
        this._attributes = attributes;
    }

    protected Attributes getAttributes() {
        if (this._attributes == null) {
            this._attributes = new CellRendererAttributes();
        }
        return this._attributes;
    }

    private static boolean isActive(ExplorerNode explorerNode) {
        Element element = explorerNode.getData();
        return explorerNode.isSet(ElementAttributes.ACTIVE) || element != null && element.getAttributes().isSet(ElementAttributes.ACTIVE);
    }

    private static boolean isInProject(ExplorerNode explorerNode) {
        return explorerNode.isSet(TNodeConstants.IS_NOT_IN_PROJECT) ^ true;
    }

    private static String getToolTipText(ExplorerNode explorerNode) {
        if (explorerNode != null) {
            ChildFilter childFilter = explorerNode.getFilter();
            if (childFilter != null) {
                return childFilter.getToolTipText();
            }
            Element element = explorerNode.getData();
            if (element != null) {
                return element.getToolTipText();
            }
        }
        return null;
    }

    private static Icon createDisabledIcon(OverlayIcon overlayIcon) {
        Collection collection = overlayIcon.getIcons();
        ArrayList<Icon> arrayList = new ArrayList<Icon>(collection.size());
        for (Icon icon : collection) {
            if (icon != null && icon instanceof ImageIcon) {
                icon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
            }
            arrayList.add(icon);
        }
        return new OverlayIcon(arrayList);
    }

    private boolean isDirty(ExplorerNode explorerNode) {
        Element element = explorerNode.getData();
        if (element == null) {
            return false;
        }
        Attributes attributes = element.getAttributes();
        if (this.getAttributes().isSet(CellRendererAttributes.HIDE_FILE_EXTENSIONS) && attributes.isSet(ElementAttributes.COMPOSITE)) {
            return attributes.isSet(ElementAttributes.DIRTY_COMPOSITE);
        }
        return attributes.isSet(ElementAttributes.DIRTY);
    }

    private boolean boldActiveNode(JTree jTree) {
        return jTree.hasFocus() || this.getAttributes().isSet(CellRendererAttributes.ALWAYS_BOLD_ACTIVE_NODE);
    }

    private Integer getFontStyle(JTree jTree, ExplorerNode explorerNode) {
        boolean bl = CustomTreeCellRenderer.isActive(explorerNode) && this.boldActiveNode(jTree);
        boolean bl2 = this.isDirty(explorerNode);
        if (bl) {
            return bl2 ? BOLD_ITALIC_STYLE : BOLD_STYLE;
        }
        return bl2 ? ITALIC_STYLE : PLAIN_STYLE;
    }

    private Font getFont(JTree jTree, ExplorerNode explorerNode) {
        Integer n = this.getFontStyle(jTree, explorerNode);
        Object object = this.fonts.get(n);
        if (!(object instanceof Font)) {
            object = UIManager.getFont("Oracle.dirtyFont");
            if (object == null || (n & 2) != 2) {
                object = jTree.getFont();
            }
            object = ((Font)object).deriveFont(n);
            this.fonts.put(n, object);
        }
        return (Font)object;
    }
}

