/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import oracle.ide.explorer.TNode;
import oracle.ide.model.ElementAttributes;

public class CustomTreeSelectionModel
extends DefaultTreeSelectionModel {
    public void setSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray == null || this.hasNullPaths(treePathArray)) {
            return;
        }
        if (treePathArray.length == 0) {
            super.setSelectionPaths(treePathArray);
            return;
        }
        if (this.areParentsEqual(treePathArray, treePathArray[0].getParentPath())) {
            super.setSelectionPaths(treePathArray);
            return;
        }
        if (this.areContainerAncestorsEqual(treePathArray, this.getContainerAncestorPath(treePathArray[0]))) {
            super.setSelectionPaths(treePathArray);
            return;
        }
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray == null || treePathArray.length == 0 || this.hasNullPaths(treePathArray)) {
            return;
        }
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            super.addSelectionPaths(treePathArray);
            return;
        }
        if (this.areParentsEqual(treePathArray, treePath.getParentPath())) {
            super.addSelectionPaths(treePathArray);
            return;
        }
        if (this.areContainerAncestorsEqual(treePathArray, this.getContainerAncestorPath(treePath))) {
            super.addSelectionPaths(treePathArray);
            return;
        }
    }

    private boolean areParentsEqual(TreePath[] treePathArray, TreePath treePath) {
        int n = 0;
        while (n < treePathArray.length) {
            TreePath treePath2 = treePathArray[n].getParentPath();
            if (treePath == null || treePath2 == null) {
                if (treePath != null || treePath2 != null) {
                    return false;
                }
            } else if (!treePath2.equals(treePath)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean areContainerAncestorsEqual(TreePath[] treePathArray, TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        int n = 0;
        while (n < treePathArray.length) {
            TreePath treePath2 = this.getContainerAncestorPath(treePathArray[n]);
            if (treePath == null || treePath2 == null) {
                if (treePath != null || treePath2 != null) {
                    return false;
                }
            } else if (!treePath2.equals(treePath)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private TreePath getContainerAncestorPath(TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        while (treePath2 != null) {
            if (this.isContainerAncestorPath(treePath2)) {
                return treePath2;
            }
            treePath2 = treePath2.getParentPath();
        }
        return null;
    }

    private boolean isContainerAncestorPath(TreePath treePath) {
        TNode tNode = (TNode)treePath.getLastPathComponent();
        return tNode.getData().getAttributes().isSet(ElementAttributes.SELECTION_CONTAINER);
    }

    private boolean hasNullPaths(TreePath[] treePathArray) {
        int n = 0;
        while (n < treePathArray.length) {
            if (treePathArray[n] == null) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

