/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.util.TimedCache;

class ExplorerMutableTreeNode
extends DefaultMutableTreeNode {
    private static TimedCache childLists = new TimedCache(1);
    protected Collection _children;

    public ExplorerMutableTreeNode() {
    }

    public ExplorerMutableTreeNode(Object object) {
        super(object);
    }

    public ExplorerMutableTreeNode(Object object, boolean bl) {
        super(object, bl);
    }

    public Enumeration children() {
        if (this._children == null) {
            return DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }
        return Collections.enumeration(new ArrayList(this._children));
    }

    public TreeNode getChildAt(int n) {
        if (this._children == null || n < 0 || n > this._children.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this._children instanceof List) {
            return (TreeNode)((List)this._children).get(n);
        }
        if (this._children.size() > 5) {
            ArrayList arrayList = (ArrayList)childLists.get(this);
            if (arrayList == null) {
                arrayList = new ArrayList(this._children);
                childLists.put(this, arrayList);
            }
            return (TreeNode)arrayList.get(n);
        }
        for (TreeNode treeNode : this._children) {
            if (n-- != 0) continue;
            return treeNode;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getChildCount() {
        if (this._children == null) {
            return 0;
        }
        return this._children.size();
    }

    public int getIndex(TreeNode treeNode) {
        if (this._children == null) {
            return -1;
        }
        if (this._children instanceof List) {
            return ((List)this._children).indexOf(treeNode);
        }
        Iterator iterator = this._children.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (treeNode == iterator.next()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(mutableTreeNode)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        MutableTreeNode mutableTreeNode2 = (MutableTreeNode)mutableTreeNode.getParent();
        if (mutableTreeNode2 != null) {
            mutableTreeNode2.remove(mutableTreeNode);
        }
        mutableTreeNode.setParent(this);
        if (this._children == null) {
            this._children = this.createChildren();
        }
        if (this._children instanceof List) {
            ((List)this._children).add(n, mutableTreeNode);
        } else {
            this._children.add(mutableTreeNode);
            childLists.remove(this);
        }
    }

    public void remove(int n) {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.getChildAt(n);
        this._children.remove(mutableTreeNode);
        mutableTreeNode.setParent(null);
        childLists.remove(this);
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        if (this._children == null || !this.isNodeChild(mutableTreeNode)) {
            throw new IllegalArgumentException();
        }
        this._children.remove(mutableTreeNode);
        childLists.remove(this);
    }

    public void removeAllChildren() {
        if (this._children != null) {
            this._children.clear();
        }
        childLists.remove(this);
    }

    protected Collection createChildren() {
        return new ArrayList();
    }
}

