/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Icon;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ChildFilterFactory;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.ExplorerArb;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.View;
import oracle.ideimpl.ProfileIDs;
import oracle.ideimpl.explorer.ExplorerMutableTreeNode;
import oracle.ideimpl.explorer.NodeUpdateListener;
import oracle.ideri.navigator.DefaultNavigatorManager;

public class ExplorerNode
extends ExplorerMutableTreeNode
implements Observer,
TNode {
    private Vector _nodeUpdateListeners;
    private ChildFilter _filter;
    private int _bits;
    private Icon _icon;
    private TreeExplorer _owner;
    private Comparator comparator;
    private boolean _leaf;
    private static final Element LABEL_ELEMENT = new 1();

    void $init$() {
        this._nodeUpdateListeners = new Vector(2);
    }

    public ExplorerNode(Element element) {
        super(element);
        this.$init$();
        this.addLoadingElement();
    }

    public Element getData() {
        return (Element)this.getUserObject();
    }

    public boolean isLeaf() {
        if (this._leaf) {
            return true;
        }
        Element element = this.getData();
        return element == null || !element.mayHaveChildren();
    }

    public void update(Object object, UpdateMessage updateMessage) {
        this.triggerNodeUpdateListener(updateMessage);
    }

    public synchronized void addNodeUpdateListener(NodeUpdateListener nodeUpdateListener) {
        if (nodeUpdateListener != null && !this._nodeUpdateListeners.contains(nodeUpdateListener)) {
            Element element = this.getData();
            if (element != null && element instanceof Subject) {
                ((Subject)((Object)element)).attach(this);
            }
            this._nodeUpdateListeners.add(nodeUpdateListener);
        }
    }

    public synchronized void removeNodeUpdateListener(NodeUpdateListener nodeUpdateListener) {
        if (nodeUpdateListener != null) {
            Element element = this.getData();
            if (element != null && element instanceof Subject) {
                ((Subject)((Object)element)).detach(this);
            }
            this._nodeUpdateListeners.remove(nodeUpdateListener);
        }
    }

    public ChildFilter getChildFilter() {
        TreeExplorer treeExplorer;
        if (this.isLeaf() || this.isSet(TNodeConstants.IS_UNFILTERED)) {
            return null;
        }
        if (this._filter != null) {
            return this._filter;
        }
        int n = 0;
        if (ProfileIDs.PROFILE_GETCHILDFILTER) {
            n = IdeProfile.startEvent(3311);
        }
        if ((treeExplorer = this.getOwner()) != null) {
            this._filter = treeExplorer.findCacheFilter(this);
        }
        if (this._filter == null) {
            ChildFilterFactory childFilterFactory = this.findFilterFactory(treeExplorer);
            if (childFilterFactory != null) {
                try {
                    ChildFilter childFilter = childFilterFactory.newChildFilter();
                    if (childFilter != null) {
                        this.setChildFilter(childFilter);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else {
            this.initURLFilter(this._filter);
            this.updateComparator();
        }
        if (this._filter != null) {
            this._filter.setOwner(this);
            if (this.isSet(TNodeConstants.IS_OPENED)) {
                this._filter.refresh(null);
            }
        } else {
            this.setBit(TNodeConstants.IS_UNFILTERED);
        }
        if (ProfileIDs.PROFILE_GETCHILDFILTER) {
            IdeProfile.endEvent(n);
        }
        return this._filter;
    }

    public void setChildFilter(ChildFilter childFilter) {
        this.setChildFilter(childFilter, false);
    }

    public void setChildFilter(ChildFilter childFilter, boolean bl) {
        boolean bl2 = false;
        if (this._filter != childFilter) {
            if (this._filter != null) {
                this._filter.setOwner(null);
            }
            this._filter = childFilter;
            bl2 = true;
        }
        if (this._filter != null && (bl2 || bl)) {
            if (this._filter.getOwner() == null || this._filter.getOwner() != this) {
                this._filter.setOwner(this);
            }
            this.getOwner().cacheFilter(this, this._filter);
            this.initURLFilter(this._filter);
            this.updateComparator();
        }
    }

    public ChildFilter findChildFilter() {
        ChildFilter childFilter = this.getChildFilter();
        if (childFilter == null) {
            TNode tNode = (TNode)this.getParent();
            while (tNode != null) {
                childFilter = tNode.getChildFilter();
                if (childFilter != null) break;
                tNode = (TNode)tNode.getParent();
            }
        }
        return childFilter;
    }

    public Iterator getChildNodes() {
        Element element = this.getData();
        return element != null ? element.getChildren() : null;
    }

    public Enumeration getChildTNodes() {
        if (this.isLeaf() || this.isSet(TNodeConstants.IS_OPENED)) {
            return this.children();
        }
        TreeExplorer treeExplorer = this.getOwner();
        if (treeExplorer != null) {
            treeExplorer.addChildren(this);
        }
        return this.children();
    }

    public int getBits() {
        return this._bits;
    }

    public void setBits(int n) {
        int n2 = this._bits;
        this._bits = n;
        this.updateBits(n2);
    }

    public void setBit(int n) {
        int n2 = this._bits;
        this._bits |= n;
        this.updateBits(n2);
    }

    public void unsetBit(int n) {
        int n2 = this._bits;
        this._bits &= ~n;
        this.updateBits(n2);
    }

    public boolean isSet(int n) {
        return (this._bits & n) == n;
    }

    public void setOwner(TreeExplorer treeExplorer) {
        this._owner = treeExplorer;
        this.updateComparator();
    }

    public TreeExplorer getOwner() {
        if (this._owner == null && this.getParent() != null) {
            this.setOwner(((TNode)this.getParent()).getOwner());
        }
        return this._owner;
    }

    public Icon getIcon() {
        Element element;
        if (this._icon == null && (element = this.getData()) != null) {
            this._icon = element.getIcon();
        }
        return this._icon;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        if (!this.isLeaf() && !ModelUtil.areEqual((Object)comparator, (Object)this.comparator)) {
            this.comparator = comparator;
            this.resetChildren();
        }
    }

    ChildFilter getFilter() {
        return this._filter;
    }

    private ChildFilterFactory findFilterFactory(TreeExplorer treeExplorer) {
        NavigatorWindow navigatorWindow;
        NavigatorManager navigatorManager;
        View view;
        Element element = this.getData();
        if (element != null && treeExplorer != null && (view = treeExplorer.owner()) instanceof NavigatorWindow && (navigatorManager = (navigatorWindow = (NavigatorWindow)view).getManager()) != null) {
            return navigatorManager.getChildFilterFactoryForType(element.getClass());
        }
        return null;
    }

    public TNode getAncestorTNode(Class clazz, boolean bl) {
        Element element = this.getData();
        if (element == null) {
            return null;
        }
        if (bl ? clazz.isAssignableFrom(element.getClass()) : element.getClass() == clazz) {
            return this;
        }
        if (this.getParent() == null) {
            return null;
        }
        return ((TNode)this.getParent()).getAncestorTNode(clazz, bl);
    }

    public Element getAncestor(Class clazz, boolean bl) {
        TNode tNode = this.getAncestorTNode(clazz, bl);
        return tNode == null ? null : tNode.getData();
    }

    public Element getAncestor(Class clazz) {
        return this.getAncestor(clazz, false);
    }

    protected Collection createChildren() {
        if (this.comparator == null) {
            return super.createChildren();
        }
        return new TreeSet(this.comparator);
    }

    void makeLeaf() {
        this._leaf = true;
    }

    private void triggerNodeUpdateListener(UpdateMessage updateMessage) {
        Enumeration enumeration = this._nodeUpdateListeners.elements();
        while (enumeration.hasMoreElements()) {
            NodeUpdateListener nodeUpdateListener = (NodeUpdateListener)enumeration.nextElement();
            nodeUpdateListener.update(this, updateMessage);
        }
    }

    private void updateBits(int n) {
        if ((this._bits & TNodeConstants.IS_NOT_IN_PROJECT) != (n & TNodeConstants.IS_NOT_IN_PROJECT)) {
            this.resetIcon();
        }
        if (!this.isSet(TNodeConstants.IS_OPENED) && (n & TNodeConstants.IS_OPENED) != 0) {
            this.addLoadingElement();
        }
    }

    private void resetIcon() {
        if (this._icon != null) {
            this._icon = null;
            TreeExplorer treeExplorer = this.getOwner();
            if (treeExplorer != null) {
                treeExplorer.nodeChanged(this);
            }
        }
    }

    private void resetChildren() {
        if (this._children != null) {
            if (this.isSet(TNodeConstants.IS_OPENED)) {
                TreeExplorer treeExplorer = this.getOwner();
                if (treeExplorer != null) {
                    this.removeNodeUpdateListeners(this._children, (NodeUpdateListener)((Object)treeExplorer));
                    this._children = null;
                    this.unsetBit(TNodeConstants.IS_OPENED);
                    treeExplorer.addChildren(this);
                    treeExplorer.getTreeModel().nodeStructureChanged(this);
                }
            } else {
                Collection collection = this.createChildren();
                collection.addAll(this._children);
                this._children = collection;
            }
        }
    }

    private void removeNodeUpdateListeners(Collection collection, NodeUpdateListener nodeUpdateListener) {
        if (collection == null) {
            return;
        }
        for (ExplorerNode explorerNode : collection) {
            explorerNode.removeNodeUpdateListener(nodeUpdateListener);
            if (!explorerNode.isSet(TNodeConstants.IS_OPENED)) continue;
            this.removeNodeUpdateListeners(explorerNode._children, nodeUpdateListener);
        }
    }

    private void initURLFilter(ChildFilter childFilter) {
        View view;
        Element element = this.getData();
        if (element != null && (view = this.getOwner().owner()) != null) {
            DefaultNavigatorManager defaultNavigatorManager;
            URLFilter uRLFilter;
            NavigatorWindow navigatorWindow;
            NavigatorManager navigatorManager;
            Class<?> clazz = element.getClass();
            if (view instanceof NavigatorWindow && (navigatorManager = (navigatorWindow = (NavigatorWindow)view).getManager()) instanceof DefaultNavigatorManager && (uRLFilter = (defaultNavigatorManager = (DefaultNavigatorManager)navigatorManager).getURLFilter(clazz)) != null) {
                childFilter.setURLFilter(uRLFilter);
            }
        }
    }

    private void updateComparator() {
        if (this._filter != null) {
            this.setComparator(this._filter.getComparator());
        } else if (this._owner != null) {
            this.setComparator(this._owner.getComparator());
        } else {
            this.setComparator(null);
        }
    }

    private void addLoadingElement() {
        if (!this.isLeaf()) {
            this.removeAllChildren();
            this.add(new ExplorerNode(LABEL_ELEMENT));
        }
    }

    public static final class 1
    extends DefaultElement {
        private String _label;
        private Icon _icon;

        void $init$() {
            this._label = ExplorerArb.getString(5);
            this._icon = null;
        }

        public String getShortLabel() {
            return this._label;
        }

        public Icon getIcon() {
            if (this._icon == null) {
                this._icon = ExplorerArb.getIcon(6);
            }
            return this._icon;
        }

        public 1() {
            this.$init$();
        }
    }
}

