/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.explorer.Explorer;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.AbstractLayoutListener;
import oracle.ide.layout.Layout;
import oracle.ide.layout.URL2String;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.ExplorerArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.DynamicStatusProvider;
import oracle.ide.view.Pinnable;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ideri.util.Product;

public class ExplorerWindowImpl
extends ExplorerWindow
implements DynamicStatusProvider,
ListSelectionListener {
    private static final String TARGET_PROP = ".pinTarget";
    private static final String EXPLORER_PROP = ".explorerType";
    private static ExplorerManager MANAGER = ExplorerManager.getExplorerManager();
    private JPanel gui;
    private CustomTab tabs;
    private FocusableLabel defaultLabel;
    private JScrollPane defaultStructure;
    private String defaultText;
    private Explorer explorer;
    private URL pinTarget;
    private Class explorerType;
    private TargetMonitor targetMonitor;
    private Context context;
    private PropertyAccess properties;
    private ArrayList changeListeners;
    private Controller controller;
    private boolean shownCalled;
    private boolean loading;
    private boolean _alreadyUpdating;

    void $init$() {
        this.changeListeners = new ArrayList();
        this.controller = new ChainedController(null);
        this.shownCalled = false;
        this.loading = false;
        this._alreadyUpdating = false;
    }

    protected ExplorerWindowImpl(String string) {
        super(string);
        this.$init$();
    }

    public int getType() {
        return super.getType() | 1 | 0x20;
    }

    CustomTab getTabs() {
        return this.tabs;
    }

    public void setToolbarVisible(boolean bl) {
        super.setToolbarVisible(bl);
        if (this.gui != null) {
            if (this.isToolbarVisible) {
                if (this.toolbar == null) {
                    this.tabs = new CustomTab(3);
                    this.tabs.setShowIcons(false);
                    this.tabs.setGapBeforeTabs(-1);
                    this.tabs.setGapBetweenTabs(-1);
                    this.tabs.setGapLeft(2);
                    this.tabs.setGapRight(2);
                    this.tabs.setOffsetSelected(0);
                    this.tabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
                    this.tabs.addSelectionListener(this);
                    this.toolbar = new Toolbar();
                    this.updateToolbar();
                    this.gui.add((Component)this.toolbar, "North");
                    this.gui.add((Component)this.tabs, "South");
                    this.gui.revalidate();
                }
            } else if (this.toolbar != null) {
                this.gui.remove(this.toolbar);
                this.gui.remove(this.tabs);
                this.toolbar.dispose();
                this.toolbar.removeAll();
                this.toolbar = null;
                this.tabs.removeSelectionListener(this);
                this.tabs = null;
                this.gui.revalidate();
            }
        }
    }

    public Explorer getExplorer() {
        return this.explorer;
    }

    protected String getDefaultText() {
        return this.defaultText;
    }

    protected void setDefaultText(String string) {
        this.defaultText = string;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setContext(Context context) {
        if (this.gui == null) {
            this.context = context;
        } else {
            super.setContext(context);
        }
    }

    public Context getContext(EventObject eventObject) {
        Context context = null;
        if (this.explorer != null && (context = this.explorer.getContext(eventObject)) != null) {
            context = new Context(context);
            context.setView(this);
        }
        if (context == null) {
            context = Context.newIdeContext(this, eventObject);
            context.setEvent(eventObject);
        }
        return context;
    }

    public HelpInfo getHelpInfo() {
        HelpInfo helpInfo;
        HelpInfo helpInfo2 = helpInfo = this.explorer != null ? this.explorer.getHelpInfo() : null;
        if (helpInfo == null || helpInfo == HelpInfo.getDefaultHelpInfo()) {
            helpInfo = new HelpInfo(this.getDefaultHelpTag());
            helpInfo.setContext(this.getContext());
        }
        return helpInfo;
    }

    protected String getDefaultHelpTag() {
        return "f1_idestructurepane_html";
    }

    public ContextMenu getContextMenu() {
        return MANAGER.getContextMenu();
    }

    protected Element[] getSelectionFromUI() {
        if (this.explorer != null) {
            if (!this._alreadyUpdating) {
                this._alreadyUpdating = true;
                try {
                    this.explorer.updateSelection();
                }
                finally {
                    this._alreadyUpdating = false;
                }
            }
            return this.explorer.getSelection();
        }
        return super.getSelectionFromUI();
    }

    public String getMenuTitle() {
        return IdeArb.getString(349);
    }

    public String getTabName() {
        if (this.getPinState() != 0) {
            String string = null;
            if (this._node != null) {
                string = this._node.getShortLabel();
            } else if (this.targetMonitor != null && this.targetMonitor.target != null) {
                string = this.targetMonitor.target.getShortLabel();
            }
            return string != null ? string : ExplorerArb.getString(0);
        }
        return ExplorerArb.getString(0);
    }

    public Icon getTabIcon() {
        return IdeArb.getIcon(351);
    }

    public String getTitleName() {
        String string;
        Explorer explorer = this.getExplorer();
        String string2 = string = explorer != null ? explorer.getTitle() : null;
        if (string == null) {
            string = this._node != null ? this._node.getShortLabel() : null;
        }
        return string != null ? string + " - " + ExplorerArb.getString(0) : ExplorerArb.getString(0);
    }

    public int getDefaultVisibility(Layout layout) {
        String string = Product.isRaptor() ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
        String string2 = layout.getProperty("Layout.ShowStructure", string);
        boolean bl = Boolean.valueOf(string2);
        return bl ? 1 : 0;
    }

    public Component getGUI() {
        if (this.gui == null) {
            this.gui = new JPanel();
            this.defaultLabel = new FocusableLabel();
            this.defaultStructure = new JScrollPane();
            this.defaultStructure.setBorder(BorderFactory.createEmptyBorder());
            if (this.defaultText == null) {
                this.defaultText = ExplorerArb.getString(1);
            }
            this.defaultLabel.setText(this.defaultText);
            this.defaultLabel.setBackground((Color)UIManager.get("Tree.background"));
            this.defaultLabel.setForeground((Color)UIManager.get("Tree.foreground"));
            this.defaultStructure.setViewportView(this.defaultLabel);
            this.gui.setLayout(new BorderLayout());
            this.gui.add((Component)this.defaultStructure, "Center");
            this.setToolbarVisible(this.isToolbarVisible);
            if (this.context != null) {
                this.setContext(this.context);
                this.context = null;
            }
            if (this.properties != null) {
                this.loadLayout(this.properties);
                this.properties = null;
            }
        }
        return this.gui;
    }

    public void activate() {
        if (this.explorer != null) {
            AccessibleContext accessibleContext;
            this.explorer.activate();
            JComponent jComponent = GraphicsUtils.getFocusableComponentOrChild(this.explorer.getGUI(), true);
            if (jComponent != null && jComponent instanceof Accessible && (accessibleContext = ((Accessible)((Object)jComponent)).getAccessibleContext()) != null && accessibleContext.getAccessibleName() == null) {
                accessibleContext.setAccessibleName(ExplorerArb.getString(0));
            }
        } else {
            super.activate();
        }
    }

    public void deactivate() {
        if (this.explorer != null) {
            this.explorer.deactivate();
        } else {
            super.deactivate();
        }
    }

    public void stateChange(int n) {
        switch (n) {
            case 2: {
                if (this.explorer == null) break;
                this.explorer.removeViewSelectionListener(this);
                if (!this.shownCalled) break;
                this.shownCalled = false;
                this.explorer.stateChanged(1);
                break;
            }
            case 1: {
                if (this.explorer == null) break;
                this.explorer.addViewSelectionListener(this);
                if (this.shownCalled) break;
                this.shownCalled = true;
                this.explorer.stateChanged(0);
                break;
            }
            case 3: {
                this.setToolbarVisible(false);
            }
        }
        super.stateChange(n);
    }

    public synchronized void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        View view = viewSelectionEvent.getView();
        if (view == this.explorer) {
            this.updateSelection();
        } else {
            super.viewSelectionChanged(viewSelectionEvent);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this.tabs.getPage(listSelectionEvent.getFirstIndex());
        Class clazz = (Class)defaultCustomTabPage.getUserObject();
        this.toggleExplorer(clazz);
    }

    public void toggleExplorer(Class clazz) {
        if (clazz == null) {
            return;
        }
        if (this.explorer == null || this.explorer.getClass() != clazz) {
            boolean bl = GraphicsUtils.isAncestorOfFocusedComponent(this.getGUI());
            Context context = new Context(this.getContext());
            ExplorerContext.setExplorerType(context, clazz);
            if (bl) {
                this.getGUI().requestFocus();
                if (this.explorer != null) {
                    this.explorer.deactivate();
                }
            }
            this.viewSelectionChanged(context);
            if (this.explorer != null) {
                GraphicsUtils.focusComponentOrChild(this.explorer.getGUI(), true);
                if (bl) {
                    this.explorer.activate();
                }
            }
        }
    }

    public void saveLayout(PropertyAccess propertyAccess) {
        Context context;
        if (this.gui == null) {
            return;
        }
        String string = this.getId();
        Context context2 = context = this.explorer != null ? this.explorer.getContext() : null;
        if (this.getPinState() == 2) {
            this.persistPinTarget(context != null ? context.getNode() : null, false);
            if (this.pinTarget != null) {
                propertyAccess.setProperty(string + TARGET_PROP, URL2String.toString(this.pinTarget));
                if (this.explorerType != null) {
                    propertyAccess.setProperty(string + EXPLORER_PROP, this.explorerType.getName());
                }
            } else {
                propertyAccess.removeProperty(string + TARGET_PROP);
                propertyAccess.removeProperty(string + EXPLORER_PROP);
            }
        } else {
            propertyAccess.removeProperty(string + TARGET_PROP);
            propertyAccess.removeProperty(string + EXPLORER_PROP);
        }
    }

    public void loadLayout(PropertyAccess propertyAccess) {
        if (this.gui == null) {
            this.properties = propertyAccess;
            return;
        }
        this.loading = true;
        this.pinTarget = null;
        this.explorerType = null;
        this.setPinState(0);
        String string = this.getId();
        Node node = AbstractLayoutListener.getNode(string + TARGET_PROP, propertyAccess, true);
        if (node != null) {
            this.pinTarget = node.getURL();
            String string2 = propertyAccess.getProperty(string + EXPLORER_PROP, null);
            try {
                this.explorerType = Class.forName(string2);
            }
            catch (Exception exception) {
                this.explorerType = null;
            }
            this.setPinState(2);
        }
        this.loading = false;
        Explorer explorer = this.getExplorer();
        if (explorer instanceof Pinnable) {
            ((Pinnable)((Object)explorer)).setPinState(this.getPinState());
        }
    }

    public JComponent[] getCustomCells() {
        Explorer explorer = this.getExplorer();
        if (explorer instanceof StatusProvider) {
            return ((StatusProvider)((Object)explorer)).getCustomCells();
        }
        return null;
    }

    public boolean isExpandable(JComponent jComponent) {
        Explorer explorer = this.getExplorer();
        if (explorer instanceof StatusProvider) {
            return ((StatusProvider)((Object)explorer)).isExpandable(jComponent);
        }
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.changeListeners.contains(changeListener)) {
            this.changeListeners.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners.contains(changeListener)) {
            this.changeListeners.remove(changeListener);
        }
    }

    public synchronized void setPinState(int n) {
        Explorer explorer;
        super.setPinState(n);
        if (!this.loading && (explorer = this.getExplorer()) instanceof Pinnable) {
            ((Pinnable)((Object)explorer)).setPinState(this.getPinState());
        }
    }

    private void fireStateChanged() {
        ArrayList arrayList = (ArrayList)this.changeListeners.clone();
        Iterator iterator = arrayList.iterator();
        if (iterator != null) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged(changeEvent);
            }
        }
    }

    protected boolean isViewSupported(View view) {
        return MANAGER.supportsStructure(view);
    }

    protected void viewSelectionChanged(Context context) {
        super.viewSelectionChanged(context);
        this.setExplorer(MANAGER.getExplorerForHost(this, context));
        this.updateSelection();
    }

    protected void clear() {
        super.clear();
        this.setExplorer(null);
    }

    protected synchronized void setExplorer(Explorer explorer) {
        if (this.explorer != explorer) {
            IconOverlayConsumer iconOverlayConsumer;
            IconOverlayCache iconOverlayCache;
            Component component;
            this.gui.removeAll();
            if (this.explorer != null) {
                IconOverlayConsumer iconOverlayConsumer2;
                IconOverlayCache iconOverlayCache2;
                this.explorer.removeViewSelectionListener(this);
                if (this.shownCalled) {
                    this.shownCalled = false;
                    this.explorer.stateChanged(1);
                }
                if (this.explorer instanceof IconOverlayConsumer && (iconOverlayCache2 = (iconOverlayConsumer2 = (IconOverlayConsumer)((Object)this.explorer)).getOverlayCache()) != null) {
                    iconOverlayCache2.deregisterOverlayConsumer(iconOverlayConsumer2);
                }
            }
            this.explorer = explorer;
            if (!this.loading && explorer instanceof Pinnable) {
                ((Pinnable)((Object)explorer)).setPinState(this.getPinState());
            }
            Component component2 = component = explorer != null ? explorer.getGUI() : null;
            if (component == null) {
                component = this.defaultStructure;
                this.defaultLabel.setText(this.getDefaultText());
            }
            this.gui.add(component, "Center");
            if (this.toolbar != null) {
                this.updateToolbar();
                this.gui.add((Component)this.toolbar, "North");
                this.gui.add((Component)this.tabs, "South");
            }
            if (explorer != null) {
                explorer.addViewSelectionListener(this);
                if (!this.shownCalled) {
                    this.shownCalled = true;
                    explorer.stateChanged(0);
                }
            }
            if (explorer instanceof IconOverlayConsumer && (iconOverlayCache = (iconOverlayConsumer = (IconOverlayConsumer)((Object)explorer)).getOverlayCache()) != null) {
                iconOverlayCache.registerOverlayConsumer(iconOverlayConsumer);
            }
            this.gui.revalidate();
            this.gui.repaint();
        } else if (this.explorer == null) {
            this.defaultLabel.setText(this.getDefaultText());
            this.gui.repaint();
        }
        this.updateTitle(this.getTitleName());
        this.fireStateChanged();
    }

    protected void persistPinTarget() {
        this.persistPinTarget(this._node, true);
    }

    private void persistPinTarget(Node node, boolean bl) {
        if (this.getPinState() == 0) {
            this.pinTarget = null;
            this.explorerType = null;
            return;
        }
        this.pinTarget = node != null ? node.getURL() : null;
        Class clazz = this.explorerType = this.explorer != null ? this.explorer.getClass() : null;
        if (bl && this.pinTarget != null) {
            this.getTargetMonitor().monitor(node);
        }
    }

    protected void restorePinTarget() {
        if (this.targetMonitor != null) {
            this.targetMonitor.reset();
        }
        if (this.pinTarget != null) {
            try {
                Node node = NodeFactory.findOrCreate(this.pinTarget);
                Context context = this.getContext();
                context.setNode(node);
                ExplorerContext.setExplorerType(context, this.explorerType);
                this.viewSelectionChanged(context);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.pinTarget = null;
            this.explorerType = null;
        }
    }

    protected void objectClosed(Subject subject, UpdateMessage updateMessage) {
        String string = this.getDefaultText();
        this.setDefaultText(ExplorerArb.getString(2));
        super.objectClosed(subject, updateMessage);
        this.setDefaultText(string);
    }

    protected void objectRenamed(Subject subject, UpdateMessage updateMessage) {
        Node node = null;
        List list = updateMessage.getAddObjects();
        if (!list.isEmpty()) {
            node = (Node)list.get(0);
        } else {
            node = RenameMessage.getRenamedNode(updateMessage);
            if (node == null) {
                node = this._node;
            }
        }
        this.persistPinTarget(node, false);
        this.clear();
        this.restorePinTarget();
        this.setPinState(this.getPinState());
    }

    private TargetMonitor getTargetMonitor() {
        if (this.targetMonitor == null) {
            this.targetMonitor = new TargetMonitor(null);
        }
        return this.targetMonitor;
    }

    private void updateToolbar() {
        Iterator iterator;
        if (this.toolbar == null) {
            return;
        }
        this.tabs.removeSelectionListener(this);
        this.tabs.removeAllPages();
        this.toolbar.dispose();
        this.toolbar.removeAll();
        List list = MANAGER.getExplorerTypes(this._node);
        Iterator iterator2 = iterator = list != null ? list.iterator() : null;
        if (iterator != null && iterator.hasNext()) {
            DefaultListModel<DefaultCustomTabPage> defaultListModel = new DefaultListModel<DefaultCustomTabPage>();
            Explorer explorer = this.getExplorer();
            Class<?> clazz = explorer != null ? explorer.getClass() : null;
            DefaultCustomTabPage defaultCustomTabPage = null;
            Object object = this._node.getData();
            Class<?> clazz2 = object != null ? object.getClass() : null;
            while (iterator.hasNext()) {
                Class clazz3 = (Class)iterator.next();
                String string = MANAGER.getExplorerCaption(clazz3, clazz2);
                Icon icon = MANAGER.getExplorerIcon(clazz3, clazz2);
                DefaultCustomTabPage defaultCustomTabPage2 = new DefaultCustomTabPage(icon, null, clazz3);
                defaultCustomTabPage2.setLabel(string);
                defaultListModel.addElement(defaultCustomTabPage2);
                if (clazz3 != clazz) continue;
                defaultCustomTabPage = defaultCustomTabPage2;
            }
            this.tabs.setModel(defaultListModel);
            this.toolbar.setVisible(true);
            this.tabs.setVisible(defaultListModel.getSize() > 1);
            this.tabs.setPreferredSize(null);
            this.tabs.setSelectedPage(this.tabs.searchPage(defaultCustomTabPage));
            this.tabs.addSelectionListener(this);
        } else {
            this.toolbar.setVisible(false);
            this.tabs.setVisible(false);
        }
        IdeAction ideAction = IdeAction.find(68);
        if (ideAction != null) {
            ideAction = ideAction.newLocalAction(this);
            ideAction.putValue("State", this.getPinState() == 2 ? Boolean.TRUE : Boolean.FALSE);
            this.toolbar.addToggleButton(ideAction);
        }
        if ((ideAction = IdeAction.find(67)) != null) {
            ideAction = ideAction.newLocalAction(this);
            this.toolbar.add(ideAction);
        }
        ExplorerWindowImpl.updateToolbarActions(this.getToolbar());
    }

    static void wa$pinTarget(ExplorerWindowImpl explorerWindowImpl, URL uRL) {
        explorerWindowImpl.pinTarget = uRL;
    }

    private final class TargetMonitor
    implements Observer {
        Node target;

        public void reset() {
            if (this.target != null) {
                this.target.detach(this);
                this.target = null;
            }
        }

        public void monitor(Node node) {
            this.reset();
            this.target = node;
            if (this.target != null) {
                this.target.attach(this);
            }
        }

        public void update(Object object, UpdateMessage updateMessage) {
            if (updateMessage.getMessageID() == UpdateMessage.OBJECT_RENAMED) {
                List list = updateMessage.getAddObjects();
                Node node = null;
                if (!list.isEmpty()) {
                    node = (Node)list.get(0);
                } else {
                    node = RenameMessage.getRenamedNode(updateMessage);
                    if (node == null) {
                        node = (Node)object;
                    }
                }
                ExplorerWindowImpl.wa$pinTarget(ExplorerWindowImpl.this, node != null ? node.getURL() : null);
                if (node != this.target) {
                    this.monitor(node);
                }
            }
        }

        private TargetMonitor() {
        }

        TargetMonitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ChainedController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            Controller controller;
            Explorer explorer = ExplorerWindowImpl.this.getExplorer();
            Controller controller2 = controller = explorer != null ? explorer.getController() : null;
            if (controller != null && controller.handleEvent(ideAction, context)) {
                return true;
            }
            if (controller != ExplorerManager.getExplorerManager()) {
                return ExplorerManager.getExplorerManager().handleEvent(ideAction, context);
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            Controller controller;
            Explorer explorer = ExplorerWindowImpl.this.getExplorer();
            Controller controller2 = controller = explorer != null ? explorer.getController() : null;
            if (controller != null) {
                try {
                    if (controller.update(ideAction, context)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (controller != ExplorerManager.getExplorerManager()) {
                return ExplorerManager.getExplorerManager().update(ideAction, context);
            }
            return false;
        }

        private ChainedController() {
        }

        ChainedController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

