/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer.dnd;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.util.dnd.DragDropManager;
import oracle.ide.util.dnd.DragHelper;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ide.util.dnd.TransferablesList;
import oracle.ideimpl.explorer.dnd.DragDropListener;
import oracle.ideimpl.explorer.dnd.MultiTransferable;

public class JTreeDragHandler
implements DragSourceListener,
DragGestureListener {
    private final JTree tree;
    private final DragSource dragSource;
    private final DragDropListener dragDropListener;
    private DefaultMutableTreeNode targetDropNode;

    public JTreeDragHandler(JTree jTree, int n, DragDropListener dragDropListener) {
        this.tree = jTree;
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this.tree, n, this);
        this.dragDropListener = dragDropListener;
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.dragDropListener.dropOccurred(dragSourceDropEvent, this.targetDropNode);
    }

    public final void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        this.updateCursor(dragSourceDragEvent);
    }

    public final void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        this.targetDropNode = treePath != null ? (DefaultMutableTreeNode)treePath.getLastPathComponent() : null;
        this.updateCursor(dragSourceDragEvent);
    }

    public final void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        this.updateCursor(dragSourceDragEvent);
    }

    public final void dragExit(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    public final void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            ArrayList<Transferable> arrayList = new ArrayList<Transferable>();
            Transferable[] transferableArray = this.dragDropListener.dragStarted(dragGestureEvent);
            List<Transferable> list = transferableArray.length > 0 ? Arrays.asList(transferableArray) : Collections.EMPTY_LIST;
            arrayList.addAll(list);
            ArrayList arrayList2 = this.getTransferablesForSelection(list);
            if (arrayList2.size() == 1) {
                arrayList.addAll(arrayList2);
            } else {
                TransferablesList transferablesList = TransferablesList.getInstance();
                transferablesList.initialize(arrayList2);
                arrayList.add(transferablesList);
            }
            MultiTransferable multiTransferable = new MultiTransferable(arrayList);
            this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveNoDrop, multiTransferable, this);
        }
    }

    private void updateCursor(DragSourceDragEvent dragSourceDragEvent) {
        int n = dragSourceDragEvent.getDropAction();
        if (n == 1) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (n == 2) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    private ArrayList getTransferablesForSelection(List list) {
        ArrayList<MultiTransferable> arrayList = new ArrayList<MultiTransferable>();
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            DragDropManager dragDropManager = DragDropManager.getInstance();
            int n = 0;
            while (n < treePathArray.length) {
                ArrayList<Transferable> arrayList2 = new ArrayList<Transferable>();
                TreePath treePath = treePathArray[n];
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                Iterator iterator = dragDropManager.getDragHelpers(object.getClass());
                while (iterator.hasNext()) {
                    DragHelper dragHelper = (DragHelper)iterator.next();
                    Transferable transferable = dragHelper.getTransferable(object);
                    if (transferable == null) continue;
                    arrayList2.add(transferable);
                }
                arrayList2.add(new TransferableTreeNode(defaultMutableTreeNode));
                arrayList2.addAll(list);
                arrayList.add(new MultiTransferable(arrayList2));
                ++n;
            }
        }
        return arrayList;
    }
}

