/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.util.dnd.DragDropManager;
import oracle.ide.util.dnd.DropHelper;
import oracle.ide.util.dnd.TransferablesList;

public class JTreeDropHandler
implements DropTargetListener {
    private final JTree tree;
    private final DropTarget dropTarget;
    private DropHelper activeDropHelper;
    private DefaultMutableTreeNode targetDropNode;

    public JTreeDropHandler(JTree jTree, int n) {
        this.tree = jTree;
        this.dropTarget = new DropTarget(this.tree, n, this);
    }

    public final void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.updateDragFeedback(dropTargetDragEvent);
    }

    public final void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.updateDragFeedback(dropTargetDragEvent);
    }

    public final void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.updateDragFeedback(dropTargetDragEvent);
    }

    public final void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public final void drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        try {
            try {
                int n = dropTargetDropEvent.getDropAction();
                Point point = dropTargetDropEvent.getLocation();
                TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
                DefaultMutableTreeNode defaultMutableTreeNode = this.targetDropNode = treePath != null ? (DefaultMutableTreeNode)treePath.getLastPathComponent() : null;
                if (this.targetDropNode != null && this.activeDropHelper != null) {
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    if (transferable.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
                        ArrayList arrayList = (ArrayList)transferable.getTransferData(TransferablesList.TRANSFERABLE_LIST_FLAVOR);
                        Transferable[] transferableArray = new Transferable[arrayList.size()];
                        arrayList.toArray(transferableArray);
                        if (arrayList != null && this.canTransferSelection(this.activeDropHelper, arrayList, n) && this.activeDropHelper.transferData(this.targetDropNode, transferableArray, n)) {
                            dropTargetDropEvent.acceptDrop(n);
                            bl = true;
                        }
                    } else if (this.activeDropHelper.canTransferData(this.targetDropNode, transferable.getTransferDataFlavors(), n)) {
                        dropTargetDropEvent.acceptDrop(this.tree.getDropTarget().getDefaultActions());
                        if (this.activeDropHelper.transferData(this.targetDropNode, new Transferable[]{transferable}, n)) {
                            bl = true;
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            dropTargetDropEvent.dropComplete(bl);
            this.cleanUp();
        }
    }

    private boolean canTransferSelection(DropHelper dropHelper, List list, int n) {
        for (Transferable transferable : list) {
            if (dropHelper.canTransferData(this.targetDropNode, transferable.getTransferDataFlavors(), n)) continue;
            return false;
        }
        return true;
    }

    private void updateDragFeedback(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        int n = dropTargetDragEvent.getDropAction();
        TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
        DefaultMutableTreeNode defaultMutableTreeNode = this.targetDropNode = treePath != null ? (DefaultMutableTreeNode)treePath.getLastPathComponent() : null;
        if (this.targetDropNode != null) {
            Object object = this.targetDropNode.getUserObject();
            Iterator iterator = DragDropManager.getInstance().getDropHelpers(object.getClass());
            while (iterator.hasNext()) {
                DropHelper dropHelper = (DropHelper)iterator.next();
                DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
                if (dropTargetDragEvent.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
                    try {
                        List list = (List)TransferablesList.getInstance().getTransferData(TransferablesList.TRANSFERABLE_LIST_FLAVOR);
                        if (this.canTransferSelection(dropHelper, list, n)) {
                            this.tree.setSelectionPath(treePath);
                            this.activeDropHelper = dropHelper;
                            dropTargetDragEvent.acceptDrag(n);
                            return;
                        }
                        dropTargetDragEvent.rejectDrag();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        dropTargetDragEvent.rejectDrag();
                    }
                }
                if (!dropHelper.canTransferData(this.targetDropNode, dataFlavorArray, n)) continue;
                this.tree.setSelectionPath(treePath);
                this.activeDropHelper = dropHelper;
                dropTargetDragEvent.acceptDrag(n);
                return;
            }
        }
        dropTargetDragEvent.rejectDrag();
    }

    private void cleanUp() {
        this.activeDropHelper = null;
        this.targetDropNode = null;
        TransferablesList.getInstance().clear();
    }
}

