/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.ide.extension.Extension;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.Version;
import oracle.ide.controls.SplashScreen;
import oracle.ide.migration.MigrationManager;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideimpl.extension.AddinInfo;
import oracle.ideimpl.extension.AddinsHook;

public final class AddinManagerImpl
extends AddinManager {
    private final Map _addinInstancesByClassName;
    private List _addinInfos;
    private Properties _properties;
    private static AddinManagerImpl _instance = new AddinManagerImpl();
    private boolean _useMinAddins;
    private boolean _addinsLoaded;

    void $init$() {
        this._addinInstancesByClassName = new LinkedHashMap();
        this._addinInfos = null;
        this._properties = null;
        this._useMinAddins = false;
        this._addinsLoaded = false;
    }

    public static AddinManager createInstance() {
        return _instance;
    }

    public final Properties getProductProperties() {
        if (this._properties == null) {
            this._properties = new Properties();
        }
        return this._properties;
    }

    List getAddinInfos() {
        if (this._addinInfos == null) {
            this._addinInfos = new ArrayList();
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            AddinsHook addinsHook = (AddinsHook)extensionRegistry.getIdeHook(AddinsHook.ELEMENT);
            if (addinsHook != null) {
                this._addinInfos.addAll(addinsHook.getAddinInfos());
            }
        }
        return this._addinInfos;
    }

    protected final synchronized void initProductAndUserAddins() {
        IdeArgs ideArgs = Ide.getIdeArgs();
        this._useMinAddins = !ideArgs.getCreateUI() && !ideArgs.hasArg("-make") && !ideArgs.hasArg("-rebuild");
        try {
            this.initializeAddins(null);
        }
        finally {
            this._addinsLoaded = true;
        }
    }

    public synchronized void initAddinLoadset(String string) {
        if (string == null) {
            throw new NullPointerException("loadsetName is null");
        }
        try {
            PerformanceLogger.get().startTiming("addinLoadSet_" + string, "Initializing Addin loadset " + string + "...");
            this.initializeAddins(string);
        }
        finally {
            PerformanceLogger.get().stopTiming("addinLoadSet_" + string, "Initialized Addin loadset " + string);
        }
    }

    private int getCurrentNumberOfClasses() {
        if (Version.DEBUG_BUILD != 0) {
            try {
                Field field = ClassLoader.class.getDeclaredField("classes");
                field.setAccessible(true);
                Vector vector = (Vector)field.get(Thread.currentThread().getContextClassLoader());
                int n = vector.size();
                return n;
            }
            catch (Exception exception) {
                int n = 0;
                return n;
            }
        }
        return 0;
    }

    private void initializeAddins(String string) {
        Iterator iterator = this.getAddinInfos().iterator();
        while (iterator.hasNext()) {
            try {
                AddinInfo addinInfo = (AddinInfo)iterator.next();
                if ((string != null || addinInfo.getLoadSet() != null) && (string == null || !string.equals(addinInfo.getLoadSet()))) continue;
                int n = this.getCurrentNumberOfClasses();
                try {
                    if (!this.createAddin(addinInfo)) continue;
                    this.initializeAddin(addinInfo, this.getAddin(addinInfo.getClassName()));
                }
                finally {
                    int n2 = this.getCurrentNumberOfClasses() - n;
                    addinInfo.setClassesLoaded(n2);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                throwable.printStackTrace();
            }
        }
    }

    public synchronized boolean registerAddin(String string) {
        AddinInfo addinInfo = new AddinInfo(string);
        if (this.createAddin(addinInfo)) {
            this.getAddinInfos().add(addinInfo);
            this.initializeAddin(addinInfo, this.getAddin(string));
            return true;
        }
        return false;
    }

    public final String getCommand(String string, String string2) {
        if (string == null) {
            return null;
        }
        Properties properties = this.getProductProperties();
        String string3 = properties.getProperty(string, string2);
        return string3;
    }

    public final String getCommand(int n, String string) {
        String string2 = Ide.findCmdName(n);
        if (string2 == null) {
            return string;
        }
        return this.getCommand(string2, string);
    }

    public synchronized Addin getAddin(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is null");
        }
        Addin addin = (Addin)this._addinInstancesByClassName.get(clazz.getName());
        if (addin == null && clazz.isInterface()) {
            Iterator iterator = this._addinInstancesByClassName.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    String string = (String)iterator.next();
                    Class<?> clazz2 = Class.forName(string);
                    if (!clazz.isAssignableFrom(clazz2)) continue;
                    addin = (Addin)this._addinInstancesByClassName.get(clazz2.getName());
                    this._addinInstancesByClassName.put(clazz.getName(), addin);
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return addin;
    }

    public Addin getAddin(String string) {
        if (string == null) {
            throw new NullPointerException("className is null");
        }
        return (Addin)this._addinInstancesByClassName.get(string);
    }

    public final void addCommand(String string, String string2) {
        if (this._properties == null) {
            this._properties = new Properties();
        }
        this._properties.setProperty(string, string2);
    }

    public void initialize() {
        MigrationManager migrationManager = MigrationManager.getMigrationManager();
        if (migrationManager != null) {
            migrationManager.migrate();
        }
    }

    private AddinManagerImpl() {
        this.$init$();
    }

    private void initializeAddin(AddinInfo addinInfo, Addin addin) {
        long l = System.currentTimeMillis();
        try {
            addin.initialize();
        }
        finally {
            long l2 = System.currentTimeMillis() - l;
            addinInfo.addTimeToLoad(l2);
            PerformanceLogger.get().log(Level.INFO, addinInfo.getClassName(), addinInfo.getTimeToLoad());
            addinInfo.setLoaded(true);
        }
    }

    private boolean createAddin(AddinInfo addinInfo) {
        String string = addinInfo.getClassName();
        Addin addin = this.getAddin(string);
        if (addin == null) {
            SplashScreen.log(null);
            Class<?> clazz = null;
            try {
                long l = System.currentTimeMillis();
                clazz = Class.forName(string);
                long l2 = System.currentTimeMillis() - l;
                addinInfo.addTimeToLoad(l2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ExtensionRegistry.getOracleRegistry().getManifestLogger().log(Level.SEVERE, "Addin " + string + " does not exist.", addinInfo.getLocator());
                classNotFoundException.printStackTrace();
                boolean bl = false;
                return bl;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                ExtensionRegistry.getOracleRegistry().getManifestLogger().log(Level.SEVERE, "No class def found for addin " + string, addinInfo.getLocator());
                noClassDefFoundError.printStackTrace();
                boolean bl = false;
                return bl;
            }
            try {
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                long l = System.currentTimeMillis();
                addin = (Addin)constructor.newInstance(new Object[0]);
                long l3 = System.currentTimeMillis() - l;
                addinInfo.addTimeToLoad(l3);
                this._addinInstancesByClassName.put(string, addin);
                boolean bl = true;
                return bl;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ExtensionRegistry.getOracleRegistry().getManifestLogger().log(Level.SEVERE, "Addin " + string + " does not have a no-argument constructor", addinInfo.getLocator());
                noSuchMethodException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                ExtensionRegistry.getOracleRegistry().getLogger().log(Level.SEVERE, "Failed to create addin " + string, addinInfo.getLocator());
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                ExtensionRegistry.getOracleRegistry().getLogger().log(Level.SEVERE, "Failed to create addin " + string, addinInfo.getLocator());
                illegalAccessException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                ExtensionRegistry.getOracleRegistry().getLogger().log(Level.SEVERE, "Failed to create addin " + string, addinInfo.getLocator());
                instantiationException.printStackTrace();
            }
        }
        return false;
    }

    void setProperty(String string, String string2) {
        if (this._properties == null) {
            this._properties = new Properties();
        }
        this._properties.setProperty(string, string2);
    }

    public Extension getExtensionForAddin(Addin addin) {
        if (addin == null) {
            throw new NullPointerException("addin is null");
        }
        AddinInfo addinInfo = this.findAddinInfo(addin);
        if (addinInfo == null) {
            throw new IllegalArgumentException("Unregistered addin:" + addin);
        }
        return addinInfo.getExtension();
    }

    private AddinInfo findAddinInfo(Addin addin) {
        return this.findAddinInfo(addin.getClass().getName());
    }

    private AddinInfo findAddinInfo(String string) {
        for (AddinInfo addinInfo : this.getAddinInfos()) {
            if (!string.equals(addinInfo.getClassName())) continue;
            return addinInfo;
        }
        return null;
    }

    public boolean isRegisteredAddin(String string) {
        return this.findAddinInfo(string) != null;
    }
}

