/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.IDE;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.extension.spi.BaseExtensionVisitor;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.DefaultHookVisitorFactory;
import javax.ide.extension.spi.DependenciesVisitor;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.extension.spi.Feature;
import javax.ide.extension.spi.FeatureHook;
import javax.ide.extension.spi.FeatureRegistry;
import javax.ide.extension.spi.JARExtensionSource;
import javax.ide.extension.spi.SAXManifestParser;
import javax.ide.model.DocumentFactory;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeHook;
import oracle.ide.IdeListener;
import oracle.ide.Version;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorUtil;
import oracle.ide.help.AboutBoxFactory;
import oracle.ide.model.Locatable;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Navigable;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.Pair;
import oracle.ideimpl.extension.AddinsAboutPage;
import oracle.ideimpl.extension.ExtensionInfo;
import oracle.ideimpl.extension.IDEElementContext;
import oracle.ideimpl.extension.LegacyExtensionSource;
import oracle.ideimpl.extension.LocatorImpl;
import oracle.ideimpl.extension.MessagePresenter;
import oracle.ideimpl.extension.MutableURLClassLoader;
import oracle.ideimpl.extension.SystemProperty;
import oracle.ideimpl.extension.preference.ExtensionOptionsPanel;
import oracle.ideimpl.extension.preference.ExtensionPreferences;
import oracle.ideimpl.resource.ExtensionManagerArb;
import oracle.javatools.dialogs.MessageDialog;
import org.xml.sax.InputSource;

public final class ExtensionManagerImpl
extends ExtensionRegistry {
    private MessagePresenter _msgPresenter;
    private ExtensionSet _extensionSet;
    private Set _newlyInstalledIds;
    private static final String EXTMAN_PREFS = "extension-prefs.xml";
    private final Set _disabledExtensionIds;
    private final Map _disabledExtensions;
    private final Map _disabledFeaturesByExtension;
    private final Map _disabledReasons;
    private DefaultHookVisitorFactory _hookFactory;

    void $init$() {
        this._newlyInstalledIds = new HashSet();
        this._disabledExtensionIds = new HashSet();
        this._disabledExtensions = new HashMap();
        this._disabledFeaturesByExtension = new HashMap();
        this._disabledReasons = new HashMap();
    }

    public ExtensionManagerImpl() {
        this.$init$();
    }

    public URL getSystemDirectory(String string) {
        if (string == null) {
            throw new NullPointerException("extensionId is null");
        }
        if (string.equals("oracle.ide")) {
            return this.getSystemDirectory("oracle.ide", new javax.ide.util.Version(Version.VER_FULL));
        }
        Extension extension = this.findExtension(string);
        if (extension == null) {
            Collection collection = this.getDisabledExtensions();
            if (collection.contains(string)) {
                extension = this.findDisabledExtension(string);
            } else {
                throw new IllegalArgumentException("Unrecognized extension id " + string);
            }
        }
        return this.getSystemDirectory(string, extension.getVersion());
    }

    public URL getSystemDirectory(String string, javax.ide.util.Version version) {
        if (string == null) {
            throw new NullPointerException("extensionId is null");
        }
        if (version == null) {
            throw new NullPointerException("version is null");
        }
        return URLFactory.newDirURL(URLFactory.newDirURL(Ide.getSystemDirectory()), string + "." + version.toCanonicalString());
    }

    public boolean isLoaded(String string) {
        return this.getDisabledExtensions().contains(string) ^ true;
    }

    public boolean isUserExtension(String string) {
        if (string == null) {
            throw new NullPointerException("extensionId is null");
        }
        try {
            ExtensionSource extensionSource = ((DefaultExtension)this.findExtension(string)).getSource();
            if (extensionSource instanceof JARExtensionSource) {
                JARExtensionSource jARExtensionSource = (JARExtensionSource)extensionSource;
                String string2 = URLFileSystem.getPlatformPathName(VirtualFileSystem.getVirtualFileSystem().toURL(jARExtensionSource.getURI()));
                boolean bl = !Ide.getHomeDirectory().equals(Ide.getUserHomeDirectory()) && string2.startsWith(Ide.getUserHomeDirectory());
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }

    public Collection getAllExtensions() {
        ArrayList<Extension> arrayList = new ArrayList<Extension>(this.getExtensions());
        Collection collection = this.getDisabledExtensions();
        for (String string : collection) {
            arrayList.add(this.findDisabledExtension(string));
        }
        return arrayList;
    }

    public Collection getDisabledExtensions() {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Pair pair : this._disabledExtensionIds) {
            hashSet.add(pair.getFirst());
        }
        return hashSet;
    }

    public Extension findExtensionEvenIfNotLoaded(String string) {
        Extension extension = this.findExtension(string);
        if (extension == null && this.getDisabledExtensions().contains(string)) {
            extension = this.findDisabledExtension(string);
        }
        return extension;
    }

    public Extension findDisabledExtension(String string) {
        Extension extension = (Extension)this._disabledExtensions.get(string);
        if (extension == null) {
            javax.ide.util.Version version = null;
            for (Pair pair : this._disabledExtensionIds) {
                if (!pair.getFirst().equals(string)) continue;
                javax.ide.util.Version version2 = (javax.ide.util.Version)pair.getSecond();
                if (version != null && version2.compareTo((Object)version) <= 0) continue;
                version = version2;
            }
            if (version == null) {
                throw new IllegalArgumentException("Unknown extension " + string);
            }
            extension = this.loadDisabledExtension(string, version);
            this._disabledExtensions.put(string, extension);
        }
        return extension;
    }

    protected void loadExtension(SAXManifestParser sAXManifestParser, Logger logger, ExtensionSource extensionSource) {
        String string = extensionSource.getName();
        int n = string.lastIndexOf(47);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        PerformanceLogger.get().startTiming("init_extension_" + string);
        super.loadExtension(sAXManifestParser, logger, extensionSource);
        PerformanceLogger.get().stopTiming("init_extension_" + string, "Processed extension " + string);
    }

    private Extension loadDisabledExtension(String string, javax.ide.util.Version version) {
        Extension extension = null;
        String string2 = this.getExtensionJAR(string, version, true);
        if (string2 != null && !version.equals((Object)(extension = this.loadDisabledExtension(string, version, string2)).getVersion()) && (string2 = this.getExtensionJAR(string, version, false)) != null) {
            extension = this.loadDisabledExtension(string, version, string2);
        }
        if (extension == null) {
            DefaultExtension defaultExtension = new DefaultExtension(string);
            defaultExtension.setVersion(version);
            return defaultExtension;
        }
        return extension;
    }

    private Extension loadDisabledExtension(String string, javax.ide.util.Version version, String string2) {
        JARExtensionSourceFixed jARExtensionSourceFixed = new JARExtensionSourceFixed(URIFactory.newURI((String)string2));
        SAXManifestParser sAXManifestParser = new SAXManifestParser((DefaultElementContext)this.createInitialContext());
        DisabledExtensionVisitor disabledExtensionVisitor = new DisabledExtensionVisitor(null);
        sAXManifestParser.getContext().registerChildVisitor(ExtensionVisitor.ELEMENT, (ElementVisitor)disabledExtensionVisitor);
        sAXManifestParser.getContext().getScopeData().put("extSource", jARExtensionSourceFixed);
        MutableURLClassLoader mutableURLClassLoader = new MutableURLClassLoader(new URL[]{URLFactory.newURL(string2)}, Thread.currentThread().getContextClassLoader());
        sAXManifestParser.getContext().getScopeData().put("classLoader", mutableURLClassLoader);
        InputStream inputStream = null;
        try {
            try {
                inputStream = VirtualFileSystem.getVirtualFileSystem().openInputStream(jARExtensionSourceFixed.getManifestURI());
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setSystemId(jARExtensionSourceFixed.getManifestURI().toString());
                sAXManifestParser.parse(inputSource);
                Extension extension = disabledExtensionVisitor.getExtension();
                Feature feature = disabledExtensionVisitor.getFeature();
                if (feature != null) {
                    this._disabledFeaturesByExtension.put(extension, feature);
                }
                Extension extension2 = extension;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return extension2;
            }
            catch (Exception exception) {
                DefaultExtension defaultExtension = new DefaultExtension(string);
                defaultExtension.setVersion(version);
                DefaultExtension defaultExtension2 = defaultExtension;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return defaultExtension2;
            }
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
    }

    public Feature getFeature(Extension extension) {
        Feature feature = FeatureRegistry.getFeatureRegistry().getFeature(extension);
        if (feature == null) {
            return this.getDisabledFeature(extension);
        }
        return feature;
    }

    private Feature getDisabledFeature(Extension extension) {
        Collection collection = this.getDisabledExtensions();
        if (collection.contains(extension.getID())) {
            Extension extension2 = this.findDisabledExtension(extension.getID());
            return (Feature)this._disabledFeaturesByExtension.get(extension2);
        }
        return null;
    }

    protected ElementContext createInitialContext() {
        return new IDEElementContext();
    }

    protected ElementVisitorFactory createHookVisitorFactory() {
        this._hookFactory = new DefaultHookVisitorFactory();
        return this._hookFactory;
    }

    protected Logger createExtensionLogger() {
        Logger logger = super.createExtensionLogger();
        logger.setUseParentHandlers(false);
        if (this._msgPresenter == null) {
            this._msgPresenter = new MessagePresenter();
            logger.addHandler(this._msgPresenter);
        }
        this._manifestLogger = logger;
        return logger;
    }

    protected ExtensionVisitor createExtensionVisitor(ElementVisitorFactory elementVisitorFactory) {
        return new 4(elementVisitorFactory);
    }

    protected void addToClassPath(ExtensionSource extensionSource) {
        try {
            URI uRI = extensionSource.getClasspathEntry();
            if (uRI != null) {
                URL uRL = VirtualFileSystem.getVirtualFileSystem().toURL(uRI);
                this.addURLToClassPath(Collections.singletonList(uRL));
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    protected Collection findAllExtensionSources() {
        File file = new File(Ide.getUserHomeDirectory());
        File file2 = new File(Ide.getOracleHomeDirectory(), "jdev");
        ArrayList arrayList = new ArrayList();
        if (!file.equals(file2)) {
            arrayList.addAll(this.findExtensionSources(new File(file, "extensions")));
            arrayList.addAll(this.findLegacySources(new File(file, "lib/ext")));
        }
        arrayList.addAll(this.findExtensionSources(new File(file2, "extensions")));
        arrayList.addAll(this.findLegacySources(new File(file2, "lib/ext")));
        return arrayList;
    }

    private Collection findLegacySources(File file) {
        if (SystemProperty.getBoolean("ide.extension.legacy.disabled")) {
            return Collections.EMPTY_LIST;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LegacyExtensionSource> arrayList = new ArrayList<LegacyExtensionSource>();
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (this.isCandidateExtensionArchive(file2)) {
                URI uRI = URIFactory.newURI((String)file2.getAbsolutePath());
                LegacyExtensionSource legacyExtensionSource = new LegacyExtensionSource(uRI);
                if (legacyExtensionSource.getManifestURI() == null) {
                    try {
                        arrayList2.add(VirtualFileSystem.getVirtualFileSystem().toURL(uRI));
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                } else {
                    if (!SystemProperty.getBoolean("ide.extension.legacy.nowarn")) {
                        LocatorImpl locatorImpl = new LocatorImpl(legacyExtensionSource.getManifestURI().toString());
                        this.getManifestLogger().log(Level.WARNING, ExtensionManagerArb.getString(29), locatorImpl);
                        this.getManifestLogger().log(Level.WARNING, ExtensionManagerArb.format(30, "ide.extension.legacy.nowarn"), locatorImpl);
                        this.getManifestLogger().log(Level.WARNING, ExtensionManagerArb.format(31, "ide.extension.legacy.disabled"), locatorImpl);
                    }
                    arrayList.add(legacyExtensionSource);
                }
            }
            ++n;
        }
        this.addURLToClassPath(arrayList2);
        return arrayList;
    }

    private Collection findExtensionSources(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<JARExtensionSourceFixed> arrayList = new ArrayList<JARExtensionSourceFixed>();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (this.isCandidateExtensionArchive(file2)) {
                URI uRI = URIFactory.newURI((String)file2.getAbsolutePath());
                arrayList.add(new JARExtensionSourceFixed(uRI));
            }
            ++n;
        }
        return arrayList;
    }

    private boolean isCandidateExtensionArchive(File file) {
        return file.getName().toUpperCase().endsWith(".JAR");
    }

    protected void initialize() {
        super.initialize();
        this.postLoadedExtensions();
    }

    private void postLoadedExtensions() {
        for (Extension extension : this.getExtensions()) {
            ExtensionSource extensionSource;
            boolean bl;
            URL uRL = this.getSystemDirectory(extension.getID());
            if (!URLFileSystem.exists(uRL)) {
                this._newlyInstalledIds.add(extension.getID());
            }
            if ((bl = SystemProperty.getBoolean("ide.extension.badname.nowarn")) || !(extension instanceof DefaultExtension) || !((extensionSource = ((DefaultExtension)extension).getSource()) instanceof JARExtensionSource) || extensionSource instanceof LegacyExtensionSource) continue;
            URI uRI = ((JARExtensionSource)extensionSource).getURI();
            String string = VirtualFileSystem.getVirtualFileSystem().getFileName(uRI);
            if (string.startsWith(extension.getID())) continue;
            this.getManifestLogger().log(Level.WARNING, ExtensionManagerArb.format(32, "'" + extension.getID() + ".jar'", "'" + string + "'"), new LocatorImpl(extensionSource.getManifestURI().toString()));
        }
        Navigable navigable = new Navigable(ExtensionManagerArb.getString(19), ExtensionOptionsPanel.class);
        ClientSetting.registerUI(navigable);
        Ide.addIdeListener(new 3());
        IDE.getIDE();
        DocumentFactory.getDocumentFactory();
    }

    private void installConvertUtility() {
        String string = "oracle.ideimpl.extension.ConvertToExtension";
        int n = Ide.findOrCreateCmdID("oracle.ideimpl.extension.ConvertToExtension");
        IdeAction ideAction = IdeAction.get(n, "", ExtensionManagerArb.getString(33));
        2 var4_4 = new 2(this, string);
        ideAction.addController(var4_4);
        1 var5_5 = new 1(this, string);
        NavigatorManager.getWorkspaceNavigatorManager().addContextMenuListener(var5_5, null);
    }

    private void convertLegacyManifest(Context context) {
        if (context.getSelection() != null && context.getSelection().length == 1 && context.getSelection()[0] instanceof Locatable) {
            URL uRL = ((Locatable)((Object)context.getSelection()[0])).getURL();
            URI uRI = URIFactory.newURI((String)uRL.toString());
            LegacyExtensionSource legacyExtensionSource = new LegacyExtensionSource(uRI);
            legacyExtensionSource.setManifestURI(uRI);
            URL uRL2 = URLFactory.newURL(URLFileSystem.getParent(uRL), "extension.xml");
            if (URLFileSystem.exists(uRL2)) {
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)ExtensionManagerArb.getString(34), (String)ExtensionManagerArb.getString(35), null);
                return;
            }
            InputStream inputStream = null;
            try {
                try {
                    IdeAction ideAction;
                    inputStream = legacyExtensionSource.getInputStream();
                    URLFileSystem.copy(inputStream, uRL2);
                    Editor editor = EditorUtil.openDefaultEditorInFrame(uRL2);
                    Integer n = Ide.findCmdID("PrettyPrintXMLCommand");
                    if (n != null && (ideAction = IdeAction.find(n)) != null) {
                        ideAction.performAction(editor.getContext());
                        editor.getContext().getNode().save();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)ExtensionManagerArb.getString(36), (String)ExtensionManagerArb.getString(35), null);
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }

    final void registerHook(ElementName elementName, IdeHook ideHook) {
        super.registerIdeHook(elementName, ideHook);
    }

    String getNotLoadedReason(String string) {
        String string2 = (String)this._disabledReasons.get(string);
        if (string2 == null) {
            string2 = ExtensionManagerArb.getString(37);
        }
        return string2;
    }

    protected void unsatisfiedExtensionDependencies(Extension extension, Collection collection) {
        Pair pair = new Pair(extension.getID(), extension.getVersion());
        this._disabledExtensionIds.add(pair);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Disabled due to missing dependencies: ");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ExtensionDependency extensionDependency = (ExtensionDependency)iterator.next();
            stringBuffer.append(extensionDependency.getID());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        String string = ExtensionManagerArb.format(38, stringBuffer.toString());
        this._disabledReasons.put(extension.getID(), string);
    }

    protected boolean isExtensionEnabled(String string, javax.ide.util.Version version) {
        boolean bl;
        if (this._extensionSet == null) {
            try {
                this._extensionSet = new ExtensionSet(null);
                this._extensionSet.load();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this._extensionSet = new NullExtensionSet();
            }
        }
        if (!(bl = this._extensionSet.isExtensionEnabled(string, version))) {
            this._disabledExtensionIds.add(new Pair(string, version));
            this._disabledReasons.put(string, ExtensionManagerArb.getString(39));
        }
        return bl;
    }

    private void addURLToClassPath(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        try {
            URLClassLoader uRLClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName("java.net.URLClassLoader");
            Class[] classArray = new Class[]{Class.forName("java.net.URL")};
            Method method = clazz.getDeclaredMethod("addURL", classArray);
            method.setAccessible(true);
            HashSet<URL> hashSet = new HashSet<URL>();
            hashSet.addAll(Arrays.asList(uRLClassLoader.getURLs()));
            for (URL uRL : collection) {
                if (hashSet.contains(uRL)) continue;
                Object[] objectArray = new Object[]{uRL};
                try {
                    method.invoke((Object)uRLClassLoader, objectArray);
                    URL uRL2 = URLFactory.newDirURL(System.getProperty("user.dir"));
                    String string = URLFileSystem.toRelativeSpec(uRL, uRL2);
                    if (File.separatorChar != '/') {
                        string = string.replace('/', File.separatorChar);
                    }
                    String string2 = System.getProperty("java.class.path") + ";" + string;
                    System.setProperty("java.class.path", string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addToDisabledClasspath(ElementContext elementContext, URI uRI) {
        ClassLoader classLoader = (ClassLoader)elementContext.getScopeData().get("classLoader");
        if (classLoader instanceof MutableURLClassLoader) {
            try {
                URL uRL = VirtualFileSystem.getVirtualFileSystem().toURL(uRI);
                ((MutableURLClassLoader)classLoader).addURL(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                this.getLogger().log(Level.WARNING, "Malformed URL", malformedURLException);
            }
        }
    }

    public boolean isNewlyInstalled(String string) {
        return this._newlyInstalledIds.contains(string);
    }

    static void mav$addURLToClassPath(ExtensionManagerImpl extensionManagerImpl, Collection collection) {
        extensionManagerImpl.addURLToClassPath(collection);
    }

    static void mav$installConvertUtility(ExtensionManagerImpl extensionManagerImpl) {
        extensionManagerImpl.installConvertUtility();
    }

    static void mav$convertLegacyManifest(ExtensionManagerImpl extensionManagerImpl, Context context) {
        extensionManagerImpl.convertLegacyManifest(context);
    }

    static void mav$addToDisabledClasspath(ExtensionManagerImpl extensionManagerImpl, ElementContext elementContext, URI uRI) {
        extensionManagerImpl.addToDisabledClasspath(elementContext, uRI);
    }

    public final class 4
    extends ExtensionVisitor {
        public void addToClasspath(ElementContext elementContext, Extension extension, URI uRI) {
            try {
                URL uRL = VirtualFileSystem.getVirtualFileSystem().toURL(uRI);
                if (!URLFileSystem.exists(uRL)) {
                    if (!SystemProperty.getBoolean("ide.extension.cpmissing.nowarn")) {
                        this.log(elementContext, Level.WARNING, "Classpath entry " + URLFileSystem.getPlatformPathName(uRL) + " not found.");
                    }
                } else {
                    String string = uRL.toString();
                    if (string.charAt(string.length() - 1) != '/' && !string.endsWith("jar") && !string.endsWith("zip") && URLFileSystem.isDirectory(uRL)) {
                        uRL = URLFactory.newURL(string + '/');
                    }
                    ExtensionManagerImpl.mav$addURLToClassPath(ExtensionManagerImpl.this, Collections.singletonList(uRL));
                }
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }

        public 4(ElementVisitorFactory elementVisitorFactory) {
            super(elementVisitorFactory);
        }
    }

    private class JARExtensionSourceFixed
    extends JARExtensionSource {
        JARExtensionSourceFixed(URI uRI) {
            super(uRI);
        }

        public URI resolvePath(Extension extension, String string) {
            File file;
            if (string.length() >= 2 && string.charAt(0) == '/') {
                URI uRI = URIFactory.newJarURI((URI)this.getURI(), (String)string.substring(1));
                if (VirtualFileSystem.getVirtualFileSystem().exists(uRI)) {
                    return uRI;
                }
            }
            if ((file = new File(string)).isAbsolute()) {
                return URIFactory.newFileURI((File)file);
            }
            URI uRI = VirtualFileSystem.getVirtualFileSystem().getParent(this.getURI());
            return URIFactory.newURI((URI)uRI, (String)string);
        }
    }

    public final class 3
    implements IdeListener {
        public void addinsLoaded(IdeEvent ideEvent) {
            Ide.removeIdeListener(this);
            ExtensionManagerImpl.mav$installConvertUtility(ExtensionManagerImpl.this);
            AboutBoxFactory.getAboutBoxFactory().addPage(ExtensionInfo.class);
            if (Version.DEBUG_BUILD != 0) {
                AboutBoxFactory.getAboutBoxFactory().addPage(AddinsAboutPage.class);
            }
        }

        public void mainWindowOpened(IdeEvent ideEvent) {
        }

        public void mainWindowClosing(IdeEvent ideEvent) {
        }
    }

    public final class 2
    implements Controller {
        private final /* synthetic */ String v$CMDID;
        final /* synthetic */ ExtensionManagerImpl this$0;

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == Ide.findCmdID(this.v$CMDID).intValue()) {
                ExtensionManagerImpl.mav$convertLegacyManifest(this.this$0, context);
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }

        public 2(ExtensionManagerImpl extensionManagerImpl, String string) {
            this.v$CMDID = string;
            this.this$0 = extensionManagerImpl;
        }
    }

    public final class 1
    implements ContextMenuListener {
        private final /* synthetic */ String v$CMDID;
        final /* synthetic */ ExtensionManagerImpl this$0;

        public void menuWillShow(ContextMenu contextMenu) {
            URL uRL;
            Context context = contextMenu.getContext();
            if (context.getSelection() != null && context.getSelection().length == 1 && context.getSelection()[0] instanceof Locatable && URLFileSystem.getFileName(uRL = ((Locatable)((Object)context.getSelection()[0])).getURL()).equalsIgnoreCase("jdev-ext.xml")) {
                contextMenu.add((Component)contextMenu.createMenuItem(IdeAction.find(Ide.findCmdID(this.v$CMDID))), 1.0f);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public 1(ExtensionManagerImpl extensionManagerImpl, String string) {
            this.v$CMDID = string;
            this.this$0 = extensionManagerImpl;
        }
    }

    private final class NullExtensionSet
    extends ExtensionSet {
        public NullExtensionSet() {
            super(null);
        }

        public boolean isExtensionEnabled(String string, javax.ide.util.Version version) {
            return true;
        }
    }

    private class ExtensionSet {
        private Set _disabledExtensions;
        private Set _enabledExtensions;

        public boolean isExtensionEnabled(String string, javax.ide.util.Version version) {
            if (this._disabledExtensions != null) {
                return this._disabledExtensions.contains(string) ^ true;
            }
            if (this._enabledExtensions != null) {
                return this._enabledExtensions.contains(string);
            }
            return true;
        }

        public void load() throws Exception {
            String string = System.getProperty("ide.extensions");
            String string2 = System.getProperty("ide.noextensions");
            if (string != null && string2 != null) {
                throw new Exception("Must set only one of ide.noextensions or ide.extensions");
            }
            if (string != null) {
                this._enabledExtensions = this.getSet(string.trim());
            } else if (string2 != null) {
                this._disabledExtensions = this.getSet(string2.trim());
            } else {
                ClientSetting clientSetting = ClientSetting.findOrCreate("oracle.ide", ExtensionManagerImpl.EXTMAN_PREFS);
                ExtensionPreferences extensionPreferences = (ExtensionPreferences)clientSetting.getData("disabled.extensions.1013prod");
                if (extensionPreferences != null) {
                    this._disabledExtensions = new HashSet(extensionPreferences.getDisabledIds());
                } else {
                    extensionPreferences = new ExtensionPreferences();
                    extensionPreferences.setDisabledIds(new HashSet());
                    clientSetting.putData("disabled.extensions.1013prod", extensionPreferences);
                }
            }
        }

        private Set getSet(String string) throws IOException {
            HashSet<String> hashSet = new HashSet<String>();
            if (string.charAt(0) == '@') {
                String string2 = string.substring(1);
                File file = new File(string2);
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    String string3 = bufferedReader.readLine();
                    while (string3 != null) {
                        if ((string3 = string3.trim()).length() > 0 && string3.charAt(0) != '#') {
                            hashSet.add(string3);
                        }
                        string3 = bufferedReader.readLine();
                    }
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
            return hashSet;
        }

        private ExtensionSet() {
        }

        ExtensionSet(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class CustomDependenciesVisitor
    extends DependenciesVisitor {
        private URI findExtensionJar(String string) {
            File file;
            File file2 = new File(Ide.getUserHomeDirectory(), "extensions");
            if (file2.exists() && file2.isDirectory()) {
                File[] fileArray = file2.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    File file3 = fileArray[n];
                    if (file3.getName().startsWith(string) && file3.getName().toUpperCase().endsWith(".JAR")) {
                        return URIFactory.newFileURI((String)file3.getPath());
                    }
                    ++n;
                }
            }
            if (!(file = new File(Ide.getHomeDirectory(), "extensions")).equals(file2) && file.exists() && file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    File file4 = fileArray[n];
                    if (file4.getName().startsWith(string) && file4.getName().toUpperCase().endsWith(".JAR")) {
                        return URIFactory.newFileURI((String)file4.getPath());
                    }
                    ++n;
                }
            }
            return null;
        }

        protected void addDependency(ElementContext elementContext, DefaultExtension defaultExtension, ExtensionDependency extensionDependency) {
            defaultExtension.addDependency(extensionDependency);
            URI uRI = this.findExtensionJar(extensionDependency.getID());
            if (uRI != null) {
                ExtensionManagerImpl.mav$addToDisabledClasspath(ExtensionManagerImpl.this, elementContext, uRI);
            }
        }

        private CustomDependenciesVisitor() {
        }

        CustomDependenciesVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class DisabledExtensionVisitor
    extends BaseExtensionVisitor {
        private final ElementName HOOKS;
        private Extension _extension;
        private Feature _feature;
        private FeatureHook _featureHook;
        private DependenciesVisitor _depVisitor;
        private BaseExtensionVisitor.ClasspathsVisitor _cpVisitor;

        void $init$() {
            this.HOOKS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "hooks");
            this._featureHook = new FeatureHook();
            this._depVisitor = new CustomDependenciesVisitor(null);
            this._cpVisitor = new BaseExtensionVisitor.ClasspathsVisitor((BaseExtensionVisitor)this);
        }

        public Extension getExtension() {
            return this._extension;
        }

        public Feature getFeature() {
            return this._feature;
        }

        public void addToClasspath(ElementContext elementContext, Extension extension, URI uRI) {
            ExtensionManagerImpl.mav$addToDisabledClasspath(ExtensionManagerImpl.this, elementContext, uRI);
        }

        public void start(ElementStartContext elementStartContext) {
            this._extension = this.processExtension(elementStartContext);
            String string = elementStartContext.getAttributeValue("rsbundle-class");
            if (string != null && (string = string.trim()).length() != 0) {
                elementStartContext.getScopeData().put("rsbundleclass", string);
            }
            elementStartContext.registerChildVisitor(this.HOOKS, (ElementVisitor)new 2());
            elementStartContext.registerChildVisitor(new ElementName("http://jcp.org/jsr/198/extension-manifest", "name"), (ElementVisitor)new 1());
            elementStartContext.registerChildVisitor(DependenciesVisitor.ELEMENT, (ElementVisitor)this._depVisitor);
            elementStartContext.registerChildVisitor(BaseExtensionVisitor.CLASSPATH_ELEMENT, (ElementVisitor)this._cpVisitor);
        }

        public void end(ElementEndContext elementEndContext) {
            this._feature = (Feature)this._featureHook.getFeatures().get(this._extension.getID());
        }

        private DisabledExtensionVisitor() {
            this.$init$();
        }

        DisabledExtensionVisitor(1 var2_2) {
            this();
        }

        static FeatureHook ra$_featureHook(DisabledExtensionVisitor disabledExtensionVisitor) {
            return disabledExtensionVisitor._featureHook;
        }

        static Extension ra$_extension(DisabledExtensionVisitor disabledExtensionVisitor) {
            return disabledExtensionVisitor._extension;
        }

        public final class 2
        extends ElementVisitor {
            public void start(ElementStartContext elementStartContext) {
                elementStartContext.registerChildVisitor(FeatureHook.ELEMENT, (ElementVisitor)DisabledExtensionVisitor.ra$_featureHook(DisabledExtensionVisitor.this));
            }
        }

        public final class 1
        extends I18NStringVisitor {
            protected void string(ElementContext elementContext, String string) {
                ((DefaultExtension)DisabledExtensionVisitor.ra$_extension(DisabledExtensionVisitor.this)).setName(string);
            }
        }
    }
}

