/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.HashMap;
import java.util.Map;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.DefaultElementContext;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.TimedCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IDEElementContext
extends DefaultElementContext {
    private static final TimedCache _macroMapsByExtension = new TimedCache(5);

    protected String getMacroValue(String string) {
        String string2;
        if ("ide.install.dir".equals(string)) {
            return Ide.getOracleHomeDirectory();
        }
        Extension extension = (Extension)this.getScopeData().get("extension");
        if (extension != null && (string2 = IDEElementContext.getMacroMap(extension).get(string)) != null) {
            return string2;
        }
        return super.getMacroValue(string);
    }

    private static Map<String, String> getMacroMap(Extension extension) {
        HashMap<String, String> hashMap = (HashMap<String, String>)_macroMapsByExtension.get(extension.getID());
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            hashMap.put("ide.extension.install.home", extensionRegistry.getInstallDirectory(extension.getID(), extension.getVersion()));
            hashMap.put("ide.extension.user.home", URLFileSystem.getPlatformPathName(extensionRegistry.getSystemDirectory(extension.getID(), extension.getVersion())));
            _macroMapsByExtension.put(extension.getID(), hashMap);
        }
        return hashMap;
    }

    IDEElementContext() {
    }
}

