/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import javax.ide.extension.spi.JARExtensionSource;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

class LegacyExtensionSource
extends JARExtensionSource {
    private String _manifestText;
    private static final String MANIFEST_ENTRY = "META-INF/jdev-ext.xml";
    private static final String ALT_MANIFEST_ENTRY = "meta-inf/jdev-ext.xml";
    private URI _manifestURI;

    void $init$() {
        this._manifestText = null;
    }

    public LegacyExtensionSource(URI uRI) {
        super(uRI);
        this.$init$();
    }

    public final URI getManifestURI() {
        if (this._manifestURI != null) {
            return this._manifestURI;
        }
        this._manifestURI = URIFactory.newJarURI((URI)this.getURI(), (String)MANIFEST_ENTRY);
        if (!VirtualFileSystem.getVirtualFileSystem().exists(this._manifestURI)) {
            this._manifestURI = URIFactory.newJarURI((URI)this.getURI(), (String)ALT_MANIFEST_ENTRY);
            if (!VirtualFileSystem.getVirtualFileSystem().exists(this._manifestURI)) {
                this._manifestURI = null;
            }
        }
        return this._manifestURI;
    }

    void setManifestURI(URI uRI) {
        this._manifestURI = uRI;
    }

    public InputStream getInputStream() throws IOException {
        if (this._manifestText == null) {
            this.transformLegacyManifest();
        }
        return new ByteArrayInputStream(this._manifestText.getBytes());
    }

    private void transformLegacyManifest() throws IOException {
        InputStream inputStream = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource streamSource = new StreamSource(LegacyExtensionSource.class.getResource("manifest/manifest-1012-to-1013.xsl").toString());
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            inputStream = VirtualFileSystem.getVirtualFileSystem().openInputStream(this.getManifestURI());
            StreamSource streamSource2 = new StreamSource(inputStream);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(streamSource2, streamResult);
            stringWriter.close();
            this._manifestText = stringWriter.toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
            throw new IOException("Transformer factory error");
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            throw new IOException("Transformer exception");
        }
    }
}

