/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.TextEditor;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.resource.ExtensionManagerArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.resource.CommonIconsUtils;
import org.xml.sax.Locator;

final class MessagePresenter
extends Handler
implements IdeListener {
    private final List _logRecords;
    private final Map _locatorsByRecord;
    private final Filter _filter;

    void $init$() {
        this._logRecords = new ArrayList();
        this._locatorsByRecord = new HashMap();
        this._filter = new LocatorOnlyFilter(null);
    }

    public MessagePresenter() {
        this.$init$();
        if (Ide.isRunning()) {
            Ide.addIdeListener(this);
        }
    }

    private ManifestExtensionLogPage getLogPage() {
        LogManager logManager = LogManager.getLogManager();
        if (logManager != null) {
            ManifestExtensionLogPage manifestExtensionLogPage = new ManifestExtensionLogPage();
            logManager.addPage(manifestExtensionLogPage);
            return manifestExtensionLogPage;
        }
        return null;
    }

    public Filter getFilter() {
        return this._filter;
    }

    public Level getLevel() {
        return Level.WARNING;
    }

    public void publish(LogRecord logRecord) {
        if (this.getFilter().isLoggable(logRecord)) {
            Locator locator = (Locator)logRecord.getParameters()[0];
            StoredLocator storedLocator = new StoredLocator(locator);
            this._locatorsByRecord.put(logRecord, storedLocator);
            this._logRecords.add(logRecord);
        }
    }

    private Locator getLocator(LogRecord logRecord) {
        return (Locator)this._locatorsByRecord.get(logRecord);
    }

    public void flush() {
    }

    public void close() {
    }

    public void addinsLoaded(IdeEvent ideEvent) {
    }

    public void mainWindowClosing(IdeEvent ideEvent) {
    }

    public void mainWindowOpened(IdeEvent ideEvent) {
        if (this._logRecords.size() > 0) {
            this.getLogPage().populate(this._logRecords);
        }
        Ide.removeIdeListener(this);
    }

    static Locator mav$getLocator(MessagePresenter messagePresenter, LogRecord logRecord) {
        return messagePresenter.getLocator(logRecord);
    }

    private class StoredLocator
    implements Locator {
        private int _lineNumber;
        private int _columnNumber;
        private String _systemId;

        public StoredLocator(Locator locator) {
            this._lineNumber = locator.getLineNumber();
            this._columnNumber = locator.getColumnNumber();
            this._systemId = locator.getSystemId();
        }

        public String getPublicId() {
            return "";
        }

        public String getSystemId() {
            return this._systemId;
        }

        public int getLineNumber() {
            return this._lineNumber;
        }

        public int getColumnNumber() {
            return this._columnNumber;
        }
    }

    private static class LocatorOnlyFilter
    implements Filter {
        public boolean isLoggable(LogRecord logRecord) {
            if (logRecord.getParameters() != null && logRecord.getParameters().length == 1) {
                return logRecord.getParameters()[0] instanceof Locator;
            }
            return false;
        }

        private LocatorOnlyFilter() {
        }

        LocatorOnlyFilter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ManifestExtensionLogPage
    extends DefaultLogPage {
        public ManifestExtensionLogPage() {
            super(new ViewId("ManifestExtensionLogPage", ExtensionManagerArb.getString(18)), null, false, DefaultLogPage.HIDE_FIX_SOURCE_MENU);
            this.getTree().setCellRenderer(new ManifestLogCellRender(null));
        }

        public HelpInfo getHelpInfo() {
            return new HelpInfo("f1_idelogwindowgen_html");
        }

        protected String treeNodeToString(Object object) {
            Object object2;
            if (object instanceof DefaultMutableTreeNode && (object2 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof LogRecord) {
                return this.getRecordText((LogRecord)object2);
            }
            return super.treeNodeToString(object);
        }

        public void populate(Collection collection) {
            Map map = this.organizeByURI(collection);
            this.sortRecords(map);
            TreeModel treeModel = this.buildTreeModel(map);
            this.setModel(treeModel);
            IdeUtil.expandAllTreeRows(this.getTree());
            LogManager logManager = LogManager.getLogManager();
            if (!logManager.isLogVisible()) {
                logManager.showLog();
            }
        }

        private TreeModel buildTreeModel(Map map) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = (String)iterator.next();
                try {
                    URI uRI = URIFactory.newURI((String)string);
                    if (uRI != null && uRI.getScheme() != null) {
                        URL uRL = VirtualFileSystem.getVirtualFileSystem().toURL(uRI);
                        if ("jar".equals(uRL.getProtocol())) {
                            uRL = JarUtil.getJarFileURL(uRL);
                        }
                        string2 = URLFileSystem.getPlatformPathName(uRL);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                this.addChildren(defaultMutableTreeNode2, (Collection)map.get(string));
            }
            return new DefaultTreeModel(defaultMutableTreeNode);
        }

        private void addChildren(DefaultMutableTreeNode defaultMutableTreeNode, Collection collection) {
            if (collection == null) {
                return;
            }
            for (LogRecord logRecord : collection) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(logRecord);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }

        private String getRecordText(LogRecord logRecord) {
            Locator locator = MessagePresenter.mav$getLocator(MessagePresenter.this, logRecord);
            return this.getFormattedMessage(logRecord, locator);
        }

        private String initCap(String string) {
            StringBuffer stringBuffer = new StringBuffer(string);
            boolean bl = true;
            int n = 0;
            while (n < stringBuffer.length()) {
                char c = stringBuffer.charAt(n);
                if (Character.isWhitespace(c)) {
                    bl = true;
                } else {
                    stringBuffer.setCharAt(n, bl ? Character.toUpperCase(c) : Character.toLowerCase(c));
                    bl = false;
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        private String getFormattedMessage(LogRecord logRecord, Locator locator) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.initCap(logRecord.getLevel().toString()));
            int n = locator.getLineNumber();
            int n2 = locator.getColumnNumber();
            if (n >= 0) {
                stringBuffer.append("(");
                stringBuffer.append(String.valueOf(n));
                if (n2 < 0) {
                    n2 = 0;
                }
                stringBuffer.append(",");
                stringBuffer.append(String.valueOf(n2));
                stringBuffer.append(")");
            } else {
                stringBuffer.append("(0,0)");
            }
            stringBuffer.append(": ");
            stringBuffer.append(logRecord.getMessage());
            return stringBuffer.toString();
        }

        private Map organizeByURI(Collection collection) {
            HashMap<String, ArrayList<LogRecord>> hashMap = new HashMap<String, ArrayList<LogRecord>>();
            for (LogRecord logRecord : collection) {
                ArrayList<LogRecord> arrayList;
                Locator locator = MessagePresenter.mav$getLocator(MessagePresenter.this, logRecord);
                String string = locator.getSystemId();
                if (string == null) {
                    string = "Unknown Source";
                }
                if ((arrayList = (ArrayList<LogRecord>)hashMap.get(string)) == null) {
                    arrayList = new ArrayList<LogRecord>();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(logRecord);
            }
            return hashMap;
        }

        private void sortRecords(Map map) {
            1 var2_2 = new 1();
            for (String string : map.keySet()) {
                List list = (List)map.get(string);
                Collections.sort(list, var2_2);
            }
        }

        protected void activateObject(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            LogRecord logRecord = (LogRecord)defaultMutableTreeNode.getUserObject();
            Locator locator = MessagePresenter.mav$getLocator(MessagePresenter.this, logRecord);
            String string = locator.getSystemId();
            URL uRL = null;
            try {
                uRL = VirtualFileSystem.getVirtualFileSystem().toURL(URIFactory.newURI((String)string));
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
            }
            if (uRL == null) {
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)("Unable to open manifest for " + string), (String)"Unable to Open Manifest", null);
            } else {
                Editor editor = EditorUtil.openDefaultEditorInFrame(uRL);
                if (editor instanceof TextEditor) {
                    int n = locator.getLineNumber();
                    int n2 = locator.getColumnNumber();
                    ((TextEditor)((Object)editor)).gotoLine(n, n2, true);
                }
            }
        }

        private boolean isWarning(Object object) {
            return object instanceof LogRecord && ((LogRecord)object).getLevel() == Level.WARNING;
        }

        private boolean isError(Object object) {
            return object instanceof LogRecord && ((LogRecord)object).getLevel() == Level.SEVERE;
        }

        static String mav$getRecordText(ManifestExtensionLogPage manifestExtensionLogPage, LogRecord logRecord) {
            return manifestExtensionLogPage.getRecordText(logRecord);
        }

        static boolean mav$isError(ManifestExtensionLogPage manifestExtensionLogPage, Object object) {
            return manifestExtensionLogPage.isError(object);
        }

        static boolean mav$isWarning(ManifestExtensionLogPage manifestExtensionLogPage, Object object) {
            return manifestExtensionLogPage.isWarning(object);
        }

        final class 1
        implements Comparator {
            public int compare(Object object, Object object2) {
                LogRecord logRecord = (LogRecord)object;
                LogRecord logRecord2 = (LogRecord)object2;
                if (logRecord.getLevel() != logRecord2.getLevel()) {
                    if (logRecord.getLevel() == Level.SEVERE) {
                        return -1;
                    }
                    return 1;
                }
                Locator locator = MessagePresenter.mav$getLocator(MessagePresenter.this, logRecord);
                Locator locator2 = MessagePresenter.mav$getLocator(MessagePresenter.this, logRecord2);
                return locator.getLineNumber() - locator2.getLineNumber();
            }
        }

        private class ManifestLogCellRender
        extends DefaultTreeCellRenderer {
            private final Icon _errorIcon;
            private final Icon _warningIcon;

            void $init$() {
                this._errorIcon = CommonIconsUtils.getErrorIcon();
                this._warningIcon = CommonIconsUtils.getWarningIcon();
            }

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                if (object2 instanceof LogRecord) {
                    LogRecord logRecord = (LogRecord)object2;
                    this.setText(ManifestExtensionLogPage.mav$getRecordText(ManifestExtensionLogPage.this, logRecord));
                }
                if (bl3) {
                    if (ManifestExtensionLogPage.mav$isError(ManifestExtensionLogPage.this, object2)) {
                        this.setIcon(this._errorIcon);
                    } else if (ManifestExtensionLogPage.mav$isWarning(ManifestExtensionLogPage.this, object2)) {
                        this.setIcon(this._warningIcon);
                    }
                }
                return this;
            }

            private ManifestLogCellRender() {
                this.$init$();
            }

            ManifestLogCellRender(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }
}

