/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.spi.Feature;
import javax.ide.extension.spi.FeatureHook;
import oracle.ide.ExtensionRegistry;

final class CachedExtensionInfo {
    private final Map _dependees;
    private final Map _containees;
    private static final Object STATE_VISITING = "visiting";
    private static final Object STATE_VISITED_SAFE = "visited_safe";
    private static final Object STATE_VISITED_UNSAFE = "visited_unsafe";

    void $init$() {
        this._dependees = new HashMap();
        this._containees = new HashMap();
    }

    Collection getExtensionsWhichDependOn(Extension extension) {
        Collection collection = (Collection)this._dependees.get(extension.getID());
        if (collection == null) {
            collection = this.getExtensionsWhichDependOnImpl(extension);
            this._dependees.put(extension.getID(), collection);
        }
        return collection;
    }

    private Collection getExtensionsWhichDependOnImpl(Extension extension) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        HashMap<Extension, Object> hashMap = new HashMap<Extension, Object>();
        ArrayList arrayList = new ArrayList();
        Collection collection = extensionRegistry.getAllExtensions();
        hashMap.put(extension, STATE_VISITED_UNSAFE);
        for (Extension extension2 : collection) {
            if (hashMap.get(extension2) != null) continue;
            this.dependeeVisit(extension2, hashMap, arrayList);
        }
        return arrayList;
    }

    private void dependeeVisit(Extension extension, Map map, Collection collection) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        map.put(extension, STATE_VISITING);
        for (ExtensionDependency extensionDependency : extension.getDependencies()) {
            Extension extension2;
            if (extensionDependency == null || extensionDependency.getID() == null || (extension2 = extensionRegistry.findExtensionEvenIfNotLoaded(extensionDependency.getID())) == null) continue;
            Object v = map.get(extension2);
            if (v == null) {
                this.dependeeVisit(extension2, map, collection);
                continue;
            }
            if (v != STATE_VISITED_UNSAFE) continue;
            map.put(extension, STATE_VISITED_UNSAFE);
            collection.add(extension);
            break;
        }
        if (map.get(extension) != STATE_VISITED_UNSAFE) {
            map.put(extension, STATE_VISITED_SAFE);
        }
    }

    Collection getContainedExtensions(Extension extension) {
        Collection collection = (Collection)this._containees.get(extension.getID());
        if (collection == null) {
            collection = this.getContainedExtensionsImpl(extension);
            this._containees.put(extension.getID(), collection);
        }
        return collection;
    }

    private Collection getContainedExtensionsImpl(Extension extension) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        FeatureHook featureHook = (FeatureHook)extensionRegistry.getHook(FeatureHook.ELEMENT);
        HashSet<Extension> hashSet = new HashSet<Extension>();
        for (Extension extension2 : extensionRegistry.getAllExtensions()) {
            Feature feature;
            if (extension2.getID().equals(extension.getID()) || (feature = (Feature)featureHook.getFeatures().get(extension2.getID())) == null || !extension.getID().equals(feature.getPartOf()) || !feature.isOptional()) continue;
            hashSet.add(extension2);
        }
        return hashSet;
    }

    CachedExtensionInfo() {
        this.$init$();
    }
}

