/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.spi.Feature;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.ExtensionRegistry;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.extension.preference.CachedExtensionInfo;
import oracle.ideimpl.extension.preference.ExtensionFilter;
import oracle.ideimpl.resource.ExtensionManagerOptionsArb;
import oracle.ideimpl.webupdate.wizard.NiceList;
import oracle.ideimpl.webupdate.wizard.NiceListActionEvent;
import oracle.ideimpl.webupdate.wizard.NiceListActionListener;
import oracle.ideimpl.webupdate.wizard.NiceListRenderer;
import oracle.ideri.util.Product;
import oracle.javatools.controls.SimpleListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExtensionListPanel
extends JPanel {
    private final JLabel _extensions;
    private final NiceList _listControl;
    private final SimpleListModel _model;
    private Set _disabledIds;
    private ExtensionFilter _filter;
    private CachedExtensionInfo _info;
    private Set<String> _productExtensionIds;

    void $init$() {
        this._extensions = new JLabel();
        this._listControl = new NiceList();
        this._model = new SimpleListModel();
        this._disabledIds = Collections.EMPTY_SET;
        this._filter = null;
        this._info = null;
        this._productExtensionIds = null;
    }

    ExtensionListPanel() {
        this.$init$();
        this.resControls();
        this.layoutControls();
        this.installListeners();
        TheRenderer theRenderer = new TheRenderer(null);
        theRenderer.setTwoLineDescription(false);
        this._listControl.setCellRenderer(theRenderer);
        this._listControl.setModel(this._model);
        this._listControl.setSelectionMode(0);
        HelpUtils.setHelpID((JComponent)this, (String)"f1_idedidesetextensionmanager_html");
    }

    private Set<String> getProductExtensionIds() {
        if (this._productExtensionIds == null) {
            this._productExtensionIds = new HashSet<String>();
            String string = Product.getProductID();
            this._productExtensionIds.add(string);
            this.addExtensionDependencies(this._productExtensionIds, string);
        }
        return this._productExtensionIds;
    }

    private void addExtensionDependencies(Set<String> set, String string) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        Extension extension = extensionRegistry.findExtensionEvenIfNotLoaded(string);
        for (ExtensionDependency extensionDependency : extension.getDependencies()) {
            if (extensionDependency == null || extensionDependency.getID() == null || set.contains(extensionDependency.getID())) continue;
            set.add(extensionDependency.getID());
            this.addExtensionDependencies(set, extensionDependency.getID());
        }
    }

    void setCachedExtensionInfo(CachedExtensionInfo cachedExtensionInfo) {
        this._info = cachedExtensionInfo;
    }

    void setDisabledIds(Set set) {
        this._disabledIds = set;
    }

    void populate() {
        this.populate(new 2());
    }

    private void populate(ExtensionFilter extensionFilter) {
        this._filter = extensionFilter;
        Collection collection = this.getVisibleExtensions();
        this._model.addElements(collection.iterator());
    }

    private Collection getVisibleExtensions() {
        ArrayList<Extension> arrayList = new ArrayList<Extension>();
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        for (Extension extension : extensionRegistry.getAllExtensions()) {
            if (!this.isVisibleExtension(extension)) continue;
            arrayList.add(extension);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private void layoutControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._extensions, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this._listControl);
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    private void installListeners() {
        TheListener theListener = new TheListener(null);
        this._listControl.addListActionListener(theListener);
    }

    private void resControls() {
        ResourceUtils.resLabel(this._extensions, this._listControl, ExtensionManagerOptionsArb.getString(0));
    }

    private boolean isCurrentlyEnabled(Extension extension) {
        return this._disabledIds.contains(extension.getID()) ^ true;
    }

    private void setCurrentlyEnabled(Extension extension, boolean bl) {
        if (bl) {
            this._disabledIds.remove(extension.getID());
        } else {
            this._disabledIds.add(extension.getID());
        }
    }

    private void updateDependencies(Extension extension, boolean bl) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        if (bl) {
            for (ExtensionDependency extensionDependency : extension.getDependencies()) {
                String string = extensionDependency.getID();
                Extension extension2 = extensionRegistry.findExtensionEvenIfNotLoaded(string);
                if (extension2 == null) continue;
                if (this.isVisibleExtension(extension2)) {
                    this.setCurrentlyEnabled(extension2, bl);
                }
                this.updateDependencies(extension2, bl);
            }
        } else {
            Collection collection = this.getExtensionsWhichDependOn(extension);
            for (Extension extension3 : collection) {
                if (extension3 == null || !this.isVisibleExtension(extension3)) continue;
                this.setCurrentlyEnabled(extension3, false);
            }
        }
    }

    private Collection getExtensionsWhichDependOn(Extension extension) {
        return this._info.getExtensionsWhichDependOn(extension);
    }

    private Collection getContainedExtensions(Extension extension) {
        return this._info.getContainedExtensions(extension);
    }

    private Feature getFeature(Extension extension) {
        if (this.getProductExtensionIds().contains(extension.getID())) {
            return null;
        }
        return ((ExtensionManagerImpl)ExtensionRegistry.getExtensionRegistry()).getFeature(extension);
    }

    private boolean isVisibleExtension(Extension extension) {
        return this._filter.accept(extension);
    }

    private void showConfigureDialog(Extension extension) {
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)IdeUtil.findActiveModalWindow(), (String)ExtensionManagerOptionsArb.getString(3), (int)7);
        ExtensionListPanel extensionListPanel = new ExtensionListPanel();
        jEWTDialog.setContent((Component)extensionListPanel);
        jEWTDialog.setResizable(true);
        DialogHeader dialogHeader = new DialogHeader();
        dialogHeader.setHeaderTitle(ExtensionManagerOptionsArb.format(4, extension.getName()));
        dialogHeader.setHeaderDescription(ExtensionManagerOptionsArb.format(5, extension.getName()));
        jEWTDialog.setDialogHeader((Component)dialogHeader);
        HashSet hashSet = new HashSet(this._disabledIds);
        extensionListPanel.setDisabledIds(hashSet);
        extensionListPanel.setCachedExtensionInfo(this._info);
        extensionListPanel.populate(new 1(this, extension));
        if (jEWTDialog.runDialog()) {
            this._disabledIds.clear();
            this._disabledIds.addAll(hashSet);
        }
    }

    static Feature mav$getFeature(ExtensionListPanel extensionListPanel, Extension extension) {
        return extensionListPanel.getFeature(extension);
    }

    static SimpleListModel ra$_model(ExtensionListPanel extensionListPanel) {
        return extensionListPanel._model;
    }

    static boolean mav$isCurrentlyEnabled(ExtensionListPanel extensionListPanel, Extension extension) {
        return extensionListPanel.isCurrentlyEnabled(extension);
    }

    static void mav$setCurrentlyEnabled(ExtensionListPanel extensionListPanel, Extension extension, boolean bl) {
        extensionListPanel.setCurrentlyEnabled(extension, bl);
    }

    static void mav$updateDependencies(ExtensionListPanel extensionListPanel, Extension extension, boolean bl) {
        extensionListPanel.updateDependencies(extension, bl);
    }

    static void mav$showConfigureDialog(ExtensionListPanel extensionListPanel, Extension extension) {
        extensionListPanel.showConfigureDialog(extension);
    }

    static Collection mav$getContainedExtensions(ExtensionListPanel extensionListPanel, Extension extension) {
        return extensionListPanel.getContainedExtensions(extension);
    }

    final class 2
    implements ExtensionFilter {
        public boolean accept(Extension extension) {
            Feature feature = ExtensionListPanel.mav$getFeature(ExtensionListPanel.this, extension);
            return feature != null && feature.isOptional() && (feature.getPartOf() == null || feature.getPartOf().trim().length() == 0);
        }
    }

    final class 1
    implements ExtensionFilter {
        private final /* synthetic */ Extension v$owningExtension;
        final /* synthetic */ ExtensionListPanel this$0;

        public boolean accept(Extension extension) {
            Feature feature = ExtensionListPanel.mav$getFeature(this.this$0, extension);
            return feature != null && feature.isOptional() && this.v$owningExtension.getID().equals(feature.getPartOf());
        }

        public 1(ExtensionListPanel extensionListPanel, Extension extension) {
            this.v$owningExtension = extension;
            this.this$0 = extensionListPanel;
        }
    }

    private class TheListener
    implements NiceListActionListener {
        public void listActionPerformed(NiceListActionEvent niceListActionEvent) {
            int n = niceListActionEvent.getRow();
            if (n >= 0) {
                Extension extension = (Extension)ExtensionListPanel.ra$_model(ExtensionListPanel.this).getElementAt(n);
                if (niceListActionEvent.getType() == 0) {
                    boolean bl = ExtensionListPanel.mav$isCurrentlyEnabled(ExtensionListPanel.this, extension) ^ true;
                    ExtensionListPanel.mav$setCurrentlyEnabled(ExtensionListPanel.this, extension, bl);
                    ExtensionListPanel.mav$updateDependencies(ExtensionListPanel.this, extension, bl);
                    ExtensionListPanel.ra$_model(ExtensionListPanel.this).changed(n);
                } else if (niceListActionEvent.getType() == 1) {
                    ExtensionListPanel.mav$showConfigureDialog(ExtensionListPanel.this, extension);
                }
            }
        }

        private TheListener() {
        }

        TheListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TheRenderer
    extends NiceListRenderer {
        public String getTitle(Object object) {
            Extension extension = (Extension)object;
            String string = extension.getName();
            String string2 = extension.getVersion().toString();
            if (string == null) {
                string = extension.getID();
            }
            return string + " " + string2;
        }

        public String getDescription(Object object) {
            Extension extension = (Extension)object;
            Feature feature = ExtensionListPanel.mav$getFeature(ExtensionListPanel.this, extension);
            String string = "";
            if (feature != null) {
                string = feature.getDescription();
            }
            return string;
        }

        public boolean isItemSelected(Object object) {
            return ExtensionListPanel.mav$isCurrentlyEnabled(ExtensionListPanel.this, (Extension)object);
        }

        public String getHyperLinkText(Object object) {
            if (!ExtensionListPanel.mav$getContainedExtensions(ExtensionListPanel.this, (Extension)object).isEmpty()) {
                return "Configure";
            }
            return "";
        }

        private TheRenderer() {
        }

        TheRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

