/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.VerticalFlowLayout;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.extension.ExtensionPreferencesHook;
import oracle.ideimpl.extension.preference.CachedExtensionInfo;
import oracle.ideimpl.extension.preference.ExtensionListPanel;
import oracle.ideimpl.extension.preference.ExtensionPreferences;
import oracle.ideimpl.resource.ExtensionManagerOptionsArb;

public final class ExtensionOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private static final String NORMAL = "normal";
    private static final String DISABLED = "disabled";
    private final ExtensionListPanel _normalPanel;
    private final JPanel _disabledPanel;
    private final JLabel _disabledLabel;
    private final JPanel _clPanel;
    private final CardLayout _cl;
    private boolean _populated;
    private boolean _disabled;
    private boolean _layoutDone;
    private Set _disabledIds;
    private Set _composedTraversables;

    void $init$() {
        this._normalPanel = new ExtensionListPanel();
        this._disabledPanel = new JPanel();
        this._disabledLabel = new JLabel();
        this._clPanel = new JPanel();
        this._cl = new CardLayout();
        this._populated = false;
        this._disabled = false;
        this._layoutDone = false;
        this._disabledIds = null;
    }

    public ExtensionOptionsPanel() {
        this.$init$();
    }

    private void layoutControls() {
        this.setLayout(new BorderLayout());
        this.add((Component)this._clPanel, "Center");
        this._disabledPanel.setLayout(new GridBagLayout());
        this._disabledPanel.add((Component)this._disabledLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._clPanel.setLayout(this._cl);
        this._clPanel.add((Component)this._normalPanel, NORMAL);
        this._clPanel.add((Component)this._disabledPanel, DISABLED);
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        jPanel.setLayout(new VerticalFlowLayout(0, 0, 0, true, false));
        for (Traversable traversable : this._composedTraversables) {
            jPanel.add(traversable.getComponent());
        }
    }

    private void resControls() {
        this._disabledLabel.setText("<html><p>" + ExtensionManagerOptionsArb.getString(2) + "</p></html>");
    }

    public void onEntry(TraversableContext traversableContext) {
        if (!this._layoutDone) {
            ExtensionPreferencesHook extensionPreferencesHook = (ExtensionPreferencesHook)ExtensionRegistry.getOracleRegistry().getIdeHook(ExtensionPreferencesHook.ELEMENT);
            this._composedTraversables = extensionPreferencesHook == null ? Collections.EMPTY_SET : extensionPreferencesHook.getTraversables();
            this.layoutControls();
            this.resControls();
            this.setHelpID("f1_idedidesetextensionmanager_html");
            this._layoutDone = true;
        }
        for (Traversable traversable : this._composedTraversables) {
            traversable.onEntry(traversableContext);
        }
        if (this._populated) {
            return;
        }
        try {
            Set<Object> set = System.getProperties().keySet();
            if (set.contains("ide.extensions") || set.contains("ide.noextensions")) {
                this._cl.show(this._clPanel, DISABLED);
                this._disabled = true;
            } else {
                this._cl.show(this._clPanel, NORMAL);
                ExtensionPreferences extensionPreferences = (ExtensionPreferences)traversableContext.find("disabled.extensions.1013prod");
                this._disabledIds = extensionPreferences != null ? new HashSet(extensionPreferences.getDisabledIds()) : new HashSet();
                this._normalPanel.setDisabledIds(this._disabledIds);
                this._normalPanel.populate();
                this._normalPanel.setCachedExtensionInfo(new CachedExtensionInfo());
            }
        }
        finally {
            this._populated = true;
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        for (Traversable traversable : this._composedTraversables) {
            traversable.onExit(traversableContext);
        }
        ExtensionPreferences extensionPreferences = (ExtensionPreferences)traversableContext.find("disabled.extensions.1013prod");
        if (this._disabled) {
            return;
        }
        if (extensionPreferences == null && !this._disabledIds.isEmpty() || !this._disabledIds.equals(extensionPreferences.getDisabledIds())) {
            if (extensionPreferences == null) {
                extensionPreferences = new ExtensionPreferences();
                traversableContext.put("disabled.extensions.1013prod", (Object)extensionPreferences);
            }
            extensionPreferences.setDisabledIds(this._disabledIds);
            IdeSettings ideSettings = (IdeSettings)traversableContext.find("ide-options");
            ideSettings.setAskExit(true);
        }
    }

    public void apply(ApplyEvent applyEvent) {
        for (Traversable traversable : this._composedTraversables) {
            if (!(traversable instanceof ApplyListener)) continue;
            ((ApplyListener)((Object)traversable)).apply(applyEvent);
        }
    }

    public void cancel(ApplyEvent applyEvent) {
        for (Traversable traversable : this._composedTraversables) {
            if (!(traversable instanceof ApplyListener)) continue;
            ((ApplyListener)((Object)traversable)).cancel(applyEvent);
        }
    }
}

