/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.feedback.client;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.feedback.client.FeedbackManagerImpl;

class FeedbackDialog
extends JPanel
implements ActionListener {
    private JButton _clearButton;
    private JEWTDialog _dialog;
    private JTextArea _textArea;
    private JCheckBox _playSound;

    public FeedbackDialog(JEWTDialog jEWTDialog, List list) {
        super(new GridBagLayout());
        FeedbackManagerImpl feedbackManagerImpl = (FeedbackManagerImpl)FeedbackManager.getFeedbackManager();
        this._dialog = jEWTDialog;
        this._clearButton = new JButton("Clear");
        this._clearButton.addActionListener(this);
        JLabel jLabel = new JLabel();
        this._textArea = new JTextArea();
        this._textArea.setFont(new Font("Monospaced", 0, 12));
        this._textArea.setEditable(false);
        ResourceUtils.resLabel(jLabel, this._textArea, "&Report:");
        String string = feedbackManagerImpl.getReport(list);
        this._textArea.setText(string);
        this._textArea.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(this._textArea);
        this._playSound = new JCheckBox();
        ResourceUtils.resButton(this._playSound, "\"&Play Sound\"");
        boolean bl = feedbackManagerImpl.hasSound();
        this._playSound.setSelected(bl);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.add((Component)this._playSound, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
    }

    public static void runDialog() {
        FeedbackManagerImpl feedbackManagerImpl = (FeedbackManagerImpl)FeedbackManager.getFeedbackManager();
        List list = feedbackManagerImpl.getFeedbacks();
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)((Object)ideMainWindow), "Feedback", 3);
        FeedbackDialog feedbackDialog = new FeedbackDialog(jEWTDialog, list);
        jEWTDialog.addCustomButton((Component)feedbackDialog._clearButton);
        jEWTDialog.setContent((Component)feedbackDialog);
        jEWTDialog.setOKButtonText("Report");
        boolean bl = jEWTDialog.runDialog();
        feedbackManagerImpl.setSound(feedbackDialog._playSound.isSelected());
        if (bl) {
            feedbackManagerImpl.clearExceptions();
            feedbackManagerImpl.sendExceptions(list);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this._clearButton == object) {
            this.whenClear();
        }
    }

    private void whenClear() {
        FeedbackManagerImpl feedbackManagerImpl = (FeedbackManagerImpl)FeedbackManager.getFeedbackManager();
        feedbackManagerImpl.clearExceptions();
        this._dialog.closeDialog(true);
    }
}

