/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.feedback.client;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.Version;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.feedback.shared.Feedback;
import oracle.ide.feedback.shared.MessageFeedback;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.Registry;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeIcons;
import oracle.ide.view.View;
import oracle.ideimpl.feedback.client.FeedbackDialog;
import oracle.ideimpl.feedback.client.FeedbackWriter;
import oracle.ideimpl.feedback.shared.ExceptionFeedback;

public class FeedbackManagerImpl
extends FeedbackManager
implements Controller,
Addin {
    private DataOutputStream _dataOutputStream;
    private int _feedbackCmdId;
    private boolean _hasExceptions;
    private ToolButton _feedbackButton;
    private static final String JDEV_KEY = "Software\\Oracle\\JDeveloper";
    private static final String PLAY_SOUND_KEY = "FeedbackManagerPlaysSound";

    public FeedbackManagerImpl() {
        this.createFeedbackFile();
    }

    private void createFeedbackFile() {
        File file = this.getFeedbackFile();
        file.delete();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            this._dataOutputStream = new DataOutputStream(bufferedOutputStream);
            file.deleteOnExit();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private File getFeedbackFile() {
        String string = Ide.getSystemDirectory();
        File file = new File(string, "feedback.tmp");
        return file;
    }

    public void initialize() {
        if (Version.DEBUG_BUILD > 0) {
            FeedbackManagerImpl.setFeedbackManager(this);
            this.createActions();
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this._feedbackCmdId) {
            ideAction.setEnabled(this._hasExceptions);
            if (this._hasExceptions) {
                if (this._feedbackButton.getParent() == null) {
                    Toolbar toolbar = Ide.getToolbar();
                    toolbar.add(this._feedbackButton);
                }
            } else if (this._feedbackButton.getParent() != null) {
                Toolbar toolbar = Ide.getToolbar();
                toolbar.remove(this._feedbackButton);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n != this._feedbackCmdId) {
            return false;
        }
        this.whenReport();
        return true;
    }

    private void createActions() {
        this._feedbackCmdId = Ide.findOrCreateCmdID("FEEDBACK_CMD_ID");
        IdeAction ideAction = IdeAction.get(this._feedbackCmdId, null, "Report a Problem", IdeMainWindow.ACTION_CATEGORY_TOOLS, null, IdeIcons.getInstance(), 21, null, true);
        ideAction.addController(this);
        Toolbar toolbar = Ide.getToolbar();
        this._feedbackButton = toolbar.add(ideAction);
    }

    public void addActionPerformedFeedback(IdeAction ideAction, Context context) {
        int n;
        if (this.isOn() && (n = ideAction.getCommandId()) != this._feedbackCmdId) {
            String string = (String)ideAction.getValue("Name");
            this.addFeedback("Action performed: " + string, context);
        }
    }

    public void addFeedback(String string, Context context) {
        if (this.isOn()) {
            View view;
            if (context != null && (view = context.getView()) != null) {
                Class<?> clazz = view.getClass();
                String string2 = clazz.getName();
                string = string + "[ from " + string2 + " ]";
            }
            MessageFeedback messageFeedback = new MessageFeedback(string);
            this.addFeedback(messageFeedback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeedback(Feedback feedback) {
        if (this._dataOutputStream != null) {
            DataOutputStream dataOutputStream = this._dataOutputStream;
            synchronized (dataOutputStream) {
                try {
                    this.writeFeedback(this._dataOutputStream, feedback);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void reportException(String string, Throwable throwable) {
        if (this._dataOutputStream != null) {
            ExceptionFeedback exceptionFeedback = new ExceptionFeedback(string, throwable);
            this.addFeedback(exceptionFeedback);
            this._hasExceptions = true;
            this.updateFeedbackAction();
            if (this.hasSound()) {
                this.playSound();
            }
        }
    }

    private void playSound() {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL uRL = classLoader.getResource("oracle/ide/resource/images/feedback.wav");
            if (uRL != null && URLFileSystem.exists(uRL)) {
                AudioClip audioClip = Applet.newAudioClip(uRL);
                audioClip.play();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isOn() {
        return true;
    }

    private void whenReport() {
        FeedbackDialog.runDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearExceptions() {
        this._hasExceptions = false;
        DataOutputStream dataOutputStream = this._dataOutputStream;
        synchronized (dataOutputStream) {
            this.createFeedbackFile();
        }
        this.updateFeedbackAction();
    }

    private void updateFeedbackAction() {
        IdeAction ideAction = IdeAction.find(this._feedbackCmdId);
        ideAction.updateAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getFeedbacks() {
        ArrayList<Feedback> arrayList = null;
        DataOutputStream dataOutputStream = this._dataOutputStream;
        synchronized (dataOutputStream) {
            DataOutputStream dataOutputStream2 = this._dataOutputStream;
            this._dataOutputStream = null;
            try {
                try {
                    ArrayList<Feedback> arrayList2 = new ArrayList<Feedback>();
                    try {
                        dataOutputStream2.flush();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    File file = this.getFeedbackFile();
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        while (dataInputStream.available() > 0) {
                            Feedback feedback = Feedback.read(classLoader, dataInputStream);
                            arrayList2.add(feedback);
                        }
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    arrayList = arrayList2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            finally {
                this._dataOutputStream = dataOutputStream2;
            }
        }
        return arrayList;
    }

    String getReport(List list) {
        String string = "";
        if (list != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            int n = 0;
            while (n < list.size()) {
                Feedback feedback = (Feedback)list.get(n);
                feedback.dump(printStream);
                ++n;
            }
            string = byteArrayOutputStream.toString();
        }
        return string;
    }

    boolean hasSound() {
        boolean bl = false;
        try {
            Registry registry = NativeHandler.getRegistry();
            RegistryKey registryKey = registry.getCurrentUserKey();
            RegistryKey registryKey2 = registryKey.openKey(JDEV_KEY, 1L);
            String string = registryKey2.getStringValue(PLAY_SOUND_KEY);
            if ("1".equals(string)) {
                bl = true;
            }
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        return bl;
    }

    void setSound(boolean bl) {
        try {
            Registry registry = NativeHandler.getRegistry();
            RegistryKey registryKey = registry.getCurrentUserKey();
            RegistryKey registryKey2 = registryKey.openKey(JDEV_KEY, 7);
            registryKey2.setStringValue(PLAY_SOUND_KEY, bl ? "1" : "0");
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
    }

    void sendExceptions(List list) {
        1 var2_2 = new 1(this, list);
        var2_2.start();
    }

    public final class 1
    extends Thread {
        private final /* synthetic */ List v$feedbacks;
        final /* synthetic */ FeedbackManagerImpl this$0;

        public void run() {
            FeedbackWriter feedbackWriter = new FeedbackWriter();
            try {
                try {
                    try {
                        feedbackWriter.open("cdandoy-www.us.oracle.com", 4655);
                    }
                    catch (IOException iOException) {
                        feedbackWriter.open("cdandoy-pc.us.oracle.com", 4655);
                    }
                    feedbackWriter.sendInfo();
                    int n = 0;
                    while (n < this.v$feedbacks.size()) {
                        Feedback feedback = (Feedback)this.v$feedbacks.get(n);
                        feedbackWriter.write(feedback);
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Failed to send the report to the server: " + iOException.getMessage());
                }
            }
            finally {
                feedbackWriter.close();
            }
        }

        public 1(FeedbackManagerImpl feedbackManagerImpl, List list) {
            this.v$feedbacks = list;
            this.this$0 = feedbackManagerImpl;
        }
    }
}

