/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.feedback.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import oracle.ide.Version;
import oracle.ide.feedback.shared.Feedback;

public class FeedbackWriter {
    private Socket _socket;
    private DataOutputStream _outputStream;
    private DataInputStream _inputStream;

    public void open(String string, int n) throws IOException {
        this._socket = new Socket(string, n);
        OutputStream outputStream = this._socket.getOutputStream();
        this._outputStream = new DataOutputStream(outputStream);
        InputStream inputStream = this._socket.getInputStream();
        this._inputStream = new DataInputStream(inputStream);
        this._outputStream.writeInt(1);
        if (!this._inputStream.readBoolean()) {
            String string2 = "Feedback server does not support the client protocol";
            System.err.println("Feedback server does not support the client protocol");
            throw new IllegalStateException("Feedback server does not support the client protocol");
        }
    }

    public void sendInfo() {
        String string = System.getProperty("user.name");
        String string2 = Version.VER_FULL;
        String string3 = Version.BUILD_LABEL;
        try {
            this._outputStream.writeChar(73);
            this._outputStream.writeUTF(string);
            this._outputStream.writeUTF(string2);
            this._outputStream.writeUTF(string3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void close() {
        try {
            if (this._socket != null) {
                if (this._inputStream != null && this._outputStream != null) {
                    this._outputStream.writeChar(81);
                    this._outputStream.close();
                    this._inputStream.close();
                }
                this._socket.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void write(Feedback feedback) throws IOException {
        this._outputStream.writeChar(70);
        feedback.write(this._outputStream);
    }
}

