/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.feedback.shared;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import oracle.ide.feedback.shared.Feedback;
import oracle.ideimpl.feedback.shared.MyStackTraceElement;

public class ExceptionFeedback
extends Feedback {
    private String _problem;
    private String _exceptionClassName;
    private String _message;
    private MyStackTraceElement[] _stackTrace;

    public ExceptionFeedback() {
    }

    public ExceptionFeedback(String string, Throwable throwable) {
        this._problem = string;
        this._exceptionClassName = throwable.getClass().getName();
        this._message = throwable.toString();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        this._stackTrace = new MyStackTraceElement[stackTraceElementArray.length];
        int n = 0;
        while (n < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            this._stackTrace[n] = new MyStackTraceElement(stackTraceElement);
            ++n;
        }
    }

    protected void writeImpl(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this._problem);
        dataOutputStream.writeUTF(this._exceptionClassName);
        dataOutputStream.writeUTF(this._message);
        dataOutputStream.writeInt(this._stackTrace.length);
        int n = 0;
        while (n < this._stackTrace.length) {
            MyStackTraceElement myStackTraceElement = this._stackTrace[n];
            dataOutputStream.writeUTF(myStackTraceElement.getClassName());
            dataOutputStream.writeUTF(myStackTraceElement.getFileName());
            dataOutputStream.writeInt(myStackTraceElement.getLineNumber());
            dataOutputStream.writeUTF(myStackTraceElement.getMethodName());
            ++n;
        }
    }

    protected void readImpl(DataInputStream dataInputStream) throws IOException {
        this._problem = dataInputStream.readUTF();
        this._exceptionClassName = dataInputStream.readUTF();
        this._message = dataInputStream.readUTF();
        this._stackTrace = new MyStackTraceElement[dataInputStream.readInt()];
        int n = 0;
        while (n < this._stackTrace.length) {
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            int n2 = dataInputStream.readInt();
            String string3 = dataInputStream.readUTF();
            this._stackTrace[n] = new MyStackTraceElement(string, string3, string2, n2);
            ++n;
        }
    }

    public void dumpImpl(PrintStream printStream) {
        printStream.println(this._message);
        int n = 0;
        while (n < this._stackTrace.length) {
            MyStackTraceElement myStackTraceElement = this._stackTrace[n];
            String string = ExceptionFeedback.getLine(myStackTraceElement);
            printStream.println(" " + string);
            ++n;
        }
    }

    public String getBugTitle() {
        String string = ExceptionFeedback.getShortExceptionName(this._exceptionClassName);
        MyStackTraceElement myStackTraceElement = this.getBestStackElement();
        String string2 = myStackTraceElement.getClassName();
        String string3 = ExceptionFeedback.getShortClassName(string2);
        String string4 = string + " in " + string3 + ":" + myStackTraceElement.getLineNumber();
        return string4;
    }

    private static String getShortExceptionName(String string) {
        String[][] stringArrayArray = new String[][]{{"java.lang.NullPointerException", "NPE"}};
        int n = 0;
        while (n < stringArrayArray.length) {
            String[] stringArray = stringArrayArray[n];
            if (stringArray[0].equals(string)) {
                return stringArray[1];
            }
            ++n;
        }
        return string;
    }

    private static String getShortClassName(String string) {
        String[][] stringArrayArray = new String[][]{{"oracle.", "o."}, {"o.ide.", "o.i."}, {"o.ideimpl.", "o.ii."}, {"o.jdeveloper.", "o.j."}, {"o.jdevimpl.", "o.ji."}, {"java.", "j."}, {"j.awt.", "j.a."}, {"javax.", "jx."}, {"jx.swing.", "jx.s."}};
        int n = 0;
        while (n < stringArrayArray.length) {
            String[] stringArray = stringArrayArray[n];
            String string2 = stringArray[0];
            if (string.startsWith(string2)) {
                String string3 = stringArray[1];
                string = string3 + string.substring(string2.length());
            }
            ++n;
        }
        return string;
    }

    public MyStackTraceElement getBestStackElement() {
        int n = 0;
        while (n < this._stackTrace.length) {
            MyStackTraceElement myStackTraceElement = this._stackTrace[n];
            String string = myStackTraceElement.getClassName();
            if (string.startsWith("oracle")) {
                return myStackTraceElement;
            }
            ++n;
        }
        return this._stackTrace[0];
    }

    private static String getLine(MyStackTraceElement myStackTraceElement) {
        String string = myStackTraceElement.getClassName();
        String string2 = myStackTraceElement.getMethodName();
        String string3 = ExceptionFeedback.getShortClassName(string);
        String string4 = myStackTraceElement.getFileName();
        int n = myStackTraceElement.getLineNumber();
        String string5 = !myStackTraceElement.isNativeMethod() ? (string4 != null ? (n >= 0 ? "(" + string4 + ":" + n + ")" : "(" + string4 + ")") : "(Unknown Source)") : "(Native Method)";
        String string6 = " " + string3 + "." + string2 + string5;
        return string6;
    }
}

