/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.history;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.history.Historian;
import oracle.ide.history.HistoryContext;
import oracle.ide.history.HistoryManager;
import oracle.ide.history.LocalState;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.TextNodeHistorian;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Navigable;
import oracle.ide.persistence.NameSpace;
import oracle.ideimpl.history.HistoryOptions;
import oracle.ideimpl.history.HistoryOptionsPanel;
import oracle.ideimpl.history.LocalStateImpl;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.dialogs.MessageDialog;

public final class HistoryManagerImpl
extends HistoryManager
implements Addin,
Observer {
    public static final String RESTORE_HISTORY_RENAME_CMD = "oracle.ide.cmd.RestoreHistoryRenameCommand";
    public static final int RESTORE_HISTORY_RENAME_CMD_ID = Ide.createCmdID("oracle.ide.cmd.RestoreHistoryRenameCommand");
    private static final String FIELD_SEPARATOR = "|";
    private static final String HISTORY_DIR = Ide.getWorkDirectory() + ".history" + File.separator;
    private static final String NS_STATES = "LocalHistory:States";
    private static final String NS_URLS = "LocalHistory:Urls";
    private static final String NS_NODES = "LocalHistory:Documents";
    private static final String NS_COMMENTS = "LocalHistory:Comments";
    private static final NameSpace STATES = NameSpace.getNameSpace("LocalHistory:States");
    private static final NameSpace URLS = NameSpace.getNameSpace("LocalHistory:Urls");
    private static final NameSpace NODES = NameSpace.getNameSpace("LocalHistory:Documents");
    private static final NameSpace COMMENTS = NameSpace.getNameSpace("LocalHistory:Comments");
    private static final int DELETION_URL_ID = -1;
    private static boolean PRUNED;
    private static HashMap URLID_TO_NODEID;
    private static HashMap URL_TO_URLID;
    private static List DELETED_NODE_IDS;
    private static final HashMap LOCTYPE_TO_HISTORIANTYPE;
    private static final HashMap HISTORIANTYPE_TO_HISTORIAN;
    private boolean active;

    static {
        LOCTYPE_TO_HISTORIANTYPE = new HashMap();
        HISTORIANTYPE_TO_HISTORIAN = new HashMap();
        STATES.setAutoFlush(1500L);
        URLS.setAutoFlush(1500L);
        NODES.setAutoFlush(1500L);
        COMMENTS.setAutoFlush(1500L);
    }

    void $init$() {
        this.active = true;
    }

    public HistoryManagerImpl() {
        this.$init$();
    }

    public void initialize() {
        HistoryManager.setHistoryManager(this);
        try {
            this.registerHistorian(TextNodeHistorian.class, TextNode.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ClientSetting clientSetting = ClientSetting.findOrCreate("oracle.ide");
        HistoryOptions historyOptions = (HistoryOptions)clientSetting.getData("HistoryOptions");
        if (historyOptions == null) {
            historyOptions = new HistoryOptions();
            clientSetting.putData("HistoryOptions", historyOptions);
        }
        Navigable navigable = Ide.getSettings().getEnvironNavigable();
        Navigable navigable2 = new Navigable(IdeImplArb.getString(88), HistoryOptionsPanel.class);
        navigable.addChildNavigable(navigable2);
        historyOptions.addChangeListener(new 1());
        this.optionsChanged(historyOptions);
    }

    public synchronized boolean hasLocalHistory(URL uRL) {
        if (!this.active) {
            return false;
        }
        HistoryManagerImpl.pruneHistory();
        try {
            this.persistInitialState(new URL[]{uRL});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Object object = HistoryManagerImpl.getNodeId(uRL, false);
        if (object != null) {
            Iterator iterator = STATES.getKeyIterator(object.toString() + FIELD_SEPARATOR);
            return iterator != null && iterator.hasNext();
        }
        return false;
    }

    public synchronized LocalState[] getLocalHistory(URL uRL) {
        if (!this.active) {
            return null;
        }
        HistoryManagerImpl.pruneHistory();
        try {
            this.persistInitialState(new URL[]{uRL});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Object object = HistoryManagerImpl.getNodeId(uRL, false);
        return this.getLocalHistory(object);
    }

    public synchronized LocalState[] getLocalHistory(Object object) {
        return this.getLocalHistory(object, false);
    }

    public synchronized LocalState getLastState(Object object) {
        LocalState[] localStateArray = this.getLocalHistory(object, true);
        return localStateArray != null && localStateArray.length > 0 ? localStateArray[0] : null;
    }

    /*
     * Unable to fully structure code
     */
    private LocalState[] getLocalHistory(Object var1_1, boolean var2_2) {
        block7: {
            if (!this.active) {
                return null;
            }
            HistoryManagerImpl.pruneHistory();
            var3_3 = null;
            if (var1_1 == null) break block7;
            var4_4 = var1_1.toString() + "|";
            v0 = var5_5 = var2_2 != false ? HistoryManagerImpl.STATES.getReverseKeyIterator(var4_4) : HistoryManagerImpl.STATES.getKeyIterator(var4_4);
            if (var5_5 == null || !var5_5.hasNext()) break block7;
            var3_3 = new ArrayList<LocalStateImpl>();
            if (!var2_2) ** GOTO lbl24
            try {
                var3_3.add(LocalStateImpl.decode((String)var5_5.next()));
            }
            catch (Exception var6_6) {
                var6_6.printStackTrace();
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3.add(LocalStateImpl.decode((String)var5_5.next()));
                    continue;
                }
                catch (Exception var7_7) {
                    var7_7.printStackTrace();
                }
lbl24:
                // 3 sources

                ** while (var5_5.hasNext())
            }
        }
        v1 = var8_8 = var3_3 != null ? new LocalState[var3_3.size()] : null;
        if (var8_8 != null) {
            var3_3.toArray(var8_8);
        }
        return var8_8;
    }

    public Object[] getDeletions(URL uRL) {
        Iterator iterator;
        if (!this.active) {
            return null;
        }
        HistoryManagerImpl.pruneHistory();
        ArrayList arrayList = new ArrayList();
        List list = HistoryManagerImpl.loadDeletedNodeIds();
        Iterator iterator2 = iterator = list != null ? list.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                try {
                    Object e = iterator.next();
                    Iterator iterator3 = STATES.getReverseKeyIterator(e.toString() + FIELD_SEPARATOR);
                    if (iterator3 == null) continue;
                    String string = (String)iterator3.next();
                    LocalStateImpl localStateImpl = LocalStateImpl.decode(string);
                    if (uRL != null && !URLFileSystem.isBaseURLFor(uRL, ((LocalState)localStateImpl).getStateURL())) continue;
                    arrayList.add(e);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    public synchronized void persistInitialState(URL[] uRLArray) throws Exception {
        if (!this.active) {
            return;
        }
        HistoryManagerImpl.pruneHistory();
        if (uRLArray != null) {
            Date date = null;
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL = uRLArray[n];
                Historian historian = null;
                Node node = null;
                if (!URLFileSystem.isDirectory(uRL)) {
                    node = NodeFactory.findOrCreate(uRL);
                    Historian historian2 = historian = node != null ? HistoryManagerImpl.getHistorian(node.getClass()) : null;
                }
                if (historian != null) {
                    Object object = HistoryManagerImpl.getNodeId(uRL, true);
                    boolean bl = false;
                    Iterator iterator = STATES.getReverseKeyIterator(object.toString() + FIELD_SEPARATOR);
                    if (iterator == null || !iterator.hasNext()) {
                        bl = true;
                    } else {
                        Object e = iterator.next();
                        try {
                            LocalStateImpl localStateImpl = LocalStateImpl.decode((String)e);
                            bl = URLFileSystem.lastModified(uRL) > ((LocalState)localStateImpl).getDate().getTime();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (bl && URLFileSystem.exists(uRL)) {
                        date = date == null ? new Date(System.currentTimeMillis()) : date;
                        URL uRL2 = HistoryManagerImpl.createDataUrl(object, date);
                        try {
                            historian.copy(uRL, uRL2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (uRL2 != null && URLFileSystem.exists(uRL2)) {
                            URLFileSystem.setLastModified(uRL2, date.getTime());
                            STATES.putRecord(new LocalStateImpl(date, (Integer)object, (Integer)HistoryManagerImpl.getUrlId(uRL, true), (Integer)HistoryManagerImpl.getUrlId(uRL2, true)).toString(), null);
                            if (node instanceof Subject) {
                                ((Subject)node).attach(this);
                            }
                        }
                    }
                }
                ++n;
            }
            if (date != null) {
                HistoryManagerImpl.persistComments(date, IdeImplArb.getString(86));
            }
        }
    }

    public synchronized void persist(URL[] uRLArray, String string) throws Exception {
        if (!this.active) {
            return;
        }
        HistoryManagerImpl.pruneHistory();
        if (uRLArray != null) {
            Date date = new Date(System.currentTimeMillis());
            boolean bl = false;
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL = uRLArray[n];
                Historian historian = null;
                Node node = null;
                if (!URLFileSystem.isDirectory(uRL)) {
                    node = NodeFactory.findOrCreate(uRL);
                    Historian historian2 = historian = node != null ? HistoryManagerImpl.getHistorian(node.getClass()) : null;
                }
                if (historian != null) {
                    Object object = HistoryManagerImpl.getNodeId(uRL, true);
                    URL uRL2 = HistoryManagerImpl.createDataUrl(object, date);
                    historian.recordContents(uRL, uRL2);
                    URLFileSystem.setLastModified(uRL2, date.getTime());
                    STATES.putRecord(new LocalStateImpl(date, (Integer)object, (Integer)HistoryManagerImpl.getUrlId(uRL, true), (Integer)HistoryManagerImpl.getUrlId(uRL2, true)).toString(), null);
                    if (node instanceof Subject) {
                        ((Subject)node).attach(this);
                    }
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                HistoryManagerImpl.persistComments(date, string);
            }
        }
    }

    public void restore(LocalState[] localStateArray, Context context) throws Exception {
        int n = 0;
        while (n < localStateArray.length) {
            LocalState localState = localStateArray[n];
            URL uRL = localState.getNodeURL();
            URL uRL2 = localState.getStateURL();
            try {
                Node node = NodeFactory.find(uRL2);
                if (uRL == null) {
                    if (node != null) {
                        MessageDialog.information((Component)((Object)Ide.getMainWindow()), (Object)IdeImplArb.format(89, URLFileSystem.getPlatformPathName(uRL2)), (String)IdeImplArb.getString(90), null);
                    } else if (!URLFileSystem.exists(uRL2) || MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)IdeImplArb.format(92, URLFileSystem.getPlatformPathName(uRL2)), (String)IdeImplArb.getString(90), null)) {
                        URLFileSystem.copy(localState.getDataURL(), uRL2);
                        HistoryManagerImpl.restoreUrlId(localState.getNodeId(), uRL2);
                        node = NodeFactory.findOrCreate(uRL2);
                    }
                } else if (!URLFileSystem.equals(uRL, uRL2)) {
                    Context context2 = new Context(context);
                    node = NodeFactory.findOrCreate(uRL);
                    context2.setNode(node);
                    HistoryContext.setLocalState(context2, localState);
                    Command command = CommandProcessor.createCommand(RESTORE_HISTORY_RENAME_CMD, context2);
                    if (command != null) {
                        CommandProcessor.getInstance().invoke(command);
                    }
                } else {
                    Context context3 = new Context(context);
                    node = node != null ? node : NodeFactory.findOrCreate(uRL2);
                    context3.setNode(node);
                    HistoryContext.setLocalState(context3, localState);
                    Command command = CommandProcessor.createCommand("oracle.ide.cmd.RestoreHistoryCommand", context3);
                    if (command != null) {
                        CommandProcessor.getInstance().invoke(command);
                    }
                }
            }
            catch (Exception exception) {
                MessageDialog.information((Component)((Object)Ide.getMainWindow()), (Object)IdeImplArb.format(91, new String[]{URLFileSystem.getPlatformPathName(uRL2)}), (String)IdeImplArb.getString(90), null);
            }
            ++n;
        }
    }

    public void registerHistorian(Class clazz, Class clazz2) throws Exception {
        if (Historian.class.isAssignableFrom(clazz) && Node.class.isAssignableFrom(clazz2)) {
            if (LOCTYPE_TO_HISTORIANTYPE.put(clazz2, clazz) == null) {
                NodeFactory.attach(this, clazz2);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Class getRegisteredHistorian(Class clazz) throws Exception {
        if (Node.class.isAssignableFrom(clazz)) {
            return HistoryManagerImpl.lookupRegisteredHistorian(clazz);
        }
        throw new Exception();
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n;
        int n2 = n = updateMessage != null ? updateMessage.getMessageID() : -1;
        if (n == NodeFactory.NODE_CACHED) {
            Node node = (Node)object;
            if (HistoryManagerImpl.getNodeId(node.getURL(), false) != null) {
                node.attach(this);
            }
        } else if (n == NodeFactory.NODE_UNCACHED) {
            Node node = (Node)object;
            URL uRL = node.getURL();
            node.detach(this);
            HistoryManagerImpl.updateNodeId(uRL, null);
        } else if (n == UpdateMessage.OBJECT_RENAMED) {
            List list = updateMessage.getAddObjects();
            URL uRL = null;
            URL uRL2 = null;
            if (!list.isEmpty()) {
                uRL2 = ((Node)list.get(0)).getURL();
                uRL = ((Node)object).getURL();
            } else {
                Node node = RenameMessage.getRenamedNode(updateMessage);
                if (node != null) {
                    list = updateMessage.getModifyObjects();
                    if (!list.isEmpty()) {
                        uRL2 = node.getURL();
                        uRL = (URL)list.get(0);
                    }
                } else {
                    list = updateMessage.getModifyObjects();
                    if (!list.isEmpty()) {
                        uRL2 = ((Node)object).getURL();
                        uRL = (URL)list.get(0);
                    }
                }
            }
            if (uRL2 != null && uRL != null) {
                HistoryManagerImpl.updateNodeId(uRL, uRL2);
            }
        }
    }

    public void clear(URL[] uRLArray) {
        HistoryManagerImpl._clear(uRLArray);
    }

    private synchronized void optionsChanged(HistoryOptions historyOptions) {
        this.active = historyOptions != null ? historyOptions.isEnabled() : this.active;
    }

    static URL createDataUrl(Object object, Date date) {
        URL uRL = URLFactory.newDirURL(HISTORY_DIR + object);
        URLFileSystem.mkdirs(uRL);
        return URLFactory.newFileURL(uRL.getPath() + date.getTime());
    }

    static synchronized String getDescription(LocalState localState) {
        Iterator iterator;
        if (localState != null && (iterator = COMMENTS.getKeyIterator("" + localState.getDate().getTime())) != null && iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf(FIELD_SEPARATOR);
            return string.substring(++n);
        }
        return null;
    }

    static synchronized Object getNodeId(URL uRL, boolean bl) {
        if (uRL == null) {
            return null;
        }
        Object object = HistoryManagerImpl.getUrlId(uRL, bl);
        return HistoryManagerImpl.getNodeId(object, bl);
    }

    static synchronized Object getNodeId(Object object, boolean bl) {
        HashMap hashMap;
        Object object2 = null;
        if (object != null && (object2 = (Object)(hashMap = HistoryManagerImpl.loadNodeIds()).get(object)) == null && bl) {
            object2 = HistoryManagerImpl.nextNodeId(object);
        }
        return object2;
    }

    private static synchronized HashMap loadNodeIds() {
        if (URLID_TO_NODEID != null) {
            return URLID_TO_NODEID;
        }
        URLID_TO_NODEID = new HashMap();
        DELETED_NODE_IDS = new ArrayList();
        int n = 0;
        Iterator iterator = NODES.getKeyIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n2 = string.indexOf(FIELD_SEPARATOR);
                try {
                    ++n;
                    Integer n3 = Integer.decode(string.substring(0, n2));
                    Integer n4 = Integer.decode(string.substring(++n2));
                    if (n3 != -1) {
                        URLID_TO_NODEID.put(n3, n4);
                        continue;
                    }
                    DELETED_NODE_IDS.add(n4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return URLID_TO_NODEID;
    }

    private static List loadDeletedNodeIds() {
        HistoryManagerImpl.loadNodeIds();
        return DELETED_NODE_IDS;
    }

    private static synchronized HashMap loadUrlIds() {
        if (URL_TO_URLID != null) {
            return URL_TO_URLID;
        }
        URL_TO_URLID = new HashMap();
        int n = 0;
        Iterator iterator = URLS.getKeyIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n2 = string.lastIndexOf(FIELD_SEPARATOR);
                try {
                    ++n;
                    URL uRL = Ide.getWorkspaces().getWorkDirectory();
                    URL uRL2 = URLFactory.newURL(uRL, string.substring(0, n2));
                    Integer n3 = Integer.decode(string.substring(++n2));
                    URL_TO_URLID.put(uRL2, n3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return URL_TO_URLID;
    }

    private static synchronized void updateNodeId(URL uRL, URL uRL2) {
        Object object = HistoryManagerImpl.getUrlId(uRL, false);
        if (object != null) {
            HashMap hashMap = HistoryManagerImpl.loadNodeIds();
            Object v = hashMap.get(object);
            if (v == null) {
                return;
            }
            hashMap.remove(object);
            String string = object.toString() + FIELD_SEPARATOR;
            if (uRL2 != null) {
                object = HistoryManagerImpl.getUrlId(uRL2, false);
                if (object != null) {
                    Object v2 = hashMap.get(object);
                    if (v2 != null) {
                        HistoryManagerImpl.updateNodeId(uRL2, null);
                    }
                } else {
                    object = HistoryManagerImpl.getUrlId(uRL2, true);
                }
                hashMap.put(object, v);
            } else {
                List list = HistoryManagerImpl.loadDeletedNodeIds();
                object = new Integer(-1);
                list.add(v);
            }
            try {
                NODES.delRecord(string + v.toString());
                string = object.toString() + FIELD_SEPARATOR;
                NODES.putRecord(string + v, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static synchronized void restoreUrlId(Object object, URL uRL) {
        Object object2 = HistoryManagerImpl.getUrlId(uRL, true);
        if (object2 != null) {
            HashMap hashMap = HistoryManagerImpl.loadNodeIds();
            Object v = hashMap.get(object2);
            if (v != null && !v.equals(object)) {
                HistoryManagerImpl.updateNodeId(uRL, null);
            }
            List list = HistoryManagerImpl.loadDeletedNodeIds();
            list.remove(object);
            hashMap.put(object2, object);
            try {
                String string = new Integer(-1).toString() + FIELD_SEPARATOR;
                NODES.delRecord(string + object.toString());
                string = object2.toString() + FIELD_SEPARATOR;
                NODES.putRecord(string + object, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static synchronized Node getNode(Object object) {
        URL uRL = HistoryManagerImpl.getCurrentUrl(object);
        if (uRL != null) {
            try {
                if (!URLFileSystem.isDirectory(uRL)) {
                    Node node = NodeFactory.findOrCreate(uRL);
                    return node;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    static synchronized Object getUrlId(URL uRL, boolean bl) {
        if (uRL == null) {
            return null;
        }
        HashMap hashMap = HistoryManagerImpl.loadUrlIds();
        Object object = hashMap.get(uRL);
        if (object == null && bl) {
            object = HistoryManagerImpl.nextUrlId(uRL);
        }
        return object;
    }

    static synchronized URL getUrl(Object object) {
        Iterator iterator;
        if (object == null) {
            return null;
        }
        HashMap hashMap = HistoryManagerImpl.loadUrlIds();
        Set set = hashMap.keySet();
        Iterator iterator2 = iterator = set != null ? set.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Object v = hashMap.get(e);
                if (v == null || !object.equals(v)) continue;
                return (URL)e;
            }
        }
        return null;
    }

    static synchronized URL getCurrentUrl(Object object) {
        if (object != null) {
            Iterator iterator;
            HashMap hashMap = HistoryManagerImpl.loadNodeIds();
            Set set = hashMap.keySet();
            Iterator iterator2 = iterator = set != null ? set.iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Object v = hashMap.get(e);
                    if (v == null || !object.equals(v)) continue;
                    return HistoryManagerImpl.getUrl(e);
                }
            }
        }
        return null;
    }

    static synchronized Object nextNodeId(Object object) {
        Integer n;
        if (object == null) {
            return null;
        }
        HashMap hashMap = HistoryManagerImpl.loadNodeIds();
        Collection collection = hashMap.values();
        List list = HistoryManagerImpl.loadDeletedNodeIds();
        if (collection != null) {
            BitSet bitSet = new BitSet(Math.max(collection.size(), list.size()));
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                bitSet.set((Integer)iterator.next());
            }
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                bitSet.set((Integer)iterator2.next());
            }
            int n2 = bitSet.nextClearBit(0);
            n = new Integer(n2 >= 0 ? n2 : bitSet.length());
        } else {
            n = new Integer(0);
        }
        String string = object.toString() + FIELD_SEPARATOR + ((Object)n).toString();
        hashMap.put(object, n);
        NODES.putRecord(string, null);
        return n;
    }

    static synchronized Object nextUrlId(URL uRL) {
        Integer n;
        if (uRL == null) {
            return null;
        }
        HashMap hashMap = HistoryManagerImpl.loadUrlIds();
        Collection collection = hashMap.values();
        if (collection != null) {
            BitSet bitSet = new BitSet(collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                bitSet.set((Integer)iterator.next());
            }
            int n2 = bitSet.nextClearBit(0);
            n = new Integer(n2 >= 0 ? n2 : bitSet.length());
        } else {
            n = new Integer(0);
        }
        String string = URLFileSystem.toRelativeSpec(uRL, Ide.getWorkspaces().getWorkDirectory()) + FIELD_SEPARATOR;
        String string2 = string + ((Object)n).toString();
        hashMap.put(uRL, n);
        URLS.putRecord(string2, null);
        return n;
    }

    private static Historian getHistorian(Class clazz) {
        Class clazz2;
        Historian historian = null;
        if (clazz != null && (clazz2 = HistoryManagerImpl.lookupRegisteredHistorian(clazz)) != null && (historian = (Historian)HISTORIANTYPE_TO_HISTORIAN.get(clazz2)) == null) {
            try {
                historian = (Historian)clazz2.newInstance();
                HISTORIANTYPE_TO_HISTORIAN.put(clazz2, historian);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return historian;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void persistComments(Date date, String string) {
        if (date != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(date.getTime());
            stringBuffer.append(FIELD_SEPARATOR);
            stringBuffer.append(string);
            NameSpace nameSpace = COMMENTS;
            synchronized (nameSpace) {
                COMMENTS.putRecord(stringBuffer.toString(), null);
            }
        }
    }

    private static synchronized void _clear(URL[] uRLArray) {
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        HashMap<Object, LocalStateImpl> hashMap2 = new HashMap<Object, LocalStateImpl>();
        Iterator iterator = STATES.getReverseKeyIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                boolean bl = false;
                try {
                    String string = (String)iterator.next();
                    LocalStateImpl localStateImpl = LocalStateImpl.decode(string);
                    int n = 0;
                    while (n < uRLArray.length) {
                        if (URLFileSystem.equals(localStateImpl.getNodeURL(), uRLArray[n])) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                    if (bl) {
                        STATES.delRecord(string);
                        URLFileSystem.delete(localStateImpl.getDataURL());
                        continue;
                    }
                    hashMap.put(localStateImpl.getNodeId(), new Integer(0));
                    hashMap2.put(localStateImpl.getStateUrlId(), localStateImpl);
                    hashMap2.put(localStateImpl.getDataUrlId(), localStateImpl);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        HistoryManagerImpl._pruneHistory(hashMap, hashMap2);
    }

    private static synchronized void pruneHistory() {
        if (PRUNED) {
            return;
        }
        PRUNED = true;
        IdeSettings ideSettings = Ide.getSettings();
        HistoryOptions historyOptions = (HistoryOptions)ideSettings.getData("HistoryOptions");
        long l = System.currentTimeMillis();
        int n = Integer.MAX_VALUE;
        if (historyOptions != null) {
            int n2 = historyOptions.getLifespan();
            if (n2 >= 0) {
                long l2 = (long)n2 * (long)24 * (long)60 * (long)60 * 1000L;
                l -= l2;
            } else {
                l = Long.MIN_VALUE;
            }
            n = historyOptions.getRevisions();
        } else {
            l = Long.MIN_VALUE;
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        HashMap<Object, LocalStateImpl> hashMap2 = new HashMap<Object, LocalStateImpl>();
        Date date = new Date(l);
        Iterator iterator = STATES.getReverseKeyIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                boolean bl = false;
                try {
                    String string = (String)iterator.next();
                    LocalStateImpl localStateImpl = LocalStateImpl.decode(string);
                    int n3 = 0;
                    if (date.after(localStateImpl.getDate())) {
                        bl = true;
                    } else {
                        Object v = hashMap.get(localStateImpl.getNodeId());
                        int n4 = n3 = v != null ? (Integer)v : 0;
                        if (++n3 > n) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        STATES.delRecord(string);
                        URLFileSystem.delete(localStateImpl.getDataURL());
                        continue;
                    }
                    hashMap.put(localStateImpl.getNodeId(), new Integer(n3));
                    hashMap2.put(localStateImpl.getStateUrlId(), localStateImpl);
                    hashMap2.put(localStateImpl.getDataUrlId(), localStateImpl);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        HistoryManagerImpl._pruneHistory(hashMap, hashMap2);
    }

    private static synchronized void _pruneHistory(HashMap hashMap, HashMap hashMap2) {
        List list;
        HashMap hashMap3 = HistoryManagerImpl.loadNodeIds();
        Set set = hashMap3 != null ? hashMap3.keySet() : null;
        Object[] objectArray = null;
        if (set != null) {
            objectArray = new Object[set.size()];
            set.toArray(objectArray);
        }
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                try {
                    Object object = objectArray[n];
                    Object v = hashMap3.get(object);
                    if (hashMap.get(v) == null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(object.toString());
                        stringBuffer.append(FIELD_SEPARATOR);
                        stringBuffer.append(v.toString());
                        NODES.delRecord(stringBuffer.toString());
                        hashMap3.remove(object);
                        URL uRL = URLFactory.newDirURL(HISTORY_DIR + v);
                        URLFileSystem.delete(uRL);
                    } else {
                        hashMap2.put(object, v);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }
        if ((list = HistoryManagerImpl.loadDeletedNodeIds()) != null) {
            int n = list.size() - 1;
            while (n >= 0) {
                try {
                    Object e = list.get(n);
                    if (hashMap.get(e) == null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(new Integer(-1).toString());
                        stringBuffer.append(FIELD_SEPARATOR);
                        stringBuffer.append(e.toString());
                        NODES.delRecord(stringBuffer.toString());
                        list.remove(e);
                        URL uRL = URLFactory.newDirURL(HISTORY_DIR + e);
                        URLFileSystem.delete(uRL);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                --n;
            }
        }
        set = (hashMap3 = HistoryManagerImpl.loadUrlIds()) != null ? hashMap3.keySet() : null;
        objectArray = null;
        if (set != null) {
            objectArray = new Object[set.size()];
            set.toArray(objectArray);
        }
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                try {
                    Object object = objectArray[n];
                    Object v = hashMap3.get(object);
                    if (hashMap2.get(v) == null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(URLFileSystem.toRelativeSpec((URL)object, Ide.getWorkspaces().getWorkDirectory()));
                        stringBuffer.append(FIELD_SEPARATOR);
                        stringBuffer.append(v.toString());
                        URLS.delRecord(stringBuffer.toString());
                        hashMap3.remove(object);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }
        hashMap.clear();
        hashMap2.clear();
    }

    private static final Class lookupRegisteredHistorian(Class clazz) {
        for (Map.Entry entry : LOCTYPE_TO_HISTORIANTYPE.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(clazz)) continue;
            return (Class)entry.getValue();
        }
        return null;
    }

    static void mav$optionsChanged(HistoryManagerImpl historyManagerImpl, HistoryOptions historyOptions) {
        historyManagerImpl.optionsChanged(historyOptions);
    }

    public final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            HistoryManagerImpl.mav$optionsChanged(HistoryManagerImpl.this, (HistoryOptions)changeEvent.getSource());
        }
    }
}

