/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.history;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import oracle.ide.config.IdeSettings;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.history.HistoryOptions;
import oracle.ideimpl.resource.IdeImplArb;

public class HistoryOptionsPanel
extends DefaultTraversablePanel {
    private JCheckBox enabledCheckBox;
    private GridBagLayout gridBagLayout1;
    private JLabel lifespanLabel;
    private JSpinner lifespanSpinner;
    private JLabel lifespanHint;
    private JLabel revisionsLabel;
    private JSpinner revisionsSpinner;
    private JLabel revisionsHint;

    void $init$() {
        this.gridBagLayout1 = new GridBagLayout();
        this.lifespanLabel = new JLabel();
        this.lifespanSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 365, 1));
        this.lifespanHint = new JLabel();
        this.revisionsLabel = new JLabel();
        this.revisionsSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        this.revisionsHint = new JLabel();
    }

    public HistoryOptionsPanel() {
        this.$init$();
        try {
            this.jbInit();
            HelpSystem helpSystem = HelpSystem.getHelpSystem();
            if (helpSystem != null) {
                helpSystem.registerTopic(this, "f1_idedidesetlocalhistory_html");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.enabledCheckBox = new JCheckBox();
        this.setLayout(this.gridBagLayout1);
        this.enabledCheckBox.addItemListener(new 1());
        this.lifespanHint.setText(EnvironOptionsArb.getString(9));
        this.lifespanHint.setHorizontalAlignment(2);
        this.revisionsHint.setText(EnvironOptionsArb.getString(9));
        this.revisionsHint.setHorizontalAlignment(2);
        ResourceUtils.resButton(this.enabledCheckBox, HistoryOptions.getEnabledLabel());
        ResourceUtils.resLabel(this.lifespanLabel, this.lifespanSpinner, IdeImplArb.getString(93));
        ResourceUtils.resLabel(this.revisionsLabel, this.revisionsSpinner, IdeImplArb.getString(94));
        this.add((Component)this.enabledCheckBox, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.lifespanLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 25, 0, 5), 0, 0));
        this.add((Component)this.lifespanSpinner, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.lifespanHint, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 5), 0, 0));
        this.add((Component)this.revisionsLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 25, 0, 5), 0, 0));
        this.add((Component)this.revisionsSpinner, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.revisionsHint, new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 10, 0, 5), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        HistoryOptions historyOptions = (HistoryOptions)traversableContext.find("HistoryOptions");
        this.enabledCheckBox.setSelected(historyOptions.isEnabled());
        this.lifespanSpinner.setValue(new Integer(historyOptions.getLifespan()));
        this.revisionsSpinner.setValue(new Integer(historyOptions.getRevisions()));
        this.updateEnabled(null);
    }

    public void onExit(TraversableContext traversableContext) {
        HistoryOptions historyOptions = (HistoryOptions)traversableContext.find("HistoryOptions");
        int n = (Integer)this.lifespanSpinner.getValue();
        int n2 = (Integer)this.revisionsSpinner.getValue();
        boolean bl = n != historyOptions.getLifespan() || n2 != historyOptions.getRevisions();
        historyOptions.setEnabled(this.enabledCheckBox.isSelected());
        historyOptions.setLifespan(n);
        historyOptions.setRevisions(n2);
        if (bl) {
            IdeSettings ideSettings = (IdeSettings)traversableContext.find("ide-options");
            ideSettings.setAskExit(true);
        }
    }

    private void updateEnabled(ItemEvent itemEvent) {
        this.lifespanSpinner.setEnabled(this.enabledCheckBox.isSelected());
        this.revisionsSpinner.setEnabled(this.enabledCheckBox.isSelected());
    }

    static void mav$updateEnabled(HistoryOptionsPanel historyOptionsPanel, ItemEvent itemEvent) {
        historyOptionsPanel.updateEnabled(itemEvent);
    }

    public final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            HistoryOptionsPanel.mav$updateEnabled(HistoryOptionsPanel.this, itemEvent);
        }
    }
}

