/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.history;

import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;
import oracle.ide.history.LocalState;
import oracle.ideimpl.history.HistoryManagerImpl;

final class LocalStateImpl
extends LocalState {
    public static final String FIELD_SEPARATOR = "|";
    private Date date;
    private Integer nodeId;
    private Integer nodeUrlId;
    private Integer dataUrlId;

    LocalStateImpl(Date date, Integer n, Integer n2, Integer n3) {
        this.date = date;
        this.nodeId = n;
        this.nodeUrlId = n2;
        this.dataUrlId = n3;
    }

    public Date getDate() {
        return this.date;
    }

    public URL getNodeURL() {
        return HistoryManagerImpl.getCurrentUrl(this.nodeId);
    }

    public URL getStateURL() {
        return HistoryManagerImpl.getUrl(this.nodeUrlId);
    }

    public URL getDataURL() {
        return HistoryManagerImpl.getUrl(this.dataUrlId);
    }

    public String getDescription() {
        return HistoryManagerImpl.getDescription(this);
    }

    public Object getNodeId() {
        return this.nodeId;
    }

    Object getStateUrlId() {
        return this.nodeUrlId;
    }

    Object getDataUrlId() {
        return this.dataUrlId;
    }

    public static LocalStateImpl decode(String string) throws NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, FIELD_SEPARATOR);
        Integer n = Integer.decode(stringTokenizer.nextToken());
        Date date = new Date(Long.decode(stringTokenizer.nextToken()));
        Integer n2 = Integer.decode(stringTokenizer.nextToken());
        Integer n3 = Integer.decode(stringTokenizer.nextToken());
        return new LocalStateImpl(date, n, n2, n3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.nodeId);
        stringBuffer.append(FIELD_SEPARATOR);
        stringBuffer.append(this.date.getTime());
        stringBuffer.append(FIELD_SEPARATOR);
        stringBuffer.append(this.nodeUrlId);
        stringBuffer.append(FIELD_SEPARATOR);
        stringBuffer.append(this.dataUrlId);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof LocalStateImpl) {
            LocalStateImpl localStateImpl = (LocalStateImpl)object;
            return localStateImpl.date.equals(this.date) && localStateImpl.nodeId.equals(this.nodeId) && localStateImpl.nodeUrlId.equals(this.nodeUrlId) && localStateImpl.dataUrlId.equals(this.dataUrlId);
        }
        return false;
    }
}

