/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.awt.Component;
import java.awt.Window;
import java.beans.VetoableChangeListener;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.resource.IdeArb;
import oracle.ideimpl.resource.InspectorArb;

public class InspectorGroup
extends oracle.bali.inspector.InspectorGroup {
    protected boolean showAdvancedEditor(Object object, PropertyEditorFactory propertyEditorFactory, PropertyInspector propertyInspector) {
        JEWTDialog jEWTDialog = new JEWTDialog(WindowUtils.parentFrame((Component)propertyInspector), this.getAdvancedEditorTitle(object, propertyEditorFactory, propertyInspector), 7);
        PropertyModel propertyModel = propertyInspector.getPropertyModel();
        int n = propertyModel.getColumnIndex(PropertyModel.COLUMN_VALUE);
        Object object2 = propertyModel.getPropertyByID(n, object);
        propertyEditorFactory.setEditorValue(object2);
        Component component = propertyEditorFactory.getAdvancedEditor();
        boolean bl = component instanceof VetoableChangeListener;
        jEWTDialog.setResizable(true);
        jEWTDialog.setContent(component);
        jEWTDialog.setLocale(propertyInspector.getLocale());
        if (bl) {
            jEWTDialog.addVetoableChangeListener((VetoableChangeListener)((Object)component));
        }
        WindowUtils.centerWindow((Window)jEWTDialog, (Component)propertyInspector);
        JTable jTable = propertyInspector.getPropertyTable();
        TableCellEditor tableCellEditor = jTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        boolean bl2 = jEWTDialog.runDialog();
        if (bl) {
            jEWTDialog.removeVetoableChangeListener((VetoableChangeListener)((Object)component));
        }
        if (bl2) {
            Object object3 = propertyEditorFactory.getEditorValue();
            try {
                propertyModel.setPropertyByID(n, object, object3);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.showErrorMessage(object, propertyEditorFactory, propertyInspector, throwable, object3);
            }
        }
        jEWTDialog.dispose();
        SwingUtilities.invokeLater(new Cleanup(jTable));
        return bl2;
    }

    protected void showErrorMessage(Object object, PropertyEditorFactory propertyEditorFactory, PropertyInspector propertyInspector, Throwable throwable, Object object2) {
        String string;
        JTable jTable = propertyInspector.getPropertyTable();
        PropertyModel propertyModel = (PropertyModel)jTable.getModel();
        int n = propertyModel.getPropertyIndex(object);
        String string2 = propertyModel.getPropertyDisplayName(n);
        String string3 = object2 != null ? object2.toString() : null;
        String string4 = null;
        String string5 = string = throwable != null ? throwable.getLocalizedMessage() : null;
        string4 = string == null ? (string3 == null ? InspectorArb.format(19, new String[]{string2, string}) : InspectorArb.format(20, new String[]{string2, string3, string})) : string;
        TableCellEditor tableCellEditor = jTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        JMultiLineLabel jMultiLineLabel = new JMultiLineLabel(string4);
        JOptionPane.showMessageDialog(jTable, (Object)jMultiLineLabel, IdeArb.getString(235), 0);
    }

    private static final class Cleanup
    implements Runnable {
        JTable table;

        Cleanup(JTable jTable) {
            this.table = jTable;
        }

        public void run() {
            Window window = SwingUtilities.getWindowAncestor(this.table);
            if (window != null) {
                window.toFront();
            }
            this.table.requestFocus();
        }
    }
}

