/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.layout.ViewId;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.ideimpl.inspector.InspectorDockableFactory;
import oracle.ideimpl.inspector.InspectorWindowImpl;
import oracle.ideimpl.resource.IdeImplMenuArb;
import oracle.ideimpl.resource.InspectorArb;

public class InspectorManagerImpl
extends InspectorManager
implements Addin {
    public static final int TOGGLE_TOOLBAR_CMD_ID = Ide.findOrCreateCmdID("Inspector.TOGGLE_TOOLBAR_CMD_ID");
    public static final int TOGGLE_PAGE_CMD_ID = Ide.findOrCreateCmdID("Inspector.TOGGLE_PAGE_CMD_ID");
    public static final int CUSTOMIZER_CMD_ID = Ide.findOrCreateCmdID("Inspector.CUSTOMIZER_CMD_ID");
    private static IdeAction CUSTOMIZER_CMD_ACTION;
    public static final String SINGLETON = "SingletonInspectorWindow";
    private static final String SUPPORTERS_PROP = "Inspector.inspectedViews";
    private static final String DETRACTORS_PROP = "Inspector.nonInspectedViews";
    private static final DockableFactory FACTORY;
    private static final List INSPECTION_SUPPORTERS;
    private static final List INSPECTION_DETRACTORS;

    static {
        FACTORY = new InspectorDockableFactory();
        INSPECTION_SUPPORTERS = new ArrayList();
        INSPECTION_DETRACTORS = new ArrayList();
        INSPECTION_SUPPORTERS.add("oracle.ide.navigator.NavigatorWindow");
        INSPECTION_SUPPORTERS.add("oracle.ide.editor.Editor");
        INSPECTION_SUPPORTERS.add("oracle.ideimpl.explorer.ExplorerWindowImpl");
        INSPECTION_SUPPORTERS.add("oracle.ide.explorer.Explorer");
        String string = Ide.getProperty(SUPPORTERS_PROP);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                INSPECTION_SUPPORTERS.add(string2);
            }
        }
        if ((string = Ide.getProperty(DETRACTORS_PROP)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                INSPECTION_DETRACTORS.add(string3);
            }
        }
    }

    protected InspectorManagerImpl() {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n;
        int n2 = n = ideAction != null ? ideAction.getCommandId() : -1;
        if (n == 70) {
            InspectorWindowImpl inspectorWindowImpl;
            CustomTab customTab;
            View view = context.getView();
            if (view instanceof InspectorWindowImpl && (customTab = (inspectorWindowImpl = (InspectorWindowImpl)view).getTabs()) != null) {
                customTab.setSelectedPage(customTab.getSelectedPage() - 1);
            }
            return true;
        }
        if (n == 71) {
            InspectorWindowImpl inspectorWindowImpl;
            CustomTab customTab;
            View view = context.getView();
            if (view instanceof InspectorWindowImpl && (customTab = (inspectorWindowImpl = (InspectorWindowImpl)view).getTabs()) != null) {
                customTab.setSelectedPage(customTab.getSelectedPage() + 1);
            }
            return true;
        }
        if (n == CUSTOMIZER_CMD_ID) {
            View view = context.getView();
            if (view instanceof InspectorWindowImpl) {
                ((InspectorWindowImpl)view).showCustomizer();
            }
            return true;
        }
        return super.handleEvent(ideAction, context);
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction == null) {
            return false;
        }
        int n = ideAction.getCommandId();
        if (n == 70) {
            View view = context.getView();
            if (view instanceof InspectorWindowImpl) {
                InspectorWindowImpl inspectorWindowImpl = (InspectorWindowImpl)view;
                CustomTab customTab = inspectorWindowImpl.getTabs();
                ideAction.setEnabled(customTab != null && customTab.getSelectedPage() > 0);
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == 71) {
            View view = context.getView();
            if (view instanceof InspectorWindowImpl) {
                InspectorWindowImpl inspectorWindowImpl = (InspectorWindowImpl)view;
                CustomTab customTab = inspectorWindowImpl.getTabs();
                ideAction.setEnabled(customTab != null && customTab.getSelectedPage() < customTab.getPageCount() - 1);
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        return super.update(ideAction, context);
    }

    public void initialize() {
        super.initialize();
        InspectorManager.setInspectorManager(this);
        IdeAction ideAction = this.getShowAction();
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem(ideAction, MenuConstants.WEIGHT_VIEW_PROPERTY_INSPECTOR);
        JMenu jMenu = MenuManager.getJMenu("View");
        menubar.add(jMenuItem, jMenu, MenuConstants.SECTION_VIEW_SUPPORTING);
    }

    protected String getViewCategory() {
        return "InspectorWindow";
    }

    protected String getAcceleratorFile() {
        return "oracle/ideimpl/inspector/accelerators.xml";
    }

    protected String getDefaultName() {
        return SINGLETON;
    }

    protected ViewId getViewId(Context context) {
        if (context != null) {
            return new ViewId(this.getViewCategory());
        }
        return new ViewId(this.getViewCategory());
    }

    protected DockableFactory getDockableFactory() {
        return FACTORY;
    }

    protected IdeAction createShowAction() {
        return IdeAction.get(33, AddinManager.getAddinManager().getCommand(33, "oracle.ide.cmd.NotImplementedCommand"), IdeArb.getString(166), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeArb.getInteger(167), IdeArb.getInstance(), 168, null, true);
    }

    protected float getToggleToolbarMenuWeight() {
        return MenuConstants.WEIGHT_VIEW_PROPERTY_INSPECTOR;
    }

    protected IdeAction createToggleToolbarAction() {
        return IdeAction.get(TOGGLE_TOOLBAR_CMD_ID, null, IdeImplMenuArb.getString(12), IdeMainWindow.ACTION_CATEGORY_VIEW, IdeImplMenuArb.getInteger(13), IdeImplMenuArb.getInstance(), 14, null, true);
    }

    protected DockableView createDockableView(Context context, ViewId viewId) {
        InspectorWindowImpl inspectorWindowImpl = new InspectorWindowImpl(viewId.getId());
        if (inspectorWindowImpl != null && context != null) {
            inspectorWindowImpl.setContext(context);
        }
        return inspectorWindowImpl;
    }

    protected int getOrientation(ViewId viewId, DockableView dockableView) {
        return dockableView != null ? 4 : 1;
    }

    public boolean supportsInspection(View view) {
        if (view == null) {
            return false;
        }
        Class<?> clazz = view.getClass();
        Class<?> clazz2 = null;
        Iterator iterator = INSPECTION_SUPPORTERS.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz3 = null;
            try {
                clazz3 = Class.forName((String)iterator.next());
            }
            catch (Exception exception) {
                continue;
            }
            if (clazz == clazz3) {
                return true;
            }
            if (!clazz3.isAssignableFrom(clazz)) continue;
            if (clazz2 == null) {
                clazz2 = clazz3;
                continue;
            }
            if (!clazz2.isAssignableFrom(clazz3)) continue;
            clazz2 = clazz3;
        }
        iterator = INSPECTION_DETRACTORS.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz4 = null;
            try {
                clazz4 = Class.forName((String)iterator.next());
            }
            catch (Exception exception) {
                continue;
            }
            if (clazz == clazz4) {
                return false;
            }
            if (!clazz4.isAssignableFrom(clazz)) continue;
            if (clazz2 == null) {
                return false;
            }
            if (!clazz2.isAssignableFrom(clazz4)) continue;
            return false;
        }
        return clazz2 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IdeAction getCustomizerCmdAction() {
        Class<InspectorManagerImpl> clazz = InspectorManagerImpl.class;
        synchronized (InspectorManagerImpl.class) {
            if (CUSTOMIZER_CMD_ACTION == null) {
                CUSTOMIZER_CMD_ACTION = IdeAction.get(CUSTOMIZER_CMD_ID, null, InspectorArb.getString(23));
                CUSTOMIZER_CMD_ACTION.putValue("SmallIcon", InspectorArb.getIcon(24));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return CUSTOMIZER_CMD_ACTION;
        }
    }
}

