/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.inspector.PropertyExpansionState;
import oracle.bali.inspector.PropertyGroup;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.Site;
import oracle.ide.help.HelpInfo;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.inspector.Inspectable;
import oracle.ide.inspector.Inspectable2;
import oracle.ide.inspector.InspectorFactory;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.inspector.InspectorPage;
import oracle.ide.inspector.InspectorWindow;
import oracle.ide.inspector.MultiInspectable;
import oracle.ide.inspector.PropertyEditorRegistrar;
import oracle.ide.layout.Layout;
import oracle.ide.layout.URL2String;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.ElementFactory;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ideimpl.inspector.InspectorManagerImpl;
import oracle.ideimpl.inspector.PropertyInspector;
import oracle.ideimpl.resource.InspectorArb;
import oracle.javatools.controls.HyperlinkButton;

public final class InspectorWindowImpl
extends InspectorWindow
implements ListSelectionListener,
Observer {
    public static final Subject[] NO_SUBJECTS = new Subject[0];
    static final Object NULL_OBJECT = new Object();
    private static final String CATEGORIZED = ".categorized";
    private static final String UNION = ".union";
    private static final String SHOW_READ_ONLY = ".showReadOnly";
    private static final String SHOW_WRITE_ONLY = ".showWriteOnly";
    private static final String SHOW_FIND = ".showFind";
    private static final String SHOW_STATUS = ".showStatus";
    private static final String TARGET = ".pinTarget";
    private static final String COUNT = ".count";
    private static final String NODE = ".document";
    private static final String PROJECT = ".project";
    private static final String WORKSPACE = ".workspace";
    private static boolean REGISTRATION_COMPLETE;
    private String title;
    private Component selectedPage;
    private JPanel container;
    private CustomTab tabs;
    private JSplitPane outerSplit;
    private JSplitPane innerSplit;
    private PropertyInspector inspector;
    private JPanel linksPanel;
    private JScrollPane linksScroll;
    private JEditorPane status;
    private JScrollPane statusScroll;
    private PropertyAccess properties;
    private Inspectable inspectable;
    private Customizer customizer;
    private JEWTDialog customizerDlg;
    private Component[] additionalPages;
    private TattleTale tattleTale;
    private TitleListener titleListener;
    private HashMap idMap;
    private HashMap valueMap;
    private Context context;
    private Context initialContext;
    private Subject[] subjects;
    private ArrayList pinTargets;
    private URL nodeURL;
    private URL projectURL;
    private URL workspaceURL;
    private TargetMonitor targetMonitor;
    private boolean isMultiUpdate;
    private boolean isLoadingLayout;
    private boolean isStatusVisible;
    private boolean areLinksVisible;
    private boolean isFontSet;
    private HashMap lastGroups;
    private PropertyChangeListener propChangeListenerInnerSplit;
    private int latestDividerLocation;
    private URL propURL;
    private boolean settingDividerLocation;
    private int prevMax;
    private double dividerOffset;
    private int tabHeight;
    private static final Insets EMPTY_INSETS;

    static {
        EMPTY_INSETS = new Insets(0, 0, 0, 0);
    }

    void $init$() {
        this.tattleTale = new TattleTale(null);
        this.titleListener = new TitleListener(null);
        this.idMap = new HashMap();
        this.valueMap = new HashMap();
        this.subjects = NO_SUBJECTS;
        this.pinTargets = new ArrayList();
        this.isStatusVisible = true;
        this.lastGroups = new HashMap();
        this.dividerOffset = 0.1;
        this.tabHeight = 25;
    }

    protected InspectorWindowImpl(String string) {
        super(string);
        this.$init$();
    }

    public int getType() {
        return super.getType() | 1;
    }

    public boolean isStatusVisible() {
        return this.isStatusVisible;
    }

    public void setStatusVisible(boolean bl) {
        if (bl == this.isStatusVisible) {
            return;
        }
        this.isStatusVisible = bl;
        if (this.container != null) {
            if (this.isStatusVisible) {
                if (this.areLinksVisible) {
                    this.outerSplit.add((Component)this.innerSplit, "top");
                    this.outerSplit.add((Component)this.statusScroll, "bottom");
                    this.container.add((Component)this.outerSplit, "Center");
                } else {
                    this.innerSplit.add(this.selectedPage, "top");
                    this.innerSplit.add((Component)this.statusScroll, "bottom");
                    this.container.add((Component)this.innerSplit, "Center");
                }
            } else if (this.areLinksVisible) {
                this.container.remove(this.outerSplit);
                this.container.add((Component)this.innerSplit, "Center");
            } else {
                this.container.remove(this.innerSplit);
                this.container.add(this.selectedPage, "Center");
            }
            this.container.revalidate();
            this.container.repaint();
        }
    }

    public void setStatus(String string) {
        if (this.container != null) {
            if (!this.isFontSet) {
                StyleSheet styleSheet = ((HTMLDocument)this.status.getDocument()).getStyleSheet();
                Font font = this.inspector.getFont();
                if (styleSheet != null && font != null) {
                    styleSheet.addRule("body {font-size: " + font.getSize() + "pt;" + "font-family: " + font.getFamily() + ";" + "font-weight: " + (font.isBold() ? "bold" : "normal") + ";" + "font-style: " + (font.isItalic() ? "italic" : "normal") + ";" + "color: #" + Integer.toHexString(this.status.getForeground().getRGB() & 0xFFFFFF) + "}");
                }
                this.isFontSet = true;
            }
            this.status.setText(string != null ? string : "");
            this.status.setCaretPosition(0);
        }
    }

    private void setLinksVisible(boolean bl) {
        boolean bl2 = false;
        if (bl == this.areLinksVisible) {
            return;
        }
        this.areLinksVisible = bl;
        if (this.container != null) {
            if (this.areLinksVisible) {
                if (this.isStatusVisible) {
                    this.outerSplit.add((Component)this.statusScroll, "bottom");
                    this.innerSplit.add((Component)this.linksScroll, "bottom");
                    this.outerSplit.add((Component)this.innerSplit, "top");
                    this.container.add((Component)this.outerSplit, "Center");
                    bl2 = true;
                } else {
                    this.innerSplit.add(this.selectedPage, "top");
                    this.innerSplit.add((Component)this.linksScroll, "bottom");
                    this.container.add((Component)this.innerSplit, "Center");
                }
            } else if (this.isStatusVisible) {
                this.container.remove(this.outerSplit);
                this.innerSplit.remove(this.linksScroll);
                this.innerSplit.add((Component)this.statusScroll, "bottom");
                this.container.add((Component)this.innerSplit, "Center");
                bl2 = true;
            } else {
                this.container.remove(this.innerSplit);
                this.container.add(this.selectedPage, "Center");
            }
            if (bl2) {
                this.latestDividerLocation = this.innerSplit.getMaximumDividerLocation();
                bl2 = false;
            }
        }
    }

    CustomTab getTabs() {
        return this.tabs;
    }

    public void setToolbarVisible(boolean bl) {
        super.setToolbarVisible(bl);
        if (this.container != null) {
            if (this.isToolbarVisible) {
                if (this.toolbar == null) {
                    this.tabs = new CustomTab(3);
                    this.tabs.setShowIcons(false);
                    this.tabs.setGapBeforeTabs(-1);
                    this.tabs.setGapBetweenTabs(-1);
                    this.tabs.setGapLeft(2);
                    this.tabs.setGapRight(2);
                    this.tabs.setOffsetSelected(0);
                    this.tabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
                    this.tabs.addSelectionListener(this);
                    this.toolbar = new Toolbar();
                    this.updateToolbar();
                    this.container.add((Component)this.toolbar, "North");
                    this.container.add((Component)this.tabs, "South");
                    if (this.selectedPage instanceof InspectorPage) {
                        ((InspectorPage)((Object)this.selectedPage)).toolbarStateChanged(0);
                    }
                    this.container.revalidate();
                }
            } else if (this.toolbar != null) {
                this.container.remove(this.toolbar);
                this.container.remove(this.tabs);
                if (this.selectedPage instanceof InspectorPage) {
                    ((InspectorPage)((Object)this.selectedPage)).toolbarStateChanged(1);
                }
                this.toolbar.dispose();
                this.toolbar.removeAll();
                this.toolbar = null;
                this.tabs.removeSelectionListener(this);
                this.tabs = null;
                this.container.revalidate();
            }
        }
    }

    public Controller getController() {
        return InspectorManager.getInspectorManager();
    }

    public void setContext(Context context) {
        if (this.container == null) {
            this.initialContext = new Context(context);
            this.initialContext.setView(this);
        } else {
            super.setContext(context);
        }
    }

    public Context getContext(EventObject eventObject) {
        if (this.context != null) {
            this.context.setEvent(eventObject);
        } else {
            if (this.initialContext != null) {
                this.initialContext.setEvent(eventObject);
                return this.initialContext;
            }
            this.context = Context.newIdeContext();
            this.context.setView(this);
            this.context.setSelection(View.EMPTY_SELECTION);
        }
        return this.context;
    }

    public HelpInfo getHelpInfo() {
        HelpInfo helpInfo = new HelpInfo("f1_idepropertyinspector_html");
        helpInfo.setContext(this.getContext());
        return helpInfo;
    }

    protected Element[] getSelectionFromUI() {
        if (this.context == null) {
            if (this.initialContext == null) {
                return View.EMPTY_SELECTION;
            }
            return this.initialContext.getSelection();
        }
        return this.context.getSelection();
    }

    public Component getGUI() {
        if (this.container == null) {
            this.initRegistrar();
            this.inspector = new PropertyInspector();
            this.inspector.setName(InspectorArb.getString(21));
            this.inspector.setOwner(this);
            this.selectedPage = this.inspector;
            this.linksPanel = new JPanel();
            this.linksPanel.setLayout(new LinksLayout());
            this.linksPanel.setBorder(BorderFactory.createEmptyBorder());
            this.linksScroll = new JScrollPane(this.linksPanel, 20, 31);
            this.linksScroll.setBorder(BorderFactory.createEmptyBorder());
            this.linksScroll.setFocusable(false);
            this.linksScroll.getViewport().setFocusable(false);
            this.status = new JEditorPane("text/html", "");
            this.status.setEditable(false);
            this.status.setFocusable(false);
            this.status.setMargin(EMPTY_INSETS);
            this.status.setBackground(this.linksPanel.getBackground());
            this.status.setBorder(BorderFactory.createEmptyBorder());
            this.statusScroll = new JScrollPane(this.status, 20, 31);
            this.statusScroll.setBorder(BorderFactory.createEmptyBorder());
            this.statusScroll.setFocusable(false);
            this.statusScroll.getViewport().setFocusable(false);
            this.innerSplit = new JSplitPane();
            this.innerSplit.setOrientation(0);
            this.innerSplit.setResizeWeight(1.0);
            this.propChangeListenerInnerSplit = new propertyChangeListenerInnerSplit(null);
            this.innerSplit.addPropertyChangeListener(this.propChangeListenerInnerSplit);
            this.outerSplit = new JSplitPane();
            this.outerSplit.setOrientation(0);
            this.outerSplit.setResizeWeight(1.0);
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setVgap(0);
            borderLayout.setHgap(0);
            this.container = new JPanel();
            this.container.setLayout(borderLayout);
            if (this.isStatusVisible) {
                this.innerSplit.add((Component)((Object)this.inspector), "top");
                this.innerSplit.add((Component)this.statusScroll, "bottom");
                this.container.add((Component)this.innerSplit, "Center");
            } else {
                this.container.add((Component)((Object)this.inspector), "Center");
            }
            this.innerSplit.setBorder(BorderFactory.createEmptyBorder());
            this.outerSplit.setBorder(BorderFactory.createEmptyBorder());
            this.loadLayout(this.properties);
            this.properties = null;
            this.setToolbarVisible(this.isToolbarVisible);
            if (this.initialContext != null) {
                this.setContext(this.initialContext);
                this.initialContext = null;
            }
        }
        return this.container;
    }

    private synchronized void initRegistrar() {
        if (REGISTRATION_COMPLETE) {
            return;
        }
        String string = Ide.getProperty("Inspector.PropertyEditor.registrar");
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                PropertyEditorRegistrar propertyEditorRegistrar = (PropertyEditorRegistrar)clazz.newInstance();
                if (propertyEditorRegistrar != null) {
                    propertyEditorRegistrar.registerPropertyEditors();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string2 = Ide.getProperty("Inspector.PropertyEditor.count", "0");
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            n = 0;
        }
        int n2 = 0;
        while (n2 < n) {
            String string3 = "Inspector.PropertyEditor.editor" + n2;
            String string4 = Ide.getProperty(string3 + ".type");
            string2 = Ide.getProperty(string3 + ".editor");
            try {
                PropertyEditorManager.registerEditor(Class.forName(string4), Class.forName(string2));
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("PropertyEditor for " + string4 + " could not be registered: " + string2);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("PropertyEditor for " + string4 + " could not be registered: " + string2);
            }
            catch (Throwable throwable) {
                System.err.println("PropertyEditor for " + string4 + " could not be registered: " + string2);
            }
            ++n2;
        }
        REGISTRATION_COMPLETE = true;
    }

    public void activate() {
        super.activate();
    }

    public void deactivate() {
        if (this.inspector != null) {
            TableCellEditor tableCellEditor;
            JTable jTable = this.inspector.getPropertyTable();
            TableCellEditor tableCellEditor2 = tableCellEditor = jTable != null ? jTable.getCellEditor() : null;
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
        }
        super.deactivate();
    }

    public void stateChange(int n) {
        super.stateChange(n);
        if (n == 3) {
            PropertyModel propertyModel;
            this.detachFromSubjects();
            this.setToolbarVisible(false);
            PropertyModel propertyModel2 = propertyModel = this.inspector != null ? this.inspector.getUnderlyingPropertyModel() : null;
            if (propertyModel != null) {
                propertyModel.removePropertyChangeListener((PropertyChangeListener)this.titleListener);
            }
            this.inspector.stateChanged(2);
            this.inspector.setOwner(null);
            if (this.additionalPages != null) {
                int n2 = 0;
                while (n2 < this.additionalPages.length) {
                    Component component = this.additionalPages[n2];
                    if (component instanceof InspectorPage) {
                        ((InspectorPage)((Object)component)).stateChanged(2);
                        ((InspectorPage)((Object)component)).setOwner(null);
                    } else if (component instanceof oracle.bali.inspector.PropertyInspector) {
                        ((oracle.bali.inspector.PropertyInspector)component).setUnderlyingPropertyModel(null);
                    }
                    ++n2;
                }
            }
            if (this.targetMonitor != null) {
                this.targetMonitor.reset();
                this.targetMonitor = null;
            }
            if (this.lastGroups != null) {
                this.lastGroups.clear();
                this.lastGroups = null;
            }
            this.inspector = null;
            this.additionalPages = null;
            this.selectedPage = null;
            this.container = null;
            this.outerSplit = null;
            if (this.innerSplit != null && this.propChangeListenerInnerSplit != null) {
                this.innerSplit.removePropertyChangeListener(this.propChangeListenerInnerSplit);
                this.propChangeListenerInnerSplit = null;
            }
            this.innerSplit = null;
            this.linksPanel = null;
            this.linksScroll = null;
            this.status = null;
            this.statusScroll = null;
            this.properties = null;
            this.inspectable = null;
            this.releaseCustomizer();
            this.tattleTale = null;
            this.titleListener = null;
            this.context = null;
            this.initialContext = null;
            this.nodeURL = null;
            this.projectURL = null;
            this.workspaceURL = null;
            this.idMap.clear();
            this.idMap = null;
            this.valueMap.clear();
            this.valueMap = null;
            this.pinTargets.clear();
            this.pinTargets = null;
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage == null) {
            return;
        }
        super.update(object, updateMessage);
        this.refresh();
    }

    public synchronized void setPinState(int n) {
        if (!this.isLoadingLayout) {
            switch (n) {
                case 0: {
                    this.getTargetMonitor().reset();
                    super.setPinState(n);
                    break;
                }
                case 2: {
                    super.setPinState(n);
                    this.persistPinTarget(true);
                    break;
                }
                default: {
                    super.setPinState(n);
                    break;
                }
            }
        } else {
            super.setPinState(n);
        }
    }

    public int getDefaultVisibility(Layout layout) {
        String string = layout.getProperty("Layout.ShowInspector", Boolean.FALSE.toString());
        boolean bl = Boolean.valueOf(string);
        return bl ? 5 : 0;
    }

    public String getTabName() {
        if (this.getPinState() != 0) {
            String string = this.getTitle();
            if (string == null && this.targetMonitor != null && this.targetMonitor.isMonitoring()) {
                string = TargetMonitor.ra$title(this.targetMonitor);
            }
            return string != null ? string : InspectorArb.getString(0);
        }
        return InspectorArb.getString(0);
    }

    public Icon getTabIcon() {
        return IdeArb.getIcon(168);
    }

    public String getTitleName() {
        String string = this.getTitle();
        String string2 = InspectorArb.getString(1);
        return string != null ? string + " - " + string2 : string2;
    }

    public String getMenuTitle() {
        return IdeArb.getString(166);
    }

    public Site getPreferredSite() {
        return new Site(this.getSite());
    }

    public void saveLayout(PropertyAccess propertyAccess) {
        if (this.inspector == null) {
            return;
        }
        String string = this.getId();
        String string2 = propertyAccess.getProperty(string + COUNT, null);
        if (string2 != null) {
            int n = 0;
            String string3 = string + TARGET + ".";
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n2 = 0;
            while (n2 < n) {
                propertyAccess.removeProperty(string3 + n2);
                ++n2;
            }
        }
        if (this.getPinState() == 2) {
            if (this.nodeURL != null) {
                propertyAccess.setProperty(string + NODE, URL2String.toString(this.nodeURL));
            } else {
                propertyAccess.removeProperty(string + NODE);
            }
            if (this.projectURL != null) {
                propertyAccess.setProperty(string + PROJECT, URL2String.toString(this.projectURL));
            } else {
                propertyAccess.removeProperty(string + PROJECT);
            }
            if (this.workspaceURL != null) {
                propertyAccess.setProperty(string + WORKSPACE, URL2String.toString(this.workspaceURL));
            } else {
                propertyAccess.removeProperty(string + WORKSPACE);
            }
            propertyAccess.setProperty(string + COUNT, "" + this.pinTargets.size());
            if (this.pinTargets.size() > 0) {
                int n = 0;
                while (n < this.pinTargets.size()) {
                    propertyAccess.setProperty(string + TARGET + "." + n, URL2String.toString((URL)this.pinTargets.get(n)));
                    ++n;
                }
            }
        } else {
            propertyAccess.removeProperty(string + NODE);
            propertyAccess.removeProperty(string + PROJECT);
            propertyAccess.removeProperty(string + WORKSPACE);
            propertyAccess.removeProperty(string + COUNT);
        }
        propertyAccess.setProperty("InspectorWindow", new ViewId(string).getName());
        propertyAccess.setProperty(string + CATEGORIZED, this.inspector.isCategorized() ? "true" : "false");
        propertyAccess.setProperty(string + UNION, this.inspector.isIntersection() ? "false" : "true");
        propertyAccess.setProperty(string + SHOW_READ_ONLY, this.inspector.isReadOnlyIncluded() ? "true" : "false");
        propertyAccess.setProperty(string + SHOW_WRITE_ONLY, this.inspector.isWriteOnlyIncluded() ? "true" : "false");
        propertyAccess.setProperty(string + SHOW_FIND, this.inspector.isFindVisible() ? "true" : "false");
        propertyAccess.setProperty(string + SHOW_STATUS, this.isStatusVisible() ? "true" : "false");
    }

    public void loadLayout(PropertyAccess propertyAccess) {
        if (propertyAccess == null) {
            return;
        }
        if (this.inspector == null) {
            this.properties = propertyAccess;
            return;
        }
        this.pinTargets.clear();
        this.isLoadingLayout = true;
        this.setPinState(0);
        this.isLoadingLayout = false;
        String string = this.getId();
        String string2 = propertyAccess.getProperty(string + COUNT, null);
        if (string2 != null) {
            String string3 = propertyAccess.getProperty(string + NODE, null);
            this.nodeURL = string3 != null ? URL2String.toURL(string3) : null;
            string3 = propertyAccess.getProperty(string + PROJECT, null);
            this.projectURL = string3 != null ? URL2String.toURL(string3) : null;
            string3 = propertyAccess.getProperty(string + WORKSPACE, null);
            this.workspaceURL = string3 != null ? URL2String.toURL(string3) : null;
            int n = 0;
            String string4 = string + TARGET + ".";
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n2 = 0;
            while (n2 < n) {
                string2 = propertyAccess.getProperty(string4 + n2, null);
                if (string2 != null && string2.length() > 0) {
                    URL uRL = URL2String.toURL(string2);
                    if (uRL != null) {
                        this.pinTargets.add(uRL);
                    } else {
                        this.pinTargets.clear();
                        break;
                    }
                }
                ++n2;
            }
            this.isLoadingLayout = true;
            this.setPinState(2);
            this.isLoadingLayout = false;
        } else {
            this.nodeURL = null;
            this.projectURL = null;
            this.workspaceURL = null;
        }
        this.inspector.setCategorized("true".equals(propertyAccess.getProperty(string + CATEGORIZED, "false")));
        this.inspector.setIntersection("true".equals(propertyAccess.getProperty(string + UNION, "false")) ^ true);
        this.inspector.setReadOnlyIncluded("true".equals(propertyAccess.getProperty(string + SHOW_READ_ONLY, "false")));
        this.inspector.setWriteOnlyIncluded("true".equals(propertyAccess.getProperty(string + SHOW_WRITE_ONLY, "false")));
        this.inspector.setFindVisible("true".equals(propertyAccess.getProperty(string + SHOW_FIND, "false")));
        this.setStatusVisible("true".equals(propertyAccess.getProperty(string + SHOW_STATUS, "true")));
    }

    public oracle.bali.inspector.PropertyInspector getPropertyInspector() {
        return this.inspector;
    }

    public Customizer getCustomizer() {
        if (this.inspectable instanceof Inspectable2 && ((Inspectable2)this.inspectable).hasCustomDialog()) {
            this.releaseCustomizer();
        } else if (this.inspectable != null && this.customizer == null) {
            this.customizer = this.inspectable.getCustomizer();
            if (this.customizer != null) {
                this.customizer.addPropertyChangeListener(this.tattleTale);
            }
        }
        return this.customizer;
    }

    private void releaseCustomizer() {
        if (this.customizer != null) {
            this.customizer.removePropertyChangeListener(this.tattleTale);
            this.customizer = null;
            this.idMap.clear();
            this.valueMap.clear();
        }
    }

    public Component[] getAdditionalTabPages() {
        return this.additionalPages;
    }

    private String getTitle() {
        return this.title;
    }

    private void setTitle(String string) {
        this.title = string;
        this.updateTitle(this.getTitleName());
    }

    private synchronized void attachToSubjects(Subject[] subjectArray) {
        if (this.targetMonitor != null && this.targetMonitor.isMonitoring()) {
            return;
        }
        this.detachFromSubjects();
        if (subjectArray != null) {
            this.subjects = subjectArray;
        }
        int n = 0;
        while (n < this.subjects.length) {
            if (this.subjects[n] != null) {
                this.subjects[n].attach(this);
            }
            ++n;
        }
    }

    private void detachFromSubjects() {
        int n = 0;
        while (n < this.subjects.length) {
            if (this.subjects[n] != null) {
                this.subjects[n].detach(this);
            }
            ++n;
        }
        this.subjects = NO_SUBJECTS;
    }

    private synchronized void refresh() {
        PropertyModel propertyModel;
        if (this.inspector == null) {
            return;
        }
        if (this.isMultiUpdate) {
            return;
        }
        this.updateSelection();
        InspectorFactory inspectorFactory = InspectorFactory.getInstance();
        MultiInspectable multiInspectable = inspectorFactory.getMultiInspectable(this.context);
        IdePropertyModel idePropertyModel = multiInspectable.getPropertyModel();
        this.attachToSubjects(idePropertyModel.getSubjects());
        JTable jTable = this.inspector.getPropertyTable();
        TableCellEditor tableCellEditor = jTable != null ? jTable.getCellEditor() : null;
        String string = this.selectedPage != null ? this.selectedPage.getName() : null;
        int n = 0;
        int n2 = 0;
        Set set = null;
        PropertyExpansionState[] propertyExpansionStateArray = null;
        Dimension dimension = this.linksScroll.getSize();
        Dimension dimension2 = this.statusScroll.getSize();
        if (this.selectedPage != null) {
            if (this.selectedPage instanceof oracle.bali.inspector.PropertyInspector) {
                oracle.bali.inspector.PropertyInspector propertyInspector = (oracle.bali.inspector.PropertyInspector)this.selectedPage;
                jTable = propertyInspector.getPropertyTable();
                n = jTable.getSelectedRow();
                n = n < 0 ? 0 : n;
                n2 = jTable.getSelectedColumn();
                n2 = n2 < 0 ? 0 : n2;
                PropertyGroup[] propertyGroupArray = propertyInspector.getExpandedGroups();
                if (propertyGroupArray != null) {
                    Locale locale = propertyInspector.getLocale();
                    int n3 = propertyGroupArray.length - 1;
                    while (n3 >= 0) {
                        this.lastGroups.remove(propertyGroupArray[n3].getName(locale));
                        --n3;
                    }
                }
                set = this.lastGroups.keySet();
                propertyExpansionStateArray = propertyInspector.getExpandedProperties();
            }
            if (this.selectedPage == this.inspector) {
                this.inspector.stateChanged(1);
            } else {
                if (this.isStatusVisible || this.areLinksVisible) {
                    this.innerSplit.remove(this.selectedPage);
                } else {
                    this.container.remove(this.selectedPage);
                }
                if (this.selectedPage instanceof InspectorPage) {
                    ((InspectorPage)((Object)this.selectedPage)).stateChanged(1);
                }
                this.selectedPage = null;
            }
        }
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        PropertyModel propertyModel2 = propertyModel = this.inspector != null ? this.inspector.getUnderlyingPropertyModel() : null;
        if (propertyModel != null) {
            propertyModel.removePropertyChangeListener((PropertyChangeListener)this.titleListener);
        }
        if (this.additionalPages != null) {
            int n4 = 0;
            while (n4 < this.additionalPages.length) {
                Component component = this.additionalPages[n4];
                if (component instanceof InspectorPage) {
                    ((InspectorPage)((Object)component)).stateChanged(2);
                    ((InspectorPage)((Object)component)).setOwner(null);
                } else if (component instanceof oracle.bali.inspector.PropertyInspector) {
                    ((oracle.bali.inspector.PropertyInspector)component).setUnderlyingPropertyModel(null);
                }
                ++n4;
            }
        }
        this.releaseCustomizer();
        if (this.areLinksVisible) {
            Component[] componentArray = this.linksPanel.getComponents();
            if (componentArray != null) {
                int n5 = 0;
                while (n5 < componentArray.length) {
                    ((AbstractButton)componentArray[n5]).setAction(null);
                    ++n5;
                }
            }
            this.linksPanel.removeAll();
        }
        this.inspector.setUnderlyingPropertyModel((PropertyModel)idePropertyModel);
        if (multiInspectable.getSize() == 1) {
            Inspectable2 inspectable2;
            Action[] actionArray;
            this.inspectable = multiInspectable.getInspectable(0);
            this.additionalPages = this.inspectable.getAdditionalTabPages();
            if (this.additionalPages != null) {
                int n6 = 0;
                while (n6 < this.additionalPages.length) {
                    if (this.additionalPages[n6] instanceof InspectorPage) {
                        ((InspectorPage)((Object)this.additionalPages[n6])).setOwner(this);
                    }
                    ++n6;
                }
            }
            if (this.getCustomizer() != null) {
                this.copyModelValues((PropertyModel)idePropertyModel);
            }
            if (this.inspectable instanceof Inspectable2 && (actionArray = (inspectable2 = (Inspectable2)this.inspectable).getLinkActions()) != null && actionArray.length > 0) {
                int n7 = 0;
                while (n7 < actionArray.length - 1) {
                    HyperlinkButton hyperlinkButton = new HyperlinkButton(actionArray[n7]);
                    String string2 = (String)actionArray[n7].getValue("Name");
                    hyperlinkButton.setIcon(null);
                    hyperlinkButton.setMargin(EMPTY_INSETS);
                    hyperlinkButton.setText(InspectorArb.format(28, new String[]{string2, ","}));
                    this.linksPanel.add((Component)hyperlinkButton);
                    ++n7;
                }
                HyperlinkButton hyperlinkButton = new HyperlinkButton(actionArray[actionArray.length - 1]);
                hyperlinkButton.setIcon(null);
                hyperlinkButton.setMargin(EMPTY_INSETS);
                this.linksPanel.add((Component)hyperlinkButton);
            }
        } else {
            this.inspectable = null;
            this.additionalPages = null;
        }
        if (idePropertyModel != null) {
            this.setTitle(idePropertyModel.getTargetDisplayName());
            idePropertyModel.addPropertyChangeListener(this.titleListener);
        } else {
            this.setTitle(null);
        }
        if (this.selectedPage != this.inspector) {
            if (string != null) {
                int n8 = this.additionalPages != null ? this.additionalPages.length : 0;
                while (--n8 >= 0) {
                    String string3;
                    Component component = this.additionalPages[n8];
                    String string4 = string3 = component != null ? component.getName() : null;
                    if (string3 == null || !string3.equals(string)) continue;
                    this.selectedPage = component;
                    break;
                }
                if (n8 < 0) {
                    this.selectedPage = this.inspector;
                }
            } else {
                this.selectedPage = this.inspector;
            }
        }
        if (this.toolbar != null) {
            this.updateToolbar();
            this.container.add((Component)this.toolbar, "North");
            this.container.add((Component)this.tabs, "South");
            if (this.tabs != null && this.tabs.getHeight() > 0) {
                this.tabHeight = this.tabs.getHeight();
            }
        }
        if (dimension2.height > 0) {
            this.statusScroll.setPreferredSize(dimension2);
        }
        if (dimension.height > 0) {
            this.linksScroll.setPreferredSize(dimension);
        }
        if (this.isStatusVisible || this.areLinksVisible) {
            this.innerSplit.add(this.selectedPage, "top");
        } else {
            this.container.add(this.selectedPage, "Center");
        }
        this.setLinksVisible(this.linksPanel.getComponentCount() > 0);
        if (this.selectedPage instanceof InspectorPage) {
            ((InspectorPage)((Object)this.selectedPage)).stateChanged(0);
        }
        if (this.selectedPage instanceof oracle.bali.inspector.PropertyInspector) {
            this.restorePI((oracle.bali.inspector.PropertyInspector)this.selectedPage, n, n2, set, propertyExpansionStateArray);
        }
        this.container.revalidate();
        this.container.repaint();
        if (this.customizerDlg != null) {
            this.customizerDlg.setContent((Component)((Object)this.getCustomizer()));
        }
        int n9 = this.innerSplit.getMaximumDividerLocation();
        int n10 = this.innerSplit.getMinimumDividerLocation();
        if (n10 < n9) {
            int n11 = this.tabHeight;
            if (this.latestDividerLocation == 0 || this.latestDividerLocation > n9) {
                this.latestDividerLocation = n9 - n11;
            }
            if (this.latestDividerLocation < n10) {
                this.latestDividerLocation = n10 + n11;
            }
            this.settingDividerLocation = true;
            this.innerSplit.setDividerLocation(this.latestDividerLocation);
            this.settingDividerLocation = false;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this.tabs.getPage(listSelectionEvent.getFirstIndex());
        Component component = (Component)defaultCustomTabPage.getUserObject();
        this.togglePage(component);
        this.updateVisibleActions();
    }

    private void togglePage(Component component) {
        boolean bl;
        if (component == this.selectedPage) {
            return;
        }
        if (component != null && component != this.inspector && this.additionalPages != null) {
            int n = this.additionalPages.length;
            while (--n >= 0) {
                if (component == this.additionalPages[n]) break;
            }
            if (n < 0) {
                return;
            }
        }
        if (bl = GraphicsUtils.isAncestorOfFocusedComponent(this.getGUI())) {
            this.getGUI().requestFocus();
        }
        if (this.selectedPage != null) {
            if (this.isStatusVisible || this.areLinksVisible) {
                this.innerSplit.remove(this.selectedPage);
            } else {
                this.container.remove(this.selectedPage);
            }
            if (this.selectedPage instanceof InspectorPage) {
                ((InspectorPage)((Object)this.selectedPage)).stateChanged(1);
            }
        }
        this.selectedPage = component;
        if (this.isStatusVisible || this.areLinksVisible) {
            this.innerSplit.add(this.selectedPage, "top");
        } else {
            this.container.add(this.selectedPage, "Center");
        }
        if (this.selectedPage instanceof InspectorPage) {
            ((InspectorPage)((Object)this.selectedPage)).stateChanged(0);
        }
        this.container.revalidate();
        if (bl && !GraphicsUtils.isAncestorOfFocusedComponent(this.selectedPage)) {
            if (this.selectedPage instanceof InspectorPage) {
                Component component2 = ((InspectorPage)((Object)this.selectedPage)).getDefaultFocusComponent();
                if (component2 != null) {
                    component2.requestFocus();
                }
            } else {
                GraphicsUtils.focusComponentOrChild(this.selectedPage, true);
            }
        }
        this.container.repaint();
    }

    private HashMap getGroups(oracle.bali.inspector.PropertyInspector propertyInspector) {
        HashMap<String, PropertyGroup> hashMap = new HashMap<String, PropertyGroup>();
        PropertyModel propertyModel = propertyInspector.getUnderlyingPropertyModel();
        int n = propertyModel.getColumnIndex(PropertyModel.COLUMN_GROUP);
        if (n != -1) {
            Locale locale = propertyInspector.getLocale();
            int n2 = propertyModel.getRowCount();
            int n3 = 0;
            while (n3 < n2) {
                Object object = propertyModel.getValueAt(n3, n);
                if (!PropertyModel.DOES_NOT_EXIST.equals(object)) {
                    String string;
                    PropertyGroup propertyGroup = (PropertyGroup)object;
                    String string2 = string = propertyGroup != null ? propertyGroup.getName(locale) : null;
                    if (string != null && hashMap.get(string) == null) {
                        hashMap.put(string, propertyGroup);
                    }
                }
                ++n3;
            }
        }
        return hashMap;
    }

    private void restorePI(oracle.bali.inspector.PropertyInspector propertyInspector, int n, int n2, Set set, PropertyExpansionState[] propertyExpansionStateArray) {
        JTable jTable;
        int n3 = set != null ? set.size() : 0;
        this.lastGroups = this.getGroups(propertyInspector);
        if (n3 > 0) {
            PropertyGroup[] propertyGroupArray;
            Iterator iterator;
            HashMap hashMap = (HashMap)this.lastGroups.clone();
            Iterator iterator2 = iterator = set != null ? set.iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    hashMap.remove(iterator.next());
                }
            }
            if ((propertyGroupArray = new PropertyGroup[hashMap.size()]).length > 0) {
                hashMap.values().toArray(propertyGroupArray);
            }
            propertyInspector.setExpandedGroups(propertyGroupArray);
        }
        if (propertyExpansionStateArray != null) {
            propertyInspector.setExpandedProperties(propertyExpansionStateArray);
        }
        if ((jTable = propertyInspector.getPropertyTable()) != null) {
            int n4 = jTable.getRowCount() - 1;
            int n5 = jTable.getColumnCount() - 1;
            n = n <= n4 ? n : n4;
            n2 = n2 <= n5 ? n2 : n5;
            jTable.changeSelection(n, n2, false, false);
        }
    }

    private void updateToolbar() {
        DefaultCustomTabPage defaultCustomTabPage;
        if (this.toolbar == null) {
            return;
        }
        this.tabs.removeSelectionListener(this);
        this.tabs.removeAllPages();
        this.toolbar.dispose();
        this.toolbar.removeAll();
        String string = this.inspector.getShortLabel();
        Icon icon = this.inspector.getIcon();
        String string2 = this.inspector.getToolTipText();
        DefaultListModel<DefaultCustomTabPage> defaultListModel = new DefaultListModel<DefaultCustomTabPage>();
        DefaultCustomTabPage defaultCustomTabPage2 = defaultCustomTabPage = new DefaultCustomTabPage(icon, null, this.inspector);
        defaultCustomTabPage.setLabel(string);
        defaultCustomTabPage.setTooltip(ModelUtil.areDifferent((Object)string, (Object)string2) ? string2 : null);
        defaultListModel.addElement(defaultCustomTabPage);
        if (this.additionalPages != null) {
            String string3 = this.selectedPage != null ? this.selectedPage.getName() : null;
            int n = 0;
            while (n < this.additionalPages.length) {
                Component component = this.additionalPages[n];
                if (component instanceof InspectorPage) {
                    InspectorPage inspectorPage = (InspectorPage)((Object)component);
                    string = inspectorPage.getShortLabel();
                    icon = inspectorPage.getIcon();
                    string2 = inspectorPage.getToolTipText();
                } else {
                    string = component.getClass().getName();
                    icon = IdeArb.getIcon(168);
                    string2 = string;
                }
                defaultCustomTabPage = new DefaultCustomTabPage(icon, null, component);
                defaultCustomTabPage.setLabel(string);
                defaultCustomTabPage.setTooltip(ModelUtil.areDifferent((Object)string, (Object)string2) ? string2 : null);
                defaultListModel.addElement(defaultCustomTabPage);
                if (string == string3) {
                    defaultCustomTabPage2 = defaultCustomTabPage;
                }
                ++n;
            }
        }
        this.tabs.setModel(defaultListModel);
        this.tabs.setVisible(defaultListModel.getSize() > 1);
        this.tabs.setPreferredSize(null);
        this.tabs.setSelectedPage(this.tabs.searchPage(defaultCustomTabPage2));
        this.tabs.addSelectionListener(this);
        IdeAction ideAction = null;
        ideAction = IdeAction.find(68);
        if (ideAction != null) {
            ideAction = ideAction.newLocalAction(this);
            ideAction.putValue("State", this.getPinState() == 2 ? Boolean.TRUE : Boolean.FALSE);
            this.toolbar.addToggleButton(ideAction);
        }
        if ((ideAction = IdeAction.find(67)) != null) {
            ideAction = ideAction.newLocalAction(this);
            this.toolbar.add(ideAction);
        }
        boolean bl = false;
        if (this.inspectable instanceof Inspectable2) {
            bl = ((Inspectable2)this.inspectable).hasCustomDialog();
        }
        if (!bl) {
            bl = this.getCustomizer() != null;
        }
        string = InspectorArb.getString(23);
        icon = InspectorArb.getIcon(24);
        string2 = InspectorArb.getString(25);
        ideAction = InspectorManagerImpl.getCustomizerCmdAction().newLocalAction(this);
        ideAction.setCommandId(InspectorManagerImpl.CUSTOMIZER_CMD_ID);
        ideAction.setEnabled(bl);
        ToolButton toolButton = this.toolbar.add(ideAction);
        toolButton.setToolTipText(string2);
        InspectorWindowImpl.updateToolbarActions(this.getToolbar());
    }

    private void copyModelValues(PropertyModel propertyModel) {
        Enumeration enumeration = propertyModel.getPropertyIDs();
        int n = propertyModel.getColumnIndex(PropertyModel.COLUMN_NAME);
        int n2 = propertyModel.getColumnIndex(PropertyModel.COLUMN_VALUE);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                Object object = propertyModel.getPropertyByID(n, e);
                Object object2 = propertyModel.getPropertyByID(n2, e);
                if (object2 == null) {
                    object2 = NULL_OBJECT;
                }
                if (object == null) continue;
                this.idMap.put(object, e);
                this.valueMap.put(e, object2);
            }
        }
    }

    public void showCustomizer() {
        if (this.inspectable instanceof Inspectable2 && ((Inspectable2)this.inspectable).hasCustomDialog()) {
            ((Inspectable2)this.inspectable).showCustomDialog(this.getGUI());
        } else if (this.getCustomizer() != null) {
            this.customizerDlg = DialogUtil.createJEWTDialogOwnedBy(this.getGUI());
            if (this.customizerDlg != null) {
                try {
                    this.customizerDlg.setButtonMask(16);
                    this.customizerDlg.setContent((Component)((Object)this.getCustomizer()));
                    this.customizerDlg.runDialog();
                }
                finally {
                    this.customizerDlg = null;
                }
            }
        }
    }

    protected void customizerChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyModel propertyModel;
        boolean bl;
        block23: {
            if (propertyChangeEvent == null) {
                return;
            }
            if (this.inspector == null) {
                return;
            }
            bl = false;
            propertyModel = this.inspector.getUnderlyingPropertyModel();
            try {
                Object v;
                propertyModel.invalidateValueData();
                String string = propertyChangeEvent.getPropertyName();
                if (string == null || (v = this.idMap.get(string)) == null) break block23;
                Object object = null;
                int n = propertyModel.getColumnIndex(PropertyModel.COLUMN_IS_READABLE);
                Object object2 = propertyModel.getPropertyByID(n, v);
                if (object2 != null && ((Boolean)object2).booleanValue()) {
                    n = propertyModel.getColumnIndex(PropertyModel.COLUMN_VALUE);
                    object = propertyModel.getPropertyByID(n, v);
                } else {
                    object = propertyChangeEvent.getNewValue();
                }
                try {
                    int n2 = propertyModel.getPropertyIndex(v);
                    propertyModel.setPropertyValue(n2, object);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            try {
                try {
                    this.isMultiUpdate = true;
                    Enumeration enumeration = propertyModel.getPropertyIDs();
                    int n = propertyModel.getColumnIndex(PropertyModel.COLUMN_NAME);
                    int n3 = propertyModel.getColumnIndex(PropertyModel.COLUMN_VALUE);
                    int n4 = propertyModel.getColumnIndex(PropertyModel.COLUMN_IS_READABLE);
                    while (enumeration.hasMoreElements()) {
                        Object object;
                        boolean bl2 = false;
                        Object e = enumeration.nextElement();
                        Object object3 = propertyModel.getPropertyByID(n, e);
                        Object v = this.valueMap.get(this.idMap.get(object3));
                        Object object4 = propertyModel.getPropertyByID(n3, e);
                        if (v == null || v == NULL_OBJECT) {
                            if (object4 != null) {
                                bl2 = true;
                            }
                        } else if (object4 == null) {
                            bl2 = true;
                        } else if (v != object4 && !v.equals(object4)) {
                            bl2 = true;
                        }
                        if (!bl2 || (object = propertyModel.getPropertyByID(n4, e)) == null || !((Boolean)object).booleanValue()) continue;
                        try {
                            int n5 = propertyModel.getPropertyIndex(e);
                            propertyModel.setPropertyValue(n5, object4);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception exception) {}
            }
            finally {
                this.isMultiUpdate = false;
                this.refresh();
            }
        }
    }

    protected boolean isViewSupported(View view) {
        return InspectorManager.getInspectorManager().supportsInspection(view);
    }

    protected synchronized void viewSelectionChanged(Context context) {
        if (context != null) {
            this.context = new Context(context);
        } else {
            this.context = Context.newIdeContext();
            this.context.setSelection(View.EMPTY_SELECTION);
        }
        this.context.setView(this);
        this.refresh();
    }

    protected void clear() {
        super.clear();
        this.detachFromSubjects();
        if (this.context == null) {
            this.context = Context.newIdeContext();
            this.context.setView(this);
        }
        this.context.setNode(null);
        this.context.setProject(Ide.getActiveProject());
        this.context.setWorkspace(Ide.getActiveWorkspace());
        this.context.setSelection(View.EMPTY_SELECTION);
        this.viewSelectionChanged(this.context);
    }

    protected void persistPinTarget() {
        this.persistPinTarget(true);
    }

    private void persistPinTarget(boolean bl) {
        Element[] elementArray;
        if (this.targetMonitor != null && this.targetMonitor.isMonitoring()) {
            return;
        }
        this.getTargetMonitor().reset();
        this.pinTargets.clear();
        if (this.getPinState() == 0) {
            this.nodeURL = null;
            this.projectURL = null;
            this.workspaceURL = null;
            return;
        }
        Context context = this.getContext();
        Node node = context != null ? context.getNode() : null;
        Project project = context != null ? context.getProject() : null;
        Workspace workspace = context != null ? context.getWorkspace() : null;
        this.nodeURL = node != null ? node.getURL() : null;
        this.projectURL = project != null ? project.getURL() : null;
        this.workspaceURL = workspace != null ? workspace.getURL() : null;
        Element[] elementArray2 = elementArray = context != null ? context.getSelection() : View.EMPTY_SELECTION;
        if (elementArray != null && elementArray.length > 0) {
            int n = 0;
            while (n < elementArray.length) {
                if (!(elementArray[n] instanceof Locatable)) {
                    this.pinTargets.clear();
                    break;
                }
                this.pinTargets.add(((Locatable)((Object)elementArray[n])).getURL());
                ++n;
            }
        }
        if (bl) {
            int n = 0;
            while (n < this.subjects.length) {
                TargetMonitor.mav$monitor(this.getTargetMonitor(), this.subjects[n], true);
                ++n;
            }
            this.detachFromSubjects();
            this.getTargetMonitor().monitor(context.getNode());
            this.getTargetMonitor().monitor(context.getProject());
            this.getTargetMonitor().monitor(context.getWorkspace());
            TargetMonitor.wa$title(this.getTargetMonitor(), this.getTitle());
        }
    }

    protected void restorePinTarget() {
        this.restorePinTarget(true);
    }

    private void restorePinTarget(boolean bl) {
        Context context = this.getContext();
        Workspace workspace = null;
        Project project = null;
        Node node = null;
        try {
            workspace = (Workspace)NodeFactory.findOrCreate(this.workspaceURL);
            context.setWorkspace(workspace);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            project = (Project)NodeFactory.findOrCreate(this.projectURL);
            context.setProject(project);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            node = NodeFactory.findOrCreate(this.nodeURL);
            context.setNode(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
        context.setSelection(View.EMPTY_SELECTION);
        if (!this.pinTargets.isEmpty()) {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            try {
                int n = this.pinTargets.size();
                int n2 = 0;
                while (n2 < n) {
                    Element element = ElementFactory.findOrCreate((URL)this.pinTargets.get(n2), project);
                    if (element == null) {
                        element = NodeFactory.findOrCreate((URL)this.pinTargets.get(n2));
                    }
                    if (element == null) {
                        this.pinTargets.clear();
                        arrayList.clear();
                        break;
                    }
                    arrayList.add(element);
                    ++n2;
                }
            }
            catch (Exception exception) {
                this.pinTargets.clear();
                arrayList.clear();
            }
            if (!arrayList.isEmpty()) {
                Element[] elementArray = new Element[arrayList.size()];
                arrayList.toArray(elementArray);
                context.setSelection(elementArray);
            }
        }
        if (bl) {
            this.getTargetMonitor().reset();
            this.pinTargets.clear();
            this.nodeURL = null;
            this.projectURL = null;
            this.workspaceURL = null;
        }
        this.viewSelectionChanged(context);
    }

    private TargetMonitor getTargetMonitor() {
        if (this.targetMonitor == null) {
            this.targetMonitor = new TargetMonitor(null);
        }
        return this.targetMonitor;
    }

    static boolean ra$settingDividerLocation(InspectorWindowImpl inspectorWindowImpl) {
        return inspectorWindowImpl.settingDividerLocation;
    }

    static int ra$tabHeight(InspectorWindowImpl inspectorWindowImpl) {
        return inspectorWindowImpl.tabHeight;
    }

    static int ra$prevMax(InspectorWindowImpl inspectorWindowImpl) {
        return inspectorWindowImpl.prevMax;
    }

    static URL ra$propURL(InspectorWindowImpl inspectorWindowImpl) {
        return inspectorWindowImpl.propURL;
    }

    static void wa$propURL(InspectorWindowImpl inspectorWindowImpl, URL uRL) {
        inspectorWindowImpl.propURL = uRL;
    }

    static void wa$settingDividerLocation(InspectorWindowImpl inspectorWindowImpl, boolean bl) {
        inspectorWindowImpl.settingDividerLocation = bl;
    }

    static int ra$latestDividerLocation(InspectorWindowImpl inspectorWindowImpl) {
        return inspectorWindowImpl.latestDividerLocation;
    }

    static String ra$title(InspectorWindowImpl inspectorWindowImpl) {
        return inspectorWindowImpl.title;
    }

    static void wa$latestDividerLocation(InspectorWindowImpl inspectorWindowImpl, int n) {
        inspectorWindowImpl.latestDividerLocation = n;
    }

    static void wa$prevMax(InspectorWindowImpl inspectorWindowImpl, int n) {
        inspectorWindowImpl.prevMax = n;
    }

    static ArrayList ra$pinTargets(InspectorWindowImpl inspectorWindowImpl) {
        return inspectorWindowImpl.pinTargets;
    }

    static URL ra$nodeURL(InspectorWindowImpl inspectorWindowImpl) {
        return inspectorWindowImpl.nodeURL;
    }

    static void wa$nodeURL(InspectorWindowImpl inspectorWindowImpl, URL uRL) {
        inspectorWindowImpl.nodeURL = uRL;
    }

    static URL ra$projectURL(InspectorWindowImpl inspectorWindowImpl) {
        return inspectorWindowImpl.projectURL;
    }

    static void wa$projectURL(InspectorWindowImpl inspectorWindowImpl, URL uRL) {
        inspectorWindowImpl.projectURL = uRL;
    }

    static URL ra$workspaceURL(InspectorWindowImpl inspectorWindowImpl) {
        return inspectorWindowImpl.workspaceURL;
    }

    static void wa$workspaceURL(InspectorWindowImpl inspectorWindowImpl, URL uRL) {
        inspectorWindowImpl.workspaceURL = uRL;
    }

    static void mav$restorePinTarget(InspectorWindowImpl inspectorWindowImpl, boolean bl) {
        inspectorWindowImpl.restorePinTarget(bl);
    }

    static void mav$setTitle(InspectorWindowImpl inspectorWindowImpl, String string) {
        inspectorWindowImpl.setTitle(string);
    }

    private class propertyChangeListenerInnerSplit
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            URL uRL;
            Context context;
            if (InspectorWindowImpl.ra$settingDividerLocation(InspectorWindowImpl.this)) {
                return;
            }
            JSplitPane jSplitPane = (JSplitPane)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            int n = jSplitPane.getMinimumDividerLocation();
            int n2 = jSplitPane.getMaximumDividerLocation();
            int n3 = InspectorWindowImpl.ra$tabHeight(InspectorWindowImpl.this);
            boolean bl = false;
            if (n2 != InspectorWindowImpl.ra$prevMax(InspectorWindowImpl.this)) {
                bl = true;
            }
            Node node = (context = InspectorWindowImpl.this.getContext()) != null ? context.getNode() : null;
            URL uRL2 = uRL = node != null ? node.getURL() : null;
            if (InspectorWindowImpl.ra$propURL(InspectorWindowImpl.this) == null) {
                InspectorWindowImpl.wa$propURL(InspectorWindowImpl.this, uRL);
            }
            if (n < n2) {
                int n4 = jSplitPane.getDividerLocation();
                if (InspectorWindowImpl.ra$propURL(InspectorWindowImpl.this) != null && uRL != null && !InspectorWindowImpl.ra$propURL(InspectorWindowImpl.this).equals(uRL)) {
                    InspectorWindowImpl.wa$propURL(InspectorWindowImpl.this, uRL);
                    InspectorWindowImpl.wa$settingDividerLocation(InspectorWindowImpl.this, true);
                    jSplitPane.setDividerLocation(InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this));
                    jSplitPane.setDividerLocation(InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this));
                    InspectorWindowImpl.wa$settingDividerLocation(InspectorWindowImpl.this, false);
                    return;
                }
                if (InspectorWindowImpl.ra$title(InspectorWindowImpl.this) == null && InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this) != n4) {
                    InspectorWindowImpl.wa$latestDividerLocation(InspectorWindowImpl.this, n2 - n3);
                    InspectorWindowImpl.wa$settingDividerLocation(InspectorWindowImpl.this, true);
                    jSplitPane.setDividerLocation(InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this));
                    jSplitPane.setDividerLocation(InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this));
                    InspectorWindowImpl.wa$settingDividerLocation(InspectorWindowImpl.this, false);
                    return;
                }
                if (string.equals("lastDividerLocation") && InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this) > 0 && (InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this) > n2 || InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this) < n)) {
                    if (n4 > 0 && n4 <= n2 && n4 >= n) {
                        InspectorWindowImpl.wa$latestDividerLocation(InspectorWindowImpl.this, n4);
                    } else if (InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this) > n2) {
                        InspectorWindowImpl.wa$latestDividerLocation(InspectorWindowImpl.this, n2 - n3);
                    } else {
                        InspectorWindowImpl.wa$latestDividerLocation(InspectorWindowImpl.this, n + n3);
                    }
                    if (n4 > 0 && InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this) != n4) {
                        InspectorWindowImpl.wa$settingDividerLocation(InspectorWindowImpl.this, true);
                        jSplitPane.setDividerLocation(InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this));
                        jSplitPane.setDividerLocation(InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this));
                        InspectorWindowImpl.wa$settingDividerLocation(InspectorWindowImpl.this, false);
                    }
                    return;
                }
                if (string.equals("lastDividerLocation") || string.equals("dividerLocation")) {
                    if (bl || n4 == 0) {
                        InspectorWindowImpl.wa$prevMax(InspectorWindowImpl.this, n2);
                        InspectorWindowImpl.wa$latestDividerLocation(InspectorWindowImpl.this, n2 - n3);
                        InspectorWindowImpl.wa$settingDividerLocation(InspectorWindowImpl.this, true);
                        jSplitPane.setDividerLocation(InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this));
                        jSplitPane.setDividerLocation(InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this));
                        InspectorWindowImpl.wa$settingDividerLocation(InspectorWindowImpl.this, false);
                    } else {
                        InspectorWindowImpl.wa$latestDividerLocation(InspectorWindowImpl.this, n4);
                        InspectorWindowImpl.wa$settingDividerLocation(InspectorWindowImpl.this, true);
                        jSplitPane.setDividerLocation(InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this));
                        jSplitPane.setDividerLocation(InspectorWindowImpl.ra$latestDividerLocation(InspectorWindowImpl.this));
                        InspectorWindowImpl.wa$settingDividerLocation(InspectorWindowImpl.this, false);
                    }
                }
            }
        }

        private propertyChangeListenerInnerSplit() {
        }

        propertyChangeListenerInnerSplit(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class TargetMonitor
    implements Observer {
        private ArrayList targets;
        private ArrayList hotTargets;
        private String title;

        void $init$() {
            this.targets = new ArrayList();
            this.hotTargets = new ArrayList();
        }

        public void reset() {
            int n = this.targets.size() - 1;
            while (n >= 0) {
                ((Subject)this.targets.get(n)).detach(this);
                --n;
            }
            this.targets.clear();
            int n2 = this.hotTargets.size() - 1;
            while (n2 >= 0) {
                ((Subject)this.hotTargets.get(n2)).detach(this);
                --n2;
            }
            this.hotTargets.clear();
            this.title = null;
        }

        public boolean isMonitoring() {
            return this.targets.size() > 0 || this.hotTargets.size() > 0;
        }

        public void monitor(Subject subject) {
            this.monitor(subject, false);
        }

        private void monitor(Subject subject, boolean bl) {
            if (subject != null) {
                if (bl) {
                    if (this.targets.contains(subject)) {
                        this.targets.remove(subject);
                    }
                    if (!this.hotTargets.contains(subject)) {
                        this.hotTargets.add(subject);
                    }
                } else if (!this.hotTargets.contains(subject)) {
                    this.targets.add(subject);
                }
                subject.attach(this);
            }
        }

        public void update(Object object, UpdateMessage updateMessage) {
            if (updateMessage.getMessageID() == UpdateMessage.OBJECT_RENAMED) {
                URL uRL;
                List list = updateMessage.getAddObjects();
                Subject subject = null;
                URL uRL2 = null;
                if (!list.isEmpty()) {
                    subject = (Subject)list.get(0);
                } else {
                    subject = RenameMessage.getRenamedNode(updateMessage);
                    if (subject != null) {
                        try {
                            uRL2 = (URL)updateMessage.getModifyObjects().get(0);
                        }
                        catch (Exception exception) {}
                    } else {
                        subject = (Subject)object;
                        try {
                            uRL2 = (URL)updateMessage.getModifyObjects().get(0);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (uRL2 != null && subject instanceof Locatable && (uRL = ((Locatable)((Object)subject)).getURL()) != uRL2 && !uRL.equals(uRL2)) {
                    if (InspectorWindowImpl.ra$pinTargets(InspectorWindowImpl.this).contains(uRL2)) {
                        InspectorWindowImpl.ra$pinTargets(InspectorWindowImpl.this).set(InspectorWindowImpl.ra$pinTargets(InspectorWindowImpl.this).indexOf(uRL2), uRL);
                    }
                    if (InspectorWindowImpl.ra$nodeURL(InspectorWindowImpl.this) == uRL2 || InspectorWindowImpl.ra$nodeURL(InspectorWindowImpl.this).equals(uRL2)) {
                        InspectorWindowImpl.wa$nodeURL(InspectorWindowImpl.this, uRL);
                    }
                    if (InspectorWindowImpl.ra$projectURL(InspectorWindowImpl.this) == uRL2 || InspectorWindowImpl.ra$projectURL(InspectorWindowImpl.this).equals(uRL2)) {
                        InspectorWindowImpl.wa$projectURL(InspectorWindowImpl.this, uRL);
                    }
                    if (InspectorWindowImpl.ra$workspaceURL(InspectorWindowImpl.this) == uRL2 || InspectorWindowImpl.ra$workspaceURL(InspectorWindowImpl.this).equals(uRL2)) {
                        InspectorWindowImpl.wa$workspaceURL(InspectorWindowImpl.this, uRL);
                    }
                }
                if (!this.targets.contains(subject)) {
                    this.targets.remove(object);
                    this.monitor(subject);
                }
                if (InspectorWindowImpl.this.isVisible()) {
                    InspectorWindowImpl.mav$restorePinTarget(InspectorWindowImpl.this, false);
                }
            } else if (updateMessage.getMessageID() != UpdateMessage.OBJECT_CLOSING) {
                if (updateMessage.getMessageID() == UpdateMessage.OBJECT_CLOSED) {
                    InspectorWindowImpl.wa$nodeURL(InspectorWindowImpl.this, null);
                    InspectorWindowImpl.wa$projectURL(InspectorWindowImpl.this, null);
                    InspectorWindowImpl.wa$workspaceURL(InspectorWindowImpl.this, null);
                    InspectorWindowImpl.ra$pinTargets(InspectorWindowImpl.this).clear();
                    this.reset();
                    InspectorWindowImpl.this.clear();
                } else if (InspectorWindowImpl.this.isVisible() && this.hotTargets.contains(object)) {
                    InspectorWindowImpl.mav$restorePinTarget(InspectorWindowImpl.this, false);
                }
            }
        }

        private TargetMonitor() {
            this.$init$();
        }

        TargetMonitor(1 var2_2) {
            this();
        }

        static void mav$monitor(TargetMonitor targetMonitor, Subject subject, boolean bl) {
            targetMonitor.monitor(subject, bl);
        }

        static void wa$title(TargetMonitor targetMonitor, String string) {
            targetMonitor.title = string;
        }

        static String ra$title(TargetMonitor targetMonitor) {
            return targetMonitor.title;
        }

        public final class 1 {
        }
    }

    private class TattleTale
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            InspectorWindowImpl.this.customizerChange(propertyChangeEvent);
        }

        private TattleTale() {
        }

        TattleTale(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TitleListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("targetDisplayName".equals(propertyChangeEvent.getPropertyName())) {
                InspectorWindowImpl.mav$setTitle(InspectorWindowImpl.this, (String)propertyChangeEvent.getNewValue());
            }
        }

        private TitleListener() {
        }

        TitleListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class LinksLayout
    extends FlowLayout {
        public LinksLayout() {
            this.setAlignment(0);
            this.setVgap(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Insets insets = container.getInsets();
                int n = container.getWidth() - (insets.left + insets.right + this.getHgap() * 2);
                if (n < 0) {
                    Dimension dimension = super.preferredLayoutSize(container);
                    return dimension;
                }
                int n2 = container.getComponentCount();
                int n3 = 0;
                int n4 = insets.top + this.getVgap();
                int n5 = 0;
                boolean bl = false;
                boolean bl2 = container.getComponentOrientation().isLeftToRight();
                int n6 = 0;
                while (n6 < n2) {
                    Component component = container.getComponent(n6);
                    if (component.isVisible()) {
                        Dimension dimension = component.getPreferredSize();
                        if (n3 == 0 || n3 + dimension.width <= n) {
                            if (n3 > 0) {
                                n3 += this.getHgap();
                            }
                            n3 += dimension.width;
                            n5 = Math.max(n5, dimension.height);
                        } else {
                            n3 = dimension.width;
                            n4 += this.getVgap() + n5;
                            n5 = dimension.height;
                        }
                    }
                    ++n6;
                }
                Dimension dimension = new Dimension(n3, n4 += n5);
                return dimension;
            }
        }
    }
}

