/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.Ide;
import oracle.ide.IdeUIManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableView;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.icons.IdeIcons;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.inspector.InspectorPage;
import oracle.ide.inspector.InspectorWindow;
import oracle.ide.resource.IdeArb;
import oracle.ideimpl.inspector.InspectorGroup;
import oracle.ideimpl.resource.InspectorArb;

public class PropertyInspector
extends oracle.bali.inspector.PropertyInspector
implements InspectorPage {
    public static final String PROPERTY_READ_ONLY = "readOnlyIncluded";
    public static final String PROPERTY_WRITE_ONLY = "writeOnlyIncluded";
    public static final String PROPERTY_TOOLBAR = "actionComponentVisible";
    public static final String PROPERTY_STATUS = "statusVisible";
    private static final HashMap ICONS = new HashMap(10);
    protected InternalAction categorizedAction;
    protected InternalAction unionAction;
    protected InternalAction readOnlyAction;
    protected InternalAction writeOnlyAction;
    protected InternalAction findAction;
    protected InternalAction statusAction;
    protected InternalAction helpAction;
    protected InspectorWindow owner;
    protected Component separator;
    protected ToggleToolButton findButton;
    protected ToggleToolButton unionButton;
    protected ToggleToolButton categoryButton;
    protected JPopupMenu contextMenu;
    protected JMenuItem categorizedItem;
    protected JMenuItem unionItem;
    protected JMenuItem readOnlyItem;
    protected JMenuItem writeOnlyItem;
    protected JMenuItem findItem;
    protected JMenuItem statusItem;
    protected JSeparator helpSeparator;
    protected JMenuItem helpItem;
    private AbstractButton findNextButton;
    private AbstractButton findPrevButton;

    private boolean updateBackground(Component component) {
        Component[] componentArray;
        if (component instanceof JViewport) {
            component.setBackground(IdeUIManager.getSelectedFocusedTabColor());
            return true;
        }
        Component[] componentArray2 = componentArray = component instanceof Container ? ((Container)component).getComponents() : null;
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                if (this.updateBackground(componentArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public PropertyInspector() {
        super((oracle.bali.inspector.InspectorGroup)new InspectorGroup());
        this.findNextButton.setIcon(IdeIcons.getIcon(4));
        this.findPrevButton.setIcon(IdeIcons.getIcon(5));
        this.setColumnFilter(PropertyModel.COLUMN_IS_HIDDEN, Boolean.TRUE, Boolean.FALSE);
        this.setActionComponent(null);
        ((BorderLayout)this.getLayout()).setVgap(0);
        super.setStatusVisible(false);
        this.updateBackground((Component)((Object)this));
        Container container = this.findNextButton.getParent();
        Container container2 = container.getParent();
        Toolbar toolbar = new Toolbar();
        toolbar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        toolbar.add(this.findNextButton);
        toolbar.add(this.findPrevButton);
        container2.remove(container);
        container2.add((Component)toolbar, "East");
        this.updateBorders();
        this.setCategorized(false);
        this.setIntersection(true);
        this.setReadOnlyIncluded(false);
        this.setWriteOnlyIncluded(false);
        this.setFindVisible(false);
        this.setAlphabetizeGroupProperties(true);
        this.addPropertyChangeListener(new 2());
        this.setColumnRenderer(PropertyModel.COLUMN_DISPLAY_NAME, new NameRenderer(this));
    }

    public void setUnderlyingPropertyModel(PropertyModel propertyModel) {
        PropertyModel propertyModel2 = this.getUnderlyingPropertyModel();
        super.setUnderlyingPropertyModel(propertyModel);
        if (propertyModel2 != null && propertyModel2 != this.getUnderlyingPropertyModel()) {
            SwingUtilities.invokeLater(new 1(this, propertyModel2));
        }
    }

    public void setStatusVisible(boolean bl) {
        if (this.owner != null) {
            this.owner.setStatusVisible(bl);
        }
    }

    public boolean isStatusVisible() {
        return this.owner != null ? this.owner.isStatusVisible() : false;
    }

    public void setStatusText(String string) {
        if (this.owner != null) {
            this.owner.setStatus(string);
        }
    }

    protected synchronized JPopupMenu getMenuForRow(int n, PropertyModel propertyModel, Object object) {
        Object object2;
        int n2;
        if (this.contextMenu == null) {
            if (this.findAction == null) {
                this.initActions();
            }
            this.categorizedItem = new ToggleMenuItem(this.categorizedAction);
            this.unionItem = new ToggleMenuItem(this.unionAction);
            this.readOnlyItem = new ToggleMenuItem(this.readOnlyAction);
            this.writeOnlyItem = new ToggleMenuItem(this.writeOnlyAction);
            this.findItem = new ToggleMenuItem(this.findAction);
            this.statusItem = new ToggleMenuItem(this.statusAction);
            this.helpItem = Ide.getMenubar().createMenuItem(this.helpAction);
            this.contextMenu = new JPopupMenu();
            this.contextMenu.add(this.categorizedItem);
            this.contextMenu.add(this.unionItem);
            this.contextMenu.add(new JSeparator());
            this.contextMenu.add(this.readOnlyItem);
            this.contextMenu.add(this.writeOnlyItem);
            this.contextMenu.add(new JSeparator());
            this.contextMenu.add(this.findItem);
            this.contextMenu.add(this.statusItem);
        }
        HelpInfo helpInfo = null;
        int n3 = n2 = propertyModel != null ? propertyModel.getColumnIndex(IdePropertyModel.COLUMN_HELP) : -1;
        if (n2 != -1 && n >= 0 && (object2 = propertyModel.getValueAt(n, n2)) instanceof HelpInfo) {
            DockableView dockableView = InspectorManager.getInspectorManager().getLastView();
            helpInfo = (HelpInfo)object2;
            helpInfo.setContext(dockableView != null ? dockableView.getContext() : null);
        }
        if (helpInfo != null) {
            this.helpAction.putValue("UserData", helpInfo);
            if (this.helpItem.getParent() == null) {
                this.contextMenu.add(this.helpSeparator);
                this.contextMenu.add(this.helpItem);
            }
        } else if (this.helpItem.getParent() != null) {
            this.contextMenu.remove(this.helpSeparator);
            this.contextMenu.remove(this.helpItem);
        }
        this.statusAction.setState(this.owner != null ? this.owner.isStatusVisible() : false);
        return this.contextMenu;
    }

    protected Icon getIcon(String string) {
        Icon icon = (Icon)ICONS.get(string);
        if (icon == null) {
            icon = "categorized".equals(string) ? InspectorArb.getIcon(16) : ("find".equals(string) ? IdeArb.getIcon(110) : ("findNext".equals(string) ? IdeArb.getIcon(116) : ("findPrevious".equals(string) ? IdeArb.getIcon(119) : ("union".equals(string) ? InspectorArb.getIcon(15) : super.getIcon(string)))));
            ICONS.put(string, icon);
        }
        return icon;
    }

    public String getShortLabel() {
        return InspectorArb.getString(21);
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return InspectorArb.getIcon(26);
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public void stateChanged(int n) {
        if (n == 2) {
            this.setUnderlyingPropertyModel(null);
            if (this.findAction != null) {
                this.categorizedAction = null;
                this.unionAction = null;
                this.readOnlyAction = null;
                this.writeOnlyAction = null;
                this.findAction = null;
                this.statusAction = null;
                this.helpAction = null;
            }
            this.findButton = null;
            this.unionButton = null;
            this.categoryButton = null;
        } else {
            this.toolbarStateChanged(n);
        }
    }

    public void toolbarStateChanged(int n) {
        Toolbar toolbar = this.owner.getToolbar();
        switch (n) {
            case 0: {
                if (this.findButton == null) {
                    if (toolbar == null) break;
                    if (this.findAction == null) {
                        this.initActions();
                    }
                    toolbar.addSeparator();
                    this.separator = toolbar.getComponent(toolbar.getComponentCount() - 1);
                    this.findButton = toolbar.addToggleButton(this.findAction);
                    this.unionButton = toolbar.addToggleButton(this.unionAction);
                    this.categoryButton = toolbar.addToggleButton(this.categorizedAction);
                    break;
                }
                if (toolbar == null) break;
                toolbar.add(this.separator);
                toolbar.add(this.findButton);
                toolbar.add(this.unionButton);
                toolbar.add(this.categoryButton);
                break;
            }
            case 1: {
                if (this.findButton == null || toolbar == null) break;
                toolbar.remove(this.separator);
                toolbar.remove(this.findButton);
                toolbar.remove(this.unionButton);
                toolbar.remove(this.categoryButton);
            }
        }
    }

    public void setOwner(InspectorWindow inspectorWindow) {
        this.owner = inspectorWindow;
    }

    public Component getDefaultFocusComponent() {
        return this.getPropertyTable();
    }

    protected void initActions() {
        this.categorizedAction = new InternalAction(InspectorArb.getString(2), InspectorArb.getInteger(3), this.getIcon("categorized"), this.isCategorized());
        this.unionAction = new InternalAction(InspectorArb.getString(4), InspectorArb.getInteger(5), this.getIcon("union"), this.isIntersection() ^ true);
        this.readOnlyAction = new InternalAction(InspectorArb.getString(6), InspectorArb.getInteger(7), null, this.isReadOnlyIncluded());
        this.writeOnlyAction = new InternalAction(InspectorArb.getString(8), InspectorArb.getInteger(9), null, this.isWriteOnlyIncluded());
        this.findAction = new InternalAction(InspectorArb.getString(11), InspectorArb.getInteger(12), this.getIcon("find"), this.isFindVisible());
        this.statusAction = new InternalAction(InspectorArb.getString(13), InspectorArb.getInteger(14), null, this.isStatusVisible());
        this.helpSeparator = new JSeparator();
        this.helpAction = new InternalAction(InspectorArb.getString(17), InspectorArb.getInteger(18), null, false);
        this.helpAction.putValue("Check", Boolean.FALSE);
    }

    private void updateBorders() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(BorderFactory.createEmptyBorder());
                if (component instanceof JSplitPane) {
                    Component component2 = ((JSplitPane)component).getTopComponent();
                    if (component2 instanceof JComponent) {
                        ((JComponent)component2).setBorder(BorderFactory.createEmptyBorder());
                    }
                    if ((component2 = ((JSplitPane)component).getBottomComponent()) instanceof JComponent) {
                        ((JComponent)component2).setBorder(BorderFactory.createEmptyBorder());
                    }
                }
            }
            ++n;
        }
    }

    protected AbstractButton createFindNextButton() {
        this.findNextButton = new ToolButton(null);
        return this.findNextButton;
    }

    protected AbstractButton createFindPreviousButton() {
        this.findPrevButton = new ToolButton(null);
        return this.findPrevButton;
    }

    protected JTextField createFindTextField() {
        JTextField jTextField = super.createFindTextField();
        jTextField.setBorder(BorderFactory.createEmptyBorder());
        return jTextField;
    }

    public final class 2
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (PropertyInspector.this.findAction == null) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if ("categorized".equals(string)) {
                PropertyInspector.this.categorizedAction.setState(PropertyInspector.this.isCategorized());
            } else if ("intersection".equals(string)) {
                PropertyInspector.this.unionAction.setState(PropertyInspector.this.isIntersection() ^ true);
            } else if (PropertyInspector.PROPERTY_READ_ONLY.equals(string)) {
                PropertyInspector.this.readOnlyAction.setState(PropertyInspector.this.isReadOnlyIncluded());
            } else if (PropertyInspector.PROPERTY_WRITE_ONLY.equals(string)) {
                PropertyInspector.this.writeOnlyAction.setState(PropertyInspector.this.isWriteOnlyIncluded());
            } else if ("findVisible".equals(string)) {
                PropertyInspector.this.findAction.setState(PropertyInspector.this.isFindVisible());
            } else if (PropertyInspector.PROPERTY_STATUS.equals(string)) {
                PropertyInspector.this.statusAction.setState(PropertyInspector.this.isStatusVisible());
            }
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ PropertyModel v$oldModel;
        final /* synthetic */ PropertyInspector this$0;

        public void run() {
            this.v$oldModel.dispose();
        }

        public 1(PropertyInspector propertyInspector, PropertyModel propertyModel) {
            this.v$oldModel = propertyModel;
            this.this$0 = propertyInspector;
        }
    }

    public static final class NameRenderer
    extends DefaultTableCellRenderer {
        private PropertyInspector pi;

        public NameRenderer(PropertyInspector propertyInspector) {
            this.pi = propertyInspector;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3;
            PropertyModel propertyModel = this.pi != null ? this.pi.getPropertyModel() : null;
            int n4 = n3 = propertyModel != null ? propertyModel.getColumnIndex(IdePropertyModel.COLUMN_ICON) : -1;
            if (n3 != -1) {
                this.setIcon((Icon)propertyModel.getValueAt(n, n3));
            } else {
                this.setIcon(null);
            }
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ((JComponent)component).setBorder(null);
            return component;
        }
    }

    public class InternalAction
    extends ToggleAction {
        InternalAction(String string, Integer n, Icon icon, boolean bl) {
            super(string, icon);
            this.putValue("Check", Boolean.TRUE);
            this.putValue("State", bl ? Boolean.TRUE : Boolean.FALSE);
            this.putValue("MnemonicKey", n);
            this.putValue("ActionCommandKey", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpInfo helpInfo;
            String string = actionEvent.getActionCommand();
            if (PropertyInspector.this.categorizedAction.getValue("Name").equals(string)) {
                PropertyInspector.this.setCategorized(PropertyInspector.this.isCategorized() ^ true);
            } else if (PropertyInspector.this.unionAction.getValue("Name").equals(string)) {
                PropertyInspector.this.setIntersection(PropertyInspector.this.isIntersection() ^ true);
            } else if (PropertyInspector.this.readOnlyAction.getValue("Name").equals(string)) {
                PropertyInspector.this.setReadOnlyIncluded(PropertyInspector.this.isReadOnlyIncluded() ^ true);
            } else if (PropertyInspector.this.writeOnlyAction.getValue("Name").equals(string)) {
                PropertyInspector.this.setWriteOnlyIncluded(PropertyInspector.this.isWriteOnlyIncluded() ^ true);
            } else if (PropertyInspector.this.findAction.getValue("Name").equals(string)) {
                PropertyInspector.this.setFindVisible(PropertyInspector.this.isFindVisible() ^ true);
            } else if (PropertyInspector.this.statusAction.getValue("Name").equals(string)) {
                PropertyInspector.this.setStatusVisible(PropertyInspector.this.isStatusVisible() ^ true);
            } else if (PropertyInspector.this.helpAction.getValue("Name").equals(string) && (helpInfo = (HelpInfo)this.getValue("UserData")) != null) {
                HelpSystem.getHelpSystem().showHelp(helpInfo);
            }
        }
    }
}

