/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198;

import java.awt.Component;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ide.command.Controller;
import javax.ide.menu.ActionRegistry;
import javax.ide.menu.IDEAction;
import javax.ide.menu.spi.Item;
import javax.ide.menu.spi.Menu;
import javax.ide.menu.spi.MenuBar;
import javax.ide.menu.spi.MenuModel;
import javax.ide.menu.spi.PopupMenu;
import javax.ide.menu.spi.Section;
import javax.ide.menu.spi.SectionContainer;
import javax.ide.util.MissingIconException;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.editor.EditorManager;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.resource.IdeIcons;
import oracle.ideimpl.jsr198.JSR198Action;
import oracle.ideimpl.jsr198.JavaxIdeController;
import oracle.ideimpl.jsr198.WrappedOracleAction;

public final class OracleActionRegistry
extends ActionRegistry {
    private static final Map TL_MENU_ID_MAP = new HashMap();
    private static final Map STANDARD_SECTIONS = new HashMap();
    private static final Map STANDARD_ITEMS = new HashMap();
    private static Map ACTION_ALIAS_MAP = null;

    static {
        TL_MENU_ID_MAP.put("javax.ide.FILE_MENU_ID", "File");
        TL_MENU_ID_MAP.put("javax.ide.EDIT_MENU_ID", "Edit");
        TL_MENU_ID_MAP.put("javax.ide.VIEW_MENU_ID", "View");
        TL_MENU_ID_MAP.put("javax.ide.HELP_MENU_ID", "Help");
        STANDARD_SECTIONS.put("javax.ide.OPEN_SECTION_ID", new Float(1.0f));
        STANDARD_SECTIONS.put("javax.ide.NEW_SECTION_ID", new Float(1.0f));
        STANDARD_SECTIONS.put("javax.ide.PRINT_SECTION_ID", new Float(MenuConstants.SECTION_FILE_PRINT));
        STANDARD_SECTIONS.put("javax.ide.SAVE_SECTION_ID", new Float(MenuConstants.SECTION_FILE_SAVE));
        STANDARD_SECTIONS.put("javax.ide.COPY_PASTE_SECTION_ID", new Float(MenuConstants.SECTION_EDIT_CUT_COPY_PASTE));
        STANDARD_ITEMS.put("javax.ide.OPEN_ACTION_ID", new Float(MenuConstants.WEIGHT_FILE_OPEN));
        STANDARD_ITEMS.put("javax.ide.CUT_ACTION_ID", new Float(MenuConstants.WEIGHT_EDIT_CUT));
        STANDARD_ITEMS.put("javax.ide.COPY_ACTION_ID", new Float(MenuConstants.WEIGHT_EDIT_COPY));
        STANDARD_ITEMS.put("javax.ide.PASTE_ACTION_ID", new Float(MenuConstants.WEIGHT_EDIT_PASTE));
    }

    protected void initialize() {
        this.registerActions();
        if (Ide.getMainWindow().isVisible()) {
            this.postMainWindowInit();
        } else {
            Ide.addIdeListener(new 2());
        }
    }

    private void postMainWindowInit() {
        this.registerTopLevelMenus();
        this.registerControllerChains();
        this.registerContextMenus();
    }

    private ExtensionRegistry getExtensionRegistry() {
        return ExtensionRegistry.getOracleRegistry();
    }

    private void registerContextMenus() {
        NavigatorManager.getWorkspaceNavigatorManager().getContextMenu().addContextMenuListener(new MyContextMenuListener("javax.ide.view.PROJECT_EXPLORER_POPUP_ID"));
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(new MyContextMenuListener("javax.ide.view.EDITOR_POPUP_ID"));
    }

    private void registerControllerChains() {
        if (ACTION_ALIAS_MAP == null) {
            ACTION_ALIAS_MAP = new HashMap();
            ACTION_ALIAS_MAP.put("javax.ide.OPEN_ACTION_ID", Ide.findCmdName(9));
            ACTION_ALIAS_MAP.put("javax.ide.CUT_ACTION_ID", Ide.findCmdName(17));
            ACTION_ALIAS_MAP.put("javax.ide.COPY_ACTION_ID", Ide.findCmdName(18));
            ACTION_ALIAS_MAP.put("javax.ide.PASTE_ACTION_ID", Ide.findCmdName(19));
        }
        Map map = this.getModel().getActions();
        Set set = this.getModel().getActionsWithControllers();
        for (String string : set) {
            Integer n;
            List list = this.getModel().getControllers(string);
            if (map.get(string) != null) continue;
            String string2 = (String)ACTION_ALIAS_MAP.get(string);
            if (string2 != null) {
                string = string2;
            }
            if ((n = Ide.findCmdID(string)) == null) continue;
            IdeAction ideAction = IdeAction.find(n);
            for (Controller controller : list) {
                ideAction.addController(new 1(this, controller, ideAction));
            }
        }
    }

    private void registerTopLevelMenus() {
        MenuModel menuModel = this.getModel();
        Map map = menuModel.getMenuBars();
        MenuBar menuBar = (MenuBar)map.get("javax.ide.view.MAIN_WINDOW_MENUBAR_ID");
        if (menuBar != null) {
            float f = 0.0f;
            List list = menuBar.getMenus();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                f += 0.001f;
                Menu menu = (Menu)iterator.next();
                JMenu jMenu = this.getPhysicalMenu(menu);
                if (jMenu != null) {
                    Float f2 = (Float)jMenu.getClientProperty("menu-weight");
                    if (f2 == null) {
                        this.getExtensionRegistry().getLogger().warning("Found menu " + menu.getID() + " with no weight. Order may be wrong.");
                    } else {
                        f = f2.floatValue();
                    }
                } else {
                    jMenu = Ide.getMenubar().createMenu(menu.getLabel(), new Integer(menu.getMnemonic()), f);
                    Ide.getMenubar().add(jMenu);
                    MenuManager.putJMenu(menu.getID(), jMenu);
                }
                this.addToMenu(new JMenuWrapper(jMenu), (SectionContainer)menu);
            }
        }
    }

    private void addToMenu(PhysicalMenuWrapper physicalMenuWrapper, SectionContainer sectionContainer) {
        Menubar menubar = Ide.getMenubar();
        float f = 0.0f;
        for (Section section : sectionContainer.getSections()) {
            float f2 = 1000.0f;
            Float f3 = (Float)STANDARD_SECTIONS.get(section.getID());
            if (f3 != null) {
                f = f3.floatValue();
                if ("javax.ide.NEW_SECTION_ID".equals(section.getID())) {
                    f2 = MenuConstants.WEIGHT_FILE_OPEN - 0.05f;
                }
            }
            for (Object e : section.getContent()) {
                if (e instanceof Item) {
                    String string = ((Item)e).getActionID();
                    Float f4 = (Float)STANDARD_ITEMS.get(string);
                    if (f4 != null) {
                        f2 = f4.floatValue();
                        continue;
                    }
                    Integer n = Ide.findCmdID(string);
                    if (n == null) {
                        this.getExtensionRegistry().getLogger().warning("Action id " + string + " not found in menu " + sectionContainer.getID());
                        continue;
                    }
                    IdeAction ideAction = IdeAction.find(n);
                    physicalMenuWrapper.add(menubar.createMenuItem(ideAction, f2), f);
                    continue;
                }
                if (!(e instanceof Menu)) continue;
                Menu menu = (Menu)e;
                JMenu jMenu = menubar.createSubMenu(menu.getLabel(), new Integer(menu.getMnemonic()), f2);
                if (menu.getIcon() != null) {
                    try {
                        URL uRL = menu.getIcon().getURL();
                        ImageIcon imageIcon = new ImageIcon(uRL);
                        jMenu.setIcon(imageIcon);
                    }
                    catch (MissingIconException missingIconException) {
                        this.getExtensionRegistry().getLogger().warning(missingIconException.getMessage());
                    }
                } else {
                    jMenu.setIcon(IdeIcons.getIcon(0));
                }
                physicalMenuWrapper.add(jMenu, f);
                this.addToMenu(new JMenuWrapper(jMenu), (SectionContainer)menu);
            }
            f += 1.0f;
        }
    }

    private JMenu getPhysicalMenu(Menu menu) {
        String string = menu.getID();
        String string2 = (String)TL_MENU_ID_MAP.get(string);
        if (string2 == null) {
            string2 = string;
        }
        return MenuManager.getJMenu(string2);
    }

    private void registerActions() {
        Map map = this.getModel().getActions();
        for (String string : map.keySet()) {
            Integer n = Ide.findCmdID(string);
            if (n != null) {
                this.getExtensionRegistry().getLogger().warning("Action with id '" + string + "' is defined both in an extension manifest and " + "programmatically. The programmatic definition wins.");
                return;
            }
            int n2 = Ide.findOrCreateCmdID(string);
            JSR198Action jSR198Action = new JSR198Action((IDEAction)map.get(string));
            Ide.getIdeActionMap().put(new Integer(n2), jSR198Action);
        }
    }

    static void mav$postMainWindowInit(OracleActionRegistry oracleActionRegistry) {
        oracleActionRegistry.postMainWindowInit();
    }

    static MenuModel mav$getModel(OracleActionRegistry oracleActionRegistry) {
        return oracleActionRegistry.getModel();
    }

    static void mav$addToMenu(OracleActionRegistry oracleActionRegistry, PhysicalMenuWrapper physicalMenuWrapper, SectionContainer sectionContainer) {
        oracleActionRegistry.addToMenu(physicalMenuWrapper, sectionContainer);
    }

    public final class 2
    implements IdeListener {
        public void addinsLoaded(IdeEvent ideEvent) {
        }

        public void mainWindowOpened(IdeEvent ideEvent) {
            Ide.removeIdeListener(this);
            OracleActionRegistry.mav$postMainWindowInit(OracleActionRegistry.this);
        }

        public void mainWindowClosing(IdeEvent ideEvent) {
        }
    }

    private class MyContextMenuListener
    implements ContextMenuListener {
        private final String _popupId;

        public MyContextMenuListener(String string) {
            this._popupId = string;
        }

        public void menuWillShow(ContextMenu contextMenu) {
            MenuModel menuModel = OracleActionRegistry.mav$getModel(OracleActionRegistry.this);
            PopupMenu popupMenu = (PopupMenu)menuModel.getPopupMenus().get(this._popupId);
            if (popupMenu != null) {
                OracleActionRegistry.mav$addToMenu(OracleActionRegistry.this, new ContextMenuWrapper(contextMenu), (SectionContainer)popupMenu);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    public final class 1
    extends JavaxIdeController {
        private final /* synthetic */ IdeAction v$oideAction;
        final /* synthetic */ OracleActionRegistry this$0;

        protected IDEAction getJavaxIdeAction() {
            return new WrappedOracleAction(this.v$oideAction.getCommandId());
        }

        public 1(OracleActionRegistry oracleActionRegistry, Controller controller, IdeAction ideAction) {
            this.v$oideAction = ideAction;
            this.this$0 = oracleActionRegistry;
            super(controller);
        }
    }

    private interface PhysicalMenuWrapper {
        public void add(Component var1, float var2);
    }

    private class JMenuWrapper
    implements PhysicalMenuWrapper {
        private final JMenu _menu;

        JMenuWrapper(JMenu jMenu) {
            this._menu = jMenu;
        }

        public void add(Component component, float f) {
            Ide.getMenubar().add(component, this._menu, f);
        }
    }

    private class ContextMenuWrapper
    implements PhysicalMenuWrapper {
        private final ContextMenu _contextMenu;

        ContextMenuWrapper(ContextMenu contextMenu) {
            this._contextMenu = contextMenu;
        }

        public void add(Component component, float f) {
            this._contextMenu.add(component, f);
        }
    }
}

