/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystemHelper;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;

final class VirtualFileSystemHelperImpl
extends VirtualFileSystemHelper {
    public URI canonicalize(URI uRI) throws IOException {
        URL uRL = URLFileSystem.canonicalize(this.toURL(uRI));
        return URIFactory.newURI((URL)uRL);
    }

    public boolean canRead(URI uRI) {
        try {
            boolean bl = URLFileSystem.canRead(this.toURL(uRI));
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean canWrite(URI uRI) {
        try {
            boolean bl = URLFileSystem.canWrite(this.toURL(uRI));
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean canCreate(URI uRI) {
        try {
            boolean bl = URLFileSystem.canCreate(this.toURL(uRI));
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean delete(URI uRI) {
        try {
            boolean bl = URLFileSystem.delete(this.toURL(uRI));
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean equals(URI uRI, URI uRI2) {
        try {
            boolean bl = URLFileSystem.equals(uRI.toURL(), uRI2.toURL());
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean exists(URI uRI) {
        try {
            URL uRL = this.toURL(uRI);
            boolean bl = URLFileSystem.exists(uRL);
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public long getLength(URI uRI) {
        try {
            long l = URLFileSystem.getLength(this.toURL(uRI));
            return l;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public URI getParent(URI uRI) {
        try {
            URL uRL = URLFileSystem.getParent(this.toURL(uRI));
            URI uRI2 = URIFactory.newURI((URL)uRL);
            return uRI2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getPlatformPathName(URI uRI) {
        try {
            String string = URLFileSystem.getPlatformPathName(this.toURL(uRI));
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean hasSuffix(URI uRI, String string) {
        try {
            boolean bl = URLFileSystem.hasSuffix(this.toURL(uRI), string);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isDirectory(URI uRI) {
        try {
            boolean bl = URLFileSystem.isDirectory(this.toURL(uRI));
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isHidden(URI uRI) {
        try {
            boolean bl = URLFileSystem.isHidden(this.toURL(uRI));
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isRegularFile(URI uRI) {
        try {
            boolean bl = URLFileSystem.isRegularFile(this.toURL(uRI));
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public long lastModified(URI uRI) {
        try {
            long l = URLFileSystem.lastModified(this.toURL(uRI));
            return l;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public boolean isReadOnly(URI uRI) {
        try {
            boolean bl = URLFileSystem.isReadOnly(this.toURL(uRI));
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public URI[] list(URI uRI) {
        try {
            URL[] uRLArray = URLFileSystem.list(this.toURL(uRI));
            URI[] uRIArray = new URI[uRLArray.length];
            int n = 0;
            while (n < uRLArray.length) {
                uRIArray[n] = URIFactory.newURI((URL)uRLArray[n]);
                ++n;
            }
            URI[] uRIArray2 = uRIArray;
            return uRIArray2;
        }
        catch (Exception exception) {
            return new URI[0];
        }
    }

    public URI[] listRoots() {
        try {
            URL[] uRLArray = URLFileSystem.listRoots();
            URI[] uRIArray = new URI[uRLArray.length];
            int n = 0;
            while (n < uRLArray.length) {
                uRIArray[n] = URIFactory.newURI((URL)uRLArray[n]);
                ++n;
            }
            URI[] uRIArray2 = uRIArray;
            return uRIArray2;
        }
        catch (Exception exception) {
            return new URI[0];
        }
    }

    public boolean mkdirs(URI uRI) {
        try {
            boolean bl = URLFileSystem.mkdirs(this.toURL(uRI));
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public URI createTempFile(String string, String string2, URI uRI) throws IOException {
        try {
            URL uRL = URLFileSystem.createTempFile(string, string2, uRI.toURL());
            URI uRI2 = URIFactory.newURI((URL)uRL);
            return uRI2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InputStream openInputStream(URI uRI) throws IOException {
        URL uRL = this.toURL(uRI);
        return URLFileSystem.openInputStream(uRL);
    }

    public OutputStream openOutputStream(URI uRI) throws IOException {
        URL uRL = this.toURL(uRI);
        return URLFileSystem.openOutputStream(uRL);
    }

    public boolean renameTo(URI uRI, URI uRI2) {
        try {
            boolean bl = URLFileSystem.renameTo(URLFactory.newURL(uRI.toString()), URLFactory.newURL(uRI2.toString()));
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setLastModified(URI uRI, long l) {
        try {
            boolean bl = URLFileSystem.setLastModified(this.toURL(uRI), l);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setReadOnly(URI uRI, boolean bl) {
        try {
            boolean bl2 = URLFileSystem.setReadOnly(this.toURL(uRI), bl);
            return bl2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toRelativeSpec(URI uRI, URI uRI2, boolean bl) {
        try {
            String string = URLFileSystem.toRelativeSpec(this.toURL(uRI), uRI2.toURL(), bl);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public URI getBaseParent(URI uRI, String string) {
        try {
            URL uRL = URLFileSystem.getBaseParent(this.toURL(uRI), string);
            URI uRI2 = URIFactory.newURI((URL)uRL);
            return uRI2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public URL toURL(URI uRI) {
        String string = uRI.getPath();
        if ("jar".equals(uRI.getScheme()) && string.startsWith("/file:")) {
            string = string.substring(1);
        }
        return URLFactory.newURL(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), string, uRI.getQuery(), uRI.getQuery());
    }

    VirtualFileSystemHelperImpl() {
    }
}

