/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.editor;

import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ide.editor.spi.DisplayInfo;
import javax.ide.editor.spi.EditorHook;
import javax.ide.editor.spi.MappingInfo;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.model.Document;
import javax.ide.model.DocumentFactory;
import javax.ide.net.URIFactory;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorCreator;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.util.MenuSpec;
import oracle.ideimpl.jsr198.editor.JavaxIdeEditor;

final class JavaxIdeEditorAddin
extends EditorAddin
implements EditorCreator {
    private final MetaClass _javaxEditorClass;
    private Set _documentClasses;
    private MenuSpec _menuSpec;

    void $init$() {
        this._documentClasses = null;
        this._menuSpec = null;
    }

    JavaxIdeEditorAddin(MetaClass metaClass) {
        this.$init$();
        this._javaxEditorClass = metaClass;
    }

    public Class getEditorClass() {
        return JavaxIdeEditor.class;
    }

    public MenuSpec getMenuSpecification() {
        if (this._menuSpec == null) {
            EditorHook editorHook = (EditorHook)ExtensionRegistry.getExtensionRegistry().getHook(EditorHook.ELEMENT);
            DisplayInfo displayInfo = editorHook.getDisplayInfo(this._javaxEditorClass);
            this._menuSpec = new MenuSpec(displayInfo == null ? "Unknown" : displayInfo.getName(), null, null);
        }
        return this._menuSpec;
    }

    public float getEditorWeight(Element element) {
        if (element instanceof Locatable) {
            URL uRL = ((Locatable)((Object)element)).getURL();
            URI uRI = URIFactory.newURI((URL)uRL);
            Document document = DocumentFactory.getDocumentFactory().find(uRI);
            if (this.isValidDocument(document)) {
                return -1.0f;
            }
        }
        return Float.NaN;
    }

    private boolean isValidDocument(Document document) {
        if (this._documentClasses == null) {
            this._documentClasses = new HashSet();
        } else if (this._documentClasses.contains(document.getClass().getName())) {
            return true;
        }
        EditorHook editorHook = (EditorHook)ExtensionRegistry.getExtensionRegistry().getHook(EditorHook.ELEMENT);
        Collection collection = editorHook.getEditorsForDocClass(document.getClass());
        if (collection != null) {
            for (MappingInfo mappingInfo : collection) {
                if (!mappingInfo.getEditorClass().equals(this._javaxEditorClass.getClassName())) continue;
                this._documentClasses.add(document.getClass().getName());
                return true;
            }
        }
        return false;
    }

    public Editor createEditor(Context context) {
        return new JavaxIdeEditor(this._javaxEditorClass);
    }
}

