/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.model;

import java.net.URI;
import java.net.URL;
import javax.ide.model.Document;
import javax.ide.model.DocumentFactory;
import javax.ide.model.Element;
import javax.ide.model.ElementDisplayInfo;
import javax.ide.net.URIFactory;
import javax.ide.util.IconDescription;
import javax.ide.util.MetaClass;
import javax.ide.util.MissingIconException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ideimpl.jsr198.model.Custom;

public final class CustomUtil {
    private CustomUtil() {
    }

    public static Document getJSRDocument(URL uRL) {
        Document document = null;
        URI uRI = URIFactory.newURI((URL)uRL);
        MetaClass metaClass = DocumentFactory.getDocumentFactory().recognize(uRI);
        if (metaClass == null) {
            throw new IllegalStateException("Unrecognized JSR-198 custom node: " + uRI);
        }
        try {
            document = (Document)metaClass.newInstance();
            document.setURI(URIFactory.newURI((URL)uRL));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            document = new Document();
        }
        return document;
    }

    public static Icon getIcon(Custom custom) {
        Document document = custom.getJSRDocument();
        ElementDisplayInfo elementDisplayInfo = document.getDisplayInfo();
        if (elementDisplayInfo == null) {
            return null;
        }
        IconDescription iconDescription = elementDisplayInfo.getIcon((Element)document);
        if (iconDescription != null) {
            try {
                URL uRL = iconDescription.getURL();
                ImageIcon imageIcon = new ImageIcon(uRL);
                if (imageIcon.getImageLoadStatus() == 8) {
                    ImageIcon imageIcon2 = imageIcon;
                    return imageIcon2;
                }
            }
            catch (MissingIconException missingIconException) {
                missingIconException.printStackTrace();
            }
        }
        return null;
    }

    public static String getLabel(Custom custom) {
        Document document = custom.getJSRDocument();
        ElementDisplayInfo elementDisplayInfo = document.getDisplayInfo();
        if (elementDisplayInfo == null) {
            return null;
        }
        return elementDisplayInfo.getLabel((Element)document);
    }

    public static String getLongLabel(Custom custom) {
        Document document = custom.getJSRDocument();
        ElementDisplayInfo elementDisplayInfo = document.getDisplayInfo();
        if (elementDisplayInfo == null) {
            return null;
        }
        return elementDisplayInfo.getLongLabel((Element)document);
    }

    public static String getToolTip(Custom custom) {
        Document document = custom.getJSRDocument();
        ElementDisplayInfo elementDisplayInfo = document.getDisplayInfo();
        if (elementDisplayInfo == null) {
            return null;
        }
        return elementDisplayInfo.getToolTip((Element)document);
    }
}

