/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.model;

import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ide.extension.ElementName;
import javax.ide.extension.spi.ListenerInfo;
import javax.ide.model.Document;
import javax.ide.model.DocumentEvent;
import javax.ide.model.DocumentFactory;
import javax.ide.model.DocumentListener;
import javax.ide.model.Recognizer;
import javax.ide.model.spi.DocumentHook;
import javax.ide.model.spi.SuffixRecognizer;
import javax.ide.model.spi.XMLRootElementRecognizer;
import javax.ide.model.text.TextDocument;
import javax.ide.model.xml.XMLDocument;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLRecognizer;
import oracle.ide.xml.XMLUtil;
import oracle.ideimpl.jsr198.Util;
import oracle.ideimpl.jsr198.model.Custom;
import oracle.ideimpl.jsr198.model.CustomNode;
import oracle.ideimpl.jsr198.model.CustomTextNode;

public class OracleDocumentFactory
extends DocumentFactory {
    private Collection _recognizers;
    private CustomNodeRootListener _customNodeRootListener;

    public final Document findOrCreate(URI uRI) {
        try {
            URL uRL = VirtualFileSystem.getVirtualFileSystem().toURL(uRI);
            Node node = NodeFactory.findOrCreate(uRL);
            Document document = this.convert(uRI, node);
            return document;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public final Document findOrCreate(MetaClass metaClass, URI uRI) {
        return null;
    }

    public final Document find(URI uRI) {
        try {
            URL uRL = VirtualFileSystem.getVirtualFileSystem().toURL(uRI);
            Node node = NodeFactory.find(uRL);
            Document document = this.convert(uRI, node);
            return document;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public final Document recache(URI uRI, URI uRI2, Document document) {
        return null;
    }

    public final Collection getCachedDocuments() {
        ArrayList<Document> arrayList = new ArrayList<Document>();
        Iterator iterator = NodeFactory.getCachedNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            URL uRL = node.getURL();
            URI uRI = URIFactory.newURI((URL)uRL);
            arrayList.add(this.find(uRI));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public MetaClass recognize(URI uRI) {
        DocumentHook documentHook = (DocumentHook)ExtensionRegistry.getExtensionRegistry().getHook(DocumentHook.ELEMENT);
        String string = VirtualFileSystem.getVirtualFileSystem().getSuffix(uRI);
        Collection collection = documentHook.getSuffixRecognizers();
        for (SuffixRecognizer suffixRecognizer : collection) {
            if (!suffixRecognizer.containsSuffix(string)) continue;
            return suffixRecognizer.getDocumentClass();
        }
        StartElementPacket startElementPacket = null;
        Collection collection2 = documentHook.getXMLRecognizers();
        for (SuffixRecognizer suffixRecognizer : collection2) {
            if (!suffixRecognizer.containsSuffix(string)) continue;
            if (startElementPacket == null) {
                try {
                    URL uRL = VirtualFileSystem.getVirtualFileSystem().toURL(uRI);
                    startElementPacket = XMLUtil.getXMLRootElement(uRL);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    break;
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    break;
                }
            }
            if (!this.matchesXMLRecognizer(startElementPacket, suffixRecognizer)) continue;
            return suffixRecognizer.getDocumentClass();
        }
        for (Recognizer recognizer : this.getRecognizers()) {
            MetaClass metaClass = recognizer.recognize(uRI);
            if (metaClass == null) continue;
            return metaClass;
        }
        return null;
    }

    private Collection getRecognizers() {
        DocumentHook documentHook = (DocumentHook)ExtensionRegistry.getExtensionRegistry().getHook(DocumentHook.ELEMENT);
        if (this._recognizers == null) {
            this._recognizers = new ArrayList();
            Collection collection = documentHook.getCustomRecognizers();
            for (MetaClass metaClass : collection) {
                Recognizer recognizer = (Recognizer)Util.createInstance(metaClass, Recognizer.class, "recognizer");
                if (recognizer == null) continue;
                this._recognizers.add(recognizer);
            }
        }
        return this._recognizers;
    }

    private boolean matchesXMLRecognizer(StartElementPacket startElementPacket, SuffixRecognizer suffixRecognizer) {
        if (suffixRecognizer instanceof XMLRootElementRecognizer) {
            XMLRootElementRecognizer xMLRootElementRecognizer = (XMLRootElementRecognizer)suffixRecognizer;
            for (ElementName elementName : xMLRootElementRecognizer.getRootElements()) {
                if ((startElementPacket.localName == null || !startElementPacket.localName.equals(elementName.getLocalName())) && elementName.getLocalName() != null || (startElementPacket.namespaceURI == null || !startElementPacket.namespaceURI.equals(elementName.getNamespaceURI())) && elementName.getNamespaceURI() != null) continue;
                return true;
            }
        }
        return false;
    }

    public Collection getRecognizedDocuments() {
        return null;
    }

    public String findDocumentTypeIdentifier(Class clazz, boolean bl) {
        return null;
    }

    protected Document convert(URI uRI, Node node) {
        if (node == null) {
            return null;
        }
        Object object = null;
        if (node instanceof Custom) {
            return ((Custom)((Object)node)).getJSRDocument();
        }
        object = node instanceof Project ? new javax.ide.model.Project() : (node instanceof TextNode ? new TextDocument() : new Document());
        object.setURI(uRI);
        return object;
    }

    protected void initialize() {
        DocumentHook documentHook = (DocumentHook)ExtensionRegistry.getExtensionRegistry().getHook(DocumentHook.ELEMENT);
        this.registerDocumentListeners(documentHook);
        this.registerDocumentTypes(documentHook);
    }

    protected void registerDocumentTypes(DocumentHook documentHook) {
        Collection collection = documentHook.getSuffixRecognizers();
        for (SuffixRecognizer suffixRecognizer : collection) {
            MetaClass metaClass = suffixRecognizer.getDocumentClass();
            Class clazz = this.getOracleNodeClassFor(metaClass.getClassName());
            if (clazz == null) {
                Document document = (Document)Util.createInstance(metaClass, Document.class, "document");
                clazz = this.getCustomNodeClassFor(document.getClass());
            }
            for (String string : suffixRecognizer.getSuffixes()) {
                if (metaClass.getClass().equals(XMLDocument.class.getName())) {
                    XMLRecognizer.treatExtensionAsXML(string);
                    continue;
                }
                oracle.ide.model.Recognizer.mapExtensionToClass(string, clazz);
            }
        }
        if (!documentHook.getCustomRecognizers().isEmpty()) {
            oracle.ide.model.Recognizer.registerLowPriorityRecognizer(new 1());
        }
    }

    private void registerDocumentListeners(DocumentHook documentHook) {
        Collection collection = documentHook.getDocumentListeners();
        for (ListenerInfo listenerInfo : collection) {
            Class clazz;
            MetaClass metaClass = listenerInfo.getListenerClass();
            String string = listenerInfo.getSourceID();
            if (string == null || string.trim().length() == 0) {
                string = "javax.ide.model.Document";
            }
            if ((clazz = this.getOracleNodeClassFor(string)) != null) {
                Node.addNodeListenerForTypeHierarchy(clazz, new NodeListenerAdapter(metaClass));
                continue;
            }
            if (this._customNodeRootListener == null) {
                this._customNodeRootListener = new CustomNodeRootListener(null);
                Node.addNodeListenerForTypeHierarchy(Node.class, this._customNodeRootListener);
            }
            this._customNodeRootListener.addDelegateListener(string, new NodeListenerAdapter(metaClass));
        }
    }

    private final Class getCustomNodeClassFor(MetaClass metaClass) {
        Document document = (Document)Util.createInstance(metaClass, Document.class, "document");
        return document == null ? null : this.getCustomNodeClassFor(document.getClass());
    }

    protected Class getCustomNodeClassFor(Class clazz) {
        if (TextDocument.class.isAssignableFrom(clazz)) {
            return CustomTextNode.class;
        }
        if (Document.class.isAssignableFrom(clazz)) {
            return CustomNode.class;
        }
        return null;
    }

    protected Class getOracleNodeClassFor(String string) {
        if (TextDocument.class.getName().equals(string)) {
            return TextNode.class;
        }
        if (Document.class.getName().equals(string)) {
            return Node.class;
        }
        if (javax.ide.model.Project.class.getName().equals(string)) {
            return Project.class;
        }
        return null;
    }

    static Collection mav$getRecognizers(OracleDocumentFactory oracleDocumentFactory) {
        return oracleDocumentFactory.getRecognizers();
    }

    static Class mav$getCustomNodeClassFor(OracleDocumentFactory oracleDocumentFactory, MetaClass metaClass) {
        return oracleDocumentFactory.getCustomNodeClassFor(metaClass);
    }

    public final class 1
    extends oracle.ide.model.Recognizer {
        public Class recognize(URL uRL) {
            URI uRI = URIFactory.newURI((URL)uRL);
            for (Recognizer recognizer : OracleDocumentFactory.mav$getRecognizers(OracleDocumentFactory.this)) {
                Class clazz;
                MetaClass metaClass = recognizer.recognize(uRI);
                if (metaClass == null || (clazz = OracleDocumentFactory.mav$getCustomNodeClassFor(OracleDocumentFactory.this, metaClass)) == null) continue;
                return clazz;
            }
            return null;
        }
    }

    private final class CustomNodeRootListener
    extends NodeListener {
        private Map _classNamesToListenerLists;

        void $init$() {
            this._classNamesToListenerLists = new HashMap();
        }

        public void addDelegateListener(String string, NodeListener nodeListener) {
            ArrayList<NodeListener> arrayList = (ArrayList<NodeListener>)this._classNamesToListenerLists.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<NodeListener>();
                this._classNamesToListenerLists.put(string, arrayList);
            }
            arrayList.add(nodeListener);
        }

        private List findListeners(Node node) {
            Document document;
            List list;
            if (node instanceof Custom && (list = (List)this._classNamesToListenerLists.get((document = ((Custom)((Object)node)).getJSRDocument()).getClass().getName())) != null) {
                return list;
            }
            return Collections.EMPTY_LIST;
        }

        public void nodeOpened(NodeEvent nodeEvent) {
            Iterator iterator = this.findListeners(nodeEvent.getNode()).iterator();
            while (iterator.hasNext()) {
                ((NodeListener)iterator.next()).nodeOpened(nodeEvent);
            }
        }

        public void nodeWillClose(NodeEvent nodeEvent) {
            Iterator iterator = this.findListeners(nodeEvent.getNode()).iterator();
            while (iterator.hasNext()) {
                ((NodeListener)iterator.next()).nodeOpened(nodeEvent);
            }
        }

        public void nodeClosed(NodeEvent nodeEvent) {
            Iterator iterator = this.findListeners(nodeEvent.getNode()).iterator();
            while (iterator.hasNext()) {
                ((NodeListener)iterator.next()).nodeClosed(nodeEvent);
            }
        }

        public void nodeWillBeSaved(NodeEvent nodeEvent) {
            Iterator iterator = this.findListeners(nodeEvent.getNode()).iterator();
            while (iterator.hasNext()) {
                ((NodeListener)iterator.next()).nodeWillBeSaved(nodeEvent);
            }
        }

        public void nodeSaved(NodeEvent nodeEvent) {
            Iterator iterator = this.findListeners(nodeEvent.getNode()).iterator();
            while (iterator.hasNext()) {
                ((NodeListener)iterator.next()).nodeSaved(nodeEvent);
            }
        }

        public void nodeReverted(NodeEvent nodeEvent) {
            Iterator iterator = this.findListeners(nodeEvent.getNode()).iterator();
            while (iterator.hasNext()) {
                ((NodeListener)iterator.next()).nodeReverted(nodeEvent);
            }
        }

        private CustomNodeRootListener() {
            this.$init$();
        }

        CustomNodeRootListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class NodeListenerAdapter
    extends NodeListener {
        private final MetaClass _listenerClass;
        private DocumentListener _jsrListener;

        NodeListenerAdapter(MetaClass metaClass) {
            this._listenerClass = metaClass;
        }

        private DocumentListener getJSRListener() {
            if (this._jsrListener == null) {
                try {
                    this._jsrListener = (DocumentListener)this._listenerClass.newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this._jsrListener = new NullDocumentListener(null);
                }
            }
            return this._jsrListener;
        }

        private DocumentEvent convertEvent(NodeEvent nodeEvent) {
            URL uRL = nodeEvent.getNodeURL();
            URI uRI = URIFactory.newURI((URL)uRL);
            Document document = OracleDocumentFactory.this.find(uRI);
            if (document == null) {
                ExtensionRegistry.getOracleRegistry().getLogger().fine("Not firing JSR-198 document event for " + URLFileSystem.getFileName(uRL) + ". (it's probably not in jdeveloper's node factory)");
                return null;
            }
            return new DocumentEvent(document);
        }

        public void nodeOpened(NodeEvent nodeEvent) {
            DocumentEvent documentEvent = this.convertEvent(nodeEvent);
            if (documentEvent != null) {
                this.getJSRListener().opened(documentEvent);
            }
        }

        public void nodeWillClose(NodeEvent nodeEvent) {
            DocumentEvent documentEvent = this.convertEvent(nodeEvent);
            if (documentEvent != null) {
                this.getJSRListener().willBeClosed(documentEvent);
            }
        }

        public void nodeClosed(NodeEvent nodeEvent) {
            DocumentEvent documentEvent = this.convertEvent(nodeEvent);
            if (documentEvent != null) {
                this.getJSRListener().closed(documentEvent);
            }
        }

        public void nodeWillBeSaved(NodeEvent nodeEvent) {
            DocumentEvent documentEvent = this.convertEvent(nodeEvent);
            if (documentEvent != null) {
                this.getJSRListener().willBeSaved(documentEvent);
            }
        }

        public void nodeSaved(NodeEvent nodeEvent) {
            DocumentEvent documentEvent = this.convertEvent(nodeEvent);
            if (documentEvent != null) {
                this.getJSRListener().saved(documentEvent);
            }
        }

        public void nodeReverted(NodeEvent nodeEvent) {
        }
    }

    private static final class NullDocumentListener
    implements DocumentListener {
        public void opened(DocumentEvent documentEvent) {
        }

        public void willBeClosed(DocumentEvent documentEvent) {
        }

        public void closed(DocumentEvent documentEvent) {
        }

        public void modified(DocumentEvent documentEvent) {
        }

        public void willBeSaved(DocumentEvent documentEvent) {
        }

        public void saved(DocumentEvent documentEvent) {
        }

        private NullDocumentListener() {
        }

        NullDocumentListener(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

